/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb2;

import com.aliyun.polardb2.Column;
import com.aliyun.polardb2.HostExec;
import com.aliyun.polardb2.PolarPlus;
import com.aliyun.polardb2.PrintUtils;
import com.aliyun.polardb2.Settings;
import com.aliyun.polardb2.SubVar;
import com.aliyun.polardb2.Util;
import com.aliyun.polardb2.WinNative;
import com.aliyun.polardb2.events.SQLErrorEvent;
import com.aliyun.polardb2.exception.InternalException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.Vector;
import jline.console.ConsoleReader;

public class ProcessInput {
    ResultSet rs = null;
    Vector cv = null;
    int columnKount = 0;
    String stmtFirstLine = null;
    String variableSubstitutionValue = "";
    private JDBCWorkerThread jdbcWorkerThread = null;
    private InputStreamMonitor monitorThread = null;
    private String scriptPath = "";
    private String cursorNamePrefix = "CURSOR STATEMENT : ";
    private SQLErrorEvent sqlErrorEvent = new SQLErrorEvent();

    public void inputLooper(BufferedReader in, Settings s, boolean isInteractive) {
        int lineFile = 0;
        int lineStmt = 0;
        String rLine = null;
        StringBuffer sql = new StringBuffer();
        boolean isComment = false;
        boolean isCodeBlock = false;
        boolean inSingleQuotes = false;
        boolean inDoubleQuotes = false;
        boolean isLineComment = false;
        boolean lineContinued = false;
        boolean isCompleted = false;
        s.currentBufferLine = 0;
        while (true) {
            String msg;
            int i;
            Settings.isInteractive = isInteractive;
            if (!s.silent) {
                if (lineContinued && isInteractive) {
                    Util.print("> ", s, s.echo.equalsIgnoreCase("ON"));
                } else if (lineStmt == 0) {
                    Util.printPrompt(s, isInteractive);
                } else if (isInteractive) {
                    String linePrompt = lineStmt + 1 + "  ";
                    Util.print(Util.padLeft(linePrompt, ' ', s.sqlPrompt.length()), s, s.echo.equalsIgnoreCase("ON"));
                }
            }
            try {
                lineContinued = false;
                this.waitForInputStreamMonitor(s);
                rLine = in.readLine();
                if (rLine == null) {
                    in.close();
                    break;
                }
                boolean standardConformingStrings = s.getDBHandler().isStandardConformingStrings();
                if (!standardConformingStrings) {
                    rLine = Util.escapeChars(rLine, "\\");
                }
            }
            catch (IOException | SQLException ie) {
                Util.println(ie.getMessage(), s);
            }
            String line = rLine;
            isLineComment = false;
            isCompleted = false;
            boolean wasComment = isComment;
            char[] chars = line.toCharArray();
            StringBuilder queryPart = new StringBuilder();
            int queryStartIndex = 0;
            for (i = 0; i < chars.length && !isCodeBlock; ++i) {
                char c = chars[i];
                char nextChar = '\u0000';
                if (i < chars.length - 1) {
                    nextChar = chars[i + 1];
                }
                if (c == '\"' && !inSingleQuotes && !isComment) {
                    inDoubleQuotes = !inDoubleQuotes;
                    continue;
                }
                if (c == '\'' && !inDoubleQuotes && !isComment) {
                    inSingleQuotes = !inSingleQuotes;
                    continue;
                }
                if (inSingleQuotes || inDoubleQuotes) continue;
                if (c == '/' && nextChar == '*') {
                    isComment = true;
                    queryPart.append(line.substring(queryStartIndex, i));
                    ++i;
                    continue;
                }
                if (c == '*' && nextChar == '/' && (isComment || wasComment)) {
                    isComment = false;
                    queryStartIndex = ++i + 1;
                    queryPart.append(" ").append(line.substring(queryStartIndex));
                    continue;
                }
                if (c == '-' && nextChar == '-') {
                    isLineComment = true;
                    break;
                }
                if (c != s.sqlTerminator.charAt(0) || isComment) continue;
                isCompleted = true;
                break;
            }
            String newLine = new String(chars);
            if (!isCodeBlock && isLineComment) {
                newLine = newLine.substring(0, i);
            }
            if (!(isComment || isCodeBlock || !line.trim().endsWith("-") || line.trim().startsWith("--") || line.trim().startsWith("rem") || line.trim().startsWith("remark"))) {
                line = Util.rTrim(line, s);
                line = line.substring(0, line.length() - 1);
                sql.append(line + " ");
                lineContinued = true;
                ++lineStmt;
                if (this.stmtFirstLine != null) continue;
                this.stmtFirstLine = "";
                continue;
            }
            if (line.trim().length() == 0 && lineStmt == 0 || newLine.trim().length() == 0 && isLineComment && lineStmt == 0 || (isComment || wasComment) && queryPart.toString().trim().length() == 0) {
                ++lineFile;
                if (lineStmt > 0) {
                    ++lineStmt;
                }
                if (isInteractive) {
                    lineFile = 0;
                }
                if (!isInteractive && s.echo.equals("ON")) {
                    if (lineStmt <= 1) {
                        Util.print(s.sqlPrompt, s);
                        Util.println(line, s);
                        continue;
                    }
                    Util.println(line, s);
                    continue;
                }
                if (!s.echo.equals("ON") || !isLineComment && !isComment && !wasComment) continue;
                Util.spoolInput(line, s);
                continue;
            }
            if ((isComment || wasComment) && queryPart.toString().trim().length() != 0) {
                newLine = queryPart.toString();
            }
            if (lineStmt >= 1 && this.stmtFirstLine.trim().toLowerCase().startsWith("i") && "input".startsWith(this.stmtFirstLine.trim().toLowerCase())) {
                if (line.trim().equals(".") || line.trim().equals("/") || line.endsWith(s.sqlTerminator)) {
                    if (line.endsWith(s.sqlTerminator)) {
                        sql.append(newLine);
                    }
                    String tempSQL = sql.substring(this.stmtFirstLine.length() + 1);
                    s.bufferInput(tempSQL);
                    if (line.trim().endsWith(s.sqlTerminator)) {
                        sql = new StringBuffer(s.currentBuffer);
                    }
                } else {
                    sql.append(newLine);
                }
            } else if (line.trim().equals(".")) {
                s.currentBuffer = Util.rTrim(sql.toString(), s);
                s.currentBufferLine = lineStmt;
            } else if (line.trim().equals("/")) {
                if (sql != null && sql.toString().trim().length() > 0) {
                    s.currentBuffer = sql.toString();
                    s.currentBufferLine = lineStmt;
                }
            } else {
                sql.append(newLine);
            }
            if (++lineStmt == 1) {
                ++lineFile;
            }
            this.stmtFirstLine = sql.toString();
            if (!isInteractive && s.echo.equals("ON")) {
                if (lineStmt == 1) {
                    Util.println(s.sqlPrompt + line, s);
                } else {
                    Util.println(line, s);
                }
            }
            String t1 = "";
            String[] tokens = null;
            if (!isCodeBlock) {
                String tempString = sql.toString().toLowerCase();
                if (tempString.startsWith("c/") && lineStmt == 1) {
                    this.stmtFirstLine = tempString = "c /" + sql.toString().substring(2);
                }
                if ((tokens = Util.tokenSplitter(tempString, s)).length >= 1) {
                    t1 = tokens[0];
                }
            }
            if (!isCodeBlock && this.containsBlockToken(tokens)) {
                isCodeBlock = true;
            }
            if (!isCodeBlock) {
                boolean edbplusCommand = true;
                if (t1.equals("select") || t1.equals("insert") || t1.equals("update") || t1.equals("delete") || t1.equals("create")) {
                    edbplusCommand = false;
                } else if (t1.startsWith("acc") && "accept".startsWith(t1)) {
                    this.stmtFirstLine = this.processSubVars(this.stmtFirstLine, 1, false, s);
                    String subVarName = Util.tokenTrim(this.stmtFirstLine);
                    String substitutionString = s.accept(subVarName);
                    this.defineSubVar(subVarName + " = \"" + substitutionString + "\"", s);
                } else if (t1.startsWith("a") && "append".startsWith(t1)) {
                    this.stmtFirstLine = this.processSubVars(this.stmtFirstLine, 1, false, s);
                    s.bufferAppend(this.stmtFirstLine.substring(t1.length(), this.stmtFirstLine.length()));
                } else if (t1.startsWith("c") && "change".startsWith(t1)) {
                    this.stmtFirstLine = this.processSubVars(this.stmtFirstLine, 1, false, s);
                    s.bufferChange(Util.tokenTrim(this.stmtFirstLine));
                } else if (t1.startsWith("cl") && "clear".startsWith(t1)) {
                    this.stmtFirstLine = this.processSubVars(this.stmtFirstLine, 1, false, s);
                    this.clearCommand(Util.tokenTrim(this.stmtFirstLine), s);
                } else if (t1.startsWith("col") && "column".startsWith(t1)) {
                    this.stmtFirstLine = this.processSubVars(this.stmtFirstLine, 1, false, s);
                    this.columnCommand(this.stmtFirstLine.substring(t1.length(), this.stmtFirstLine.length()), s);
                } else if (t1.startsWith("con") && "connect".startsWith(t1)) {
                    this.stmtFirstLine = this.processSubVars(this.stmtFirstLine, 1, false, s);
                    s.connectDB(Util.tokenTrim(this.stmtFirstLine));
                    try {
                        this.checkConnected(s);
                    }
                    catch (SQLException e) {
                        this.handleSQLError(e, s);
                    }
                } else if (t1.equals("del")) {
                    this.stmtFirstLine = this.processSubVars(this.stmtFirstLine, 1, false, s);
                    s.bufferDelete(Util.tokenTrim(this.stmtFirstLine));
                } else if (t1.startsWith("def") && "define".startsWith(t1)) {
                    this.stmtFirstLine = this.processSubVars(this.stmtFirstLine, 1, false, s);
                    this.defineSubVar(Util.tokenTrim(this.stmtFirstLine), s);
                } else if (t1.startsWith("desc") && "describe".startsWith(t1)) {
                    this.stmtFirstLine = this.processSubVars(this.stmtFirstLine, 1, false, s);
                    s.getDBHandler().describeObject(Util.tokenTrim(this.stmtFirstLine), s);
                } else if (t1.startsWith("disc") && "disconnect".startsWith(t1)) {
                    s.disconnectDB();
                } else if (t1.startsWith("ed") && "edit".startsWith(t1)) {
                    this.stmtFirstLine = this.processSubVars(this.stmtFirstLine, 1, false, s);
                    s.editFile(Util.tokenTrim(this.stmtFirstLine));
                } else if (t1.startsWith("exec") && "execute".startsWith(t1)) {
                    this.stmtFirstLine = this.processSubVars(this.stmtFirstLine, 1, false, s);
                    String plSQL = this.stmtFirstLine.substring(t1.length(), this.stmtFirstLine.length());
                    if (!plSQL.trim().endsWith(";")) {
                        plSQL = plSQL + ";";
                    }
                    String newSQL = "BEGIN \n" + plSQL + "\n END;";
                    sql = new StringBuffer(newSQL);
                    edbplusCommand = false;
                    isCodeBlock = true;
                    line = "/";
                } else if (t1.startsWith("ex") && "exit".startsWith(t1)) {
                    this.stmtFirstLine = this.processSubVars(this.stmtFirstLine, 1, false, s);
                    this.exitCommand(this.stmtFirstLine.substring(t1.length(), this.stmtFirstLine.length()), s);
                } else if (t1.equals("get")) {
                    this.stmtFirstLine = this.processSubVars(this.stmtFirstLine, 1, false, s);
                    s.bufferGet(Util.tokenTrim(this.stmtFirstLine));
                } else if (t1.equals("?") || t1.equals("help")) {
                    this.stmtFirstLine = this.processSubVars(this.stmtFirstLine, 1, false, s);
                    this.helpCommand(Util.tokenTrim(this.stmtFirstLine), s);
                } else if (t1.startsWith("ho") && "host".startsWith(t1)) {
                    this.stmtFirstLine = this.processSubVars(this.stmtFirstLine, 1, false, s);
                    HostExec.hostExec(Util.tokenTrim(this.stmtFirstLine), s);
                } else if (t1.startsWith("i") && "input".startsWith(t1)) {
                    this.stmtFirstLine = this.processSubVars(this.stmtFirstLine, 1, false, s);
                    String value = this.stmtFirstLine.substring(t1.length(), this.stmtFirstLine.length());
                    if (value.trim().length() > 0) {
                        s.bufferInput(value);
                    } else {
                        edbplusCommand = false;
                    }
                } else if (t1.startsWith("l") && "list".startsWith(t1)) {
                    this.stmtFirstLine = this.processSubVars(this.stmtFirstLine, 1, false, s);
                    s.bufferList(Util.tokenTrim(this.stmtFirstLine));
                } else if (t1.startsWith("passw") && "password".startsWith(t1)) {
                    this.stmtFirstLine = this.processSubVars(this.stmtFirstLine, 1, false, s);
                    s.passwordFunction(this.stmtFirstLine, t1);
                } else if (t1.startsWith("pau") && "pause".startsWith(t1)) {
                    this.stmtFirstLine = this.processSubVars(this.stmtFirstLine, 1, false, s);
                    this.stmtFirstLine = this.stmtFirstLine.replace("\\\\", "\\");
                    s.pauseFunction(Util.tokenTrim(this.stmtFirstLine));
                } else if (t1.startsWith("pro") && "prompt".startsWith(t1)) {
                    this.stmtFirstLine = this.processSubVars(this.stmtFirstLine, 1, false, s);
                    s.prompt(this.stmtFirstLine, t1);
                } else if (t1.equals("quit")) {
                    this.stmtFirstLine = this.processSubVars(this.stmtFirstLine, 1, false, s);
                    this.exitCommand(this.stmtFirstLine.substring(t1.length(), this.stmtFirstLine.length()), s);
                } else if (!t1.startsWith("rem") || !"remark".startsWith(t1)) {
                    if (t1.startsWith("r") && "run".startsWith(t1)) {
                        s.bufferList("");
                        line = "/";
                        edbplusCommand = false;
                    } else if (t1.startsWith("sav") && "save".startsWith(t1)) {
                        this.stmtFirstLine = this.processSubVars(this.stmtFirstLine, 1, false, s);
                        s.bufferSave(Util.tokenTrim(this.stmtFirstLine));
                    } else {
                        if (t1.startsWith("sta") && "start".startsWith(t1) || t1.startsWith("@")) {
                            this.stmtFirstLine = this.processSubVars(this.stmtFirstLine, 1, false, s);
                            this.startCommand("@" + this.stmtFirstLine.substring(t1.length(), this.stmtFirstLine.length()).trim(), s);
                            ++lineFile;
                            lineStmt = 0;
                            sql = new StringBuffer();
                            if (!isInteractive) continue;
                            lineFile = 0;
                            continue;
                        }
                        if (t1.equals("set")) {
                            this.stmtFirstLine = this.processSubVars(this.stmtFirstLine, 1, false, s);
                            s.set(this.stmtFirstLine);
                        } else if (t1.startsWith("sho") && "show".startsWith(t1)) {
                            this.stmtFirstLine = this.processSubVars(this.stmtFirstLine, 1, false, s);
                            Util.println(s.show(this.stmtFirstLine), s);
                        } else if (t1.startsWith("sp") && "spool".startsWith(t1)) {
                            this.stmtFirstLine = this.processSubVars(this.stmtFirstLine, 1, false, s);
                            s.spool(this.stmtFirstLine, t1);
                        } else if (t1.startsWith("undef") && "undefine".startsWith(t1)) {
                            this.stmtFirstLine = this.processSubVars(this.stmtFirstLine, 1, false, s);
                            this.undefineSubVar(Util.tokenTrim(this.stmtFirstLine), s);
                        } else if (t1.equals("whenever")) {
                            this.stmtFirstLine = this.processSubVars(this.stmtFirstLine, 1, false, s);
                            this.setupEvents(Util.tokenTrim(this.stmtFirstLine), s);
                        } else if (t1.startsWith("$__edbwrapped__$")) {
                            try {
                                String tmpStr = "";
                                sql.append("\n");
                                while (!tmpStr.trim().equals("$__edbwrapped__$")) {
                                    tmpStr = in.readLine();
                                    if (tmpStr == null) continue;
                                    sql.append(tmpStr + "\n");
                                }
                            }
                            catch (Exception tmpStr) {
                                // empty catch block
                            }
                            if (sql != null && sql.toString().trim().length() > 0) {
                                if (isInteractive && PolarPlus.isTerminal) {
                                    this.execJDBCInThread(sql.toString(), s, lineFile, lineStmt);
                                } else {
                                    try {
                                        this.execJDBC(new StringBuffer(sql), s, lineFile, lineStmt);
                                    }
                                    catch (SQLException se) {
                                        msg = se.getMessage();
                                        if (msg.startsWith("ERROR: ")) {
                                            msg = msg.substring(7, msg.length());
                                        }
                                        Util.println("ERROR near line " + lineFile + ":", s);
                                        Util.println(msg, s);
                                        this.handleSQLError(se, s);
                                    }
                                    catch (InternalException iex) {
                                        Util.println("PolarDB-" + Util.padLeft("" + iex.getErrorCode(), '0', 4) + ": " + iex.getMessage(), s);
                                        s.getDBHandler().implicitRollback();
                                    }
                                }
                            }
                            Util.printPrompt(s, isInteractive);
                        } else {
                            try {
                                int lineNum = Integer.parseInt(line.trim());
                                s.bufferList(lineNum + "");
                            }
                            catch (Exception e) {
                                edbplusCommand = false;
                            }
                        }
                    }
                }
                if (edbplusCommand) {
                    lineStmt = 0;
                    sql = new StringBuffer();
                    if (!isInteractive) continue;
                    lineFile = 0;
                    continue;
                }
            }
            if (line.trim().equals("/") && !isCodeBlock) {
                if (s.currentBuffer.trim().length() == 0) {
                    Util.println("ERROR: No SQL statements to execute.", s);
                }
                line = s.currentBuffer + ";";
                sql = new StringBuffer();
                sql.append(line);
                lineFile = 1;
            }
            if ((line.trim().endsWith(s.sqlTerminator) || isCompleted) && !isCodeBlock || line.trim().equals("/") && isCodeBlock || line.trim().equals(".")) {
                String execSQL;
                if (!line.trim().equals(".") && (execSQL = Util.rTrim(sql.toString(), s)).length() > 0) {
                    if (lineStmt > 0) {
                        s.setCurrentBuffer(execSQL);
                    }
                    execSQL = this.subVarLooper(execSQL, s);
                    if (isInteractive && PolarPlus.isTerminal) {
                        this.execJDBCInThread(execSQL, s, lineFile, lineStmt);
                    } else {
                        try {
                            this.execJDBC(new StringBuffer(execSQL), s, lineFile, lineStmt);
                        }
                        catch (SQLException se) {
                            msg = se.getMessage();
                            if (msg.startsWith("ERROR: ")) {
                                msg = msg.substring(7, msg.length());
                            }
                            Util.println("ERROR near line " + lineFile + ":", s);
                            Util.println(msg, s);
                            this.handleSQLError(se, s);
                        }
                        catch (InternalException iex) {
                            Util.println("PolarDB-" + Util.padLeft("" + iex.getErrorCode(), '0', 4) + ": " + iex.getMessage(), s);
                            s.getDBHandler().implicitRollback();
                        }
                    }
                }
                isCodeBlock = false;
                lineFile = lineFile + lineStmt - 1;
                lineStmt = 0;
                sql = new StringBuffer();
                if (!isInteractive) continue;
                lineFile = 0;
                continue;
            }
            sql.append("\n");
        }
    }

    private void checkConnected(Settings s) throws SQLException {
        if (!s.isConnectedDB || s.getDBHandler().getConnection().isClosed()) {
            throw new SQLException("Not Connected");
        }
    }

    public void handleSQLError(SQLException sqle, Settings s) {
        if (this.sqlErrorEvent.isExitSQLCode() && sqle != null) {
            this.sqlErrorEvent.setExitCode(sqle.getErrorCode());
        }
        if (this.sqlErrorEvent.getAction() == SQLErrorEvent.ACTION_TYPE.CONTINUE) {
            if (this.sqlErrorEvent.getContinueParameter() == SQLErrorEvent.PARAMETER_TYPES.ROLLBACK) {
                try {
                    this.checkConnected(s);
                    s.getDBHandler().rollback(s);
                    Util.println("\nRollback complete.\n", s);
                }
                catch (SQLException ex) {
                    Util.println("\n" + ex.getMessage(), s);
                }
            } else if (this.sqlErrorEvent.getContinueParameter() == SQLErrorEvent.PARAMETER_TYPES.COMMIT) {
                try {
                    this.checkConnected(s);
                    s.getDBHandler().commit(s);
                    Util.println("\nCommit complete.\n", s);
                }
                catch (SQLException ex) {
                    Util.println("\n" + ex.getMessage(), s);
                }
            } else if (this.sqlErrorEvent.getContinueParameter() == SQLErrorEvent.PARAMETER_TYPES.NONE) {
                // empty if block
            }
        }
        if (this.sqlErrorEvent.getAction() == SQLErrorEvent.ACTION_TYPE.EXIT) {
            if (this.sqlErrorEvent.isHasSetupError()) {
                Util.println("", s);
                this.printWheneverSqlErrorUsage(s);
            } else if (this.sqlErrorEvent.getExitParameter() == SQLErrorEvent.PARAMETER_TYPES.ROLLBACK) {
                try {
                    this.checkConnected(s);
                    s.getDBHandler().rollback(s);
                }
                catch (SQLException ex) {
                    Util.println("\n" + ex.getMessage(), s);
                }
            } else if (this.sqlErrorEvent.getExitParameter() == SQLErrorEvent.PARAMETER_TYPES.COMMIT) {
                try {
                    this.checkConnected(s);
                    s.getDBHandler().commit(s);
                }
                catch (SQLException ex) {
                    Util.println("\n" + ex.getMessage(), s);
                }
            }
            s.disconnectDB();
            System.exit(this.sqlErrorEvent.getExitCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCommand(String inLine, Settings s) {
        String expandedPath;
        String cmdFile = Util.rTrim(inLine.trim(), s);
        boolean useScriptPath = false;
        if (cmdFile.startsWith("@@")) {
            cmdFile = cmdFile.substring(2, cmdFile.length());
            useScriptPath = true;
        } else if (cmdFile.startsWith("@")) {
            cmdFile = cmdFile.substring(1, cmdFile.length());
        }
        if (cmdFile == null || cmdFile.trim().length() == 0) {
            return;
        }
        String[] tokens = Util.tokenSplitter(cmdFile, s);
        cmdFile = tokens[0];
        for (int i = 1; i < tokens.length; ++i) {
            this.defineSubVar(i + " = \"" + tokens[i] + "\"", s);
        }
        cmdFile = s.appendFileSuffix(cmdFile);
        String lastPath = this.scriptPath;
        String path = cmdFile;
        if (useScriptPath && !cmdFile.startsWith("/")) {
            path = this.scriptPath + cmdFile;
        }
        if ((expandedPath = Util.expandEnvVars(path)) != null) {
            path = expandedPath;
        } else {
            expandedPath = path;
        }
        try {
            File f = new File(path);
            BufferedReader in2 = new BufferedReader(new FileReader(f));
            path = f.getPath();
            int index = path.lastIndexOf(f.getName());
            this.scriptPath = path.substring(0, index);
            this.inputLooper(in2, s, false);
        }
        catch (IOException ie) {
            Util.println("ERROR: Unable to read file \"" + expandedPath + "\"", s);
        }
        finally {
            this.scriptPath = lastPath;
        }
    }

    private void helpCommand(String inLine, Settings s) {
        String sVariable;
        String[] tokens;
        String helpForHelp = "HELP\n----\n\nType HELP INDEX or '? INDEX' for a complete list of topics.\n\nHELP | ? [topic]";
        if (inLine.endsWith(";")) {
            inLine = inLine.substring(0, inLine.length() - 1);
        }
        if ((tokens = Util.tokenSplitter(sVariable = Util.rTrim(inLine, s), s)).length < 1) {
            Util.println(helpForHelp, s);
            return;
        }
        String helpEnvVariable = System.getenv("POLARPLUS_HELP");
        if (helpEnvVariable == null) {
            Util.println("ERROR: Environment variable POLARPLUS_HELP is not defined.", s);
            return;
        }
        File dir = new File(helpEnvVariable);
        Object[] dirList = dir.list();
        if (dirList == null) {
            Util.println("ERROR: Invalid POLARPLUS_HELP directory.", s);
            return;
        }
        Arrays.sort(dirList);
        String helpWildcard = "HELP";
        helpWildcard = inLine.toUpperCase();
        int kount = 0;
        Object fileName = "";
        for (int i = 0; i < dirList.length; ++i) {
            fileName = dirList[i];
            if (!((String)fileName).startsWith(helpWildcard) || !((String)fileName).endsWith(".txt")) continue;
            fileName = helpEnvVariable + "/" + (String)fileName;
            String rLine = null;
            try {
                BufferedReader in = new BufferedReader(new FileReader((String)fileName));
                Util.println(" ", s);
                while ((rLine = in.readLine()) != null) {
                    Util.println(rLine, s);
                }
                in.close();
                Util.println(" ", s);
                ++kount;
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        if (kount == 0) {
            Util.println("ERROR: No HELP matching this topic was found.", s);
            return;
        }
        kount = 0;
        StringBuffer sb = new StringBuffer(" ");
        if (tokens.length == 1 && helpWildcard.equals("INDEX")) {
            for (int i = 0; i < dirList.length; ++i) {
                fileName = dirList[i];
                if (!((String)fileName).endsWith(".txt") || ((String)(fileName = ((String)fileName).substring(0, ((String)fileName).length() - 4))).length() > 14) continue;
                sb.append((String)fileName + Util.padRight("", ' ', 15 - ((String)fileName).length()));
                if (++kount < 4) continue;
                kount = 0;
                sb.append("\n");
            }
            Util.println(sb.toString().trim() + "\n", s);
        }
    }

    private void clearCommand(String inLine, Settings s) {
        inLine = Util.rTrim(inLine, s);
        String invalidClearCommand = "Invalid CLEAR command, try \n   CL[EAR] {BUFF[ER] | SQL | COL[UMNS] | SCR[EEN]}";
        String sVariable = inLine.trim().toLowerCase();
        if (sVariable.length() == 0) {
            sVariable = "screen";
        }
        if ("buffer".startsWith(sVariable) && sVariable.startsWith("buff")) {
            s.bufferClear();
            Util.println("buffer cleared", s);
            return;
        }
        if (sVariable.equals("sql")) {
            s.bufferClear();
            Util.println("sql cleared", s);
            return;
        }
        if ("columns".startsWith(sVariable) && sVariable.startsWith("col")) {
            s.columnVector = new Vector();
            s.columnKount = 0;
            Util.println("columns cleared", s);
            return;
        }
        if ("screen".startsWith(sVariable) && sVariable.startsWith("scr")) {
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Windows")) {
                WinNative.cls();
            } else {
                HostExec.hostExec("clear", s);
            }
            return;
        }
        Util.println(invalidClearCommand, s);
    }

    private void exitCommand(String commandStr, Settings s) {
        String[] tokens;
        String invalidExitCommand = "Invalid EXIT/QUIT command, try \n   EXIT | QUIT [SUCCESS | FAILURE | WARNING | value | sub_variable] \n               [COMMIT | ROLLBACK]";
        String sVariable = Util.rTrim(commandStr, s);
        if (sVariable.length() == 0) {
            s.disconnectDB();
            System.exit(s.EXIT_SUCCESS);
        }
        if ((tokens = Util.tokenSplitter(sVariable.toLowerCase(), s)).length == 0 || tokens.length > 2) {
            Util.println(invalidExitCommand, s);
            s.disconnectDB();
            System.exit(s.EXIT_WARNING);
        }
        boolean isCommit = true;
        if (tokens.length == 2) {
            if (!tokens[1].equals("commit") && !tokens[1].equals("rollback")) {
                Util.println(invalidExitCommand, s);
            }
            if (tokens[1].equals("rollback")) {
                isCommit = false;
            }
        }
        int returnCode = 0;
        if (tokens[0].equals("success")) {
            returnCode = s.EXIT_SUCCESS;
        } else if (tokens[0].equals("failure")) {
            returnCode = s.EXIT_FAILURE;
        } else if (tokens[0].equals("warning")) {
            returnCode = s.EXIT_WARNING;
        } else {
            try {
                returnCode = Integer.parseInt(tokens[0]);
            }
            catch (Exception e) {
                returnCode = s.EXIT_FAILURE;
                Util.println(invalidExitCommand, s);
            }
        }
        if (isCommit) {
            s.getDBHandler().silentCommit();
        } else {
            s.getDBHandler().silentRollback();
        }
        s.disconnectDB();
        System.exit(returnCode);
    }

    private void columnCommand(String inLine, Settings s) {
        String sVariable = Util.rTrim(inLine, s);
        if (sVariable.length() == 0) {
            this.showAllColumns(s);
            return;
        }
        String[] tokens = Util.tokenSplitter(sVariable, s);
        if (tokens.length == 1) {
            this.showColumn(tokens[0].toUpperCase(), s);
            return;
        }
        Column c = new Column();
        c.colName = tokens[0].toUpperCase();
        for (int i = 1; i < tokens.length; ++i) {
            String token = tokens[i];
            String upperToken = tokens[i].toUpperCase();
            if ("CLEAR".startsWith(upperToken) && upperToken.startsWith("CLE")) {
                this.clearColumn(c.colName, s);
                return;
            }
            if (upperToken.equals("ON") || upperToken.equals("OFF")) {
                c.onOff = upperToken;
                continue;
            }
            if ("HEADING".startsWith(upperToken) && upperToken.startsWith("HEA")) {
                if (i >= tokens.length - 1) {
                    Util.println("ERROR: Heading text is missing.", s);
                    return;
                }
                c.colLabel = tokens[++i];
                c.isHeading = true;
                if (!c.colLabel.contains(s.headSep)) continue;
                c.headSep = s.headSep;
                continue;
            }
            if ("WRAPPED".startsWith(upperToken) && upperToken.startsWith("WRA")) {
                c.wrapper = "WRAPPED";
                continue;
            }
            if ("TRUNCATED".startsWith(upperToken) && upperToken.startsWith("TRU")) {
                c.wrapper = "TRUNCATED";
                continue;
            }
            if ("FORMAT".startsWith(upperToken) && upperToken.startsWith("FOR")) {
                if (i >= tokens.length - 1) {
                    Util.println("ERROR: format string is missing.", s);
                    return;
                }
                c.formatString = tokens[++i];
                if (this.processFormatString(c)) continue;
                Util.println("ERROR: Format string \"" + c.formatString + "\" is illegal.", s);
                return;
            }
            Util.println("ERROR: COLUMN option \"" + token + "\" is unknown.", s);
            return;
        }
        this.putColumn(c, s);
    }

    private boolean processFormatString(Column c) {
        if (c.formatString.startsWith("a") || c.formatString.startsWith("A")) {
            String sFormatWidth = c.formatString.substring(1);
            try {
                c.colSize = Integer.parseInt(sFormatWidth.trim());
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        char[] numericFormatChars = new char[]{'0', '9', '$', ',', '.'};
        StringBuffer sb = new StringBuffer(c.formatString.trim());
        StringBuffer sbFormat = new StringBuffer("");
        for (int i = 0; i < sb.length(); ++i) {
            char myChar = sb.charAt(i);
            boolean formatChar = false;
            for (int x = 0; x < numericFormatChars.length; ++x) {
                if (myChar != numericFormatChars[x]) continue;
                if (myChar == '9') {
                    sbFormat.append('#');
                } else {
                    sbFormat.append(myChar);
                }
                formatChar = true;
                break;
            }
            if (formatChar) continue;
            return false;
        }
        try {
            c.colSize = sbFormat.toString().trim().length() + 1;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void showAllColumns(Settings s) {
        if (s.columnKount == 0) {
            Util.println("ERROR: No COLUMNs are defined.", s);
            return;
        }
        ListIterator iter = s.columnVector.listIterator();
        for (int i = 1; i <= s.columnKount; ++i) {
            Column c = (Column)iter.next();
            Util.println(c.toString(), s);
            if (i >= s.columnKount) continue;
            Util.println(" ", s);
        }
    }

    private void showColumn(String inColName, Settings s) {
        ListIterator iter = s.columnVector.listIterator();
        for (int i = 1; i <= s.columnKount; ++i) {
            Column c = (Column)iter.next();
            if (!c.colName.equals(inColName)) continue;
            Util.println(c.toString(), s);
            return;
        }
        Util.println("ERROR: COLUMN \"" + inColName + "\" does not exist.", s);
    }

    private void clearColumn(String inColName, Settings s) {
        ListIterator iter = s.columnVector.listIterator();
        for (int i = 1; i <= s.columnKount; ++i) {
            Column c = (Column)iter.next();
            if (!c.colName.equals(inColName)) continue;
            iter.remove();
            --s.columnKount;
            return;
        }
        Util.println("ERROR: COLUMN \"" + inColName + "\" is not defined.", s);
    }

    private void putColumn(Column inCol, Settings s) {
        ListIterator<Column> iter = s.columnVector.listIterator();
        for (int i = 1; i <= s.columnKount; ++i) {
            Column c = (Column)iter.next();
            if (!c.colName.equals(inCol.colName)) continue;
            if (inCol.onOff.length() > 0) {
                c.onOff = inCol.onOff;
            }
            if (inCol.formatString.length() > 0) {
                c.formatString = inCol.formatString;
                c.colSize = inCol.colSize;
            }
            if (inCol.isHeading) {
                c.isHeading = inCol.isHeading;
                c.colLabel = inCol.colLabel;
                c.headSep = inCol.headSep;
            }
            if (inCol.wrapper.length() > 0) {
                c.wrapper = inCol.wrapper;
            }
            return;
        }
        if (inCol.onOff.length() == 0) {
            inCol.onOff = "ON";
        }
        if (inCol.wrapper.length() == 0) {
            inCol.wrapper = "WRAPPED";
        }
        iter.add(inCol);
        ++s.columnKount;
    }

    private void getColumnOverrides(Column inCol, Settings s) {
        ListIterator iter = s.columnVector.listIterator();
        for (int i = 1; i <= s.columnKount; ++i) {
            Column c = (Column)iter.next();
            if (!c.colName.equals(inCol.colName) || !c.onOff.equals("ON")) continue;
            if (c.formatString.length() > 0) {
                inCol.colSize = c.colSize;
                inCol.formatString = c.formatString;
            }
            if (c.wrapper.length() > 0) {
                inCol.wrapper = c.wrapper;
            }
            if (c.isHeading) {
                inCol.isHeading = c.isHeading;
                inCol.colLabel = c.colLabel;
                inCol.headSep = c.headSep;
                inCol.headRows = c.headRows;
            }
            return;
        }
    }

    private void undefineSubVar(String inLine, Settings s) {
        String sVariable = Util.rTrim(inLine, s).toUpperCase();
        if (sVariable.length() == 0) {
            Util.println("ERROR: Invalid syntax, try:\nUNDEF[INE] variable_name [ variable_name...]", s);
            return;
        }
        String[] tokens = Util.tokenSplitter(sVariable, s);
        ListIterator iter = s.variableVector.listIterator();
        for (int i = 1; i <= s.variableKount; ++i) {
            SubVar v = (SubVar)iter.next();
            for (int z = 0; z < tokens.length; ++z) {
                if (!v.varName.equals(tokens[z])) continue;
                iter.remove();
                --s.variableKount;
            }
        }
    }

    private void printWheneverSqlErrorUsage(Settings s) {
        Util.println("Usage: WHENEVER SQLERROR\n     { CONTINUE  [ COMMIT | ROLLBACK | NONE ]\n     | EXIT  [ SUCCESS | FAILURE | WARNING | n | <sub_variable> ]\n\t     [ COMMIT | ROLLBACK ] }", s);
    }

    private void printWheneverUsage(Settings s) {
        this.printWheneverSqlErrorUsage(s);
    }

    private void setupEvents(String inLine, Settings s) {
        String sVariable = Util.rTrim(inLine, s);
        String[] tokens = Util.tokenSplitter(sVariable, s);
        if (tokens.length < 1) {
            this.printWheneverUsage(s);
            return;
        }
        SQLErrorEvent evnt = new SQLErrorEvent();
        if (tokens[0].equalsIgnoreCase("sqlerror")) {
            try {
                if (tokens.length < 2) {
                    throw new IllegalArgumentException("Invalid use of command WHENEVER SQLERROR");
                }
                evnt.setAction(SQLErrorEvent.ACTION_TYPE.valueOf(tokens[1].toUpperCase()));
                if (evnt.getAction() == SQLErrorEvent.ACTION_TYPE.CONTINUE) {
                    if (tokens.length > 2) {
                        evnt.setContinueParameter(SQLErrorEvent.PARAMETER_TYPES.valueOf(tokens[2].toUpperCase()));
                    }
                } else if (evnt.getAction() == SQLErrorEvent.ACTION_TYPE.EXIT) {
                    if (tokens.length > 2) {
                        int exitCode = 0;
                        if (tokens[2].equalsIgnoreCase("success")) {
                            exitCode = s.EXIT_SUCCESS;
                        } else if (tokens[2].equalsIgnoreCase("failure")) {
                            exitCode = s.EXIT_FAILURE;
                        } else if (tokens[2].equalsIgnoreCase("warning")) {
                            exitCode = s.EXIT_WARNING;
                        } else if (tokens[2].equalsIgnoreCase("SQL.SQLCODE")) {
                            evnt.setExitSQLCode(true);
                            exitCode = -1;
                        } else if (tokens[2].equalsIgnoreCase("commit")) {
                            evnt.setExitParameter(SQLErrorEvent.PARAMETER_TYPES.COMMIT);
                            exitCode = s.EXIT_SUCCESS;
                        } else if (tokens[2].equalsIgnoreCase("rollback")) {
                            evnt.setExitParameter(SQLErrorEvent.PARAMETER_TYPES.ROLLBACK);
                            exitCode = s.EXIT_FAILURE;
                        } else if (tokens[2].equalsIgnoreCase("none")) {
                            evnt.setExitParameter(SQLErrorEvent.PARAMETER_TYPES.NONE);
                            exitCode = s.EXIT_SUCCESS;
                        } else {
                            try {
                                exitCode = Integer.parseInt(tokens[2]);
                            }
                            catch (Exception exp) {
                                evnt.setHasSetupError(true);
                            }
                        }
                        evnt.setExitCode(exitCode);
                    }
                    if (tokens.length > 3) {
                        if (tokens[3].equalsIgnoreCase("default")) {
                            throw new IllegalArgumentException("Unknown continue option default");
                        }
                        evnt.setExitParameter(SQLErrorEvent.PARAMETER_TYPES.valueOf(tokens[3].toUpperCase()));
                    }
                }
                this.sqlErrorEvent = evnt;
            }
            catch (Exception exp) {
                this.printWheneverSqlErrorUsage(s);
                return;
            }
        }
        this.printWheneverUsage(s);
        return;
    }

    private void defineSubVar(String inLine, Settings s) {
        String sVariable = Util.rTrim(inLine, s);
        if (sVariable.length() == 0) {
            this.showAllSubVars(s);
            return;
        }
        String[] tokens = Util.tokenSplitter(sVariable, s);
        if (tokens.length == 1) {
            this.showSubVar(tokens[0], s);
            return;
        }
        if (tokens.length != 3 || !tokens[1].equals("=")) {
            Util.println("Invalid DEFINE command, try \n   DEF[INE] [variable_name [= text]]", s);
            return;
        }
        String varName = tokens[0].toUpperCase().trim();
        String varValue = tokens[2];
        this.putSubVar(varName, varValue, s);
    }

    private void showAllSubVars(Settings s) {
        if (s.variableKount == 0) {
            Util.println("\nNo user substitution variables are defined.\n", s);
            return;
        }
        ListIterator iter = s.variableVector.listIterator();
        for (int i = 1; i <= s.variableKount; ++i) {
            SubVar v = (SubVar)iter.next();
            Util.println("DEFINE " + v.varName + " = \"" + v.varValue + "\"", s);
        }
    }

    private void showSubVar(String inVariableName, Settings s) {
        String sVariableName = inVariableName.toUpperCase().trim();
        ListIterator iter = s.variableVector.listIterator();
        for (int i = 1; i <= s.variableKount; ++i) {
            SubVar v = (SubVar)iter.next();
            if (!v.varName.equals(sVariableName)) continue;
            Util.println("DEFINE " + sVariableName + " = \"" + v.varValue + "\"", s);
            return;
        }
        Util.println("ERROR: DEFINE variable \"" + inVariableName + "\" is undefined.", s);
    }

    private void putSubVar(String inVarName, String inVarValue, Settings s) {
        String sVarName = inVarName.toUpperCase().trim();
        ListIterator iter = s.variableVector.listIterator();
        for (int i = 1; i <= s.variableKount; ++i) {
            SubVar v = (SubVar)iter.next();
            if (!v.varName.equals(sVarName)) continue;
            v.varValue = inVarValue;
            return;
        }
        SubVar myVar = new SubVar();
        myVar.varName = inVarName;
        myVar.varValue = inVarValue;
        s.variableVector.add(myVar);
        ++s.variableKount;
    }

    private String subVarLooper(String inLine, Settings s) {
        if (s.define.equals("OFF")) {
            return inLine;
        }
        StringBuffer sb = new StringBuffer("");
        String str = null;
        int kount = 0;
        try {
            BufferedReader reader = new BufferedReader(new StringReader(inLine));
            while ((str = reader.readLine()) != null) {
                str = this.processSubVars(str, ++kount, true, s);
                if (kount == 1) {
                    sb.append(str);
                    continue;
                }
                sb.append("\n" + str);
            }
            reader.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return inLine;
        }
        return sb.toString();
    }

    private int nextSubvarIndex(String text, char defineChar, int start) {
        if (start >= text.length()) {
            return -1;
        }
        return text.indexOf("" + defineChar, start);
    }

    private int getSubVarLength(String text, int start) {
        int length = 0;
        while (start + length < text.length() && !this.isEndSubVar(text.charAt(start + length))) {
            ++length;
        }
        return length;
    }

    private String processSubVars(String inLine, Integer lineNumber, Boolean isSQL, Settings s) {
        if (s.define.equals("OFF")) {
            return inLine;
        }
        if (!inLine.contains(s.define)) {
            return inLine;
        }
        char cDefine = s.define.charAt(0);
        StringBuffer line = new StringBuffer(inLine);
        boolean varSubstituted = false;
        int subIndex = 0;
        while ((subIndex = this.nextSubvarIndex(line.toString(), cDefine, subIndex + 1)) >= 0) {
            int length;
            boolean isDoubleAmpersend;
            int localIndex = subIndex + 1;
            boolean bl = isDoubleAmpersend = line.length() > localIndex && line.charAt(localIndex) == cDefine;
            if (isDoubleAmpersend) {
                ++localIndex;
            }
            if ((length = this.getSubVarLength(line.toString(), localIndex)) > 0) {
                String varName = line.substring(localIndex, localIndex + length);
                if (this.isSubVar(varName, s)) {
                    line = line.replace(subIndex, localIndex + length, this.variableSubstitutionValue);
                    varSubstituted = true;
                    subIndex += this.variableSubstitutionValue.length() - 1;
                } else {
                    String substitutionString = s.accept(varName);
                    line = line.replace(subIndex, localIndex + length, substitutionString);
                    varSubstituted = true;
                    if (isDoubleAmpersend) {
                        this.defineSubVar(varName + " = \"" + substitutionString + "\"", s);
                    }
                    subIndex += substitutionString.length() - 1;
                }
            }
            if (subIndex + 1 >= line.length() || line.charAt(subIndex + 1) != s.concat) continue;
            line.replace(subIndex + 1, subIndex + 2, "");
        }
        String newLine = line.toString();
        line = null;
        if (s.sqlCase.equals("UPPER")) {
            newLine = newLine.toUpperCase();
        } else if (s.sqlCase.equals("LOWER")) {
            newLine = newLine.toLowerCase();
        }
        if (s.verify.equals("ON") && isSQL.booleanValue() && varSubstituted) {
            Util.println(" ", s);
            Util.println("old " + lineNumber + ": " + inLine, s);
            Util.println("new " + lineNumber + ": " + newLine.trim(), s);
        }
        return newLine.trim();
    }

    private boolean isSubVar(String inVarName, Settings s) {
        String varName = inVarName.toUpperCase().trim();
        ListIterator iter = s.variableVector.listIterator();
        for (int i = 1; i <= s.variableKount; ++i) {
            SubVar v = (SubVar)iter.next();
            if (!v.varName.equals(varName)) continue;
            this.variableSubstitutionValue = v.varValue;
            return true;
        }
        return false;
    }

    private boolean isEndSubVar(char myChar) {
        char asciiNumber = myChar;
        if (asciiNumber >= '0' && asciiNumber <= '9') {
            return false;
        }
        if (asciiNumber >= 'A' && asciiNumber <= 'Z') {
            return false;
        }
        if (asciiNumber >= 'a' && asciiNumber <= 'z') {
            return false;
        }
        return asciiNumber != '_';
    }

    boolean containsBlockToken(String[] tokens) {
        if (tokens.length == 0) {
            return false;
        }
        if (tokens[0].equals("begin") || tokens[0].equals("declare")) {
            return true;
        }
        if (!tokens[0].equals("create")) {
            return false;
        }
        if (tokens.length >= 2 && tokens[1].equals("type") || tokens.length >= 4 && tokens[3].equals("type")) {
            return true;
        }
        if (tokens.length >= 2 && tokens[1].equals("rule") || tokens.length >= 4 && tokens[3].equals("rule")) {
            return true;
        }
        for (int i = 1; i < tokens.length; ++i) {
            if (!tokens[i].equals("package") && !tokens[i].equals("procedure") && !tokens[i].equals("function") && !tokens[i].equals("trigger")) continue;
            return true;
        }
        return false;
    }

    void execJDBCInThread(String execSQL, Settings s, int lineFile, int lineStmt) {
        Thread mainThread = Thread.currentThread();
        this.monitorThread = new InputStreamMonitor(PolarPlus.in, s, true);
        this.jdbcWorkerThread = new JDBCWorkerThread(new StringBuffer(execSQL), s, lineFile, lineStmt, mainThread, this.monitorThread);
        this.jdbcWorkerThread.start();
        this.monitorThread.start();
        try {
            this.jdbcWorkerThread.join();
        }
        catch (InterruptedException ie) {
            Util.print("ERROR: " + ie.getMessage(), s);
        }
        this.jdbcWorkerThread = null;
    }

    void execJDBC(StringBuffer sql, Settings s, int lineFile, int lineStmt) throws SQLException, InternalException {
        if (!s.isConnectedDB) {
            Util.println("Not connected", s);
            return;
        }
        String execSQL = Util.rTrim(sql.toString(), s);
        if (execSQL.length() == 0) {
            return;
        }
        String[] tokenSQL = Util.tokenSplitter(Util.lTrim(Util.rTrim(execSQL, s)).toLowerCase().trim(), s);
        boolean isCodeBlock = this.containsBlockToken(tokenSQL);
        long startTimeMS = new Date().getTime();
        String finalSql = execSQL;
        if (s.sqlCase.equals("UPPER")) {
            finalSql = execSQL.toUpperCase();
        } else if (s.sqlCase.equals("LOWER")) {
            finalSql = execSQL.toLowerCase();
        }
        try {
            s.getDBHandler().execute(tokenSQL, isCodeBlock, finalSql);
        }
        catch (SQLException exp) {
            String message = exp.getMessage();
            int transIndex = message.indexOf("cannot run inside a transaction block");
            if (transIndex > 0) {
                String cmdname = message.substring(0, transIndex);
                if (cmdname.startsWith("ERROR:")) {
                    cmdname = cmdname.substring(6);
                }
                cmdname = cmdname.trim();
                message = message + System.getProperty("line.separator") + "Execute {set autocommit ON | IMMEDIATE} before " + cmdname;
                throw new SQLException(message);
            }
            throw exp;
        }
        finally {
            if (s.serverOutput.equals("ON")) {
                s.getDBHandler().printWarnings(s);
                s.getDBHandler().printNotifications(s);
            }
        }
        this.rs = s.getDBHandler().getStatement().getResultSet();
        boolean isSelect = s.getDBHandler().isSelect(tokenSQL);
        this.printResultSet(this.rs, isSelect, s, tokenSQL);
        long runTimeMS = new Date().getTime() + 1L - startTimeMS;
        s.getDBHandler().handleCommandComplete(tokenSQL, s);
        if (s.timing.equals("ON")) {
            Util.println("Elapsed: " + runTimeMS + " ms", s);
        }
    }

    private void printResultSet(ResultSet rs, boolean isSelect, Settings s, String[] tokenSQL) throws SQLException, InternalException {
        if (rs != null && rs.next()) {
            int dbRows = 0;
            this.cv = new Vector();
            ResultSetMetaData meta = rs.getMetaData();
            this.columnKount = meta.getColumnCount();
            for (int i = 1; i <= this.columnKount; ++i) {
                Column cf = new Column();
                cf.colName = meta.getColumnName(i).toUpperCase();
                cf.colLabel = meta.getColumnLabel(i).toUpperCase();
                cf.colType = meta.getColumnType(i);
                cf.colTypeName = meta.getColumnTypeName(i);
                cf.colNullable = meta.isNullable(i);
                cf.colSigned = meta.isSigned(i);
                cf.colSize = meta.getColumnDisplaySize(i);
                if (cf.colSize < cf.colLabel.length()) {
                    cf.colSize = cf.colLabel.length();
                }
                if (cf.colSize > 50) {
                    if (cf.colSigned) {
                        cf.colSize = 10;
                    } else {
                        if (cf.colSize == Integer.MAX_VALUE) {
                            cf.colSize = s.lineSize / this.columnKount - 1;
                            if (cf.colSize < 10) {
                                cf.colSize = 10;
                            }
                        }
                        cf.wrapper = "WRAPPED";
                    }
                }
                if (cf.colNullable == 1 && cf.colSize < s.nul.length()) {
                    cf.colSize = s.nul.length();
                }
                cf.colPrecision = meta.getPrecision(i);
                cf.colScale = meta.getScale(i);
                if (cf.colType == 2006) {
                    cf.colSize = 20;
                }
                this.getColumnOverrides(cf, s);
                if (tokenSQL[0].equals("explain")) {
                    cf.wrapper = "WRAPPED";
                    cf.colSize = s.lineSize / this.columnKount;
                }
                this.cv.add(cf);
            }
            int origPageSize = s.pageSize;
            int outRowCount = 0;
            int headerRows = PrintUtils.countHeaderRows(this.cv, s);
            PrintUtils.printPreHeader(s);
            outRowCount = s.newPage;
            if (s.pageSize > headerRows + s.newPage) {
                outRowCount += PrintUtils.printColumnHeaders(this.cv, s);
            }
            LinkedHashMap<String, ResultSet> cursors = new LinkedHashMap<String, ResultSet>();
            do {
                ++dbRows;
                ListIterator iter = this.cv.listIterator();
                Column[] columns = new Column[this.columnKount];
                for (int i = 1; i <= this.columnKount; ++i) {
                    try {
                        Column cf;
                        columns[i - 1] = cf = (Column)iter.next();
                        Object val = null;
                        try {
                            val = rs.getObject(i);
                        }
                        catch (Exception exp) {
                            val = rs.getString(i);
                        }
                        if (val instanceof ResultSet) {
                            ResultSet tmpRs = (ResultSet)val;
                            val = this.cursorNamePrefix + i;
                            cursors.put((String)val, tmpRs);
                        }
                        String colValue = "";
                        if (val != null && val instanceof Timestamp || val instanceof byte[] || val instanceof SQLXML) {
                            colValue = rs.getString(i);
                        } else if (val != null) {
                            colValue = val.toString();
                        }
                        if (rs.wasNull()) {
                            colValue = s.nul;
                        }
                        if (cf.colSigned) {
                            if (cf.formatString.toLowerCase().startsWith("a")) {
                                colValue = Util.padRight("", '#', cf.colSize);
                            } else if (!rs.wasNull() && cf.formatString.length() > 0) {
                                try {
                                    DecimalFormat df = new DecimalFormat(cf.formatString.replace('9', '#'));
                                    colValue = df.format(rs.getDouble(i));
                                    if (colValue.length() > cf.colSize) {
                                        colValue = Util.padRight("", '#', cf.colSize);
                                    }
                                }
                                catch (Exception e) {
                                    colValue = Util.padRight("", '#', cf.colSize);
                                }
                            }
                            colValue = Util.padLeft(colValue, ' ', cf.colSize);
                        }
                        columns[i - 1].text = colValue;
                        continue;
                    }
                    catch (SQLException e) {
                        String msg = "";
                        if (this.monitorThread == null || !this.monitorThread.isCanceled()) {
                            msg = "ERROR: ";
                        }
                        Util.println(msg + e.getMessage(), s);
                        this.handleSQLError(e, s);
                        return;
                    }
                }
                if (outRowCount >= s.pageSize) {
                    PrintUtils.printPreHeader(s);
                    outRowCount = s.newPage;
                    if (s.pageSize > headerRows + s.newPage) {
                        outRowCount += PrintUtils.printColumnHeaders(this.cv, s);
                    }
                }
                outRowCount = PrintUtils.printRow(columns, s, "", s.colSep, s.lineSize, outRowCount);
                Util.println("", s);
            } while (rs.next());
            Iterator cursorNames = cursors.keySet().iterator();
            while (cursorNames.hasNext()) {
                Util.println("", s);
                String key = (String)cursorNames.next();
                Util.println(key, s);
                this.printResultSet((ResultSet)cursors.get(key), isSelect, s, tokenSQL);
            }
            Util.println("", s);
            if (s.feedback.equals("ON") && dbRows >= s.feedbackRows && isSelect) {
                if (dbRows == 1) {
                    Util.println("1 row retrieved." + System.getProperty("line.separator"), s);
                } else {
                    Util.println(dbRows + " rows retrieved." + System.getProperty("line.separator"), s);
                }
            }
            s.pageSize = origPageSize;
        } else if (s.feedback.equals("ON") && isSelect) {
            Util.println("\nno rows selected\n", s);
            return;
        }
    }

    public void waitForReturnPressed() throws IOException {
        if (this.monitorThread != null) {
            while (this.monitorThread.getStatus() == MonitorStatus.RUNNING && !this.monitorThread.isReturnPressed()) {
                try {
                    Thread.sleep(400L);
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            System.in.read();
        }
    }

    private void waitForInputStreamMonitor(Settings s) {
        try {
            if (this.monitorThread != null && this.monitorThread.isAlive()) {
                this.flushCharactersAlreadyRead();
                this.monitorThread.join();
                this.flushCharactersAlreadyRead();
            }
        }
        catch (InterruptedException ie) {
            Util.println("ERROR: " + ie.getMessage(), s);
        }
        this.monitorThread = null;
    }

    private void flushCharactersAlreadyRead() {
        if (PolarPlus.in != null) {
            try {
                PolarPlus.in.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void cancelJDBCTask() {
        if (this.jdbcWorkerThread != null) {
            try {
                PolarPlus.sessionSettings.getDBHandler().cancelStatement();
                if (this.jdbcWorkerThread != null) {
                    this.jdbcWorkerThread.interrupt();
                }
            }
            catch (SQLException sqle) {
                Util.println("ERROR: " + sqle.getMessage(), PolarPlus.sessionSettings);
                PolarPlus.sessionSettings.getDBHandler().implicitRollback();
            }
        }
    }

    class InputStreamMonitor
    extends Thread {
        private ConsoleReader in = null;
        private Settings s = null;
        private boolean returnPressed = false;
        private MonitorStatus status = MonitorStatus.RUNNING;
        private boolean isInteractive = true;

        public InputStreamMonitor(ConsoleReader in, Settings s, boolean isInteractive) {
            this.in = in;
            this.s = s;
            this.isInteractive = isInteractive;
            this.setStatus(MonitorStatus.RUNNING);
        }

        @Override
        public void run() {
            int ch = 0;
            while (this.isRunning()) {
                try {
                    ch = this.in.readCharacter();
                    if (ch == 3) {
                        this.status = MonitorStatus.CANCELED;
                        ProcessInput.this.cancelJDBCTask();
                        continue;
                    }
                    if (ch == 10 || ch == 13) {
                        if (this.isStopped() || this.isCanceled()) {
                            this.in.println();
                            this.in.flush();
                            Util.printPrompt(this.s, this.isInteractive);
                        } else {
                            this.in.flush();
                        }
                        this.returnPressed = true;
                        continue;
                    }
                    if (Character.isISOControl((char)ch)) continue;
                    try {
                        this.in.putString(new Character((char)ch).toString());
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (Exception e) {
                    Util.println("MonitorThread: " + e.getMessage(), this.s);
                }
            }
        }

        public void setStatus(MonitorStatus status) {
            this.status = status;
        }

        public MonitorStatus getStatus() {
            return this.status;
        }

        public boolean isRunning() {
            return this.status == MonitorStatus.RUNNING;
        }

        public boolean isStopped() {
            return this.status == MonitorStatus.STOPPED;
        }

        public boolean isCanceled() {
            return this.status == MonitorStatus.CANCELED;
        }

        public boolean isReturnPressed() {
            if (this.returnPressed) {
                this.returnPressed = false;
                return true;
            }
            return false;
        }

        @Override
        public String toString() {
            return "MonitorThread with TID: " + this.getId();
        }
    }

    class JDBCWorkerThread
    extends Thread {
        private Settings s;
        private int lineFile;
        private int lineStmt;
        private StringBuffer sql;
        private Thread mainThread;
        private InputStreamMonitor streamMonitor;

        public JDBCWorkerThread(StringBuffer sql, Settings s, int lineFile, int lineStmt, Thread mainThread, InputStreamMonitor streamMonitor) {
            this.sql = sql;
            this.s = s;
            this.lineFile = lineFile;
            this.lineStmt = lineStmt;
            this.mainThread = mainThread;
            this.streamMonitor = streamMonitor;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                ProcessInput.this.execJDBC(this.sql, this.s, this.lineFile, this.lineStmt);
            }
            catch (SQLException se) {
                if (this.streamMonitor == null || !this.streamMonitor.isCanceled()) {
                    String msg = se.getMessage();
                    if (msg.startsWith("ERROR: ")) {
                        msg = msg.substring(7, msg.length());
                    }
                    Util.println("ERROR near line " + this.lineFile + ":", this.s);
                    Util.println(msg, this.s);
                    ProcessInput.this.handleSQLError(se, this.s);
                }
            }
            catch (InternalException iex) {
                Util.println("PolarDB-" + Util.padLeft("" + iex.getErrorCode(), '0', 4) + ": " + iex.getMessage(), this.s);
                this.s.getDBHandler().implicitRollback();
            }
            finally {
                this.streamMonitor.setStatus(MonitorStatus.STOPPED);
            }
        }

        @Override
        public String toString() {
            return "JDBCThread with TID: " + this.getId();
        }
    }

    static enum MonitorStatus {
        IDLE,
        RUNNING,
        STOPPED,
        CANCELED;

    }
}

