/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb2.polarora;

import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Enumeration;
import java.util.Locale;

public enum PolarDriverPrefix {
    POSTGRES("postgresql", "jdbc:postgresql:", "POSTGRES Database"),
    POLARDB("polardb", "jdbc:polardb:", "POLARDB Database Compatible with Oracle"),
    POLARDB2("polardb2", "jdbc:polardb2:", "POLARDB Database Compatible with Oracle 2.0"),
    ORACLE_THIN("oracle", "jdbc:oracle:thin:", "Oracle"),
    ORACLE("oracle", "jdbc:oracle:", "Oracle");

    private String mode;
    private String prefix;
    private int prefixLen;
    private String productName;

    private PolarDriverPrefix(String mode, String prefix, String productName) {
        this.mode = mode;
        this.prefix = prefix;
        this.prefixLen = prefix.length();
        this.productName = productName;
    }

    private static int compOraclePrefix() {
        String urlAllowOraclePrefix = System.getProperty("POLARDB.JDBC.urlAllowOraclePrefix");
        if (urlAllowOraclePrefix == null) {
            return 1;
        }
        if ((urlAllowOraclePrefix = urlAllowOraclePrefix.toLowerCase(Locale.ROOT)).equals("off") || urlAllowOraclePrefix.equals("0") || urlAllowOraclePrefix.equals("false")) {
            return 0;
        }
        if (urlAllowOraclePrefix.equals("auto")) {
            return 2;
        }
        return 1;
    }

    public static PolarDriverPrefix buildCompMode(String url) {
        PolarDriverPrefix ret = null;
        if (url == null || url.isEmpty()) {
            return null;
        }
        for (PolarDriverPrefix mode : PolarDriverPrefix.values()) {
            if (mode == POSTGRES || !url.startsWith(mode.getPrefix())) continue;
            ret = mode;
            break;
        }
        if (ret != ORACLE && ret != ORACLE_THIN) {
            return ret;
        }
        switch (PolarDriverPrefix.compOraclePrefix()) {
            case 0: {
                return null;
            }
            case 1: {
                return ret;
            }
            case 2: {
                Enumeration<Driver> drivers = DriverManager.getDrivers();
                while (drivers.hasMoreElements()) {
                    Driver driver = drivers.nextElement();
                    if (!driver.getClass().getName().toLowerCase(Locale.ROOT).contains("oracle.jdbc")) continue;
                    return null;
                }
                return ret;
            }
        }
        throw new RuntimeException("Unexpected run path for compOraclePrefix");
    }

    public static PolarDriverPrefix forName(String name) {
        for (PolarDriverPrefix mode : PolarDriverPrefix.values()) {
            if (!mode.getMode().equalsIgnoreCase(name)) continue;
            return mode;
        }
        return null;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int getPrefixLen() {
        return this.prefixLen;
    }

    public String getMode() {
        return this.mode;
    }

    public String getProductName() {
        return this.productName;
    }

    public static boolean checkUrlPrefix(String url) {
        if (url == null || url.isEmpty()) {
            return false;
        }
        PolarDriverPrefix compMode = PolarDriverPrefix.buildCompMode(url);
        return compMode != null;
    }
}

