/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb.jdbc;

import com.aliyun.polardb.Driver;
import com.aliyun.polardb.core.BaseConnection;
import com.aliyun.polardb.core.CachedQuery;
import com.aliyun.polardb.core.ParameterList;
import com.aliyun.polardb.core.Query;
import com.aliyun.polardb.core.QueryExecutor;
import com.aliyun.polardb.core.ServerVersion;
import com.aliyun.polardb.core.SetupQueryRunner;
import com.aliyun.polardb.core.TypeInfo;
import com.aliyun.polardb.core.v3.BatchedQuery;
import com.aliyun.polardb.core.v3.QueryExecutorImpl;
import com.aliyun.polardb.core.v3.SimpleParameterList;
import com.aliyun.polardb.jdbc.BooleanTypeUtil;
import com.aliyun.polardb.jdbc.PgArray;
import com.aliyun.polardb.jdbc.PgClobText;
import com.aliyun.polardb.jdbc.PgConnection;
import com.aliyun.polardb.jdbc.PgParameterMetaData;
import com.aliyun.polardb.jdbc.PgResultSet;
import com.aliyun.polardb.jdbc.PgSQLXML;
import com.aliyun.polardb.jdbc.PgStatement;
import com.aliyun.polardb.jdbc.PreferQueryMode;
import com.aliyun.polardb.jdbc.PrimitiveArraySupport;
import com.aliyun.polardb.jdbc.ResultWrapper;
import com.aliyun.polardb.jdbc.TimestampUtils;
import com.aliyun.polardb.jdbc.TypeInfoCache;
import com.aliyun.polardb.jdbc2.Struct;
import com.aliyun.polardb.largeobject.LargeObject;
import com.aliyun.polardb.largeobject.LargeObjectManager;
import com.aliyun.polardb.stream.SQLObjectFactory;
import com.aliyun.polardb.util.ByteConverter;
import com.aliyun.polardb.util.GT;
import com.aliyun.polardb.util.HStoreConverter;
import com.aliyun.polardb.util.PGBinaryObject;
import com.aliyun.polardb.util.PGTime;
import com.aliyun.polardb.util.PGTimestamp;
import com.aliyun.polardb.util.PGobject;
import com.aliyun.polardb.util.PSQLException;
import com.aliyun.polardb.util.PSQLState;
import com.aliyun.polardb.util.ReaderInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;

class PgPreparedStatement
extends PgStatement
implements PreparedStatement {
    protected final CachedQuery preparedQuery;
    protected final ParameterList preparedParameters;
    protected boolean adjustIndex = false;
    private TimeZone defaultTimeZone;
    protected boolean hasSetUnamedProc = false;

    PgPreparedStatement(PgConnection connection, String sql, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        this(connection, connection.borrowQuery(sql), false, rsType, rsConcurrency, rsHoldability);
    }

    PgPreparedStatement(PgConnection connection, CachedQuery query, boolean isCallable, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        super(connection, rsType, rsConcurrency, rsHoldability);
        this.isCallable = isCallable;
        this.preparedQuery = query;
        this.preparedParameters = isCallable ? this.preparedQuery.query.createParameterList().copy() : this.preparedQuery.query.createParameterList();
        this.outParmBeforeFunc = this.adjustIndex = this.preparedQuery.outParmBeforeFunc;
        this.preparedParameters.setFunctionReturns(this.outParmBeforeFunc);
        this.setPoolable(true);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        throw new PSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement.", new Object[0]), PSQLState.WRONG_OBJECT_TYPE);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (!this.executeWithFlags(0)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        return this.getSingleResultSet();
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw new PSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement.", new Object[0]), PSQLState.WRONG_OBJECT_TYPE);
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (this.preparedQuery.isUnamedProc) {
            if (!this.hasSetUnamedProc) {
                this.polar_unamed_proc_process_begin();
            }
            this.executeWithFlags(0);
            return 1;
        }
        if (this.isFunction || this.isCallable) {
            this.executeWithFlags(0);
            return 0;
        }
        this.executeWithFlags(4);
        return this.getNoResultUpdateCount();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw new PSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement.", new Object[0]), PSQLState.WRONG_OBJECT_TYPE);
    }

    public final void polar_execute_oneshot_sql(String sql) throws SQLException {
        QueryExecutor qe = this.connection.getQueryExecutor();
        SetupQueryRunner.run(qe, sql, false);
    }

    public void polar_unamed_proc_process_begin() throws SQLException {
        String procSql = "create procedure " + this.preparedQuery.unamedProcName + "(";
        String target_type = "";
        if (this.preparedParameters instanceof SimpleParameterList) {
            SimpleParameterList simple_paramemter_list = (SimpleParameterList)this.preparedParameters;
            String procBody = this.preparedQuery.getUnamedProcBody();
            if (procBody.length() == 0) {
                throw new SQLException("Cannot get the unamed proc body");
            }
            for (int i = 0; i < simple_paramemter_list.getParameterCount(); ++i) {
                String type = "";
                if (simple_paramemter_list.isInOutParam(i)) {
                    type = " INOUT ";
                } else if (simple_paramemter_list.isInParam(i)) {
                    type = " IN ";
                } else if (simple_paramemter_list.isOutParam(i)) {
                    type = " OUT ";
                }
                target_type = simple_paramemter_list.getTypeToString(i);
                if (target_type.equalsIgnoreCase("UNSPECIFIED")) {
                    target_type = "TEXT";
                }
                procSql = procSql + "par_" + i + type + target_type;
                if (i != simple_paramemter_list.getParameterCount() - 1) {
                    procSql = procSql + ",";
                }
                procBody = procBody.replaceFirst("[?]", "par_" + i);
            }
            procSql = procSql + ")\nis\n";
            procSql = procSql + procBody;
        }
        this.polar_execute_oneshot_sql(procSql);
        this.hasSetUnamedProc = true;
    }

    public void polar_unamed_proc_process_end() throws SQLException {
        String procSql = "drop procedure " + this.preparedQuery.unamedProcName + ";";
        this.polar_execute_oneshot_sql(procSql);
    }

    @Override
    public boolean execute() throws SQLException {
        if (!this.hasSetUnamedProc && this.preparedQuery.isUnamedProc) {
            this.polar_unamed_proc_process_begin();
        }
        return this.executeWithFlags(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean executeWithFlags(int flags) throws SQLException {
        int cols;
        ResultSet rs;
        block22: {
            block20: {
                block21: {
                    try {
                        this.checkClosed();
                        if (this.connection.getPreferQueryMode() == PreferQueryMode.SIMPLE) {
                            flags |= 0x400;
                        }
                        this.execute(this.preparedQuery, this.preparedParameters, flags);
                        PgPreparedStatement pgPreparedStatement = this;
                        // MONITORENTER : pgPreparedStatement
                        this.checkClosed();
                        if (!this.isFunction && !this.isCallable) break block20;
                        if (!this.returnTypeSet) {
                            if (this.result != null) {
                                ResultSet rs2 = this.result.getResultSet();
                                if (rs2 != null) {
                                    rs2.close();
                                }
                                this.result = null;
                            }
                            boolean rs2 = false;
                            // MONITOREXIT : pgPreparedStatement
                            this.defaultTimeZone = null;
                            return rs2;
                        }
                        if (this.result == null) throw new PSQLException(GT.tr("A CallableStatement was executed with nothing returned.", new Object[0]), PSQLState.NO_DATA);
                        if (this.result.getResultSet() != null) break block21;
                    }
                    catch (Throwable throwable) {
                        this.defaultTimeZone = null;
                        throw throwable;
                    }
                    throw new PSQLException(GT.tr("A CallableStatement was executed with nothing returned.", new Object[0]), PSQLState.NO_DATA);
                }
                rs = this.result.getResultSet();
                if (!rs.next()) {
                    throw new PSQLException(GT.tr("A CallableStatement was executed with nothing returned.", new Object[0]), PSQLState.NO_DATA);
                }
                cols = rs.getMetaData().getColumnCount();
                int outParameterCount = this.preparedParameters.getParameterCount();
                if (this.outParmBeforeFunc) {
                    ++outParameterCount;
                }
                if (cols != outParameterCount) {
                    throw new PSQLException(GT.tr("A CallableStatement was executed with an invalid number of parameters", new Object[0]), PSQLState.SYNTAX_ERROR);
                }
                break block22;
            }
            boolean bl = this.result != null && this.result.getResultSet() != null;
            // MONITOREXIT : pgPreparedStatement
            this.defaultTimeZone = null;
            return bl;
        }
        this.lastIndex = 0;
        this.callResult = new Object[this.preparedParameters.getParameterCount() + 1];
        int i = 0;
        int j = 0;
        while (true) {
            if (i >= cols) {
                rs.close();
                this.result = null;
                boolean bl = false;
                // MONITOREXIT : pgPreparedStatement
                this.defaultTimeZone = null;
                return bl;
            }
            this.callResult[j] = rs.getObject(i + 1);
            int columnType = rs.getMetaData().getColumnType(i + 1);
            String typeName = rs.getMetaData().getColumnTypeName(i + 1);
            String registeredTypeName = null;
            if (this.preparedParameters instanceof SimpleParameterList) {
                int paramIndex = i + 1;
                registeredTypeName = this.isFunction ? (--paramIndex > 0 ? ((SimpleParameterList)this.preparedParameters).getOutParameterTypeName(paramIndex) : ((SimpleParameterList)this.preparedParameters).getReturnTypeName()) : ((SimpleParameterList)this.preparedParameters).getOutParameterTypeName(paramIndex);
            }
            if (columnType != 0 && columnType != this.functionReturnType[j]) {
                if (columnType != 8 || this.functionReturnType[j] != 7) throw new PSQLException(GT.tr("A CallableStatement function was executed and the out parameter {0} was of type {1} however type {2} was registered.", new Integer(i + 1), "java.sql.Types=" + columnType, "java.sql.Types=" + this.functionReturnType[j]), PSQLState.DATA_TYPE_MISMATCH);
                if (this.callResult[j] != null) {
                    this.callResult[j] = new Float(((Double)this.callResult[j]).floatValue());
                }
            }
            if (registeredTypeName != null && typeName != null && !TypeInfoCache.compareTypeNames(registeredTypeName, typeName)) {
                throw new PSQLException(GT.tr("A CallableStatement function was executed and the return type name was {0} however type name {1} was registered for index {2}.", typeName, registeredTypeName, "" + i), PSQLState.DATA_TYPE_MISMATCH);
            }
            ++i;
            ++j;
        }
    }

    @Override
    protected boolean isOneShotQuery(CachedQuery cachedQuery) {
        if (cachedQuery == null) {
            cachedQuery = this.preparedQuery;
        }
        return super.isOneShotQuery(cachedQuery);
    }

    @Override
    public void closeImpl() throws SQLException {
        if (this.preparedQuery != null) {
            ((PgConnection)this.connection).releaseQuery(this.preparedQuery);
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        int oid;
        this.checkClosed();
        switch (sqlType) {
            case 2009: {
                oid = 142;
                break;
            }
            case 4: {
                oid = 23;
                break;
            }
            case -6: 
            case 5: {
                oid = 21;
                break;
            }
            case -5: {
                oid = 20;
                break;
            }
            case 7: {
                oid = 700;
                break;
            }
            case 6: 
            case 8: {
                oid = 701;
                break;
            }
            case 2: 
            case 3: {
                oid = 1700;
                break;
            }
            case 1: {
                if (!this.connection.isPolarComp()) {
                    oid = 1042;
                    break;
                }
            }
            case -1: 
            case 12: {
                oid = this.connection.getStringVarcharFlag() ? 1043 : 0;
                break;
            }
            case 91: {
                oid = 1082;
                if (!this.connection.isMapDateToTimestamp()) break;
                oid = 1114;
                break;
            }
            case 92: 
            case 93: 
            case 2013: 
            case 2014: {
                oid = 0;
                break;
            }
            case -7: 
            case 16: {
                oid = 16;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                oid = 17;
                break;
            }
            case 2004: {
                oid = this.connection.getBlobAsBytea() ? 17 : 26;
                break;
            }
            case 2005: {
                oid = this.connection.getClobAsText() ? (this.connection.getStringVarcharFlag() ? 1043 : 0) : 26;
                break;
            }
            case 0: 
            case 1111: 
            case 2001: 
            case 2002: 
            case 2003: {
                oid = 0;
                break;
            }
            default: {
                throw new PSQLException(GT.tr("Unknown Types value.", new Object[0]), PSQLState.INVALID_PARAMETER_TYPE);
            }
        }
        if (this.adjustIndex) {
            --parameterIndex;
        }
        this.preparedParameters.setNull(parameterIndex, oid);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkClosed();
        if (this.connection.isBoolAsInt()) {
            this.bindLiteral(parameterIndex, x ? "1" : "0", 21);
        } else {
            this.bindLiteral(parameterIndex, x ? "TRUE" : "FALSE", 16);
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setShort(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkClosed();
        if (this.connection.binaryTransferSend(21)) {
            byte[] val = new byte[2];
            ByteConverter.int2(val, 0, x);
            this.bindBytes(parameterIndex, val, 21);
            return;
        }
        this.bindLiteral(parameterIndex, Integer.toString(x), 21);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkClosed();
        if (this.connection.binaryTransferSend(23)) {
            byte[] val = new byte[4];
            ByteConverter.int4(val, 0, x);
            this.bindBytes(parameterIndex, val, 23);
            return;
        }
        this.bindLiteral(parameterIndex, Integer.toString(x), 23);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkClosed();
        if (this.connection.binaryTransferSend(20)) {
            byte[] val = new byte[8];
            ByteConverter.int8(val, 0, x);
            this.bindBytes(parameterIndex, val, 20);
            return;
        }
        this.bindLiteral(parameterIndex, Long.toString(x), 20);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkClosed();
        if (this.connection.binaryTransferSend(700)) {
            byte[] val = new byte[4];
            ByteConverter.float4(val, 0, x);
            this.bindBytes(parameterIndex, val, 700);
            return;
        }
        this.bindLiteral(parameterIndex, Float.toString(x), 701);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkClosed();
        if (this.connection.binaryTransferSend(701)) {
            byte[] val = new byte[8];
            ByteConverter.float8(val, 0, x);
            this.bindBytes(parameterIndex, val, 701);
            return;
        }
        this.bindLiteral(parameterIndex, Double.toString(x), 701);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setNumber(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkClosed();
        this.setString(parameterIndex, x, this.getStringType());
    }

    private int getStringType() {
        return this.connection.getStringVarcharFlag() ? 1043 : 0;
    }

    protected void setString(int parameterIndex, String x, int oid) throws SQLException {
        this.checkClosed();
        if (x == null) {
            if (this.adjustIndex) {
                --parameterIndex;
            }
            this.preparedParameters.setNull(parameterIndex, oid);
        } else {
            this.bindString(parameterIndex, x, oid);
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkClosed();
        if (null == x) {
            this.setNull(parameterIndex, -3);
            return;
        }
        byte[] copy = new byte[x.length];
        System.arraycopy(x, 0, copy, 0, x.length);
        this.preparedParameters.setBytea(parameterIndex, copy, 0, x.length);
    }

    @Override
    public void setDate(int parameterIndex, java.sql.Date x) throws SQLException {
        if (x != null && this.connection.isMapDateToTimestamp()) {
            this.setTimestamp(parameterIndex, new Timestamp(x.getTime()));
            return;
        }
        this.setDate(parameterIndex, x, null);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTime(parameterIndex, x, null);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setTimestamp(parameterIndex, x, null);
    }

    private void setCharacterStreamPost71(int parameterIndex, InputStream x, int length, String encoding) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 12);
            return;
        }
        if (length < 0) {
            throw new PSQLException(GT.tr("Invalid stream length {0}.", length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        try {
            int n;
            InputStreamReader inStream = new InputStreamReader(x, encoding);
            char[] chars = new char[length];
            int charsRead = 0;
            while ((n = inStream.read(chars, charsRead, length - charsRead)) != -1 && (charsRead += n) != length) {
            }
            this.setString(parameterIndex, new String(chars, 0, charsRead), 1043);
        }
        catch (UnsupportedEncodingException uee) {
            throw new PSQLException(GT.tr("The JVM claims not to support the {0} encoding.", encoding), PSQLState.UNEXPECTED_ERROR, (Throwable)uee);
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Provided InputStream failed.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)ioe);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        this.setCharacterStreamPost71(parameterIndex, x, length, "ASCII");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        this.setCharacterStreamPost71(parameterIndex, x, length, "UTF-8");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, -3);
            return;
        }
        if (length < 0) {
            throw new PSQLException(GT.tr("Invalid stream length {0}.", length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.preparedParameters.setBytea(parameterIndex, x, length);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.preparedParameters.clear();
    }

    private void setPGobject(int parameterIndex, PGobject x) throws SQLException {
        int oid;
        String typename = x.getType();
        if (typename.equals("date") && this.connection.isMapDateToTimestamp()) {
            typename = "timestamp";
        }
        if ((oid = this.connection.getTypeInfo().getPGType(typename)) == 0) {
            throw new PSQLException(GT.tr("Unknown type {0}.", typename), PSQLState.INVALID_PARAMETER_TYPE);
        }
        if (x instanceof PGBinaryObject && this.connection.binaryTransferSend(oid)) {
            PGBinaryObject binObj = (PGBinaryObject)((Object)x);
            byte[] data = new byte[binObj.lengthInBytes()];
            binObj.toBytes(data, 0);
            this.bindBytes(parameterIndex, data, oid);
        } else {
            this.setString(parameterIndex, x.getValue(), oid);
        }
    }

    private void setMap(int parameterIndex, Map<?, ?> x) throws SQLException {
        int oid = this.connection.getTypeInfo().getPGType("hstore");
        if (oid == 0) {
            throw new PSQLException(GT.tr("No hstore extension installed.", new Object[0]), PSQLState.INVALID_PARAMETER_TYPE);
        }
        if (this.connection.binaryTransferSend(oid)) {
            byte[] data = HStoreConverter.toBytes(x, this.connection.getEncoding());
            this.bindBytes(parameterIndex, data, oid);
        } else {
            this.setString(parameterIndex, HStoreConverter.toString(x), oid);
        }
    }

    private void setNumber(int parameterIndex, Number x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, 3);
        } else {
            this.bindLiteral(parameterIndex, x.toString(), 1700);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object in, int targetSqlType, int scale) throws SQLException {
        this.checkClosed();
        if (in == null) {
            this.setNull(parameterIndex, targetSqlType);
            return;
        }
        if (targetSqlType == 1111 && in instanceof UUID && this.connection.haveMinimumServerVersion(ServerVersion.v8_3)) {
            this.setUuid(parameterIndex, (UUID)in);
            return;
        }
        switch (targetSqlType) {
            case 2009: {
                if (in instanceof SQLXML) {
                    this.setSQLXML(parameterIndex, (SQLXML)in);
                    break;
                }
                this.setSQLXML(parameterIndex, new PgSQLXML(this.connection, in.toString()));
                break;
            }
            case 4: {
                this.setInt(parameterIndex, PgPreparedStatement.castToInt(in));
                break;
            }
            case -6: 
            case 5: {
                this.setShort(parameterIndex, PgPreparedStatement.castToShort(in));
                break;
            }
            case -5: {
                this.setLong(parameterIndex, PgPreparedStatement.castToLong(in));
                break;
            }
            case 7: {
                this.setFloat(parameterIndex, PgPreparedStatement.castToFloat(in));
                break;
            }
            case 6: 
            case 8: {
                this.setDouble(parameterIndex, PgPreparedStatement.castToDouble(in));
                break;
            }
            case 2: 
            case 3: {
                this.setBigDecimal(parameterIndex, PgPreparedStatement.castToBigDecimal(in, scale));
                break;
            }
            case 1: {
                this.setString(parameterIndex, PgPreparedStatement.castToString(in), 1042);
                break;
            }
            case 12: {
                this.setString(parameterIndex, PgPreparedStatement.castToString(in), this.getStringType());
                break;
            }
            case -1: {
                if (in instanceof InputStream) {
                    this.preparedParameters.setText(parameterIndex, (InputStream)in);
                    break;
                }
                this.setString(parameterIndex, PgPreparedStatement.castToString(in), this.getStringType());
                break;
            }
            case 91: {
                java.sql.Date tmpd;
                if (in instanceof java.sql.Date) {
                    this.setDate(parameterIndex, (java.sql.Date)in);
                    break;
                }
                if (in instanceof Date) {
                    tmpd = new java.sql.Date(((Date)in).getTime());
                } else {
                    if (in instanceof LocalDate) {
                        this.setDate(parameterIndex, (LocalDate)in);
                        break;
                    }
                    tmpd = this.connection.getTimestampUtils().toDate(this.getDefaultCalendar(), in.toString());
                }
                this.setDate(parameterIndex, tmpd);
                break;
            }
            case 92: {
                Time tmpt;
                if (in instanceof Time) {
                    this.setTime(parameterIndex, (Time)in);
                    break;
                }
                if (in instanceof Date) {
                    tmpt = new Time(((Date)in).getTime());
                } else {
                    if (in instanceof LocalTime) {
                        this.setTime(parameterIndex, (LocalTime)in);
                        break;
                    }
                    tmpt = this.connection.getTimestampUtils().toTime(this.getDefaultCalendar(), in.toString());
                }
                this.setTime(parameterIndex, tmpt);
                break;
            }
            case 93: {
                Timestamp tmpts;
                if (in instanceof PGTimestamp) {
                    this.setObject(parameterIndex, in);
                    break;
                }
                if (in instanceof Timestamp) {
                    this.setTimestamp(parameterIndex, (Timestamp)in);
                    break;
                }
                if (in instanceof Date) {
                    tmpts = new Timestamp(((Date)in).getTime());
                } else {
                    if (in instanceof LocalDateTime) {
                        this.setTimestamp(parameterIndex, (LocalDateTime)in);
                        break;
                    }
                    tmpts = this.connection.getTimestampUtils().toTimestamp(this.getDefaultCalendar(), in.toString());
                }
                this.setTimestamp(parameterIndex, tmpts);
                break;
            }
            case 2014: {
                if (in instanceof OffsetDateTime) {
                    this.setTimestamp(parameterIndex, (OffsetDateTime)in);
                    break;
                }
                if (in instanceof PGTimestamp) {
                    this.setObject(parameterIndex, in);
                    break;
                }
                throw new PSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", in.getClass().getName(), "Types.TIMESTAMP_WITH_TIMEZONE"), PSQLState.INVALID_PARAMETER_TYPE);
            }
            case -7: 
            case 16: {
                this.setBoolean(parameterIndex, BooleanTypeUtil.castToBoolean(in));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setObject(parameterIndex, in);
                break;
            }
            case 2004: {
                if (in instanceof Blob) {
                    this.setBlob(parameterIndex, (Blob)in);
                    break;
                }
                if (in instanceof byte[]) {
                    this.setBlob(parameterIndex, new ByteArrayInputStream((byte[])in));
                    break;
                }
                if (in instanceof InputStream) {
                    if (this.connection.getBlobAsBytea()) {
                        this.setBlobBytea(parameterIndex, (InputStream)in);
                        break;
                    }
                    long oid = this.createBlob(parameterIndex, (InputStream)in, -1L);
                    this.setLong(parameterIndex, oid);
                    break;
                }
                throw new PSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", in.getClass().getName(), "Types.BLOB"), PSQLState.INVALID_PARAMETER_TYPE);
            }
            case 2005: {
                if (this.connection.getClobAsText()) {
                    if (in instanceof PgClobText) {
                        this.setString(parameterIndex, in.toString());
                        break;
                    }
                    this.setString(parameterIndex, PgPreparedStatement.castToString(in), this.getStringType());
                    break;
                }
                if (in instanceof Clob) {
                    this.setClob(parameterIndex, (Clob)in);
                    break;
                }
                throw new PSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", in.getClass().getName(), "Types.CLOB"), PSQLState.INVALID_PARAMETER_TYPE);
            }
            case 2003: {
                if (in instanceof Array) {
                    this.setArray(parameterIndex, (Array)in);
                    break;
                }
                if (PrimitiveArraySupport.isSupportedPrimitiveArray(in)) {
                    this.setPrimitiveArray(parameterIndex, in);
                    break;
                }
                throw new PSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", in.getClass().getName(), "Types.ARRAY"), PSQLState.INVALID_PARAMETER_TYPE);
            }
            case 2001: {
                this.bindString(parameterIndex, in.toString(), 0);
                break;
            }
            case 1111: {
                if (in instanceof PGobject) {
                    this.setPGobject(parameterIndex, (PGobject)in);
                    break;
                }
                if (in instanceof Map) {
                    this.setMap(parameterIndex, (Map)in);
                    break;
                }
                this.bindString(parameterIndex, in.toString(), 0);
                break;
            }
            default: {
                throw new PSQLException(GT.tr("Unsupported Types value: {0}", targetSqlType), PSQLState.INVALID_PARAMETER_TYPE);
            }
        }
    }

    private <A> void setPrimitiveArray(int parameterIndex, A in) throws SQLException {
        PrimitiveArraySupport<A> arrayToString = PrimitiveArraySupport.getArraySupport(in);
        TypeInfo typeInfo = this.connection.getTypeInfo();
        int oid = arrayToString.getDefaultArrayTypeOid(typeInfo);
        if (arrayToString.supportBinaryRepresentation() && this.connection.getPreferQueryMode() != PreferQueryMode.SIMPLE) {
            this.bindBytes(parameterIndex, arrayToString.toBinaryRepresentation(this.connection, in), oid);
        } else {
            char delim = typeInfo.getArrayDelimiter(oid);
            this.setString(parameterIndex, arrayToString.toArrayString(delim, in), oid);
        }
    }

    private static String asString(Clob in) throws SQLException {
        return in.getSubString(1L, (int)in.length());
    }

    private static int castToInt(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Integer.parseInt((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).intValue();
            }
            if (in instanceof Date) {
                return (int)((Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1 : 0;
            }
            if (in instanceof Clob) {
                return Integer.parseInt(PgPreparedStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Integer.parseInt(in.toString());
            }
        }
        catch (Exception e) {
            throw PgPreparedStatement.cannotCastException(in.getClass().getName(), "int", e);
        }
        throw PgPreparedStatement.cannotCastException(in.getClass().getName(), "int");
    }

    private static short castToShort(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Short.parseShort((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).shortValue();
            }
            if (in instanceof Date) {
                return (short)((Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? (short)1 : 0;
            }
            if (in instanceof Clob) {
                return Short.parseShort(PgPreparedStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Short.parseShort(in.toString());
            }
        }
        catch (Exception e) {
            throw PgPreparedStatement.cannotCastException(in.getClass().getName(), "short", e);
        }
        throw PgPreparedStatement.cannotCastException(in.getClass().getName(), "short");
    }

    private static long castToLong(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Long.parseLong((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).longValue();
            }
            if (in instanceof Date) {
                return ((Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1L : 0L;
            }
            if (in instanceof Clob) {
                return Long.parseLong(PgPreparedStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Long.parseLong(in.toString());
            }
        }
        catch (Exception e) {
            throw PgPreparedStatement.cannotCastException(in.getClass().getName(), "long", e);
        }
        throw PgPreparedStatement.cannotCastException(in.getClass().getName(), "long");
    }

    private static float castToFloat(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Float.parseFloat((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).floatValue();
            }
            if (in instanceof Date) {
                return ((Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1.0f : 0.0f;
            }
            if (in instanceof Clob) {
                return Float.parseFloat(PgPreparedStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Float.parseFloat(in.toString());
            }
        }
        catch (Exception e) {
            throw PgPreparedStatement.cannotCastException(in.getClass().getName(), "float", e);
        }
        throw PgPreparedStatement.cannotCastException(in.getClass().getName(), "float");
    }

    private static double castToDouble(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Double.parseDouble((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).doubleValue();
            }
            if (in instanceof Date) {
                return ((Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1.0 : 0.0;
            }
            if (in instanceof Clob) {
                return Double.parseDouble(PgPreparedStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Double.parseDouble(in.toString());
            }
        }
        catch (Exception e) {
            throw PgPreparedStatement.cannotCastException(in.getClass().getName(), "double", e);
        }
        throw PgPreparedStatement.cannotCastException(in.getClass().getName(), "double");
    }

    private static BigDecimal castToBigDecimal(Object in, int scale) throws SQLException {
        try {
            BigDecimal rc = null;
            if (in instanceof String) {
                rc = new BigDecimal((String)in);
            } else if (in instanceof BigDecimal) {
                rc = (BigDecimal)in;
            } else if (in instanceof BigInteger) {
                rc = new BigDecimal((BigInteger)in);
            } else if (in instanceof Long || in instanceof Integer || in instanceof Short || in instanceof Byte) {
                rc = BigDecimal.valueOf(((Number)in).longValue());
            } else if (in instanceof Double || in instanceof Float) {
                rc = BigDecimal.valueOf(((Number)in).doubleValue());
            } else if (in instanceof Date) {
                rc = BigDecimal.valueOf(((Date)in).getTime());
            } else if (in instanceof Boolean) {
                rc = (Boolean)in != false ? BigDecimal.ONE : BigDecimal.ZERO;
            } else if (in instanceof Clob) {
                rc = new BigDecimal(PgPreparedStatement.asString((Clob)in));
            } else if (in instanceof Character) {
                rc = new BigDecimal(new char[]{((Character)in).charValue()});
            }
            if (rc != null) {
                if (scale >= 0) {
                    rc = rc.setScale(scale, RoundingMode.HALF_UP);
                }
                return rc;
            }
        }
        catch (Exception e) {
            throw PgPreparedStatement.cannotCastException(in.getClass().getName(), "BigDecimal", e);
        }
        throw PgPreparedStatement.cannotCastException(in.getClass().getName(), "BigDecimal");
    }

    private static String castToString(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return (String)in;
            }
            if (in instanceof Clob) {
                return PgPreparedStatement.asString((Clob)in);
            }
            return in.toString();
        }
        catch (Exception e) {
            throw PgPreparedStatement.cannotCastException(in.getClass().getName(), "String", e);
        }
    }

    private static PSQLException cannotCastException(String fromType, String toType) {
        return PgPreparedStatement.cannotCastException(fromType, toType, null);
    }

    private static PSQLException cannotCastException(String fromType, String toType, Exception cause) {
        return new PSQLException(GT.tr("Cannot convert an instance of {0} to type {1}", fromType, toType), PSQLState.INVALID_PARAMETER_TYPE, (Throwable)cause);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType, -1);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, 1111);
        } else if (x instanceof UUID && this.connection.haveMinimumServerVersion(ServerVersion.v8_3)) {
            this.setUuid(parameterIndex, (UUID)x);
        } else if (x instanceof SQLXML) {
            this.setSQLXML(parameterIndex, (SQLXML)x);
        } else if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
        } else if (x instanceof java.sql.Date) {
            this.setDate(parameterIndex, (java.sql.Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (x instanceof Byte) {
            this.setByte(parameterIndex, (Byte)x);
        } else if (x instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)x);
        } else if (x instanceof Clob) {
            this.setClob(parameterIndex, (Clob)x);
        } else if (x instanceof Array) {
            this.setArray(parameterIndex, (Array)x);
        } else if (x instanceof PGobject) {
            this.setPGobject(parameterIndex, (PGobject)x);
        } else if (x instanceof int[]) {
            this.setIntArray(parameterIndex, (int[])x);
        } else if (x instanceof short[]) {
            this.setShortArray(parameterIndex, (short[])x);
        } else if (x instanceof long[]) {
            this.setLongArray(parameterIndex, (long[])x);
        } else if (x instanceof float[]) {
            this.setFloatArray(parameterIndex, (float[])x);
        } else if (x instanceof double[]) {
            this.setDoubleArray(parameterIndex, (double[])x);
        } else if (x instanceof char[]) {
            this.setCharArray(parameterIndex, (char[])x);
        } else if (x instanceof boolean[]) {
            this.setBooleanArray(parameterIndex, (boolean[])x);
        } else if (x instanceof String[]) {
            this.setStringArray(parameterIndex, (String[])x);
        } else if (x instanceof Character) {
            this.setString(parameterIndex, ((Character)x).toString());
        } else if (x instanceof LocalDate) {
            this.setDate(parameterIndex, (LocalDate)x);
        } else if (x instanceof LocalTime) {
            this.setTime(parameterIndex, (LocalTime)x);
        } else if (x instanceof LocalDateTime) {
            this.setTimestamp(parameterIndex, (LocalDateTime)x);
        } else if (x instanceof OffsetDateTime) {
            this.setTimestamp(parameterIndex, (OffsetDateTime)x);
        } else if (x instanceof Map) {
            this.setMap(parameterIndex, (Map)x);
        } else if (x instanceof SQLData) {
            SQLOutput g = SQLObjectFactory.createSQLOutput();
            SQLData sdata = (SQLData)x;
            g.writeObject(sdata);
            this.setSQLObject(parameterIndex, g.toString(), sdata.getSQLTypeName());
        } else if (x instanceof Struct) {
            Struct struct = (Struct)x;
            this.preparedParameters.setObjectParameter(this.adjustIndex ? parameterIndex - 1 : parameterIndex, x, struct.getOid());
        } else if (x instanceof java.sql.Struct) {
            java.sql.Struct struct = (java.sql.Struct)x;
            Struct edbStruct = (Struct)this.connection.createStruct(struct.getSQLTypeName(), struct.getAttributes());
            this.preparedParameters.setObjectParameter(this.adjustIndex ? parameterIndex - 1 : parameterIndex, edbStruct, edbStruct.getOid());
        } else if (x instanceof Number) {
            this.setNumber(parameterIndex, (Number)x);
        } else if (PrimitiveArraySupport.isSupportedPrimitiveArray(x)) {
            this.setPrimitiveArray(parameterIndex, x);
        } else {
            throw new PSQLException(GT.tr("Can''t infer the SQL type to use for an instance of {0}. Use setObject() with an explicit Types value to specify the type to use.", x.getClass().getName()), PSQLState.INVALID_PARAMETER_TYPE);
        }
    }

    private void setSQLObject(int paramIndex, String data, String type) throws SQLException {
        String query = "select typrelid from pg_type where typname='" + type + "'";
        Connection con = this.getConnection();
        Statement st = con.createStatement();
        ResultSet rs = st.executeQuery(query);
        int oid = 0;
        if (!rs.next()) {
            st.close();
            throw new SQLException("Cannot locate the requested type on the server.");
        }
        oid = rs.getInt(1) + 1;
        st.close();
        this.bindString(paramIndex, data, oid);
    }

    public String toString() {
        if (this.preparedQuery == null) {
            return super.toString();
        }
        return this.preparedQuery.query.toString(this.preparedParameters);
    }

    protected void bindLiteral(int paramIndex, String s, int oid) throws SQLException {
        if (this.adjustIndex) {
            --paramIndex;
        }
        this.preparedParameters.setLiteralParameter(paramIndex, s, oid);
    }

    protected void bindBytes(int paramIndex, byte[] b, int oid) throws SQLException {
        if (this.adjustIndex) {
            --paramIndex;
        }
        this.preparedParameters.setBinaryParameter(paramIndex, b, oid);
    }

    private void bindString(int paramIndex, String s, int oid) throws SQLException {
        if (this.adjustIndex) {
            --paramIndex;
        }
        this.preparedParameters.setStringParameter(paramIndex, s, oid);
    }

    private void bindStringArray(int paramIndex, String[] x, int oid) throws SQLException {
        String literal = "{";
        for (int i = 0; i < x.length; ++i) {
            literal = literal + "\"" + x[i] + "\"";
            if (i >= x.length - 1) continue;
            literal = literal + ",";
        }
        literal = literal + "}";
        if (this.adjustIndex) {
            --paramIndex;
        }
        this.preparedParameters.setLiteralParameter(paramIndex, literal, oid);
    }

    public void setIntArray(int parameterIndex, int[] x) throws SQLException {
        this.checkClosed();
        this.bindIntArray(parameterIndex, x, 1007);
    }

    public void setShortArray(int parameterIndex, short[] x) throws SQLException {
        this.checkClosed();
        this.bindShortArray(parameterIndex, x, 1005);
    }

    public void setLongArray(int parameterIndex, long[] x) throws SQLException {
        this.checkClosed();
        this.bindLongArray(parameterIndex, x, 1016);
    }

    public void setFloatArray(int parameterIndex, float[] x) throws SQLException {
        this.checkClosed();
        this.bindFloatArray(parameterIndex, x, 1021);
    }

    public void setDoubleArray(int parameterIndex, double[] x) throws SQLException {
        this.checkClosed();
        this.bindDoubleArray(parameterIndex, x, 1022);
    }

    public void setCharArray(int parameterIndex, char[] x) throws SQLException {
        this.checkClosed();
        this.bindCharArray(parameterIndex, x, 1002);
    }

    public void setBooleanArray(int parameterIndex, boolean[] x) throws SQLException {
        this.checkClosed();
        this.bindBooleanArray(parameterIndex, x, 1000);
    }

    public void setStringArray(int parameterIndex, String[] x) throws SQLException {
        this.checkClosed();
        this.bindStringArray(parameterIndex, x, 1015);
    }

    private void bindIntArray(int paramIndex, int[] x, int oid) throws SQLException {
        String literal = "{";
        for (int i = 0; i < x.length; ++i) {
            literal = literal + x[i];
            if (i >= x.length - 1) continue;
            literal = literal + ",";
        }
        literal = literal + "}";
        if (this.adjustIndex) {
            --paramIndex;
        }
        this.preparedParameters.setLiteralParameter(paramIndex, literal, oid);
    }

    private void bindShortArray(int paramIndex, short[] x, int oid) throws SQLException {
        String literal = "{";
        for (int i = 0; i < x.length; ++i) {
            literal = literal + x[i];
            if (i >= x.length - 1) continue;
            literal = literal + ",";
        }
        literal = literal + "}";
        if (this.adjustIndex) {
            --paramIndex;
        }
        this.preparedParameters.setLiteralParameter(paramIndex, literal, oid);
    }

    private void bindLongArray(int paramIndex, long[] x, int oid) throws SQLException {
        String literal = "{";
        for (int i = 0; i < x.length; ++i) {
            literal = literal + x[i];
            if (i >= x.length - 1) continue;
            literal = literal + ",";
        }
        literal = literal + "}";
        if (this.adjustIndex) {
            --paramIndex;
        }
        this.preparedParameters.setLiteralParameter(paramIndex, literal, oid);
    }

    private void bindFloatArray(int paramIndex, float[] x, int oid) throws SQLException {
        String literal = "{";
        for (int i = 0; i < x.length; ++i) {
            literal = literal + x[i];
            if (i >= x.length - 1) continue;
            literal = literal + ",";
        }
        literal = literal + "}";
        if (this.adjustIndex) {
            --paramIndex;
        }
        this.preparedParameters.setLiteralParameter(paramIndex, literal, oid);
    }

    private void bindDoubleArray(int paramIndex, double[] x, int oid) throws SQLException {
        String literal = "{";
        for (int i = 0; i < x.length; ++i) {
            literal = literal + x[i];
            if (i >= x.length - 1) continue;
            literal = literal + ",";
        }
        literal = literal + "}";
        if (this.adjustIndex) {
            --paramIndex;
        }
        this.preparedParameters.setLiteralParameter(paramIndex, literal, oid);
    }

    private void bindCharArray(int paramIndex, char[] x, int oid) throws SQLException {
        String literal = "{";
        for (int i = 0; i < x.length; ++i) {
            literal = literal + "\"" + x[i] + "\"";
            if (i >= x.length - 1) continue;
            literal = literal + ",";
        }
        literal = literal + "}";
        if (this.adjustIndex) {
            --paramIndex;
        }
        this.preparedParameters.setLiteralParameter(paramIndex, literal, oid);
    }

    private void bindBooleanArray(int paramIndex, boolean[] x, int oid) throws SQLException {
        String literal = "{";
        for (int i = 0; i < x.length; ++i) {
            literal = literal + x[i];
            if (i >= x.length - 1) continue;
            literal = literal + ",";
        }
        literal = literal + "}";
        if (this.adjustIndex) {
            --paramIndex;
        }
        this.preparedParameters.setLiteralParameter(paramIndex, literal, oid);
    }

    @Override
    public boolean isUseServerPrepare() {
        return this.preparedQuery != null && this.mPrepareThreshold != 0 && this.preparedQuery.getExecuteCount() + 1 >= this.mPrepareThreshold;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkClosed();
        throw new PSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement.", new Object[0]), PSQLState.WRONG_OBJECT_TYPE);
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkClosed();
        if (this.batchStatements == null) {
            this.batchStatements = new ArrayList();
            this.batchParameters = new ArrayList();
        }
        this.batchParameters.add(this.preparedParameters.copy());
        Query query = this.preparedQuery.query;
        if (!(query instanceof BatchedQuery) || this.batchStatements.isEmpty()) {
            this.batchStatements.add(query);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        ResultSet rs = this.getResultSet();
        if (rs == null || ((PgResultSet)rs).isResultSetClosed()) {
            int flags = 49;
            PgStatement.StatementResultHandler handler = new PgStatement.StatementResultHandler(this);
            QueryExecutorImpl qe = (QueryExecutorImpl)this.connection.getQueryExecutor();
            qe.setFunction(this.outParmBeforeFunc);
            qe.resetError();
            qe.execute(this.preparedQuery.query, this.preparedParameters, handler, 0, 0, 0, flags, this.isCallable, this.outParmBeforeFunc);
            ResultWrapper wrapper = handler.getResults();
            if (wrapper != null) {
                rs = wrapper.getResultSet();
            }
        }
        if (rs != null) {
            return rs.getMetaData();
        }
        return null;
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        PgArray arr;
        this.checkClosed();
        if (null == x) {
            this.setNull(i, 2003);
            return;
        }
        String typename = x.getBaseTypeName();
        int oid = this.connection.getTypeInfo().getPGArrayType(typename);
        if (oid == 0) {
            throw new PSQLException(GT.tr("Unknown type {0}.", typename), PSQLState.INVALID_PARAMETER_TYPE);
        }
        if (x instanceof PgArray && (arr = (PgArray)x).isBinary()) {
            this.bindBytes(i, arr.toBytes(), oid);
            return;
        }
        this.setString(i, x.toString(), oid);
    }

    protected long createBlob(int i, InputStream inputStream, long length) throws SQLException {
        LargeObjectManager lom = this.connection.getLargeObjectAPI();
        long oid = lom.createLO();
        LargeObject lob = lom.open(oid);
        OutputStream outputStream = lob.getOutputStream();
        byte[] buf = new byte[4096];
        try {
            long remaining = length > 0L ? length : Long.MAX_VALUE;
            int numRead = inputStream.read(buf, 0, length > 0L && remaining < (long)buf.length ? (int)remaining : buf.length);
            while (numRead != -1 && remaining > 0L) {
                outputStream.write(buf, 0, numRead);
                numRead = inputStream.read(buf, 0, length > 0L && remaining < (long)buf.length ? (int)(remaining -= (long)numRead) : buf.length);
            }
        }
        catch (IOException se) {
            throw new PSQLException(GT.tr("Unexpected error writing large object to database.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)se);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
        }
        return oid;
    }

    private void setBlobBytea(int i, Blob x) throws SQLException {
        if (x == null) {
            this.setNull(i, -3);
            return;
        }
        byte[] b = x.getBytes(1L, (int)x.length());
        this.preparedParameters.setBytea(i, b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        this.checkClosed();
        if (this.connection.getBlobAsBytea()) {
            this.setBlobBytea(i, x);
            return;
        }
        if (x == null) {
            this.setNull(i, 2004);
            return;
        }
        InputStream inStream = x.getBinaryStream();
        try {
            long oid = this.createBlob(i, inStream, x.length());
            this.setLong(i, oid);
        }
        finally {
            try {
                inStream.close();
            }
            catch (Exception exception) {}
        }
    }

    private String readerToString(Reader value, int maxLength) throws SQLException {
        try {
            int bufferSize = Math.min(maxLength, 1024);
            StringBuilder v = new StringBuilder(bufferSize);
            char[] buf = new char[bufferSize];
            int nRead = 0;
            while (nRead > -1 && v.length() < maxLength) {
                nRead = value.read(buf, 0, Math.min(bufferSize, maxLength - v.length()));
                if (nRead <= 0) continue;
                v.append(buf, 0, nRead);
            }
            return v.toString();
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Provided Reader failed.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)ioe);
        }
    }

    @Override
    public void setCharacterStream(int i, Reader x, int length) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(i, 12);
            return;
        }
        if (length < 0) {
            throw new PSQLException(GT.tr("Invalid stream length {0}.", length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.setString(i, this.readerToString(x, length));
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(i, 2005);
            return;
        }
        Reader inStream = x.getCharacterStream();
        int length = (int)x.length();
        LargeObjectManager lom = this.connection.getLargeObjectAPI();
        long oid = lom.createLO();
        LargeObject lob = lom.open(oid);
        Charset connectionCharset = Charset.forName(this.connection.getEncoding().name());
        OutputStream los = lob.getOutputStream();
        OutputStreamWriter lw = new OutputStreamWriter(los, connectionCharset);
        try {
            int c = inStream.read();
            for (int p = 0; c > -1 && p < length; ++p) {
                ((Writer)lw).write(c);
                c = inStream.read();
            }
            ((Writer)lw).close();
        }
        catch (IOException se) {
            throw new PSQLException(GT.tr("Unexpected error writing large object to database.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)se);
        }
        this.setLong(i, oid);
    }

    @Override
    public void setNull(int parameterIndex, int t, String typeName) throws SQLException {
        if (typeName == null) {
            this.setNull(parameterIndex, t);
            return;
        }
        this.checkClosed();
        TypeInfo typeInfo = this.connection.getTypeInfo();
        int oid = typeInfo.getPGType(typeName);
        this.preparedParameters.setNull(parameterIndex, oid);
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setRef(int,Ref)");
    }

    @Override
    public void setDate(int i, java.sql.Date d, Calendar cal) throws SQLException {
        this.checkClosed();
        if (d == null) {
            this.setNull(i, 91);
            return;
        }
        if (this.connection.binaryTransferSend(1082)) {
            byte[] val = new byte[4];
            TimeZone tz = cal != null ? cal.getTimeZone() : null;
            this.connection.getTimestampUtils().toBinDate(tz, val, d);
            this.preparedParameters.setBinaryParameter(i, val, 1082);
            return;
        }
        if (cal == null) {
            cal = this.getDefaultCalendar();
        }
        this.bindString(i, this.connection.getTimestampUtils().toString(cal, d), 0);
    }

    @Override
    public void setTime(int i, Time t, Calendar cal) throws SQLException {
        this.checkClosed();
        if (t == null) {
            this.setNull(i, 92);
            return;
        }
        int oid = 0;
        if (t instanceof PGTime) {
            PGTime pgTime = (PGTime)t;
            if (pgTime.getCalendar() == null) {
                oid = 1083;
            } else {
                oid = 1266;
                cal = pgTime.getCalendar();
            }
        }
        if (cal == null) {
            cal = this.getDefaultCalendar();
        }
        this.bindString(i, this.connection.getTimestampUtils().toString(cal, t), oid);
    }

    @Override
    public void setTimestamp(int i, Timestamp t, Calendar cal) throws SQLException {
        this.checkClosed();
        if (t == null) {
            this.setNull(i, 93);
            return;
        }
        int oid = 0;
        if (!this.connection.isUnknownDateType()) {
            oid = 1114;
        }
        if (t instanceof PGTimestamp) {
            PGTimestamp pgTimestamp = (PGTimestamp)t;
            if (pgTimestamp.getCalendar() == null) {
                oid = 1114;
            } else {
                oid = 1184;
                cal = pgTimestamp.getCalendar();
            }
        }
        if (cal == null) {
            cal = this.getDefaultCalendar();
        }
        this.bindString(i, this.connection.getTimestampUtils().toString(cal, t), oid);
    }

    private void setDate(int i, LocalDate localDate) throws SQLException {
        int oid = 1082;
        if (this.connection.isMapDateToTimestamp()) {
            oid = 1114;
        }
        this.bindString(i, this.connection.getTimestampUtils().toString(localDate), oid);
    }

    private void setTime(int i, LocalTime localTime) throws SQLException {
        int oid = 1083;
        this.bindString(i, this.connection.getTimestampUtils().toString(localTime), oid);
    }

    private void setTimestamp(int i, LocalDateTime localDateTime) throws SQLException {
        int oid = 1114;
        this.bindString(i, this.connection.getTimestampUtils().toString(localDateTime), oid);
    }

    private void setTimestamp(int i, OffsetDateTime offsetDateTime) throws SQLException {
        int oid = 1184;
        this.bindString(i, this.connection.getTimestampUtils().toString(offsetDateTime), oid);
    }

    public ParameterMetaData createParameterMetaData(BaseConnection conn, int[] oids) throws SQLException {
        return new PgParameterMetaData(conn, oids);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setObject");
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setObject");
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setRowId(int, RowId)");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNString(int, String)");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNCharacterStream(int, Reader, long)");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNCharacterStream(int, Reader)");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        if (this.connection.getClobAsText()) {
            this.setCharacterStream(parameterIndex, value, (int)length);
            return;
        }
        throw Driver.notImplemented(this.getClass(), "setCharacterStream(int, Reader, long)");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader value) throws SQLException {
        if (this.connection.getPreferQueryMode() == PreferQueryMode.SIMPLE) {
            String s = value != null ? this.readerToString(value, Integer.MAX_VALUE) : null;
            this.setString(parameterIndex, s);
            return;
        }
        ReaderInputStream is = value != null ? new ReaderInputStream(value) : null;
        this.setObject(parameterIndex, (Object)is, -1);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream value, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new PSQLException(GT.tr("Object is too large to send over the protocol.", new Object[0]), PSQLState.NUMERIC_CONSTANT_OUT_OF_RANGE);
        }
        if (this.adjustIndex) {
            --parameterIndex;
        }
        this.preparedParameters.setBytea(parameterIndex, value, (int)length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream value) throws SQLException {
        if (this.adjustIndex) {
            --parameterIndex;
        }
        this.preparedParameters.setBytea(parameterIndex, value);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream value, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setAsciiStream(int, InputStream, long)");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setAsciiStream(int, InputStream)");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNClob(int, NClob)");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkClosed();
        if (!this.connection.getClobAsText()) {
            throw Driver.notImplemented(this.getClass(), "setClob(int, Reader, long)");
        }
        this.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.checkClosed();
        if (!this.connection.getClobAsText()) {
            throw Driver.notImplemented(this.getClass(), "setClob(int, Reader)");
        }
        this.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.checkClosed();
        if (this.connection.getBlobAsBytea()) {
            this.setBlobBytea(parameterIndex, inputStream, length);
            return;
        }
        if (inputStream == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        if (length < 0L) {
            throw new PSQLException(GT.tr("Invalid stream length {0}.", length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        long oid = this.createBlob(parameterIndex, inputStream, length);
        this.setLong(parameterIndex, oid);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.checkClosed();
        if (this.connection.getBlobAsBytea()) {
            this.setBlobBytea(parameterIndex, inputStream);
            return;
        }
        if (inputStream == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        long oid = this.createBlob(parameterIndex, inputStream, -1L);
        this.setLong(parameterIndex, oid);
    }

    private void setBlobBytea(int parameterIndex, InputStream inputStream) throws SQLException {
        byte[] b;
        if (inputStream == null) {
            this.setNull(parameterIndex, -3);
            return;
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int len = inputStream.read(buffer);
            while (len != -1) {
                os.write(buffer, 0, len);
                len = inputStream.read(buffer);
            }
            b = os.toByteArray();
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Provided InputStream failed.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)ioe);
        }
        if (b.length > 0x40000000) {
            throw new PSQLException(GT.tr("Input data too long for bytea type Blob {0}", b.length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.preparedParameters.setBytea(parameterIndex, b, 0, b.length);
    }

    private void setBlobBytea(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        byte[] b;
        if (inputStream == null) {
            this.setNull(parameterIndex, -3);
            return;
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            long remaining = length;
            int toRead = remaining > (long)buffer.length ? buffer.length : (int)remaining;
            int len = inputStream.read(buffer, 0, toRead);
            while (remaining > 0L && len > -1) {
                os.write(buffer, 0, len);
                toRead = (remaining -= (long)len) > (long)buffer.length ? buffer.length : (int)remaining;
                len = inputStream.read(buffer, 0, toRead);
            }
            if (remaining > 0L) {
                // empty if block
            }
            b = os.toByteArray();
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Provided InputStream failed.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)ioe);
        }
        if (b.length > 0x40000000) {
            throw new PSQLException(GT.tr("Input data too long for bytea type Blob {0}", b.length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.preparedParameters.setBytea(parameterIndex, b, 0, b.length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNClob(int, Reader, long)");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNClob(int, Reader)");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        String stringValue;
        this.checkClosed();
        String string = stringValue = xmlObject == null ? null : xmlObject.getString();
        if (stringValue == null) {
            this.setNull(parameterIndex, 2009);
        } else {
            this.setString(parameterIndex, stringValue, 142);
        }
    }

    private void setUuid(int parameterIndex, UUID uuid) throws SQLException {
        if (this.connection.binaryTransferSend(2950)) {
            byte[] val = new byte[16];
            ByteConverter.int8(val, 0, uuid.getMostSignificantBits());
            ByteConverter.int8(val, 8, uuid.getLeastSignificantBits());
            this.bindBytes(parameterIndex, val, 2950);
        } else {
            this.bindLiteral(parameterIndex, uuid.toString(), 2950);
        }
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setURL(int,URL)");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            if (this.batchParameters != null && this.batchParameters.size() > 1 && this.mPrepareThreshold > 0) {
                this.preparedQuery.increaseExecuteCount(this.mPrepareThreshold);
            }
            int[] nArray = super.executeBatch();
            return nArray;
        }
        finally {
            this.defaultTimeZone = null;
        }
    }

    private Calendar getDefaultCalendar() {
        TimestampUtils timestampUtils = this.connection.getTimestampUtils();
        if (timestampUtils.hasFastDefaultTimeZone()) {
            return timestampUtils.getSharedCalendar(null);
        }
        Calendar sharedCalendar = timestampUtils.getSharedCalendar(this.defaultTimeZone);
        if (this.defaultTimeZone == null) {
            this.defaultTimeZone = sharedCalendar.getTimeZone();
        }
        return sharedCalendar;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        int flags = 49;
        PgStatement.StatementResultHandler handler = new PgStatement.StatementResultHandler(this);
        this.connection.getQueryExecutor().execute(this.preparedQuery.query, this.preparedParameters, handler, 0, 0, 0, flags, this.isCallable, this.outParmBeforeFunc);
        int[] oids = this.preparedParameters.getTypeOIDs();
        if (oids != null) {
            return this.createParameterMetaData(this.connection, oids);
        }
        return null;
    }

    @Override
    protected void transformQueriesAndParameters() throws SQLException {
        if (this.batchParameters.size() <= 1 || !(this.preparedQuery.query instanceof BatchedQuery)) {
            return;
        }
        BatchedQuery originalQuery = (BatchedQuery)this.preparedQuery.query;
        int bindCount = originalQuery.getBindCount();
        int highestBlockCount = 128;
        int maxValueBlocks = bindCount == 0 ? 1024 : Integer.highestOneBit(Math.min(Math.max(1, 32766 / bindCount), 128));
        int unprocessedBatchCount = this.batchParameters.size();
        int fullValueBlocksCount = unprocessedBatchCount / maxValueBlocks;
        int partialValueBlocksCount = Integer.bitCount(unprocessedBatchCount % maxValueBlocks);
        int count = fullValueBlocksCount + partialValueBlocksCount;
        ArrayList<BatchedQuery> newBatchStatements = new ArrayList<BatchedQuery>(count);
        ArrayList<ParameterList> newBatchParameters = new ArrayList<ParameterList>(count);
        int offset = 0;
        for (int i = 0; i < count; ++i) {
            int valueBlock = unprocessedBatchCount >= maxValueBlocks ? maxValueBlocks : Integer.highestOneBit(unprocessedBatchCount);
            BatchedQuery bq = originalQuery.deriveForMultiBatch(valueBlock);
            ParameterList newPl = bq.createParameterList();
            for (int j = 0; j < valueBlock; ++j) {
                ParameterList pl = (ParameterList)this.batchParameters.get(offset++);
                newPl.appendAll(pl);
            }
            newBatchStatements.add(bq);
            newBatchParameters.add(newPl);
            unprocessedBatchCount -= valueBlock;
        }
        this.batchStatements = newBatchStatements;
        this.batchParameters = newBatchParameters;
    }

    protected void checkIndex(int parameterIndex, int type1, int type2, String getName) throws SQLException {
        this.checkIndex(parameterIndex);
        if (type1 != this.testReturn[parameterIndex - 1] && type2 != this.testReturn[parameterIndex - 1]) {
            throw new PSQLException(GT.tr("Parameter of type {0} was registered, but call to get{1} (sqltype={2}) was made.", "java.sql.Types=" + this.testReturn[parameterIndex - 1], getName, "java.sql.Types=" + type1), PSQLState.MOST_SPECIFIC_TYPE_DOES_NOT_MATCH);
        }
    }

    protected void checkIndex(int parameterIndex, int type, String getName) throws SQLException {
        this.checkIndex(parameterIndex);
        if (type != this.testReturn[parameterIndex - 1]) {
            throw new PSQLException(GT.tr("Parameter of type {0} was registered, but call to get{1} (sqltype={2}) was made.", "java.sql.Types=" + this.testReturn[parameterIndex - 1], getName, "java.sql.Types=" + type), PSQLState.MOST_SPECIFIC_TYPE_DOES_NOT_MATCH);
        }
    }

    private void checkIndex(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, true);
    }

    private void checkIndex(int parameterIndex, boolean fetchingData) throws SQLException {
        if (!this.isFunction) {
            throw new PSQLException(GT.tr("A CallableStatement was declared, but no call to registerOutParameter(1, <some type>) was made.", new Object[0]), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        if (fetchingData) {
            if (!this.returnTypeSet) {
                throw new PSQLException(GT.tr("No function outputs were registered.", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
            }
            if (this.callResult == null) {
                throw new PSQLException(GT.tr("Results cannot be retrieved from a CallableStatement before it is executed.", new Object[0]), PSQLState.NO_DATA);
            }
            if (parameterIndex > this.testReturn.length || parameterIndex <= 0) {
                throw new PSQLException(GT.tr("Invalid parameter index accessed", new Object[0]), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
            }
            this.lastIndex = parameterIndex;
        }
    }

    public boolean wasNull() throws SQLException {
        if (this.lastIndex == 0) {
            throw new PSQLException(GT.tr("wasNull cannot be call before fetching a result.", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
        }
        return this.callResult[this.lastIndex - 1] == null;
    }

    public String getString(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 12, "String");
        return (String)this.callResult[parameterIndex - 1];
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, -7, "Boolean");
        if (this.callResult[parameterIndex - 1] == null) {
            return false;
        }
        return (Boolean)this.callResult[parameterIndex - 1];
    }

    public byte getByte(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 5, "Byte");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0;
        }
        return ((Integer)this.callResult[parameterIndex - 1]).byteValue();
    }

    public short getShort(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 5, "Short");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0;
        }
        return ((Integer)this.callResult[parameterIndex - 1]).shortValue();
    }

    public int getInt(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 4, "Int");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0;
        }
        return (Integer)this.callResult[parameterIndex - 1];
    }

    public long getLong(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, -5, "Long");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0L;
        }
        return (Long)this.callResult[parameterIndex - 1];
    }

    public float getFloat(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 7, "Float");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0.0f;
        }
        return ((Float)this.callResult[parameterIndex - 1]).floatValue();
    }

    public double getDouble(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 8, "Double");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0.0;
        }
        return (Double)this.callResult[parameterIndex - 1];
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 2, "BigDecimal");
        return (BigDecimal)this.callResult[parameterIndex - 1];
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, -3, -2, "Bytes");
        return (byte[])this.callResult[parameterIndex - 1];
    }

    public java.sql.Date getDate(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 91, "Date");
        return (java.sql.Date)this.callResult[parameterIndex - 1];
    }

    public Time getTime(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 92, "Time");
        return (Time)this.callResult[parameterIndex - 1];
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 93, "Timestamp");
        return (Timestamp)this.callResult[parameterIndex - 1];
    }

    public Object getObject(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex);
        return this.callResult[parameterIndex - 1];
    }

    public Array getArray(int i) throws SQLException {
        this.checkClosed();
        this.checkIndex(i, 2003, "Array");
        return (Array)this.callResult[i - 1];
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 2, "BigDecimal");
        return (BigDecimal)this.callResult[parameterIndex - 1];
    }

    public Blob getBlob(int i) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getBlob(int)");
    }

    public Clob getClob(int i) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getClob(int)");
    }

    public Object getObjectImpl(int i, Map map) throws SQLException {
        if (map == null || map.isEmpty()) {
            return this.getObject(i);
        }
        throw Driver.notImplemented(this.getClass(), "getObjectImpl(int,Map)");
    }

    public Ref getRef(int i) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getRef(int)");
    }

    public java.sql.Date getDate(int i, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkIndex(i, 91, "Date");
        if (this.callResult[i - 1] == null) {
            return null;
        }
        if (cal != null) {
            cal = (Calendar)cal.clone();
        }
        String value = this.callResult[i - 1].toString();
        return this.connection.getTimestampUtils().toDate(cal, value);
    }

    public Time getTime(int i, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkIndex(i, 92, "Time");
        if (this.callResult[i - 1] == null) {
            return null;
        }
        if (cal != null) {
            cal = (Calendar)cal.clone();
        }
        String value = this.callResult[i - 1].toString();
        return this.connection.getTimestampUtils().toTime(cal, value);
    }

    public Timestamp getTimestamp(int i, Calendar cal) throws SQLException {
        this.checkClosed();
        this.checkIndex(i, 93, "Timestamp");
        if (this.callResult[i - 1] == null) {
            return null;
        }
        if (cal != null) {
            cal = (Calendar)cal.clone();
        }
        String value = this.callResult[i - 1].toString();
        return this.connection.getTimestampUtils().toTimestamp(cal, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws SQLException {
        PgPreparedStatement pgPreparedStatement = this;
        synchronized (pgPreparedStatement) {
            if (super.isClosed()) {
                return;
            }
        }
        if (this.hasSetUnamedProc && this.preparedQuery.isUnamedProc) {
            this.polar_unamed_proc_process_end();
        }
        super.close();
    }

    @Override
    protected final void finalize() throws SQLException {
        if (super.isClosed()) {
            return;
        }
        this.close();
        super.finalize();
    }
}

