/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb.jdbc;

import com.aliyun.polardb.core.Field;
import com.aliyun.polardb.core.ParameterList;
import com.aliyun.polardb.core.Query;
import com.aliyun.polardb.core.ResultCursor;
import com.aliyun.polardb.core.ResultHandlerBase;
import com.aliyun.polardb.core.v3.BatchedQuery;
import com.aliyun.polardb.jdbc.PgResultSet;
import com.aliyun.polardb.jdbc.PgStatement;
import com.aliyun.polardb.util.GT;
import com.aliyun.polardb.util.PSQLException;
import com.aliyun.polardb.util.PSQLState;
import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BatchResultHandler
extends ResultHandlerBase {
    private PgStatement pgStatement;
    private int resultIndex = 0;
    private final Query[] queries;
    private final int[] updateCounts;
    private final ParameterList[] parameterLists;
    private final boolean expectGeneratedKeys;
    private PgResultSet generatedKeys;
    private int committedRows;
    private List<List<byte[][]>> allGeneratedRows;
    private List<byte[][]> latestGeneratedRows;
    private PgResultSet latestGeneratedKeysRs;

    BatchResultHandler(PgStatement pgStatement, Query[] queries, ParameterList[] parameterLists, boolean expectGeneratedKeys) {
        this.pgStatement = pgStatement;
        this.queries = queries;
        this.parameterLists = parameterLists;
        this.updateCounts = new int[queries.length];
        this.expectGeneratedKeys = expectGeneratedKeys;
        this.allGeneratedRows = !expectGeneratedKeys ? null : new ArrayList();
    }

    @Override
    public void handleResultRows(Query fromQuery, Field[] fields, List<byte[][]> tuples, ResultCursor cursor) {
        ++this.resultIndex;
        if (!this.expectGeneratedKeys) {
            return;
        }
        if (this.generatedKeys == null) {
            try {
                this.latestGeneratedKeysRs = (PgResultSet)this.pgStatement.createResultSet(fromQuery, fields, new ArrayList<byte[][]>(), cursor);
            }
            catch (SQLException e) {
                this.handleError(e);
            }
        }
        this.latestGeneratedRows = tuples;
    }

    @Override
    public void handleCommandStatus(String status, int updateCount, long insertOID) {
        if (this.latestGeneratedRows != null) {
            --this.resultIndex;
            if (updateCount > 0 && (this.getException() == null || this.isAutoCommit())) {
                this.allGeneratedRows.add(this.latestGeneratedRows);
                if (this.generatedKeys == null) {
                    this.generatedKeys = this.latestGeneratedKeysRs;
                }
            }
            this.latestGeneratedRows = null;
        }
        if (this.resultIndex >= this.queries.length) {
            this.handleError(new PSQLException(GT.tr("Too many update results were returned.", new Object[0]), PSQLState.TOO_MANY_RESULTS));
            return;
        }
        this.latestGeneratedKeysRs = null;
        this.updateCounts[this.resultIndex++] = updateCount;
    }

    private boolean isAutoCommit() {
        try {
            return this.pgStatement.getConnection().getAutoCommit();
        }
        catch (SQLException e) {
            assert (false) : "pgStatement.getConnection().getAutoCommit() should not throw";
            return false;
        }
    }

    @Override
    public void secureProgress() {
        if (this.isAutoCommit()) {
            this.committedRows = this.resultIndex;
            this.updateGeneratedKeys();
        }
    }

    private void updateGeneratedKeys() {
        if (this.allGeneratedRows == null || this.allGeneratedRows.isEmpty()) {
            return;
        }
        for (List<byte[][]> rows : this.allGeneratedRows) {
            this.generatedKeys.addRows(rows);
        }
        this.allGeneratedRows.clear();
    }

    @Override
    public void handleWarning(SQLWarning warning) {
        this.pgStatement.addWarning(warning);
        this.pgStatement.notifyNoticeListeners(warning);
    }

    @Override
    public void handleError(SQLException newError) {
        if (this.getException() == null) {
            Arrays.fill(this.updateCounts, this.committedRows, this.updateCounts.length, -3);
            if (this.allGeneratedRows != null) {
                this.allGeneratedRows.clear();
            }
            String queryString = "<unknown>";
            if (this.resultIndex < this.queries.length) {
                queryString = this.queries[this.resultIndex].toString(this.parameterLists[this.resultIndex]);
            }
            BatchUpdateException batchException = new BatchUpdateException(GT.tr("Batch entry {0} {1} was aborted: {2}  Call getNextException to see other errors in the batch.", this.resultIndex, queryString, newError.getMessage()), newError.getSQLState(), this.uncompressUpdateCount());
            batchException.initCause(newError);
            super.handleError(batchException);
        }
        ++this.resultIndex;
        super.handleError(newError);
    }

    @Override
    public void handleCompletion() throws SQLException {
        this.updateGeneratedKeys();
        SQLException batchException = this.getException();
        if (batchException != null) {
            if (this.isAutoCommit()) {
                BatchUpdateException newException = new BatchUpdateException(batchException.getMessage(), batchException.getSQLState(), this.uncompressUpdateCount());
                newException.initCause(batchException.getCause());
                SQLException next = batchException.getNextException();
                if (next != null) {
                    newException.setNextException(next);
                }
                batchException = newException;
            }
            throw batchException;
        }
    }

    public ResultSet getGeneratedKeys() {
        return this.generatedKeys;
    }

    @Override
    public void notifyCommandStatus(String status) {
        this.pgStatement.notifyCommandStatusListeners(status);
    }

    private int[] uncompressUpdateCount() {
        int batchSize;
        if (!(this.queries[0] instanceof BatchedQuery)) {
            return this.updateCounts;
        }
        int totalRows = 0;
        boolean hasRewrites = false;
        for (Query query : this.queries) {
            batchSize = query.getBatchSize();
            totalRows += batchSize;
            hasRewrites |= batchSize > 1;
        }
        if (!hasRewrites) {
            return this.updateCounts;
        }
        int[] newUpdateCounts = new int[totalRows];
        int offset = 0;
        for (int i = 0; i < this.queries.length; ++i) {
            Query query;
            query = this.queries[i];
            batchSize = query.getBatchSize();
            int superBatchResult = this.updateCounts[i];
            if (batchSize == 1) {
                newUpdateCounts[offset++] = superBatchResult;
                continue;
            }
            if (superBatchResult > 0) {
                superBatchResult = -2;
            }
            Arrays.fill(newUpdateCounts, offset, offset + batchSize, superBatchResult);
            offset += batchSize;
        }
        return newUpdateCounts;
    }

    public int[] getUpdateCount() {
        return this.uncompressUpdateCount();
    }
}

