/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb.core;

import com.aliyun.polardb.core.Query;
import com.aliyun.polardb.util.CanEstimateSize;

public class CachedQuery
implements CanEstimateSize {
    public final Object key;
    public final Query query;
    public final boolean isFunction;
    public final boolean outParmBeforeFunc;
    public final boolean isCallable;
    private int executeCount;
    public final boolean isUnamedProc;
    public final String unamedProcName;
    public final String fakeUnamedProcSql;
    public final String oriSql;

    public CachedQuery(Object key, Query query, boolean isFunction, boolean outParmBeforeFunc, boolean isCallable) {
        this.key = key;
        this.query = query;
        this.isFunction = isFunction;
        this.isCallable = isCallable;
        this.outParmBeforeFunc = outParmBeforeFunc;
        this.isUnamedProc = false;
        this.unamedProcName = "";
        this.fakeUnamedProcSql = "";
        this.oriSql = "";
    }

    public CachedQuery(Object key, Query query, boolean isFunction, boolean outParmBeforeFunc, boolean isCallable, boolean isUnamedProc, String unamedProcName, String fakeUnamedProcSql, String oriSql) {
        this.key = key;
        this.query = query;
        this.isFunction = isFunction;
        this.isCallable = isCallable;
        this.outParmBeforeFunc = outParmBeforeFunc;
        this.isUnamedProc = isUnamedProc;
        this.unamedProcName = unamedProcName;
        this.fakeUnamedProcSql = fakeUnamedProcSql;
        this.oriSql = oriSql;
    }

    public void increaseExecuteCount() {
        if (this.executeCount < Integer.MAX_VALUE) {
            ++this.executeCount;
        }
    }

    public void increaseExecuteCount(int inc) {
        int newValue = this.executeCount + inc;
        if (newValue > 0) {
            this.executeCount = newValue;
        }
    }

    public int getExecuteCount() {
        return this.executeCount;
    }

    @Override
    public long getSize() {
        long queryLength = this.key instanceof String ? (long)((String)this.key).length() * 2L : ((CanEstimateSize)this.key).getSize();
        return queryLength * 2L + 100L;
    }

    public String toString() {
        return "CachedQuery{executeCount=" + this.executeCount + ", query=" + this.query + ", isFunction=" + this.isFunction + ", outParmBeforeFunc=" + this.outParmBeforeFunc + ", isCallable=" + this.isCallable + '}';
    }

    public String getUnamedProcBody() {
        if (this.isUnamedProc) {
            String trimSql = this.oriSql.toLowerCase().trim();
            int declareStartIndex = trimSql.indexOf("declare");
            int beginStartIndex = trimSql.indexOf("begin");
            int endStartIndex = trimSql.indexOf("end");
            if (declareStartIndex == 0) {
                return trimSql.substring(declareStartIndex + 8, trimSql.length());
            }
            if (beginStartIndex == 0 && endStartIndex != -1) {
                return trimSql.substring(beginStartIndex, trimSql.length());
            }
        }
        return "";
    }
}

