/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb.util;

import com.aliyun.polardb.core.BaseConnection;
import com.aliyun.polardb.core.Utils;
import com.aliyun.polardb.jdbc.PgArray;
import com.aliyun.polardb.jdbc.PgResultSet;
import com.aliyun.polardb.jdbc2.Struct;
import java.sql.Array;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class StructUtils {
    public static String toString(Connection conn, Object[] attributes, boolean standardConformingStrings, boolean supportsEStringSyntax) throws SQLException {
        return StructUtils.toString(conn, attributes, standardConformingStrings, supportsEStringSyntax, "\"", 0);
    }

    private static String toString(Connection conn, Object[] attributes, boolean standardConformingStrings, boolean supportsEStringSyntax, String quotes, int level) throws SQLException {
        if (attributes == null) {
            return null;
        }
        String output = "";
        output = output + "(";
        for (int i = 0; i < attributes.length; ++i) {
            String param;
            String innerQuotes;
            if (i > 0) {
                output = output + ",";
            }
            if (attributes[i] == null) {
                output = output + "";
                continue;
            }
            if (attributes[i] instanceof Number) {
                output = output + attributes[i];
                continue;
            }
            if (attributes[i] instanceof Struct) {
                innerQuotes = quotes + quotes;
                String param2 = ((java.sql.Struct)attributes[i]).toString();
                output = output + quotes + StructUtils.increaseLevel(param2, 2002, innerQuotes) + quotes;
                continue;
            }
            if (attributes[i] instanceof java.sql.Struct) {
                innerQuotes = quotes + quotes;
                java.sql.Struct struct = (java.sql.Struct)attributes[i];
                Struct edbStruct = (Struct)conn.createStruct(struct.getSQLTypeName(), struct.getAttributes());
                String param3 = edbStruct.toString();
                output = output + quotes + StructUtils.increaseLevel(param3, 2002, innerQuotes) + quotes;
                continue;
            }
            if (attributes[i] instanceof Array) {
                param = attributes[i].toString();
                String innerQuotes2 = quotes + quotes;
                output = output + quotes + StructUtils.increaseLevel(param, 2002, innerQuotes2) + quotes;
                continue;
            }
            param = attributes[i].toString();
            boolean hasBackslash = param.indexOf(92) != -1;
            StringBuffer p = new StringBuffer(3 + param.length() * 11 / 10);
            if (hasBackslash && !standardConformingStrings && supportsEStringSyntax) {
                p.append('E');
            }
            try {
                p = Utils.appendEscapedLiteral(p, param, standardConformingStrings);
            }
            catch (SQLException sqle) {
                throw new IllegalArgumentException(sqle.toString());
            }
            if (p.toString().contains("\"")) {
                String outerQuotes = quotes;
                String innerQuotes3 = quotes + quotes;
                output = output + outerQuotes + p.toString().replaceAll("\"", innerQuotes3) + outerQuotes;
                continue;
            }
            output = output + quotes + p.toString() + quotes;
        }
        output = output + ")";
        return output;
    }

    private static String getQuotes(int level) {
        String quotes = "\"";
        for (int i = 0; i < level; ++i) {
            quotes = quotes + "\"";
        }
        return quotes;
    }

    private static String increaseLevel(String attribute, int type, String quote) {
        return StructUtils.adjustLevel(attribute, type, quote, false);
    }

    private static String adjustLevel(String attribute, int type) {
        return StructUtils.adjustLevel(attribute, type, "\"", false);
    }

    private static String normalizeLevel(String attribute, int type) {
        return StructUtils.adjustLevel(attribute, type, "\"", true);
    }

    private static String adjustLevel(String attribute, int type, String quote, boolean normalize) {
        if (attribute.length() == 0) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        char[] chars = attribute.toCharArray();
        ArrayList<String> lastQuote = new ArrayList<String>();
        lastQuote.add(quote);
        String replacedQuote = quote;
        int level = 0;
        int calculatedLevel = 0;
        int firstCalculatedLevel = -2;
        for (int i = 0; i < chars.length; ++i) {
            StringBuffer tempBuffer = null;
            boolean quoteFound = false;
            while (chars[i] == '\\' || chars[i] == '\"') {
                if (tempBuffer == null) {
                    tempBuffer = new StringBuffer();
                }
                tempBuffer.append(chars[i]);
                if ((firstCalculatedLevel < 0 || (double)tempBuffer.length() != Math.pow(2.0, level + firstCalculatedLevel)) && ++i != chars.length) continue;
            }
            if (tempBuffer != null) {
                --i;
                int length = tempBuffer.length();
                calculatedLevel = StructUtils.log(length, 2);
                if (firstCalculatedLevel == -2) {
                    firstCalculatedLevel = calculatedLevel;
                    if (level == 0) {
                        ++firstCalculatedLevel;
                    }
                }
                if (!normalize) {
                    replacedQuote = calculatedLevel - firstCalculatedLevel >= 0 ? (String)lastQuote.get(calculatedLevel - firstCalculatedLevel) : "";
                    while (calculatedLevel - firstCalculatedLevel < level - 1) {
                        lastQuote.remove(level);
                        --level;
                    }
                } else {
                    replacedQuote = level == 0 ? "" : "\"";
                    while (calculatedLevel - firstCalculatedLevel < level - 1) {
                        --level;
                    }
                }
                buffer.append(replacedQuote);
                quoteFound = true;
            }
            if (quoteFound) continue;
            if (level <= calculatedLevel + 1) {
                if ('{' == chars[i]) {
                    if (!normalize) {
                        replacedQuote = StructUtils.getNextQuotes((String)lastQuote.get(level), 2003);
                        lastQuote.add(replacedQuote);
                    }
                    ++level;
                } else if ('(' == chars[i]) {
                    if (!normalize) {
                        replacedQuote = StructUtils.getNextQuotes((String)lastQuote.get(level), 2002);
                        lastQuote.add(replacedQuote);
                    }
                    ++level;
                }
            }
            buffer.append(chars[i]);
        }
        return buffer.toString();
    }

    private static String getNextQuotes(String lastQuotes, int lastType) {
        StringBuffer quotes = new StringBuffer();
        if (lastQuotes.length() == 0) {
            return "\"";
        }
        if (lastType == 2003) {
            int length = lastQuotes.length();
            for (int i = 0; i < length; ++i) {
                quotes.append('\\');
            }
            quotes.append(lastQuotes);
        } else {
            quotes.append(lastQuotes).append(lastQuotes);
        }
        return quotes.toString();
    }

    private static int log(int x, int base) {
        return (int)(Math.log(x) / Math.log(base));
    }

    private static String getQuotesChars(int level) {
        if (level <= 0) {
            return "";
        }
        String src = "";
        int iterations = (int)Math.pow(2.0, level - 1);
        for (int i = 1; i <= iterations; ++i) {
            src = src + "\"";
        }
        return src;
    }

    private static String escapeQuotes(String text, String escapeQuotes) {
        if ((text = text.replaceAll(escapeQuotes, "\"")).startsWith("\"") && text.endsWith("\"")) {
            text = text.substring(1);
            text = text.substring(0, text.length() - 1);
            text = text.replaceAll("\"\"", "\"");
        }
        return text;
    }

    public static List parse(BaseConnection conn, List elementOIDs, String txt) throws SQLException {
        return StructUtils.parseInternal(conn, elementOIDs, txt, 1);
    }

    private static List parseInternal(BaseConnection conn, List elementOIDs, String txt, int level) throws SQLException {
        ArrayList<Object> list = new ArrayList<Object>();
        String quotesChars = StructUtils.getQuotesChars(level);
        String outerQuotes = StructUtils.getQuotesChars(level - 1);
        if (!txt.startsWith(outerQuotes + "(") && !txt.endsWith(outerQuotes + ")")) {
            throw new RuntimeException("Not a valid construct for a Row");
        }
        txt = txt.substring(outerQuotes.length() + 1);
        txt = txt.substring(0, txt.length() - outerQuotes.length() - 1);
        boolean inQuotes = false;
        String currentToken = "";
        int elementCount = 0;
        for (int i = 0; i < txt.length(); ++i) {
            if (txt.startsWith(quotesChars, i)) {
                inQuotes = !inQuotes;
                currentToken = currentToken + quotesChars;
                i += quotesChars.length() - 1;
                continue;
            }
            if (txt.charAt(i) == ',') {
                String adjusted;
                if (inQuotes) {
                    currentToken = currentToken + ",";
                    continue;
                }
                int oid = (Integer)elementOIDs.get(elementCount);
                int sqlType = conn.getTypeInfo().getSQLType(oid);
                if (sqlType == 2002 && currentToken.length() > 0 && currentToken.startsWith(quotesChars + "(") && currentToken.endsWith(")" + quotesChars)) {
                    list.add(new Struct(conn, (int)((Integer)elementOIDs.get(elementCount)), StructUtils.adjustLevel(currentToken, 2002)));
                } else if (sqlType == 2003 && currentToken.length() > 0 && (currentToken.startsWith(quotesChars + "{") && currentToken.endsWith("}" + quotesChars) || currentToken.startsWith("{") && currentToken.endsWith("}"))) {
                    adjusted = StructUtils.adjustLevel(currentToken, 2003);
                    list.add(new PgArray(conn, (int)((Integer)elementOIDs.get(elementCount)), adjusted));
                } else {
                    adjusted = StructUtils.adjustLevel(currentToken, 2003);
                    Object obj = StructUtils.getObject(conn, adjusted, oid, sqlType);
                    list.add(obj);
                }
                ++elementCount;
                currentToken = "";
                continue;
            }
            currentToken = currentToken + txt.charAt(i);
        }
        int sqlType = conn.getTypeInfo().getSQLType((Integer)elementOIDs.get(elementCount));
        if (sqlType == 2002 && currentToken.length() > 0 && currentToken.startsWith(quotesChars + "(") && currentToken.endsWith(")" + quotesChars)) {
            list.add(new Struct(conn, (int)((Integer)elementOIDs.get(elementCount)), StructUtils.adjustLevel(currentToken, 2002)));
        } else if (sqlType == 2003 && currentToken.length() > 0 && (currentToken.startsWith(quotesChars + "{") && currentToken.endsWith("}" + quotesChars) || currentToken.startsWith("{") && currentToken.endsWith("}"))) {
            String adjusted = StructUtils.adjustLevel(currentToken, 2003);
            list.add(new PgArray(conn, (int)((Integer)elementOIDs.get(elementCount)), adjusted));
        } else {
            list.add(StructUtils.adjustLevel(currentToken, 2003));
        }
        return list;
    }

    private static Object getObject(BaseConnection connection, String text, int oid, int type) throws SQLException {
        if (type == 5 || type == 4) {
            return PgResultSet.toInt(text);
        }
        if (type == -5) {
            return PgResultSet.toLong(text);
        }
        if (type == 2) {
            return PgResultSet.toBigDecimal(text);
        }
        if (type == 7) {
            return Float.valueOf(PgResultSet.toFloat(text));
        }
        if (type == 8) {
            return PgResultSet.toDouble(text);
        }
        if (type == 1 || type == 12 || oid == 3807) {
            return text;
        }
        if (type == 91) {
            return connection.getTimestampUtils().toDate(null, text);
        }
        if (type == 92) {
            return connection.getTimestampUtils().toTime(null, text);
        }
        if (type == 93) {
            return connection.getTimestampUtils().toTimestamp(null, text);
        }
        return text;
    }
}

