/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb.ssl;

import com.aliyun.polardb.ssl.PolarPX509KeyManager;
import com.aliyun.polardb.ssl.WrappedFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;

public class PolarPSSLSocketFactory
extends WrappedFactory {
    public PolarPSSLSocketFactory(String arg) throws GeneralSecurityException {
        boolean debug;
        String clientkeyStoreType = System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType());
        String clientkeyStorePath = System.getProperty("javax.net.ssl.keyStore");
        String clientkeyStorePass = System.getProperty("javax.net.ssl.keyStorePassword");
        String sslDebug = System.getProperty("javax.net.debug");
        boolean bl = debug = sslDebug != null && (sslDebug.startsWith("all") || sslDebug.startsWith("ssl"));
        if (debug) {
            System.out.println("Creating PolarPSSLSocketFactory...");
            System.out.println("Using client keystore " + clientkeyStorePath + " of type " + clientkeyStoreType + ", password:  " + clientkeyStorePass);
        }
        KeyStore keyStore = KeyStore.getInstance(clientkeyStoreType);
        try (FileInputStream is = new FileInputStream(clientkeyStorePath);){
            keyStore.load(is, clientkeyStorePass.toCharArray());
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException ex) {
            throw new GeneralSecurityException(ex);
        }
        SSLContext edbplusSSLContext = SSLContext.getInstance("TLS");
        PolarPX509KeyManager keyManager = new PolarPX509KeyManager(keyStore, clientkeyStorePass.toCharArray());
        edbplusSSLContext.init(new KeyManager[]{keyManager}, null, null);
        this.factory = edbplusSSLContext.getSocketFactory();
        if (debug) {
            System.out.println("PolarPSSLSocketFactory creation is successful.");
        }
    }
}

