/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb;

import com.aliyun.polardb.Settings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jline.console.ConsoleReader;

public class Util {
    public static BufferedWriter Output;
    public static FileWriter file;

    private Util() {
    }

    public static String getInputLine(String prompt, Settings s) {
        String rLine = " ";
        try {
            ConsoleReader in = new ConsoleReader();
            in.setExpandEvents(false);
            Util.print(prompt, s);
            rLine = Util.escapeChars(in.readLine(), "\\");
            Util.spoolInput(rLine, s);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rLine;
    }

    public static String getMaskedInputLine(String inPrompt, Settings s) {
        String password = "";
        Util.print(inPrompt, s);
        try {
            ConsoleReader reader = new ConsoleReader();
            reader.setExpandEvents(false);
            password = reader.readLine(new Character('\u0000'));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (password == null) {
            password = "";
        }
        return password;
    }

    public static int println(String line, Settings s) {
        return Util.println(line, s, true);
    }

    public static int println(String line, Settings s, boolean needSpooling) {
        if (s.termOut.equals("ON") || Settings.isInteractive) {
            System.out.println(line);
            if (s.flush.equals("ON")) {
                System.out.flush();
            }
        }
        StringBuilder sb = new StringBuilder(line);
        int lineKount = 1;
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != '\n') continue;
            ++lineKount;
        }
        if (needSpooling) {
            Util.printlnSpool(line, s);
        }
        return lineKount;
    }

    public static void printlnSpool(String line, Settings s) {
        if (s.spool.equals("ON")) {
            try {
                if (s.trims.equals("ON")) {
                    line = line.replaceAll("\\s+$", "");
                }
                file.write(line + System.getProperty("line.separator"));
                if (s.flush.equals("ON")) {
                    file.flush();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void printPrompt(Settings s, boolean isInteractive) {
        if (isInteractive) {
            if (s.echo.equalsIgnoreCase("ON")) {
                Util.print(s.sqlPrompt, s, true);
            } else {
                Util.print(s.sqlPrompt, s, false);
            }
        }
    }

    public static int print(String field, Settings s) {
        return Util.print(field, s, true);
    }

    public static int print(String field, Settings s, boolean needSpooling) {
        if (s.termOut.equals("ON") || Settings.isInteractive) {
            System.out.print(field);
            if (s.flush.equals("ON")) {
                System.out.flush();
            }
        }
        if (needSpooling) {
            Util.printSpool(field, s);
        }
        return 0;
    }

    public static void printSpool(String field, Settings s) {
        if (s.spool.equals("ON")) {
            try {
                file.write(field);
                if (s.flush.equals("ON")) {
                    file.flush();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void spoolOff() {
        try {
            file.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean spoolOn(String spoolFile) {
        try {
            if (!new File(spoolFile).getName().contains(".")) {
                spoolFile = spoolFile + ".lst";
            }
            file = new FileWriter(spoolFile);
            Output = new BufferedWriter(file);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String trimQuotes(String inString) {
        String trimString = inString.trim();
        if (trimString.startsWith("\"") && trimString.endsWith("\"") || trimString.startsWith("'") && trimString.endsWith("'")) {
            return trimString.substring(1, trimString.length() - 1);
        }
        return trimString;
    }

    public static String padRight(String inString, char padChar, int endLength) {
        int startLength = inString.length();
        if (startLength >= endLength) {
            return inString;
        }
        StringBuffer sb = new StringBuffer(inString);
        for (int i = 1; i <= endLength - startLength; ++i) {
            sb.append(padChar);
        }
        return sb.toString();
    }

    public static String padLeft(String inString, char padChar, int endLength) {
        int startLength = inString.length();
        if (startLength >= endLength) {
            return inString;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 1; i <= endLength - startLength; ++i) {
            sb.append(padChar);
        }
        return sb.toString() + inString;
    }

    public static String rTrim(String inString, Settings s) {
        if (inString == null || inString.length() == 0) {
            return "";
        }
        StringBuffer in = new StringBuffer(inString);
        int kount = 0;
        for (int i = in.length() - 1; i >= 0; --i) {
            char previousChar = '\u0000';
            if (i > 0) {
                previousChar = in.charAt(i - 1);
            }
            if (in.charAt(i) != ' ' && in.charAt(i) != '\n' && (in.charAt(i) != '/' || previousChar == '*') && in.charAt(i) != s.sqlTerminator.charAt(0)) break;
            ++kount;
        }
        if (kount == 0) {
            return inString;
        }
        return inString.substring(0, in.length() - kount);
    }

    public static String lTrim(String inString) {
        if (inString == null || inString.trim().length() == 0) {
            return "";
        }
        if (!inString.startsWith(" ")) {
            return inString;
        }
        StringBuffer sb = new StringBuffer(inString);
        for (int i = 0; i < sb.length() && sb.charAt(i) == ' '; ++i) {
            sb.deleteCharAt(i);
        }
        return sb.toString();
    }

    public static String tokenTrim(String inString) {
        if (inString == null || inString.trim().length() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(inString);
        boolean tokenStarted = false;
        boolean tokenEnded = false;
        int sbLength = sb.length();
        for (int i = 0; i < sbLength; ++i) {
            if (sb.charAt(i) == ' ') {
                sb.deleteCharAt(i);
                --sbLength;
                --i;
                if (!tokenStarted) continue;
                tokenEnded = true;
                continue;
            }
            tokenStarted = true;
            if (tokenEnded) break;
            sb.deleteCharAt(i);
            --sbLength;
            --i;
        }
        return sb.toString();
    }

    public static String[] tokenSplitter(String inString, Settings s) {
        inString = Util.rTrim(inString, s);
        ArrayList<String> al = new ArrayList<String>();
        String currentToken = "";
        boolean inSingleQuotes = false;
        boolean inDoubleQuoted = false;
        for (int i = 0; i < inString.length(); ++i) {
            char c = inString.charAt(i);
            if (c == '\'') {
                inSingleQuotes = !inSingleQuotes;
                continue;
            }
            if (c == '\"') {
                inDoubleQuoted = !inDoubleQuoted;
                continue;
            }
            if (Util.isTokenSeparator(c, s) && !inSingleQuotes && !inDoubleQuoted) {
                if (currentToken.length() > 0) {
                    al.add(currentToken);
                    currentToken = "";
                }
                if (Character.isWhitespace(c) || c == s.sqlTerminator.charAt(0)) continue;
                al.add("" + c);
                continue;
            }
            currentToken = currentToken + c;
        }
        if (currentToken.length() > 0) {
            al.add(currentToken);
        }
        return al.toArray(new String[0]);
    }

    private static boolean isTokenSeparator(char c, Settings s) {
        return Character.isWhitespace(c) || c == '=' || c == '(' || c == ')' || c == ';' || c == '?' || c == '@' || c == s.sqlTerminator.charAt(0);
    }

    public static String escapeChars(String string, String characters) {
        String result = string;
        if (string != null && characters != null) {
            StringCharacterIterator sci = new StringCharacterIterator(characters);
            char c = sci.first();
            boolean backslashEscaped = false;
            while (c != '\uffff') {
                if (c == '\\' && !backslashEscaped) {
                    result = Util.escape(result, c, '\\');
                    backslashEscaped = true;
                } else {
                    result = Util.escape(result, c, '\\');
                }
                c = sci.next();
            }
        }
        return result;
    }

    public static void spoolInput(String input, Settings s) {
        if (s.spool.equals("ON")) {
            try {
                file.write(input + System.getProperty("line.separator"));
                if (s.flush.equals("ON")) {
                    file.flush();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static String escape(String string, char character, char escape) {
        String result = string;
        if (string != null) {
            StringBuffer sb = new StringBuffer();
            StringCharacterIterator sci = new StringCharacterIterator(string);
            char c = sci.first();
            while (c != '\uffff') {
                if (c == character) {
                    sb.append(escape);
                }
                sb.append(c);
                c = sci.next();
            }
            result = sb.toString();
        }
        return result;
    }

    public static boolean haveMinimumVersion(String srcVersion, String targetVersion) {
        String[] srcNums = srcVersion.split("[.]");
        String[] targetNums = targetVersion.split("[.]");
        for (int i = 0; i < srcNums.length && i < targetNums.length; ++i) {
            int targetNum;
            int srcNum = Integer.parseInt(srcNums[i]);
            if (srcNum < (targetNum = Integer.parseInt(targetNums[i]))) {
                return false;
            }
            if (srcNum <= targetNum) continue;
            return true;
        }
        return true;
    }

    public static String expandEnvVars(String text) {
        Map<String, String> envMap = System.getenv();
        String pattern = "\\$(\\{([^\\$^\\/^\\s]+)\\}|([^\\$^\\/^\\s]+))";
        boolean isWindows = false;
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            pattern = "\\%([^\\%^\\s]+)\\%";
            isWindows = true;
        }
        Pattern expr = Pattern.compile(pattern);
        Matcher matcher = expr.matcher(text);
        while (matcher.find()) {
            String envVar;
            if (isWindows) {
                envVar = matcher.group(1);
            } else {
                envVar = matcher.group(2);
                if (envVar == null) {
                    envVar = matcher.group(3);
                }
            }
            String envVarValue = envMap.get(envVar.toUpperCase());
            if (envVarValue == null) {
                System.err.println("The environment variable " + envVar + " is not defined.");
                return null;
            }
            envVarValue = envVarValue.replace("\\", "\\\\");
            Pattern subexpr = Pattern.compile(Pattern.quote(matcher.group(0)));
            text = subexpr.matcher(text).replaceFirst(envVarValue);
        }
        return text;
    }

    public static String authenticateViaPGPass(String host, String db, String user, String port) {
        String password;
        block20: {
            password = null;
            try {
                String line;
                boolean ipv6Address;
                File pgPassFile;
                if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                    pgPassFile = new File(Settings.PGPASS_CONFIG_FILE_PATH_WIN);
                    if (!pgPassFile.exists()) {
                        return null;
                    }
                } else {
                    File pgPassDir = new File(System.getProperty("user.home"));
                    pgPassFile = new File(pgPassDir, ".pgpass");
                    if (!pgPassFile.exists()) {
                        String pgPassFilePath = System.getenv("PGPASSFILE");
                        if (pgPassFilePath != null) {
                            pgPassDir = new File(pgPassFilePath);
                            pgPassFile = new File(pgPassFilePath, ".pgpass");
                        }
                        if (!pgPassFile.exists()) {
                            return null;
                        }
                    }
                    Path path = Paths.get(pgPassDir + File.separator + ".pgpass", new String[0]);
                    PosixFileAttributeView posixView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
                    PosixFileAttributes attribs = posixView.readAttributes();
                    Set<PosixFilePermission> permissions = attribs.permissions();
                    boolean ignorePassFile = false;
                    if (permissions.size() > 2) {
                        ignorePassFile = true;
                    } else {
                        for (PosixFilePermission filePermission : permissions) {
                            if (filePermission == PosixFilePermission.OWNER_READ || filePermission == PosixFilePermission.OWNER_WRITE) continue;
                            ignorePassFile = true;
                            break;
                        }
                    }
                    if (ignorePassFile) {
                        return null;
                    }
                }
                if (ipv6Address = host.contains(":")) {
                    host = host.replace("[", "").replace("]", "");
                }
                String[] userDbCredentials = new String[]{host, port, db, user};
                BufferedReader reader = new BufferedReader(new FileReader(pgPassFile));
                while ((line = reader.readLine()) != null) {
                    boolean lineMatch;
                    String[] pgpassDbCredentials = line.split(":");
                    int credentialLength = pgpassDbCredentials.length;
                    if (ipv6Address) {
                        boolean bl = lineMatch = credentialLength >= 7;
                        if (lineMatch) {
                            String IPV6host = "";
                            for (int i = 0; i < credentialLength - 4; ++i) {
                                IPV6host = IPV6host + pgpassDbCredentials[i] + ":";
                            }
                            IPV6host = IPV6host.substring(0, IPV6host.length() - 1);
                            pgpassDbCredentials = new String[]{IPV6host, pgpassDbCredentials[credentialLength - 4], pgpassDbCredentials[credentialLength - 3], pgpassDbCredentials[credentialLength - 2], pgpassDbCredentials[credentialLength - 1]};
                        }
                    } else {
                        boolean bl = lineMatch = credentialLength == 5;
                    }
                    if (lineMatch) {
                        for (int i = 0; i < pgpassDbCredentials.length - 1; ++i) {
                            if (pgpassDbCredentials[i].equals("*") || pgpassDbCredentials[i].equals(userDbCredentials[i])) continue;
                            lineMatch = false;
                            break;
                        }
                    }
                    if (!lineMatch) continue;
                    password = pgpassDbCredentials[4];
                    break;
                }
            }
            catch (Exception ex) {
                String error = ex.getMessage();
                if (!error.toLowerCase().contains("permission denied")) break block20;
                System.err.println("The pgpass file cannot be opened, Reason: " + error);
            }
        }
        return password;
    }
}

