/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb;

import com.aliyun.polardb.DBCredentials;
import com.aliyun.polardb.HostExec;
import com.aliyun.polardb.LinuxNative;
import com.aliyun.polardb.PolarPlus;
import com.aliyun.polardb.ProcessInput;
import com.aliyun.polardb.SubVar;
import com.aliyun.polardb.Util;
import com.aliyun.polardb.db.DBHandlerFactory;
import com.aliyun.polardb.db.IDBHandler;
import com.aliyun.polardb.db.PolarDBHandler;
import com.aliyun.polardb.events.SQLErrorEvent;
import com.aliyun.polardb.exception.InternalException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ListIterator;
import java.util.Vector;

public class Settings {
    public String autocommit = "OFF";
    public int autocommitRows = 0;
    public String colSep = " ";
    public String define = "&";
    public String echo = "OFF";
    public String feedback = "ON";
    public int feedbackRows = 6;
    public String flush = "ON";
    public String heading = "ON";
    public String headSep = "|";
    public int lineSize = 80;
    public String nul = " ";
    public int newPage = 1;
    public int pageSize = 14;
    public String pause = "OFF";
    public String serverOutput = "OFF";
    public String suffix = ".sql";
    public String spool = "OFF";
    public String sqlCase = "MIXED";
    public String sqlPrompt = "SQL> ";
    public String sqlTerminator = ";";
    public String termOut = "ON";
    public String timing = "OFF";
    public String trims = "OFF";
    public String verify = "ON";
    public char concat = (char)46;
    public boolean silent = false;
    public String userDB = "";
    public String versionDB = "";
    public String nameDB = "";
    public static String defaultNameDB = "postgres";
    public String hostDB = "";
    public static final String defaultHostDB = "localhost";
    public String portDB = "";
    public static String defaultPortDB = "55444";
    public boolean isConnectedDB = false;
    public String pauseText = "Hit ENTER to continue...";
    public String spoolFile = " ";
    public Vector variableVector = new Vector();
    public int variableKount = 0;
    public Vector columnVector = new Vector();
    public int columnKount = 0;
    public String currentBuffer = "";
    public int currentBufferLine = 0;
    public final int EXIT_SUCCESS = 0;
    public final int EXIT_FAILURE = 1;
    public final int EXIT_WARNING = 2;
    public static int MAX_LOGIN_TRIES = 3;
    public static final String HISTORY_FILENAME = ".polarplus.history";
    public static boolean isInteractive = true;
    private boolean initialized = false;
    public static final String PGPASS_CONFIG_FILE_NAME = ".pgpass";
    public static final String PGPASS_CONFIG_FILE_NAME_WIN = "pgpass.conf";
    public static final String PGPASS_CONFIG_FILE_PATH_WIN = System.getenv("APPDATA") + File.separator + "postgresql" + File.separator + "pgpass.conf";
    private IDBHandler dbHandler = null;
    private IDBHandler.DbType dbType = null;
    private SQLErrorEvent sqlErrorEvent = new SQLErrorEvent();

    public Settings() {
        this(IDBHandler.DbType.PolarDB);
    }

    public Settings(IDBHandler.DbType dbType) {
        this.dbType = dbType;
        String os = System.getProperty("os.name");
        if (os == null) {
            os = "";
        }
        if (os.toLowerCase().startsWith("windows")) {
            // empty if block
        }
        try {
            this.dbHandler = DBHandlerFactory.createDBHandler(dbType);
        }
        catch (InternalException ie) {
            System.err.println("Error: " + ie.getMessage());
        }
        if (dbType != IDBHandler.DbType.PolarDB) {
            defaultPortDB = this.dbHandler.getDefaultDBPort();
            defaultNameDB = this.dbHandler.getDefaultDBName();
        }
    }

    public IDBHandler getDBHandler() {
        return this.dbHandler;
    }

    public IDBHandler.DbType getDBType() {
        return this.dbType;
    }

    public void passwordFunction(String inPassword, String inToken) {
        String sPassword = Util.rTrim(inPassword, this);
        String sUser = sPassword.substring(inToken.length(), sPassword.length());
        if ((sUser = sUser.trim()).equals("")) {
            sUser = this.userDB;
        }
        Util.println("Changing password for " + sUser, this);
        String newPass1 = Util.getMaskedInputLine("      New password: ", this);
        String newPass2 = Util.getMaskedInputLine("New password again: ", this);
        if (!newPass1.equals(newPass2)) {
            Util.println("ERROR: New passwords do not match.", this);
            Util.println("Password has not been changed.", this);
            return;
        }
        try {
            this.dbHandler.changeUserPassword(this, sUser, newPass1);
            Util.println("Password successfully changed.", this);
        }
        catch (SQLException se) {
            Util.println("ERROR: Password has not been changed.", this);
            Util.println("  " + se.getMessage(), this);
            PolarPlus.getProcessInput().handleSQLError(se, this);
        }
        catch (Exception ex) {
            Util.println(ex.getMessage(), this);
            this.dbHandler.implicitRollback();
        }
    }

    public void pauseFunction(String inPause) {
        String sPause = inPause;
        Util.println(sPause, this);
        ProcessInput pi = PolarPlus.getProcessInput();
        try {
            if (pi != null) {
                pi.waitForReturnPressed();
            } else {
                System.in.read();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void prompt(String inPrompt, String inToken) {
        String sPrompt = Util.rTrim(inPrompt, this);
        sPrompt = sPrompt.substring(inToken.length(), sPrompt.length());
        sPrompt = sPrompt.trim();
        Util.println(sPrompt, this);
    }

    public void spool(String inSpool, String inToken) {
        String sSpool = Util.rTrim(inSpool, this);
        String[] tokens = sSpool.split("\\s+");
        if (tokens.length != 2) {
            Util.println("Invalid SPOOL command.\n", this);
            return;
        }
        String spoolCmd = tokens[1];
        if (spoolCmd.toLowerCase().equals("off")) {
            if (this.spool.equals("OFF")) {
                Util.println("SPOOLING is already OFF.\n", this);
                this.spoolFile = " ";
            } else {
                Util.spoolOff();
                this.spool = "OFF";
            }
        } else if ((spoolCmd = Util.expandEnvVars(spoolCmd)) == null) {
            System.out.println("SPOOL file not created.");
        } else if (Util.spoolOn(spoolCmd)) {
            this.spool = "ON";
            this.spoolFile = sSpool;
        } else {
            System.out.println("SPOOL file \"" + spoolCmd + "\" not created.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String inSet) {
        String[] tokens = Util.tokenSplitter(inSet, this);
        if (tokens.length != 3) {
            Util.println("ERROR: The SET command always takes 2 parameters:\n             variable_name   value", this);
            return;
        }
        String setCommand = tokens[1].toLowerCase();
        String setValue = tokens[2].toLowerCase();
        String setValueOrig = tokens[2];
        if ("autocommit".startsWith(setCommand) && setCommand.startsWith("auto")) {
            if (setValue.equals("on") || "immediate".startsWith(setValue) && setValue.startsWith("imm")) {
                this.autocommit = "ON";
                this.autocommitRows = 1;
                try {
                    this.dbHandler.setConnAutoCommit(true);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return;
            }
            if (setValue.equals("off")) {
                this.autocommit = "OFF";
                this.autocommitRows = 0;
                try {
                    this.dbHandler.setConnAutoCommit(false);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return;
            }
            try {
                try {
                    int intValue = Integer.parseInt(setValue);
                    if (intValue < 0 || intValue > 25000) {
                        Util.println("\nAUTOCOMMIT option " + intValue + " must be between 0 and 25000.", this);
                    } else if (intValue == 0) {
                        this.autocommit = "OFF";
                        this.autocommitRows = 0;
                        this.dbHandler.setConnAutoCommit(false);
                    } else {
                        this.autocommit = "ON";
                        this.autocommitRows = intValue;
                        this.dbHandler.setConnAutoCommit(intValue == 1);
                    }
                    return;
                }
                catch (Exception e) {
                    Util.println("ERROR: Invalid AUTOCOMMIT command, try: \n       SET AUTO[COMMIT] { OFF | ON | IMM[EDIATE] | n }", this);
                    return;
                }
            }
            catch (Throwable throwable) {
                return;
            }
        }
        if (setCommand.equals("colsep")) {
            this.colSep = setValue = setValue.replace("\\\\", "\\");
            return;
        }
        if ("define".startsWith(setCommand) && setCommand.startsWith("def")) {
            if (setValue.equals("on")) {
                this.define = "&";
            } else if (setValue.equals("off")) {
                this.define = "OFF";
            } else if (setValue.trim().length() == 1) {
                this.define = setValue.trim();
            } else {
                Util.println("ERROR: Invalid DEFINE command, try: \n       SET DEF[INE] {OFF | ON | single_char}", this);
            }
            return;
        }
        if (setCommand.equals("echo")) {
            if (setValue.equals("on") || setValue.equals("off")) {
                this.echo = setValue.toUpperCase();
            } else {
                Util.println("ERROR: ECHO must be ON or OFF.", this);
            }
            return;
        }
        if ("feedback".startsWith(setCommand) && setCommand.startsWith("feed")) {
            if (setValue.equals("on")) {
                this.feedback = "ON";
                this.feedbackRows = 1;
                return;
            }
            if (setValue.equals("off")) {
                this.feedback = "OFF";
                this.feedbackRows = 0;
                return;
            }
            try {
                try {
                    int intValue = Integer.parseInt(setValue);
                    if (intValue < 0 || intValue > 25000) {
                        Util.println("ERROR: FEEDBACK must be between 0 and 25000.", this);
                    } else if (intValue == 0) {
                        this.feedback = "OFF";
                        this.feedbackRows = 0;
                    } else {
                        this.feedback = "ON";
                        this.feedbackRows = intValue;
                    }
                    return;
                }
                catch (Exception e) {
                    Util.println("ERROR: FEEDBACK must be an integer.", this);
                    return;
                }
            }
            catch (Throwable throwable) {
                return;
            }
        }
        if ("flush".startsWith(setCommand) && setCommand.startsWith("flu")) {
            if (setValue.equals("on") || setValue.equals("off")) {
                this.flush = setValue.toUpperCase();
            } else {
                Util.println("ERROR: FLUSH must be ON or OFF.", this);
            }
            return;
        }
        if ("heading".startsWith(setCommand) && setCommand.startsWith("hea")) {
            if (setValue.equals("on") || setValue.equals("off")) {
                this.heading = setValue.toUpperCase();
            } else {
                Util.println("ERROR: HEADING must be ON or OFF.", this);
            }
            return;
        }
        if ("headsep".startsWith(setCommand) && setCommand.startsWith("heads")) {
            if (setValueOrig.length() == 1) {
                this.headSep = setValueOrig;
            } else {
                Util.println("ERROR: HEADSEP maximum size is 1 character.", this);
            }
            return;
        }
        if ("linesize".startsWith(setCommand) && setCommand.startsWith("lin")) {
            try {
                try {
                    int intValue = Integer.parseInt(setValue);
                    if (intValue < 1 || intValue > Short.MAX_VALUE) {
                        Util.println("ERROR: LINESIZE must be between 1 and 32767.", this);
                    } else {
                        this.lineSize = intValue;
                    }
                    return;
                }
                catch (Exception e) {
                    Util.println("ERROR: LINESIZE must be an integer.", this);
                    return;
                }
            }
            catch (Throwable throwable) {
                return;
            }
        }
        if ("newpage".startsWith(setCommand) && setCommand.startsWith("newp")) {
            try {
                try {
                    int intValue = Integer.parseInt(setValue);
                    if (intValue >= 0 && intValue <= 100) {
                        this.newPage = intValue;
                    } else {
                        Util.println("ERROR: NEWPAGE must be between 0 and 100.", this);
                    }
                    return;
                }
                catch (Exception e) {
                    Util.println("ERROR: NEWPAGE must be an integer.", this);
                    return;
                }
            }
            catch (Throwable throwable) {
                return;
            }
        }
        if (setCommand.equals("null")) {
            this.nul = setValue;
            return;
        }
        if ("pagesize".startsWith(setCommand) && setCommand.startsWith("pages")) {
            try {
                try {
                    int intValue = Integer.parseInt(setValue);
                    if (intValue == 0 || intValue >= 2 && intValue <= 50000) {
                        this.pageSize = intValue;
                    } else {
                        Util.println("ERROR: PAGESIZE must be zero or between 2 and 50000.", this);
                    }
                    return;
                }
                catch (Exception e) {
                    Util.println("ERROR: PAGESIZE must be an integer.", this);
                    return;
                }
            }
            catch (Throwable throwable) {
                return;
            }
        }
        if ("pause".startsWith(setCommand) && setCommand.startsWith("pau")) {
            if (setValue.equals("on") || setValue.equals("off")) {
                this.pause = setValue.toUpperCase();
            } else {
                Util.println("ERROR: PAUSE must be ON or OFF.", this);
            }
            return;
        }
        if ("serveroutput".startsWith(setCommand) && setCommand.startsWith("serverout")) {
            if (setValue.equals("on") || setValue.equals("off")) {
                this.serverOutput = setValue.toUpperCase();
            } else {
                Util.println("ERROR: SERVEROUTPUT must be ON or OFF.", this);
            }
            return;
        }
        if (setCommand.equals("space")) {
            try {
                try {
                    int intValue = Integer.parseInt(setValue);
                    if (intValue < 0 || intValue >= this.lineSize) {
                        Util.println("ERROR: Number of spaces must be between 0 and LINESIZE.", this);
                        return;
                    }
                    this.colSep = "";
                    for (int i = 0; i < intValue; ++i) {
                        this.colSep = this.colSep + " ";
                    }
                    return;
                }
                catch (Exception e) {
                    Util.println("ERROR: Number of spaces must be an integer.", this);
                    return;
                }
            }
            catch (Throwable throwable) {
                return;
            }
        }
        if ("sqlcase".startsWith(setCommand) && setCommand.startsWith("sqlc")) {
            if ("mixed".startsWith(setValue) && setValue.startsWith("mix")) {
                this.sqlCase = "MIXED";
            } else if ("upper".startsWith(setValue) && setValue.startsWith("up")) {
                this.sqlCase = "UPPER";
            } else if ("lower".startsWith(setValue) && setValue.startsWith("lo")) {
                this.sqlCase = "LOWER";
            } else {
                Util.println("ERROR: SQLCASE must be MIXED, UPPER or LOWER.", this);
            }
            return;
        }
        if ("sqlprompt".startsWith(setCommand) && setCommand.startsWith("sqlp")) {
            this.sqlPrompt = setValueOrig;
            return;
        }
        if ("sqlterminator".startsWith(setCommand) && setCommand.startsWith("sqlt")) {
            if (setValueOrig.trim().length() == 1) {
                this.sqlTerminator = setValueOrig.trim();
            } else {
                Util.println("ERROR: SQLTERMINATOR must be only 1 character.\n", this);
            }
            return;
        }
        if ("serveroutput".startsWith(setCommand) && setCommand.startsWith("serverout")) {
            if (setValue.equals("on") || setValue.equals("off")) {
                this.serverOutput = setValue.toUpperCase();
            } else {
                Util.println("ERROR: SERVEROUTPUT must be ON or OFF.", this);
            }
            return;
        }
        if ("suffix".startsWith(setCommand) && setCommand.startsWith("suf")) {
            this.suffix = setValueOrig;
            return;
        }
        if ("termout".startsWith(setCommand) && setCommand.startsWith("term")) {
            if (setValue.equals("on") || setValue.equals("off")) {
                this.termOut = setValue.toUpperCase();
            } else {
                Util.println("ERROR: TERMOUT must be ON or OFF.", this);
            }
            return;
        }
        if ("timing".startsWith(setCommand) && setCommand.startsWith("timi")) {
            if (setValue.equals("on") || setValue.equals("off")) {
                this.timing = setValue.toUpperCase();
            } else {
                Util.println("ERROR: TIMIMNG must be ON or OFF.", this);
            }
            return;
        }
        if ("trimspool".startsWith(setCommand) && setCommand.startsWith("trims")) {
            if (setValue.equals("on") || setValue.equals("off")) {
                this.trims = setValue.toUpperCase();
            } else {
                Util.println("ERROR: TRIMS must be ON or OFF.", this);
            }
            return;
        }
        if ("verify".startsWith(setCommand) && setCommand.startsWith("ver")) {
            if (setValue.equals("on") || setValue.equals("off")) {
                this.verify = setValue.toUpperCase();
            } else {
                Util.println("ERROR: VERIFY must be ON or OFF.", this);
            }
            return;
        }
        this.unknownSet();
    }

    private void unknownSet() {
        Util.println("ERROR: SET command is invalid.", this);
    }

    public String show(String inShow) {
        String[] tokens;
        String sShow = Util.rTrim(inShow, this);
        if ((sShow = sShow.trim()).toLowerCase().equals("sho") || sShow.toLowerCase().equals("show")) {
            sShow = "show all";
        }
        if ((tokens = sShow.toLowerCase().split("\\s+")).length < 2 || tokens.length > 3) {
            return this.unknownShow(sShow);
        }
        String showCommand = tokens[1];
        if (showCommand.equals("all")) {
            return this.showAll();
        }
        if ("autocommit".startsWith(showCommand) && showCommand.startsWith("auto")) {
            return this.formatAutocommit();
        }
        if (showCommand.equals("colsep")) {
            return "colsep \"" + this.colSep + "\"";
        }
        if ("buffer".startsWith(showCommand) && showCommand.startsWith("buff")) {
            return "currentBufferLine = " + this.currentBufferLine + "\n\"" + this.currentBuffer + "\"";
        }
        if ("define".startsWith(showCommand) && showCommand.startsWith("def")) {
            return "define \"" + this.define + "\"";
        }
        if (showCommand.equals("echo")) {
            return "echo " + this.echo;
        }
        if ("feedback".startsWith(showCommand) && showCommand.startsWith("feed")) {
            return this.formatFeedback();
        }
        if ("flush".startsWith(showCommand) && showCommand.startsWith("flu")) {
            return "flush " + this.flush;
        }
        if ("heading".startsWith(showCommand) && showCommand.startsWith("hea")) {
            return "heading " + this.heading;
        }
        if ("headsep".startsWith(showCommand) && showCommand.startsWith("heads")) {
            return "headsep \"" + this.headSep + "\"";
        }
        if ("linesize".startsWith(showCommand) && showCommand.startsWith("lin")) {
            return "linesize " + this.lineSize;
        }
        if ("newpage".startsWith(showCommand) && showCommand.startsWith("newp")) {
            return "newpage " + this.newPage;
        }
        if (showCommand.equals("null")) {
            return "null \"" + this.nul + "\"";
        }
        if ("pagesize".startsWith(showCommand) && showCommand.startsWith("pages")) {
            return "pagesize " + this.pageSize;
        }
        if ("parameters".startsWith(showCommand) && showCommand.startsWith("param")) {
            if (tokens.length == 3) {
                this.formatParams(tokens[2]);
            } else {
                this.formatParams(" ");
            }
            return " ";
        }
        if ("pause".startsWith(showCommand) && showCommand.startsWith("pau")) {
            return this.formatPause();
        }
        if ("serveroutput".startsWith(showCommand) && showCommand.startsWith("serverout")) {
            return "serveroutput " + this.serverOutput;
        }
        if ("spool".startsWith(showCommand) && showCommand.startsWith("sp")) {
            return "spool " + this.spool;
        }
        if ("sqlcase".startsWith(showCommand) && showCommand.startsWith("sqlc")) {
            return "sqlcase " + this.sqlCase;
        }
        if ("sqlprompt".startsWith(showCommand) && showCommand.startsWith("sqlp")) {
            return "sqlprompt \"" + this.sqlPrompt + "\"";
        }
        if ("sqlterminator".startsWith(showCommand) && showCommand.startsWith("sqlt")) {
            return "sqlterminator \"" + this.sqlTerminator + "\"";
        }
        if ("suffix".startsWith(showCommand) && showCommand.startsWith("suf")) {
            return "suffix \"" + this.suffix + "\"";
        }
        if ("termout".startsWith(showCommand) && showCommand.startsWith("term")) {
            return "termout " + this.termOut;
        }
        if ("verify".startsWith(showCommand) && showCommand.startsWith("ver")) {
            return "verify " + this.verify;
        }
        if ("timing".startsWith(showCommand) && showCommand.startsWith("timi")) {
            return "timing " + this.timing;
        }
        if ("trimspool".startsWith(showCommand) && showCommand.startsWith("trims")) {
            return "trimspool " + this.trims;
        }
        if (showCommand.equals("user")) {
            return "USER is \"" + this.userDB + "\"";
        }
        if (showCommand.equals("host")) {
            return "HOST is \"" + this.hostDB + "\"";
        }
        if (showCommand.equals("port")) {
            return "PORT is \"" + this.portDB + "\"";
        }
        if (showCommand.equals("database")) {
            return "DATABASE is \"" + this.nameDB + "\"";
        }
        if (showCommand.equals("version")) {
            return "VERSION is \"" + this.versionDB + "\"";
        }
        if (showCommand.equals("space")) {
            return "space " + this.colSep.length() + "";
        }
        return this.unknownShow(sShow);
    }

    private String formatAutocommit() {
        if (this.autocommit.equals("ON")) {
            if (this.autocommitRows == 1) {
                return "autocommit      IMMEDIATE";
            }
            return "AUTOCOMMIT ON for every " + this.autocommitRows + " DML statement(s).";
        }
        return "autocommit      OFF";
    }

    private String formatFeedback() {
        if (this.feedback.equals("ON")) {
            return "FEEDBACK ON for " + this.feedbackRows + " row(s).";
        }
        return "feedback        OFF";
    }

    private void formatParams(String searchString) {
        ProcessInput pi = new ProcessInput();
        String scrubbedString = Util.trimQuotes(searchString);
        scrubbedString = scrubbedString.replace('%', ' ');
        scrubbedString = scrubbedString.replace('\'', ' ');
        try {
            StringBuffer sb = new StringBuffer(this.dbHandler.getServerVarSQL(scrubbedString));
            pi.execJDBC(sb, this, 0, 0);
        }
        catch (SQLException se) {
            String msg = se.getMessage();
            if (msg.startsWith("ERROR: ")) {
                msg = msg.substring(7, msg.length());
            }
            Util.println(msg, PolarPlus.sessionSettings);
            PolarPlus.getProcessInput().handleSQLError(se, PolarPlus.sessionSettings);
            return;
        }
        catch (InternalException iex) {
            Util.println("PolarDB-" + Util.padLeft("" + iex.getErrorCode(), '0', 4) + ": " + iex.getMessage(), PolarPlus.sessionSettings);
            this.dbHandler.implicitRollback();
            return;
        }
        catch (Exception ex) {
            Util.println(ex.getMessage(), this);
            this.dbHandler.implicitRollback();
        }
    }

    private String formatPause() {
        if (this.pause.equals("ON")) {
            return "PAUSE is ON and set to \"" + this.pauseText + "\".";
        }
        return "pause           OFF";
    }

    public String showAll() {
        return this.formatAutocommit() + "\ncolsep          \"" + this.colSep + "\"\ndefine          \"" + this.define + "\"\necho            " + this.echo + "\n" + this.formatFeedback() + "\nflush           " + this.flush + "\nheading         " + this.heading + "\nheadsep         \"" + this.headSep + "\"\nlinesize        " + this.lineSize + "\nnewpage         " + this.newPage + "\nnull            \"" + this.nul + "\"\npagesize        " + this.pageSize + "\n" + this.formatPause() + "\nserveroutput    " + this.serverOutput + "\nspool           " + this.spool + "\nsqlcase         " + this.sqlCase + "\nsqlprompt       \"" + this.sqlPrompt + "\"\nsqlterminator   \"" + this.sqlTerminator + "\"\nsuffix          \"" + this.suffix + "\"\ntermout         " + this.termOut + "\ntiming          " + this.timing + "\ntrimspool       " + this.trims + "\nverify          " + this.verify + "\nUSER is         \"" + this.userDB + "\"\nHOST is         \"" + this.hostDB + "\"\nPORT is         \"" + this.portDB + "\"\nDATABASE is     \"" + this.nameDB + "\"\nVERSION is      \"" + this.versionDB + "\"";
    }

    private String unknownShow(String Util2) {
        return "ERROR: Unknown SHOW option \"" + Util2.substring(5, Util2.length()) + "\"";
    }

    public String accept(String strAccept) {
        String myAccept = "";
        String userVariable = "";
        String invalidAccept = "Error - Accept command must be of the form: \n    ACC[EPT] user_variable";
        myAccept = Util.rTrim(strAccept, this);
        String[] acceptTokens = myAccept.split("\\s");
        if (acceptTokens.length != 1) {
            Util.println(invalidAccept, this);
            return "";
        }
        userVariable = acceptTokens[0].trim();
        String returnVariable = Util.getInputLine("Enter value for " + userVariable + ": ", this);
        return returnVariable;
    }

    public void connectDB(String strConnect) {
        int tryCount;
        if (strConnect != null && strConnect.trim().equalsIgnoreCase("/nolog")) {
            this.disconnectDB();
            this.initialized = true;
            return;
        }
        try {
            BufferedReader in2 = new BufferedReader(new FileReader("login.sql"));
            ProcessInput pi = new ProcessInput();
            pi.inputLooper(in2, this, false);
        }
        catch (IOException in2) {
            // empty catch block
        }
        boolean autoDisconnect = false;
        String connectStr = "";
        if (strConnect != null && strConnect.trim().length() > 0) {
            connectStr = strConnect;
        }
        DBCredentials credentials = new DBCredentials(defaultHostDB, defaultPortDB, defaultNameDB, this);
        int n = tryCount = this.initialized ? MAX_LOGIN_TRIES - 1 : 0;
        if (this.isConnectedDB) {
            autoDisconnect = true;
            this.disconnectDB();
        }
        Connection conn = null;
        while (tryCount < MAX_LOGIN_TRIES) {
            if (connectStr.trim().length() == 0) {
                connectStr = Util.getInputLine("    User: ", this);
            }
            try {
                credentials.processInput(connectStr);
                connectStr = "";
                String host = credentials.getHost();
                String port = credentials.getPort();
                String db = credentials.getDb();
                String user = credentials.getUser();
                String password = credentials.getPassword(tryCount);
                String urlOptions = credentials.getUrlOptions();
                if (password == null && (conn = this.dbHandler.getConnection()) != null) break;
                conn = this.dbHandler.createConnection(host, port, db, user, password, urlOptions);
                break;
            }
            catch (Exception exp) {
                ++tryCount;
                connectStr = "";
                Util.println(System.getProperty("line.separator") + exp.getMessage() + System.getProperty("line.separator"), this);
            }
        }
        try {
            if (conn == null && !this.initialized) {
                Util.println("ERROR: Unable to connect to " + this.dbHandler.getProductName() + " after 3 attempts.", this);
                System.exit(-1);
            } else if ((conn == null || conn.isClosed()) && this.initialized) {
                if (autoDisconnect) {
                    Util.println("WARNING: You are no longer connected to " + this.dbHandler.getProductName() + ".", this);
                }
                return;
            }
        }
        catch (Exception exp) {
            return;
        }
        this.initialized = true;
        try {
            String dbName = this.dbHandler.getProductName();
            this.versionDB = this.dbHandler.getProductVersion();
            if (!Util.haveMinimumVersion(this.versionDB, this.dbHandler.getSupportedVersion())) {
                Util.println("ERROR: POLAR*Plus only works on an " + dbName + " database version " + this.dbHandler.getSupportedVersion() + " (or higher).", this);
                System.exit(-1);
            }
            this.dbHandler.setConnAutoCommit(false);
            if (this.dbHandler instanceof PolarDBHandler) {
                ((PolarDBHandler)this.dbHandler).setFetchSize(this);
            }
            if (!this.silent) {
                Util.println("Connected to " + dbName + " " + this.versionDB + " (" + credentials.getHost() + ":" + credentials.getPort() + "/" + credentials.getDb() + ") AS " + credentials.getUser() + System.getProperty("line.separator"), this);
            }
        }
        catch (SQLException se) {
            Util.println("ERROR:", this);
            Util.println("  " + se.getMessage(), this);
            if (autoDisconnect) {
                Util.println("WARNING: You are no longer connected to " + this.dbHandler.getProductName() + ".", this);
            }
            return;
        }
        this.isConnectedDB = true;
        this.userDB = credentials.getUser();
        this.hostDB = credentials.getHost();
        this.portDB = credentials.getPort();
        this.nameDB = credentials.getDb();
    }

    public String getVariable(String inVarName) {
        String varName = inVarName.toUpperCase().trim();
        ListIterator iter = this.variableVector.listIterator();
        for (int i = 1; i <= this.variableKount; ++i) {
            SubVar v = (SubVar)iter.next();
            if (!v.varName.equals(varName)) continue;
            return v.varValue;
        }
        return "";
    }

    public void disconnectDB() {
        if (this.isConnectedDB) {
            try {
                String msg = "Disconnected from " + this.dbHandler.getProductName() + " Database.";
                this.isConnectedDB = false;
                this.userDB = " ";
                this.versionDB = " ";
                this.hostDB = " ";
                this.portDB = " ";
                this.nameDB = " ";
                this.dbHandler.silentCommit();
                this.dbHandler.closeConnection();
                if (!this.silent) {
                    Util.println(msg, this);
                }
            }
            catch (SQLException se) {
                Util.println("ERROR: Unexpected SQL error disconnecting from DB.", this);
            }
        }
    }

    public synchronized void setCurrentBuffer(String bufferText) {
        this.currentBuffer = "";
        this.currentBufferLine = 0;
        BufferedReader reader = new BufferedReader(new StringReader(bufferText));
        String line = null;
        StringBuffer temp = new StringBuffer();
        try {
            while ((line = reader.readLine()) != null) {
                if (this.currentBufferLine == 0) {
                    temp.append(line);
                } else {
                    temp.append("\n" + line);
                }
                ++this.currentBufferLine;
            }
            this.currentBuffer = temp.toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void bufferAppend(String inString) {
        if (inString.trim().length() == 0) {
            Util.println("ERROR: APPEND must not be blank.", this);
            return;
        }
        String trimString = inString.substring(1);
        trimString = Util.rTrim(trimString, this);
        if (this.currentBuffer.trim().length() == 0) {
            this.currentBufferLine = 1;
            this.currentBuffer = trimString;
            return;
        }
        StringBuffer sb = new StringBuffer("");
        String str = null;
        int kount = 0;
        try {
            BufferedReader reader = new BufferedReader(new StringReader(this.currentBuffer));
            while ((str = reader.readLine()) != null) {
                if (++kount == this.currentBufferLine) {
                    str = str + trimString;
                }
                if (kount == 1) {
                    sb.append(str);
                    continue;
                }
                sb.append("\n" + str);
            }
            reader.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.currentBuffer = sb.toString();
    }

    public void bufferChange(String inString) {
        String invalidParms = "ERROR: Invalid CHANGE parameters, try: \n       C[HANGE] /orig_text/[new_text/]";
        if (this.currentBuffer.trim().length() == 0 || this.currentBufferLine == 0) {
            this.currentBuffer = "";
            this.currentBufferLine = 0;
            Util.println("ERROR: CHANGE must not be blank.", this);
            return;
        }
        String chgString = inString.trim();
        if (chgString.endsWith(this.sqlTerminator)) {
            chgString = chgString.substring(0, chgString.length() - 1);
        }
        if ((chgString = Util.rTrim(chgString, this) + "/").length() == 0) {
            Util.println(invalidParms, this);
            return;
        }
        if (!chgString.startsWith("/") || !chgString.endsWith("/") || chgString.length() <= 1) {
            Util.println(invalidParms, this);
            return;
        }
        chgString = chgString.substring(1, chgString.length() - 1);
        StringBuffer sbOrig = new StringBuffer("");
        StringBuffer sbNew = new StringBuffer("");
        StringBuffer sbChg = new StringBuffer(chgString);
        boolean seperatorFound = false;
        for (int i = 0; i < sbChg.length(); ++i) {
            if (sbChg.charAt(i) == '/') {
                if (seperatorFound) {
                    Util.println(invalidParms, this);
                    return;
                }
                seperatorFound = true;
                continue;
            }
            if (seperatorFound) {
                sbNew.append(sbChg.charAt(i));
                continue;
            }
            sbOrig.append(sbChg.charAt(i));
        }
        if (sbOrig.toString().length() == 0) {
            Util.println(invalidParms, this);
            return;
        }
        BufferedReader reader = null;
        String str = null;
        StringBuffer sb = new StringBuffer("");
        int kount = 0;
        try {
            reader = new BufferedReader(new StringReader(this.currentBuffer));
            while ((str = reader.readLine()) != null) {
                if (++kount == this.currentBufferLine) {
                    if (!str.contains(sbOrig.toString())) {
                        Util.println("ERROR: CHANGE variable not found.", this);
                        return;
                    }
                    String regExp = Util.escapeChars(sbOrig.toString(), "\\([{^$|)?*+.");
                    str = str.replaceFirst(regExp, sbNew.toString());
                    String linePrompt = Util.padLeft(kount + "* ", ' ', this.sqlPrompt.length());
                    Util.println(linePrompt + str, this);
                }
                if (kount == 1) {
                    sb.append(str);
                    continue;
                }
                sb.append("\n" + str);
            }
            reader.close();
            this.currentBuffer = sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void bufferClear() {
        this.currentBuffer = "";
        this.currentBufferLine = 0;
    }

    public void bufferDelete(String inString) {
        String invalidParms = "ERROR: Invalid DEL parameters, try: \n       DEL [fromLine] [toLine]";
        String delString = Util.rTrim(inString, this);
        if (this.currentBuffer.trim().length() == 0 || this.currentBufferLine == 0) {
            this.currentBuffer = "";
            this.currentBufferLine = 0;
            Util.println("ERROR: DELETE lines must not be blank.", this);
            return;
        }
        BufferedReader reader = null;
        String str = null;
        StringBuffer sb = new StringBuffer("");
        int totalRowKount = 0;
        try {
            reader = new BufferedReader(new StringReader(this.currentBuffer));
            while ((str = reader.readLine()) != null) {
                ++totalRowKount;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int startLine = 0;
        int endLine = 0;
        if (delString.length() == 0) {
            startLine = this.currentBufferLine;
            endLine = this.currentBufferLine;
        } else {
            String[] tokens = Util.tokenSplitter(delString, this);
            if (tokens.length >= 1) {
                if (tokens[0].equals("*")) {
                    tokens[0] = this.currentBufferLine + "";
                }
                if ("last".startsWith(tokens[0].toLowerCase())) {
                    tokens[0] = totalRowKount + "";
                }
            }
            if (tokens.length == 1) {
                try {
                    endLine = startLine = Integer.parseInt(tokens[0].trim());
                }
                catch (Exception e) {
                    Util.println("ERROR: Invalid numeric parameter.", this);
                    return;
                }
            } else if (tokens.length == 2) {
                if (tokens[1].equals("*")) {
                    tokens[1] = this.currentBufferLine + "";
                }
                if ("last".startsWith(tokens[1].toLowerCase())) {
                    tokens[1] = totalRowKount + "";
                }
                try {
                    startLine = Integer.parseInt(tokens[0].trim());
                    endLine = Integer.parseInt(tokens[1].trim());
                }
                catch (Exception e) {
                    Util.println("ERROR: Invalid numeric parameter.", this);
                    return;
                }
            } else {
                Util.println(invalidParms, this);
                return;
            }
        }
        if (startLine < 1 || endLine > totalRowKount) {
            Util.println("ERROR: Invalid line number range.", this);
            return;
        }
        int deletedLines = 0;
        int kount = 0;
        try {
            reader = new BufferedReader(new StringReader(this.currentBuffer));
            while ((str = reader.readLine()) != null) {
                if (++kount >= startLine && kount <= endLine) {
                    ++deletedLines;
                    continue;
                }
                sb.append(str + "\n");
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.currentBuffer = sb.toString().endsWith("\n") ? sb.toString().substring(0, sb.length() - 1) : sb.toString();
        this.currentBufferLine = kount - deletedLines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bufferList(String inString) {
        String invalidParms = "ERROR: Invalid LIST parameters, try: \n       LIST [fromLine] [toLine]";
        if (this.currentBuffer.length() == 0) {
            Util.println("ERROR: SQL Buffer is blank.", this);
            return;
        }
        String bufParms = Util.rTrim(inString, this);
        String str = null;
        BufferedReader reader = null;
        int kount = 0;
        try {
            reader = new BufferedReader(new StringReader(this.currentBuffer));
            while ((str = reader.readLine()) != null) {
                ++kount;
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int bufferTotalRows = kount;
        int startLine = 0;
        int endLine = 0;
        if (bufParms.length() == 0) {
            startLine = 1;
            endLine = bufferTotalRows;
        } else {
            String[] tokens = Util.tokenSplitter(bufParms, this);
            if (tokens.length >= 1) {
                if (tokens[0].equals("*")) {
                    tokens[0] = this.currentBufferLine + "";
                }
                if ("last".startsWith(tokens[0].toLowerCase())) {
                    tokens[0] = bufferTotalRows + "";
                }
            }
            if (tokens.length == 1) {
                try {
                    endLine = startLine = Integer.parseInt(tokens[0].trim());
                }
                catch (Exception e) {
                    Util.println("ERROR: Invalid numeric parameter.", this);
                    return;
                }
            } else if (tokens.length == 2) {
                if (tokens[1].equals("*")) {
                    tokens[1] = this.currentBufferLine + "";
                }
                if ("last".startsWith(tokens[1].toLowerCase())) {
                    tokens[1] = bufferTotalRows + "";
                }
                try {
                    startLine = Integer.parseInt(tokens[0].trim());
                    endLine = Integer.parseInt(tokens[1].trim());
                }
                catch (Exception e) {
                    Util.println("ERROR: Invalid numeric parameter.", this);
                    return;
                }
            } else {
                Util.println(invalidParms, this);
                return;
            }
        }
        if ((startLine < 1 || endLine > kount) && endLine != 32000) {
            Util.println("ERROR: Invalid line number range.", this);
            return;
        }
        try {
            String linePrompt = null;
            kount = 0;
            reader = new BufferedReader(new StringReader(this.currentBuffer));
            while ((str = reader.readLine()) != null) {
                if (++kount < startLine) continue;
                if (kount >= endLine || kount >= bufferTotalRows) {
                    linePrompt = Util.padLeft(kount + "* ", ' ', this.sqlPrompt.length());
                    Util.println(linePrompt + str, this);
                    this.currentBufferLine = kount;
                    break;
                }
                linePrompt = Util.padLeft(kount + "  ", ' ', this.sqlPrompt.length());
                Util.println(linePrompt + str, this);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean bufferSave(String inString) {
        String invalidSave = "ERROR: Invalid SAVE command, try: \n    filename [CRE[ATE] | REP[LACE] | APP[END]";
        if (this.currentBuffer.length() == 0) {
            Util.println("ERROR: Nothing to save.", this);
            return false;
        }
        String fileStr = Util.rTrim(inString, this);
        String[] tokens = Util.tokenSplitter(fileStr, this);
        if (tokens.length < 1 || tokens.length > 2) {
            Util.println(invalidSave, this);
            return false;
        }
        String fileName = this.appendFileSuffix(Util.rTrim(tokens[0], this));
        String mode = null;
        if (tokens.length == 1) {
            mode = "CREATE";
        }
        if (tokens.length == 2) {
            mode = tokens[1].toUpperCase();
            if ("CREATE".startsWith(mode) && mode.startsWith("CRE")) {
                mode = "CREATE";
            } else if ("REPLACE".startsWith(mode) && mode.startsWith("REP")) {
                mode = "REPLACE";
            } else if ("APPEND".startsWith(mode) && mode.startsWith("APP")) {
                mode = "APPEND";
            } else {
                Util.println(invalidSave, this);
                return false;
            }
        }
        if (mode.equals("CREATE") && new File(fileName).exists()) {
            Util.println("ERROR: File \"" + fileName + "\" already exists.", this);
            return false;
        }
        try {
            FileWriter fstream = null;
            fstream = mode.equals("APPEND") ? new FileWriter(fileName, true) : new FileWriter(fileName, false);
            BufferedWriter out = new BufferedWriter(fstream);
            String str = null;
            BufferedReader in = new BufferedReader(new StringReader(this.currentBuffer));
            while ((str = in.readLine()) != null) {
                out.write(str + System.getProperty("line.separator"));
            }
            if (this.currentBuffer == null || !this.currentBuffer.trim().endsWith("\n/")) {
                out.write("/" + System.getProperty("line.separator"));
            }
            out.close();
            in.close();
            Util.println("File \"" + new File(fileName).getName() + "\" written.", this);
        }
        catch (IOException e) {
            Util.println("ERROR: Unable to write file \"" + fileName + "\".", this);
            return false;
        }
        return true;
    }

    public void bufferInput(String inString) {
        String inputStr = Util.rTrim(inString, this);
        if (inputStr.trim().length() == 0) {
            return;
        }
        inputStr = inputStr.trim();
        if (this.currentBuffer.trim().length() == 0) {
            this.currentBuffer = inputStr;
            this.currentBufferLine = 1;
            return;
        }
        String str = null;
        BufferedReader reader = null;
        StringBuffer sb = new StringBuffer("");
        int kount = 0;
        try {
            reader = new BufferedReader(new StringReader(this.currentBuffer));
            while ((str = reader.readLine()) != null) {
                if (++kount == 1) {
                    sb.append(str);
                } else {
                    sb.append("\n" + str);
                }
                if (kount != this.currentBufferLine) continue;
                ++kount;
                sb.append("\n" + inputStr);
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.currentBuffer = sb.toString();
        this.currentBufferLine = kount;
    }

    public void bufferGet(String getString) {
        String invalidGet = "ERROR: Invalid GET command, try: \n    GET filename [LIS[T] | NOL[IST]]";
        String[] tokens = Util.tokenSplitter(getString, this);
        if (tokens.length != 1 && tokens.length != 2) {
            Util.println(invalidGet, this);
            return;
        }
        String fileName = this.appendFileSuffix(tokens[0]);
        String lister = "LIST";
        if (tokens.length == 2) {
            if ("list".startsWith(tokens[1]) && tokens[1].startsWith("lis")) {
                lister = "LIST";
            } else if ("nolist".startsWith(tokens[1]) && tokens[1].startsWith("nol")) {
                lister = "NOLIST";
            } else {
                Util.println(invalidGet, this);
                return;
            }
        }
        String str = null;
        StringBuffer sb = new StringBuffer("");
        this.currentBufferLine = 0;
        try {
            BufferedReader in = new BufferedReader(new FileReader(fileName));
            while ((str = in.readLine()) != null) {
                if (Util.rTrim(str, this).length() == 0) continue;
                ++this.currentBufferLine;
                if (this.currentBufferLine != 1) {
                    sb.append("\n");
                }
                sb.append(str);
            }
            in.close();
        }
        catch (IOException e) {
            Util.println("ERROR: Unable to GET \"" + fileName + "\".", this);
            return;
        }
        this.currentBuffer = sb.toString();
        if (lister.equals("LIST")) {
            this.bufferList("");
        }
    }

    public String appendFileSuffix(String fileName) {
        String fileNameEnd = fileName;
        if (fileName.length() > 4) {
            fileNameEnd = fileName.substring(fileName.length() - 4, fileName.length());
        }
        if (!fileNameEnd.contains(".")) {
            return fileName + this.suffix;
        }
        return fileName;
    }

    public void editFile(String inFileName) {
        String myEditor = System.getenv("EDITOR");
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            if (myEditor == null) {
                myEditor = "notepad";
            }
        } else if (osName.startsWith("Linux") || osName.startsWith("SunOS") || osName.startsWith("HP-UX")) {
            if (myEditor == null) {
                myEditor = "xterm -e vi";
            }
        } else {
            Util.println("ERROR: Operating system '" + osName + "' not yet supported.", this);
            return;
        }
        String editFile = inFileName.trim();
        boolean isSaved = true;
        boolean autoBuffer = false;
        if (editFile.length() == 0) {
            editFile = System.getProperty("user.home") + File.separator + ".polardb" + File.separator + "polarplus";
            File file = new File(editFile = Util.escapeChars(editFile, "\\"));
            if (!file.exists()) {
                file.mkdirs();
            }
            editFile = osName.startsWith("Windows") ? editFile + "\\\\afiedt.buf" : editFile + "/afiedt.buf";
            isSaved = this.bufferSave("\"" + editFile + "\" REPLACE");
            if (!isSaved) {
                return;
            }
            autoBuffer = true;
        }
        if (!new File(editFile).getName().contains(".")) {
            editFile = editFile + ".sql";
        }
        if (osName.startsWith("HP-UX")) {
            this.editFileInHPUX(myEditor, editFile);
        } else {
            HostExec.hostExec(myEditor + " " + editFile, this);
        }
        if (autoBuffer) {
            String str = null;
            StringBuffer sb = new StringBuffer("");
            this.currentBuffer = "";
            this.currentBufferLine = 0;
            try {
                BufferedReader in = new BufferedReader(new FileReader(editFile));
                while ((str = in.readLine()) != null) {
                    ++this.currentBufferLine;
                    if (this.currentBufferLine != 1) {
                        sb.append("\n");
                    }
                    sb.append(str);
                }
                in.close();
                if (sb.toString().trim().endsWith("\n/")) {
                    this.currentBuffer = Util.rTrim(sb.toString(), this);
                    --this.currentBufferLine;
                } else {
                    this.currentBuffer = sb.toString();
                }
                Util.println(" ", this);
                this.bufferList("");
            }
            catch (IOException e) {
                Util.println("ERROR: Unable to read in \"" + editFile + "\".", this);
            }
        }
    }

    private void editFileInHPUX(String editor, String inFileNae) {
        LinuxNative.launchEditor(editor, inFileNae);
    }

    public SQLErrorEvent getSqlErrorEvent() {
        return this.sqlErrorEvent;
    }

    public void setSqlErrorEvent(SQLErrorEvent sqlErrorEvent) {
        this.sqlErrorEvent = sqlErrorEvent;
    }
}

