/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb;

import com.aliyun.polardb.Settings;
import com.aliyun.polardb.Util;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class DBCredentials {
    private String defaultHost;
    private String defaultPort;
    private String defaultDB;
    private String user = null;
    private String password = null;
    private String host = null;
    private String port = null;
    private String db = null;
    private String urlOptions = null;
    private Settings s = null;

    public DBCredentials(String defaultHost, String defaultPort, String defaultDB, Settings s) {
        this.defaultHost = defaultHost;
        this.defaultPort = defaultPort;
        this.defaultDB = defaultDB;
        this.s = s;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processInput(String strConnect) {
        String userVarValue;
        String regex = "([^/@:]+)(/([^@:/]+))?(@(([^:/]+)|\\[(?:[0-9A-Fa-f]{0,4})(?=.*:[0-9A-Fa-f]{1,4}){1}(?::[0-9A-Fa-f]{0,4}){2,7}\\])(:([0-9]+))?(/([^\\?]+))?(\\?.+)?)?";
        String userVarRegex = "([^:/]+)(:([0-9]+))?(/(.*))?";
        String invalidConnectMsg = "ERROR: Connect string must be of form:" + System.getProperty("line.separator") + "user[/password][@user-variable | [@host[:port][/db]] ]";
        strConnect = Util.rTrim(strConnect, this.s);
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(strConnect);
        if (!m.matches()) throw new RuntimeException(invalidConnectMsg);
        if (m.group(1) != null) {
            this.user = m.group(1);
        }
        if (m.group(3) != null) {
            this.password = m.group(3);
        }
        if (m.group(5) != null) {
            this.host = m.group(5);
        }
        if (m.group(8) != null) {
            this.port = m.group(8);
        }
        if (m.group(10) != null) {
            this.db = m.group(10);
        }
        if (m.group(11) != null) {
            this.urlOptions = m.group(11);
        }
        if (this.port != null || this.db != null || this.host == null || (userVarValue = this.s.getVariable(this.host)) == null || userVarValue.length() <= 0) return;
        p = Pattern.compile(userVarRegex);
        m = p.matcher(userVarValue);
        if (m.matches()) {
            this.host = m.group(1);
            this.port = m.group(3);
            this.db = m.group(5);
            return;
        } else {
            Util.println("ERROR:  user-variable \"" + this.host + "\" not of the form \"host:port/db\"", this.s);
            throw new RuntimeException(invalidConnectMsg);
        }
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword(int tryCount) throws SQLException, ClassNotFoundException {
        if (this.password == null) {
            block8: {
                if (this.user != null && this.host != null && this.port != null && this.db != null) {
                    this.password = Util.authenticateViaPGPass(this.host, this.db, this.user, this.port);
                }
                if (this.password == null) {
                    try {
                        this.s.getDBHandler().createConnection(this.host, this.port, this.db, this.user, "", "");
                        return null;
                    }
                    catch (SQLException sqle) {
                        String sqlState = sqle.getSQLState();
                        String sqlMsg = sqle.getMessage();
                        boolean pwd_error = false;
                        if (sqlState != null && sqlState.contains("28P01")) {
                            pwd_error = true;
                        }
                        if (sqlMsg != null && sqlMsg.contains("Password authentication failed for user")) {
                            pwd_error = true;
                        }
                        if (pwd_error) break block8;
                        throw sqle;
                    }
                }
            }
            if (this.password == null) {
                this.password = Util.getMaskedInputLine("Enter Password:", this.s);
            }
        }
        return this.password;
    }

    public String getHost() {
        if (this.host == null) {
            this.host = this.defaultHost;
        }
        return this.host;
    }

    public String getPort() {
        if (this.port == null) {
            this.port = this.defaultPort;
        }
        return this.port;
    }

    public String getDb() {
        if (this.db == null) {
            this.db = this.defaultDB;
        }
        return this.db;
    }

    public String getUrlOptions() {
        return this.urlOptions;
    }
}

