/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb;

public class Column {
    public String colName = "";
    public String colLabel = "";
    public int colType = 0;
    public String colTypeName = "";
    public int colSize = 0;
    public int colNullable = 0;
    public boolean colSigned = false;
    public int colPrecision = 0;
    public int colScale = 0;
    public String onOff = "";
    public String formatString = "";
    public String headSep = "";
    public boolean isHeading = false;
    public int headRows = 1;
    public String wrapString = "";
    public String wrapper = "";
    public String text = "";

    public Column() {
    }

    public Column(String text, int colSize, String wrapped) {
        this.text = text;
        this.colSize = colSize;
        this.wrapper = wrapped;
    }

    protected String getLine(int index) {
        if (!this.hasLine(index)) {
            return "";
        }
        String[] lines = this.text.split("\n");
        if (this.wrapper.length() == 0 || this.wrapper.equals("TRUNCATED")) {
            if (index >= lines.length) {
                return "";
            }
            if (this.colSize >= lines[index].length()) {
                return lines[index];
            }
            return lines[index].substring(0, this.colSize);
        }
        int lineNum = 0;
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].length() == 0) {
                if (lineNum == index) {
                    return lines[i];
                }
                ++lineNum;
                continue;
            }
            for (int j = 0; j < lines[i].length(); j += this.colSize) {
                if (lineNum == index) {
                    if (lines[i].length() - j > this.colSize) {
                        return lines[i].substring(j, j + this.colSize);
                    }
                    return lines[i].substring(j);
                }
                ++lineNum;
            }
        }
        return "";
    }

    protected boolean hasLine(int currentIndex) {
        if (currentIndex == 0) {
            return true;
        }
        if (this.wrapper.length() == 0 || this.wrapper.equals("TRUNCATED")) {
            String[] lines = this.text.split("\n");
            return lines.length > currentIndex;
        }
        String[] lines = this.text.split("\n");
        int lineNum = 0;
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].length() > 0) {
                lineNum += lines[i].length() / this.colSize + (lines[i].length() % this.colSize == 0 ? 0 : 1);
                continue;
            }
            ++lineNum;
        }
        return lineNum > currentIndex;
    }

    protected Column clone() {
        Column c = new Column();
        c.colName = this.colName;
        c.colLabel = this.colLabel;
        c.colType = this.colType;
        c.colTypeName = this.colTypeName;
        c.colSize = this.colSize;
        c.colNullable = this.colNullable;
        c.colSigned = this.colSigned;
        c.colPrecision = this.colPrecision;
        c.colScale = this.colScale;
        c.onOff = this.onOff;
        c.formatString = this.formatString;
        c.headSep = this.headSep;
        c.isHeading = this.isHeading;
        c.headRows = this.headRows;
        c.wrapString = this.wrapString;
        c.wrapper = this.wrapper;
        c.text = this.text;
        return c;
    }

    public String toString() {
        String myColumn = "COLUMN   " + this.colName + "  " + this.onOff;
        if (this.isHeading) {
            myColumn = myColumn + "\nHEADING  '" + this.colLabel + "'";
            if (this.headSep.length() > 0 && this.colLabel.contains(this.headSep)) {
                myColumn = myColumn + "  headsep '" + this.headSep + "'";
            }
        }
        if (this.formatString.length() > 0) {
            myColumn = myColumn + "\nFORMAT   " + this.formatString;
        }
        myColumn = myColumn + "\n" + this.wrapper.toLowerCase();
        return myColumn;
    }
}

