#!/bin/bash

export base="/home/postgres/PolarPlus/polarplus/dist"
export CLASSPATH=$base/polarplus.jar:$base/lib/polardb-jdbc18.jar:$base/lib/jline-2.13.jar

export POLARPLUS_HELP=$base/help

if [ -f /etc/os-release ];
then
	IS_UBUNTU=`cat /etc/os-release | grep Ubuntu`

	if [ -n "$IS_UBUNTU" ];
	then
		export TERM=xterm-color
	fi
fi

. $base/etc/sysconfig/polarplus-CORE_POLARPLUS_VERSION.config
. $base/etc/sysconfig/runJavaApplication.sh

# On solaris, we need to override which command
if [ `uname -s` = "SunOS" ] ; then
	which() {
		ksh whence $*
	}
fi

# On HP-UX, we need to override which command with type
if [ `uname -s` = "HP-UX" ] ; then
        which() {
                type $*
        }
fi

# Check if EDITOR variable is set otherwise, export variable properly
if [ -z "$EDITOR" ]
then
    for f in kwrite gedit kate
    do
        which $f >/dev/null 2>&1
        if [ $? -eq 0 ]
        then
            export EDITOR=$f
	    break
        fi
    done
fi

if [ -z "$EDITOR" ]
then
        if [ `uname -s` = "HP-UX" ] ; then
                export EDITOR=vi
        fi
fi

runJREApplication -Djava.library.path=$base -jar $base/polarplus.jar $@
returnCode="$?"
exit $returnCode
