/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb.db;

import com.aliyun.polardb.Column;
import com.aliyun.polardb.CommandStatusListener;
import com.aliyun.polardb.PGConnection;
import com.aliyun.polardb.PGNotification;
import com.aliyun.polardb.PrintUtils;
import com.aliyun.polardb.Settings;
import com.aliyun.polardb.Util;
import com.aliyun.polardb.core.BaseStatement;
import com.aliyun.polardb.db.DBHandler;
import com.aliyun.polardb.db.DBUtils;
import com.aliyun.polardb.exception.InternalException;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;

public class PolarDBHandler
extends DBHandler {
    public static final String DEFAULT_PRODUCT_NAME = "PolarDB";
    public static final String MINIMUM_SUPPORTED_DB_VERSION = "1.1.1";
    public static final String DEFAULT_DB_PORT = "55444";
    public static final String DEFAULT_DB_NAME = "postgres";
    private ArrayList<String> statusMessages = new ArrayList();
    private Statement commonStmt2 = null;

    public PolarDBHandler() {
        this.productName = DEFAULT_PRODUCT_NAME;
    }

    @Override
    public Connection createConnection(String host, String port, String dbName, String userName, String password, String urlOptions) throws ClassNotFoundException, SQLException {
        Class.forName("com.aliyun.polardb.Driver");
        Properties props = new Properties();
        props.setProperty("user", userName);
        props.setProperty("password", password);
        props.setProperty("allowEncodingChanges", "true");
        props.setProperty("allowDateStyleChanges", "true");
        if (urlOptions != null && urlOptions.contains("ssl=true")) {
            String sslCertPass;
            String sslKeyPass;
            String trustStoreType;
            String[] urlOptionsArray;
            for (String urlOption : urlOptionsArray = urlOptions.split("&")) {
                String[] sslKeyValue;
                if (urlOption.contains("sslcert")) {
                    String[] sslCertValue = urlOption.split("=");
                    if (sslCertValue.length != 2) continue;
                    System.setProperty("javax.net.ssl.trustStore", sslCertValue[1].trim());
                    continue;
                }
                if (!urlOption.contains("sslkey") || (sslKeyValue = urlOption.split("=")).length != 2) continue;
                System.setProperty("javax.net.ssl.keyStore", sslKeyValue[1].trim());
            }
            String trustStore = System.getProperty("javax.net.ssl.trustStore");
            String keyStore = System.getProperty("javax.net.ssl.keyStore");
            if ((trustStore == null || trustStore.isEmpty()) && System.getenv("PGSSLCERT") != null) {
                System.setProperty("javax.net.ssl.trustStore", System.getenv("PGSSLCERT"));
            }
            if ((keyStore == null || keyStore.isEmpty()) && System.getenv("PGSSLKEY") != null) {
                System.setProperty("javax.net.ssl.keyStore", System.getenv("PGSSLKEY"));
            }
            props.setProperty("sslfactory", "com.aliyun.polardb.ssl.PolarPSSLSocketFactory");
            String homeDirectory = System.getProperty("user.home");
            String keyStoreType = System.getProperty("javax.net.ssl.keyStoreType");
            if (keyStoreType == null || keyStoreType.isEmpty()) {
                System.setProperty("javax.net.ssl.keyStoreType", "pkcs12");
            }
            if ((trustStoreType = System.getProperty("javax.net.ssl.trustStoreType")) == null || trustStoreType.isEmpty()) {
                System.setProperty("javax.net.ssl.trustStoreType", "jks");
            }
            if ((sslKeyPass = System.getenv("PGSSLKEYPASS")) != null) {
                System.setProperty("javax.net.ssl.keyStorePassword", sslKeyPass);
            }
            if ((sslCertPass = System.getenv("PGSSLCERTPASS")) != null) {
                System.setProperty("javax.net.ssl.trustStorePassword", System.getenv("PGSSLCERTPASS"));
            }
            if ((trustStore = System.getProperty("javax.net.ssl.trustStore")) == null || trustStore.isEmpty()) {
                String clientkeyStorePath = homeDirectory + "/.postgresql/postgresql.jks";
                File clientKeyStoreFile = new File(clientkeyStorePath);
                if (!clientKeyStoreFile.exists()) {
                    clientkeyStorePath = clientkeyStorePath.replace(".jks", ".keystore");
                }
                System.setProperty("javax.net.ssl.trustStore", clientkeyStorePath);
            }
            if ((keyStore = System.getProperty("javax.net.ssl.keyStore")) == null || keyStore.isEmpty()) {
                System.setProperty("javax.net.ssl.keyStore", homeDirectory + "/.postgresql/postgresql.p12");
            }
        }
        this.conn = DriverManager.getConnection("jdbc:polardb://" + host + ":" + port + "/" + dbName + (urlOptions != null ? urlOptions : "") + "?preferQueryMode=simple", props);
        this.productName = this.conn.getMetaData().getDatabaseProductName();
        this.dbVersion = this.conn.getMetaData().getDatabaseProductVersion();
        this.commonStmt2 = this.conn.createStatement();
        this.commonStmt2.execute("SELECT pg_catalog.set_config(name, 'ON', 'f') FROM pg_catalog.pg_settings WHERE name = 'polar_comp_stmt_level_tx';");
        this.commonStmt = this.createStatement();
        return this.conn;
    }

    @Override
    public Statement createStatement() throws SQLException {
        Statement stmt = this.conn.createStatement();
        ((BaseStatement)stmt).addCommandStatusListener(new CommandStatusListener(){
            boolean sawCommit = true;

            @Override
            public void commandStatus(String cmdStatus) {
                if (PolarDBHandler.this.statusMessages == null) {
                    PolarDBHandler.this.statusMessages = new ArrayList();
                }
                if (cmdStatus.equalsIgnoreCase("BEGIN") && this.sawCommit) {
                    this.sawCommit = false;
                    return;
                }
                if (cmdStatus.equalsIgnoreCase("COMMIT")) {
                    this.sawCommit = true;
                }
                PolarDBHandler.this.statusMessages.add(cmdStatus);
            }
        });
        return stmt;
    }

    @Override
    public void execute(String[] sqlTokens, boolean isCodeBlock, String sql) throws SQLException {
        this.statusMessages.clear();
        if (sqlTokens[0].trim().equals("create") || sqlTokens[0].trim().equalsIgnoreCase("$__EDBwrapped__$") || isCodeBlock) {
            try {
                Class klass = PolarDBHandler.getStatementClass();
                Method m = this.commonStmt.getClass().asSubclass(klass).getMethod("execute", String.class);
                m.invoke((Object)this.commonStmt, sql);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException ex) {
                throw new SQLException(ex.getMessage());
            }
            catch (InvocationTargetException ex) {
                if (ex.getCause() != null) {
                    if (ex.getCause() instanceof SQLException) {
                        throw (SQLException)ex.getCause();
                    }
                    throw new SQLException(ex.getCause());
                }
                throw new SQLException(ex);
            }
        } else {
            this.commonStmt.execute(sql);
        }
    }

    @Override
    public void execute(String[] sqlTokens, String sql) throws SQLException {
        this.execute(sqlTokens, false, sql);
    }

    @Override
    public boolean isSelect(String[] sqlTokens) {
        boolean isSelect = false;
        if (this.statusMessages.size() > 0) {
            isSelect = this.statusMessages.get(this.statusMessages.size() - 1).toLowerCase().matches("(select)|(select\\s+.*)");
        }
        if (sqlTokens[0].equals("create")) {
            isSelect = false;
        }
        return isSelect;
    }

    @Override
    public void printNotifications(Settings s) throws SQLException {
        PGNotification[] notifications = ((PGConnection)((Object)this.conn)).getNotifications();
        if (notifications != null) {
            for (int i = 0; i < notifications.length; ++i) {
                Util.println("Asynchronous notification \"" + notifications[i].getName() + "\" received from server process with PID " + notifications[i].getPID() + ".", s);
            }
        }
    }

    @Override
    public void handleCommandComplete(String[] sqlTokens, Settings s) throws SQLException {
        int updateCount = this.commonStmt.getUpdateCount();
        if (sqlTokens[0].trim().equalsIgnoreCase("$__EDBwrapped__$")) {
            updateCount = -1;
        }
        for (int i = 0; i < this.statusMessages.size(); ++i) {
            String currentMessage = this.statusMessages.get(i);
            if (currentMessage.equalsIgnoreCase("begin")) continue;
            if (currentMessage.toLowerCase().matches("(select)|(select\\s+.*)") && sqlTokens[0].equals("create")) {
                currentMessage = "";
                for (int index = 0; !(index >= sqlTokens.length || index + 1 < sqlTokens.length && sqlTokens[index + 1].equals("as")); ++index) {
                    currentMessage = currentMessage + sqlTokens[index] + " ";
                }
                currentMessage = currentMessage.trim();
            }
            sqlTokens = currentMessage.trim().toLowerCase().split("\\s");
            String msgDescription = "";
            if (sqlTokens[0].equals("edb-spl")) {
                msgDescription = currentMessage + ".";
            } else {
                msgDescription = "\n";
                if (sqlTokens.length == 1) {
                    msgDescription = msgDescription + sqlTokens[0].toUpperCase() + " completed.";
                } else {
                    for (int j = 1; j < sqlTokens.length; ++j) {
                        if (j > 1) {
                            msgDescription = msgDescription + " ";
                        }
                        msgDescription = msgDescription + sqlTokens[j].substring(0, 1).toUpperCase() + sqlTokens[j].substring(1, sqlTokens[j].length());
                    }
                    msgDescription = msgDescription + " " + sqlTokens[0];
                    if (sqlTokens[0].equals("drop")) {
                        msgDescription = msgDescription + "p";
                    }
                    if (!msgDescription.endsWith("e")) {
                        msgDescription = msgDescription + "e";
                    }
                    msgDescription = msgDescription + "d.";
                }
            }
            msgDescription = msgDescription + "\n";
            if (!sqlTokens[0].equals("begin") && !sqlTokens[0].equals("declare") || !s.feedback.equals("ON")) {
                if (sqlTokens[0].equals("commit")) {
                    this.stmtDmlCounter = 0;
                    if (s.feedback.equals("ON")) {
                        Util.println("\nCOMMIT completed.\n", s);
                    }
                } else if (sqlTokens[0].equals("rollback")) {
                    this.stmtDmlCounter = 0;
                    if (s.feedback.equals("ON")) {
                        Util.println("\nROLLBACK completed.\n", s);
                    }
                } else if (sqlTokens[0].equals("insert") && s.feedback.equals("ON")) {
                    if (updateCount < 0) {
                        Util.println("\nINSERT completed.\n", s);
                    } else if (updateCount == 1) {
                        Util.println("\n1 row INSERTED.\n", s);
                    } else {
                        Util.println("\n" + updateCount + " rows INSERTED.\n", s);
                    }
                } else if (sqlTokens[0].equals("update") && s.feedback.equals("ON")) {
                    if (updateCount < 0) {
                        Util.println("\nUPDATE completed.\n", s);
                    } else if (updateCount == 1) {
                        Util.println("\n1 row UPDATED.\n", s);
                    } else {
                        Util.println("\n" + updateCount + " rows UPDATED.\n", s);
                    }
                } else if (sqlTokens[0].equals("delete") && s.feedback.equals("ON")) {
                    if (updateCount < 0) {
                        Util.println("\nDELETE completed.\n", s);
                    } else if (updateCount == 1) {
                        Util.println("\n1 row DELETED.\n", s);
                    } else {
                        Util.println("\n" + updateCount + " rows DELETED.\n", s);
                    }
                } else if ((sqlTokens[0].equals("create") || sqlTokens[0].equals("drop") || sqlTokens[0].equals("truncate")) && s.feedback.equals("ON")) {
                    Util.println(msgDescription, s);
                } else if (!sqlTokens[0].equals("select") && !sqlTokens[0].equals("declare") && !sqlTokens[0].equals("begin") && s.feedback.equals("ON")) {
                    Util.println(msgDescription, s);
                }
            }
            if (sqlTokens[0].equals("insert") || sqlTokens[0].equals("update") || sqlTokens[0].equals("delete")) {
                ++this.stmtDmlCounter;
                if (this.stmtDmlCounter >= s.autocommitRows && s.autocommit.equals("ON")) {
                    this.stmtDmlCounter = 0;
                    if (s.feedback.equals("ON")) {
                        this.commonStmt.execute("commit");
                    } else {
                        this.silentCommit();
                    }
                }
            }
            if (!sqlTokens[0].equals("drop") && !sqlTokens[0].equals("create") && !sqlTokens[0].equals("truncate") && !sqlTokens[0].equals("alter") && !sqlTokens[0].equals("grant") && !sqlTokens[0].equals("comment") && !sqlTokens[0].equals("revoke")) continue;
            this.silentCommit();
        }
    }

    @Override
    public String getSupportedVersion() {
        return MINIMUM_SUPPORTED_DB_VERSION;
    }

    @Override
    public void describeObject(String arg, Settings s) {
        if (!s.isConnectedDB) {
            Util.println("Not connected", s);
            return;
        }
        String sDesc = arg;
        String mySchema = null;
        String myObject = null;
        String invalidDescribe = "ERROR: Describe string must be of the form:  [schema.]object \n   where object can be a table, view, package, procedure, or function.";
        sDesc = Util.rTrim(sDesc, s);
        sDesc = sDesc.trim();
        String[] tokens = DBUtils.split(sDesc, new char[]{'.', ' '}, '\"', false);
        for (int i = 0; tokens != null && i < tokens.length; ++i) {
            if (!tokens[i].startsWith("'")) continue;
            Util.println("ERROR: Illegal Identifier.", s);
            return;
        }
        if (tokens == null || tokens.length == 0 || tokens.length > 2) {
            Util.println(invalidDescribe, s);
            return;
        }
        if (tokens.length == 1) {
            myObject = tokens[0];
        } else {
            mySchema = tokens[0];
            myObject = tokens[1];
        }
        boolean isObjectCaseSensitive = false;
        boolean isSchemaCaseSensitive = false;
        String[] synObj = this.getSynonymObject(Util.rTrim(DBUtils.escapeSingleQuotes(tokens[0]), s));
        if (synObj != null && synObj.length == 2) {
            isObjectCaseSensitive = true;
            isSchemaCaseSensitive = true;
            mySchema = synObj[0];
            myObject = synObj[1];
        }
        arg = DBUtils.removeEscapeChar(arg, '\"');
        if (mySchema != null) {
            mySchema = DBUtils.escapeSingleQuotes(mySchema);
        }
        if ((myObject = DBUtils.escapeSingleQuotes(myObject)) != null && myObject.startsWith("\"")) {
            isObjectCaseSensitive = true;
            myObject = DBUtils.removeEscapeChar(myObject, '\"');
        }
        if (mySchema != null && mySchema.startsWith("\"")) {
            isSchemaCaseSensitive = true;
            mySchema = DBUtils.removeEscapeChar(mySchema, '\"');
        }
        int returnKount = this.describeTablesAndViews(mySchema, myObject, isSchemaCaseSensitive, isObjectCaseSensitive, s);
        if ((returnKount += this.describeProceduralLogic(mySchema, myObject, isSchemaCaseSensitive, isObjectCaseSensitive, s)) == -1) {
            Util.println("ERROR: Object " + Util.rTrim(sDesc.trim(), s) + " not found.\n", s);
        } else {
            Util.println(" ", s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int describeTablesAndViews(String schema, String myObject, boolean isSchemaCaseSensitive, boolean isObjectCaseSensitive, Settings s) {
        boolean found = false;
        String mySchema = schema;
        String[] searchPath = this.getSearchPath(s);
        int index = 0;
        while (!found && index < searchPath.length) {
            if (schema == null) {
                mySchema = DBUtils.escapeSingleQuotes(searchPath[index]);
            } else {
                found = true;
            }
            ++index;
            String userObjectSQL = "SELECT distinct \n       table_schema as schemaname, \n       table_name   as object_name, \n       is_updatable \n  FROM information_schema.columns \n";
            userObjectSQL = isObjectCaseSensitive ? userObjectSQL + " WHERE table_name = '" + myObject + "'" : userObjectSQL + " WHERE UPPER(table_name) = '" + myObject.toUpperCase() + "'";
            String relationSql = "SELECT  relname FROM pg_class rel WHERE ((relkind = 'r') OR (relkind = 's') OR (relkind = 'v')) ";
            relationSql = isObjectCaseSensitive ? relationSql + "AND relname='" + myObject + "' " : relationSql + "AND UPPER(relname)='" + myObject.toUpperCase() + "' ";
            if (mySchema != null && mySchema.length() > 0) {
                if (isSchemaCaseSensitive) {
                    userObjectSQL = userObjectSQL + "\n   AND table_schema = '" + mySchema + "'";
                    relationSql = relationSql + "\n AND relnamespace = (select oid from pg_namespace where nspname = '" + mySchema + "' and nspparent=0)";
                } else {
                    userObjectSQL = userObjectSQL + "\n   AND UPPER(table_schema) = '" + mySchema.toUpperCase() + "'";
                    relationSql = relationSql + "\n AND relnamespace = (select oid from pg_namespace where UPPER(nspname) = '" + mySchema.toUpperCase() + "' and nspparent=0)";
                }
            }
            try {
                if (!this.commonStmt2.executeQuery(relationSql).next()) continue;
                found = true;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            String currentFeedbackState = s.feedback;
            s.feedback = "OFF";
            int kounter = 0;
            Statement stmt3 = null;
            ResultSet rs3 = null;
            ResultSet rs2 = null;
            try {
                stmt3 = this.conn.createStatement();
                this.commonStmt2.execute(userObjectSQL);
                rs2 = this.commonStmt2.getResultSet();
                while (rs2.next()) {
                    ++kounter;
                    String schemaName = rs2.getString(1);
                    String objectName = rs2.getString(2);
                    Util.println(" ", s);
                    StringBuffer sb = new StringBuffer();
                    sb = this.getDescribeSQL(DBUtils.escapeSingleQuotes(schemaName), DBUtils.escapeSingleQuotes(objectName), true, true);
                    stmt3.execute(sb.toString());
                    rs3 = stmt3.getResultSet();
                    int typeLength = 12;
                    int nameLength = 18;
                    if (s.lineSize >= 42) {
                        typeLength = (s.lineSize - 11) * 40 / 100;
                        nameLength = s.lineSize - typeLength - 11;
                    }
                    if (rs3.next()) {
                        PrintUtils.printRow(new Column[]{new Column("Name", nameLength, ""), new Column("Null?", 8, ""), new Column("Data Type", typeLength, "")}, s, " ");
                        Util.println("", s);
                        PrintUtils.printRow(new Column[]{new Column(Util.padRight("", '-', nameLength), nameLength, ""), new Column(Util.padRight("", '-', 8), 8, ""), new Column(Util.padRight("", '-', typeLength), typeLength, "")}, s, " ");
                        Util.println("", s);
                        do {
                            String precision;
                            String dataLength;
                            String columnName = rs3.getString(1).toUpperCase();
                            String isNullable = rs3.getString(2);
                            isNullable = isNullable.equals("NO") ? "NOT NULL " : "         ";
                            String dataType = rs3.getString(3);
                            dataType = dataType.replaceAll("NUMERIC", "NUMBER");
                            dataType = dataType.replaceAll("CHARACTER VARYING", "VARCHAR2");
                            dataType = dataType.replaceAll("CHARACTER", "CHAR");
                            dataType = dataType.replaceAll("BYTEA", "BLOB");
                            dataType = dataType.replaceAll("TEXT", "CLOB");
                            dataType = dataType.replaceAll("BPCHAR", "CHAR(1)");
                            dataType = dataType.replaceAll("INT2", "SMALLINT");
                            dataType = dataType.replaceAll("INT8", "BIGINT");
                            if ((dataType = dataType.replaceAll("INT4", "INTEGER")).startsWith("_")) {
                                dataType = dataType.substring(1) + "[]";
                            }
                            if ((dataType.equals("VARCHAR2") || dataType.equals("CHAR")) && (dataLength = rs3.getString(4)) != null) {
                                dataType = dataType + "(" + dataLength + ")";
                            }
                            if (dataType.equals("NUMBER")) {
                                String scale;
                                precision = rs3.getString(5);
                                if (precision == null) {
                                    precision = "38";
                                }
                                if ((scale = rs3.getString(6)) == null) {
                                    scale = "0";
                                }
                                dataType = dataType + "(" + precision;
                                dataType = scale.equals("0") ? dataType + ")" : dataType + "," + scale + ")";
                            }
                            if (dataType.startsWith("TIMESTAMP")) {
                                precision = rs3.getString(7);
                                dataType = precision == null ? "DATE" : (precision.trim().equals("0") ? "DATE" : (dataType.equals("TIMESTAMP WITH TIME ZONE") ? "TIMESTAMP(" + precision.trim() + ") WITH TIME ZONE" : "TIMESTAMP(" + precision.trim() + ")"));
                            }
                            PrintUtils.printRow(new Column[]{new Column(columnName, nameLength, "WRAPPED"), new Column(isNullable, 8, ""), new Column(dataType, typeLength, "")}, s, " ");
                            Util.println("", s);
                        } while (rs3.next());
                    }
                    rs3.close();
                }
            }
            catch (SQLException se) {
                System.out.println(se.getMessage());
                System.out.println("ERROR: Unexpected SQL Error.");
                this.implicitRollback();
            }
            finally {
                s.feedback = currentFeedbackState;
                if (kounter == 0) {
                    Util.println("\nNo column found in table or view \"" + myObject + "\"", s);
                }
                try {
                    if (rs3 != null) {
                        rs3.close();
                    }
                    if (stmt3 != null) {
                        stmt3.close();
                    }
                    if (rs2 != null) {
                        rs2.close();
                    }
                }
                catch (SQLException sQLException) {}
                return kounter;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getSearchPath(Settings s) {
        String[] paths = null;
        ResultSet rs = null;
        try {
            rs = this.commonStmt2.executeQuery("show search_path");
            if (rs.next()) {
                String path = rs.getString(1);
                rs.close();
                boolean inSingleQuotes = false;
                boolean inDoubleQuotes = false;
                ArrayList<String> ar = new ArrayList<String>();
                String token = "";
                char[] cArray = path.toCharArray();
                for (int i = 0; i < cArray.length; ++i) {
                    if (cArray[i] == '\'' && !inDoubleQuotes) {
                        inSingleQuotes = !inSingleQuotes;
                    } else if (cArray[i] == '\"' && !inSingleQuotes) {
                        boolean bl = inDoubleQuotes = !inDoubleQuotes;
                    }
                    if (cArray[i] == ',' && !inSingleQuotes && !inDoubleQuotes) {
                        token = DBUtils.removeEscapeChar(token.trim(), '\'');
                        if ((token = DBUtils.removeEscapeChar(token, '\"')).equalsIgnoreCase("$user")) {
                            token = s.userDB;
                        }
                        ar.add(token);
                        token = "";
                        continue;
                    }
                    token = token + cArray[i];
                }
                if (token.trim().length() > 0) {
                    token = DBUtils.removeEscapeChar(token.trim(), '\'');
                    if ((token = DBUtils.removeEscapeChar(token, '\"')).equalsIgnoreCase("$user")) {
                        token = s.userDB;
                    }
                    ar.add(token);
                }
                ar.add("pg_catalog");
                ar.add("sys");
                ar.add("dbo");
                paths = ar.toArray(new String[0]);
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            paths = new String[]{"public"};
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getSynonymObject(String synName) {
        String[] obj = null;
        Statement stm = null;
        ResultSet rs = null;
        boolean isCaseSensitive = false;
        if (synName.startsWith("\"") && synName.endsWith("\"")) {
            synName = DBUtils.removeEscapeChar(synName, '\"');
            isCaseSensitive = true;
        }
        try {
            stm = this.conn.createStatement();
            String query = "SELECT SYNOBJSCHEMA, SYNOBJNAME FROM PG_CATALOG.PG_SYNONYM ";
            query = isCaseSensitive ? query + "WHERE SYNNAME='" + synName + "'" : query + "WHERE UPPER(SYNNAME)='" + synName.toUpperCase() + "'";
            rs = stm.executeQuery(query);
            if (rs.next()) {
                obj = new String[]{rs.getString(1), rs.getString(2)};
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int describeProceduralLogic(String schemaName, String myObject, boolean isSchemaCaseSensitive, boolean isObjectCaseSensitive, Settings s) {
        boolean found = false;
        String mySchema = schemaName;
        String[] searchPath = this.getSearchPath(s);
        int index = 0;
        int kounter = 0;
        while (!found && index < searchPath.length) {
            if (schemaName == null) {
                mySchema = DBUtils.escapeSingleQuotes(searchPath[index]);
            } else {
                found = true;
            }
            ++index;
            String userObjectSQL = "SELECT routine_schema AS schema, ' ' AS pkg, routine_name, case WHEN UPPER(data_type)='ARRAY' then UPPER(TYPE_UDT_NAME) ELSE UPPER(data_type) END as data_type \n  FROM information_schema.routines \n WHERE routine_schema NOT IN ( 'pg_catalog', 'information_schema', 'sys') \n   AND ((data_type is null AND routine_type = 'PROCEDURE') OR data_type <> '\"trigger\"')  \n   AND routine_schema not in (select pkgname from pg_catalog.edb_package) \n";
            userObjectSQL = isObjectCaseSensitive ? userObjectSQL + "   AND routine_name = '" + myObject + "' \n" : userObjectSQL + "   AND UPPER(routine_name) = '" + myObject.toUpperCase() + "' \n";
            if (mySchema != null && mySchema.length() > 0) {
                userObjectSQL = isSchemaCaseSensitive ? userObjectSQL + "   AND routine_schema = '" + mySchema + "' \n" : userObjectSQL + "   AND UPPER(routine_schema) = '" + mySchema.toUpperCase() + "' \n";
            }
            userObjectSQL = userObjectSQL + "UNION \nSELECT n.nspname AS schema, routine_schema as pkg, routine_name, case WHEN UPPER(data_type)='ARRAY' then UPPER(TYPE_UDT_NAME) ELSE UPPER(data_type) END as data_type \n  FROM information_schema.routines r, pg_catalog.edb_package p,  \n       pg_catalog.pg_namespace n \n WHERE r.routine_schema = p.pkgname \n   AND p.pkgnamespace = n.oid \n   AND n.nspparent = 0 \n";
            userObjectSQL = isObjectCaseSensitive ? userObjectSQL + "   AND routine_schema = '" + myObject + "' \n" : userObjectSQL + "   AND UPPER(routine_schema) = '" + myObject.toUpperCase() + "' \n";
            if (mySchema != null && mySchema.length() > 0) {
                userObjectSQL = isSchemaCaseSensitive ? userObjectSQL + "   AND n.nspname = '" + mySchema + "' \n" : userObjectSQL + "   AND UPPER(n.nspname) = '" + mySchema.toUpperCase() + "' \n";
            }
            userObjectSQL = userObjectSQL + "ORDER BY 1, 2, 3";
            String currentFeedbackState = s.feedback;
            s.feedback = "OFF";
            ResultSet rs2 = null;
            try {
                this.commonStmt2.execute(userObjectSQL);
                rs2 = this.commonStmt2.getResultSet();
                while (rs2.next()) {
                    ++kounter;
                    String schema = rs2.getString(1);
                    String pkg = rs2.getString(2);
                    String routine = rs2.getString(3);
                    String dataType = rs2.getString(4);
                    if (dataType != null) {
                        dataType = dataType.toUpperCase();
                    }
                    String qualifier = schema;
                    if (pkg.trim().length() > 0) {
                        qualifier = pkg;
                    }
                    Util.println("", s);
                    if (dataType == null || dataType.equals("VOID")) {
                        Util.println("PROCEDURE " + routine.toUpperCase(), s);
                    } else {
                        dataType = dataType.replaceAll("TIMESTAMP WITHOUT TIME ZONE", "TIMESTAMP");
                        dataType = dataType.replaceAll("NUMERIC", "NUMBER");
                        dataType = dataType.replaceAll("CHARACTER VARYING", "VARCHAR2");
                        dataType = dataType.replaceAll("CHARACTER", "CHAR");
                        dataType = dataType.replaceAll("BYTEA", "BLOB");
                        dataType = dataType.replaceAll("TEXT", "CLOB");
                        dataType = dataType.replaceAll("BPCHAR", "CHAR(1)");
                        dataType = dataType.replaceAll("INT2", "SMALLINT");
                        dataType = dataType.replaceAll("INT8", "BIGINT");
                        if ((dataType = dataType.replaceAll("INT4", "INTEGER")).startsWith("_")) {
                            dataType = dataType.substring(1) + "[]";
                        }
                        Util.println("FUNCTION " + routine.toUpperCase() + " RETURNS " + dataType, s);
                    }
                    if (pkg.trim().length() > 0) {
                        this.showParameters(DBUtils.escapeSingleQuotes(qualifier), DBUtils.escapeSingleQuotes(routine), schema, s);
                        continue;
                    }
                    this.showParameters(DBUtils.escapeSingleQuotes(qualifier), DBUtils.escapeSingleQuotes(routine), null, s);
                }
            }
            catch (SQLException se) {
                this.implicitRollback();
                System.out.println(se.getMessage());
                System.out.println("ERROR: Unexpected SQL Error.");
            }
            finally {
                s.feedback = currentFeedbackState;
                try {
                    if (rs2 == null) continue;
                    rs2.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return kounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDefaultValue(String defValExpr) {
        if (defValExpr == null || defValExpr.equals("-") || defValExpr.trim().equals("{NONDEFVALNODE}")) {
            return "";
        }
        String sql = "select pg_get_expr('" + defValExpr + "', (select oid from pg_class where relname='pg_proc'))";
        String defVal = "";
        Statement stm = null;
        ResultSet rs = null;
        try {
            stm = this.conn.createStatement();
            rs = stm.executeQuery(sql);
            if (rs.next()) {
                defVal = rs.getString(1);
            }
        }
        catch (SQLException sqle) {
            System.err.println("Error: " + sqle.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return defVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showParameters(String specificSchema, String specificName, String packageSchema, Settings s) {
        block24: {
            boolean is84 = false;
            try {
                is84 = DBUtils.isPolarDB84OrGreater(this.conn);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String colName = "proargdefvals";
            if (is84) {
                colName = "NULL";
            }
            String sqlParms = "SELECT DISTINCT parameter_name, \n       case WHEN UPPER(data_type)='ARRAY' then UPPER(UDT_NAME) ELSE UPPER(data_type) END as data_type, parameter_mode, " + colName + ", proc.oid as pro_oid \n  FROM information_schema.parameters, pg_proc proc \n WHERE specific_schema = '" + specificSchema + "' \n   AND specific_name = '" + specificName + "_'||proc.oid \n   AND proc.proname='" + specificName + "'  \n   AND proc.pronamespace=       (select oid from pg_namespace where nspname='" + specificSchema + "'       AND nspparent=" + (packageSchema == null ? "0" : "(select oid from pg_namespace where nspname='" + packageSchema + "')") + "       )  \nORDER BY 1";
            int typeLength = 23;
            int nameLength = 30;
            if (s.lineSize > 71) {
                typeLength = (s.lineSize - 14) * 43 / 100;
                nameLength = s.lineSize - typeLength - 14;
            }
            Statement stmt3 = null;
            ResultSet rs3 = null;
            try {
                stmt3 = this.conn.createStatement();
                stmt3.execute(sqlParms);
                rs3 = stmt3.getResultSet();
                int colCount = -1;
                if (!rs3.next()) break block24;
                try {
                    PrintUtils.printRow(new Column[]{new Column("Argument Name", nameLength, ""), new Column("Type", typeLength, ""), new Column("In/Out", 6, ""), new Column("Default?", 8, "")}, s, " ");
                    Util.println("", s);
                    PrintUtils.printRow(new Column[]{new Column(Util.padRight("", '-', nameLength), nameLength, ""), new Column(Util.padRight("", '-', typeLength), typeLength, ""), new Column(Util.padRight("", '-', 6), 6, ""), new Column(Util.padRight("", '-', 8), 8, "")}, s, " ");
                    Util.println("", s);
                }
                catch (InternalException internalException) {
                    // empty catch block
                }
                do {
                    String[] defvals = null;
                    defvals = !is84 ? (rs3.getArray(4) == null ? null : (String[])rs3.getArray(4).getArray()) : this.getDefaultValuesFor84(rs3.getString("pro_oid"));
                    String isDefault = "";
                    if (defvals != null && defvals.length > ++colCount) {
                        isDefault = is84 ? (defvals[colCount].length() > 0 && !"-".equals(defvals[colCount]) ? "DEFAULT" : "") : (this.getDefaultValue(defvals[colCount]).length() > 0 ? "DEFAULT" : "");
                    }
                    String parameterName = rs3.getString(1).toUpperCase();
                    String dataType = rs3.getString(2).toUpperCase();
                    dataType = dataType.replaceAll("TIMESTAMP WITHOUT TIME ZONE", "TIMESTAMP");
                    dataType = dataType.replaceAll("NUMERIC", "NUMBER");
                    dataType = dataType.replaceAll("CHARACTER VARYING", "VARCHAR2");
                    dataType = dataType.replaceAll("CHARACTER", "CHAR");
                    dataType = dataType.replaceAll("BYTEA", "BLOB");
                    dataType = dataType.replaceAll("TEXT", "CLOB");
                    dataType = dataType.replaceAll("BPCHAR", "CHAR(1)");
                    dataType = dataType.replaceAll("INT2", "SMALLINT");
                    dataType = dataType.replaceAll("INT8", "BIGINT");
                    if ((dataType = dataType.replaceAll("INT4", "INTEGER")).startsWith("_")) {
                        dataType = dataType.substring(1) + "[]";
                    }
                    String parameterMode = rs3.getString(3).toUpperCase();
                    parameterMode = parameterMode.replaceAll("INOUT", "IN/OUT");
                    try {
                        PrintUtils.printRow(new Column[]{new Column(parameterName, nameLength, "WRAPPED"), new Column(dataType, typeLength, ""), new Column(parameterMode, 6, ""), new Column(isDefault, 8, "")}, s, " ");
                        Util.println("", s);
                    }
                    catch (InternalException internalException) {
                        // empty catch block
                    }
                } while (rs3.next());
            }
            catch (SQLException se) {
                this.implicitRollback();
                System.out.println(se.getMessage());
                System.out.println("ERROR: Unexpected SQL Error.");
            }
            finally {
                try {
                    if (rs3 != null) {
                        rs3.close();
                    }
                    if (stmt3 != null) {
                        stmt3.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private String[] createStringArray(String csvValues) {
        String[] defArray = DBUtils.split(csvValues, new char[]{','}, '\'', false);
        for (int i = 0; i < defArray.length; ++i) {
            String item = defArray[i];
            if (item == null || !item.trim().equals("-")) continue;
            defArray[i] = "";
        }
        return defArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getDefaultValuesFor84(String oid) {
        String sql = "select pg_get_expr(proargdefaults, (select oid from pg_class where relname='pg_proc')), pronargs from pg_proc where oid=" + oid;
        Statement stmt = null;
        Object[] strParams = null;
        try {
            stmt = this.conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                String strDefExpr = rs.getString(1);
                if (strDefExpr != null && strDefExpr.trim().length() > 0) {
                    strParams = this.createStringArray(rs.getString(1));
                }
                int count = rs.getInt(2);
                if (strParams != null && strParams.length < count) {
                    int offset;
                    Object[] newArray = new String[count];
                    Arrays.fill(newArray, "");
                    for (int i = offset = count - strParams.length; i < count; ++i) {
                        newArray[i] = strParams[i - offset];
                    }
                    strParams = newArray;
                }
            }
        }
        catch (SQLException exp) {
            System.err.println("WARNING: Internal error. " + exp.getMessage());
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception exception) {}
        }
        return strParams;
    }

    private StringBuffer getDescribeSQL(String schemaName, String objectName, boolean isSchemaCaseSensitive, boolean isObjectCaseSensitive) {
        StringBuffer sb = new StringBuffer("SELECT column_name, is_nullable, case WHEN UPPER(data_type)='ARRAY' OR UPPER(data_type)='USER-DEFINED' then UPPER(UDT_NAME) ELSE UPPER(data_type) END as data_type, character_maximum_length, \n       numeric_precision, numeric_scale, datetime_precision \n  FROM information_schema.columns \n");
        if (isSchemaCaseSensitive) {
            sb.append(" WHERE table_schema = '" + schemaName + "' \n");
        } else {
            sb.append(" WHERE UPPER(table_schema) = '" + schemaName.toUpperCase() + "' \n");
        }
        if (isObjectCaseSensitive) {
            sb.append("   AND table_name   = '" + objectName + "'");
        } else {
            sb.append("   AND UPPER(table_name)   = '" + objectName.toUpperCase() + "'");
        }
        sb.append(" ORDER BY ORDINAL_POSITION");
        return sb;
    }

    @Override
    public String getAlterUserSQL(String userName, String password) {
        return "ALTER USER " + userName + " WITH PASSWORD '" + password + "'";
    }

    @Override
    public String getServerVarSQL(String varName) {
        return "SELECT name, setting as value   FROM pg_settings  WHERE name like '%" + varName + "%'  ORDER BY 1 ";
    }

    @Override
    public void silentCommit() {
        try {
            this.conn.commit();
            this.stmtDmlCounter = 0;
            if (this.statusMessages.size() > 0) {
                this.statusMessages.remove(this.statusMessages.size() - 1);
            }
        }
        catch (SQLException sQLException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void implicitRollback() {
        String terse = this.getStmtLevelTX();
        if (!terse.equalsIgnoreCase("ON") && !terse.equalsIgnoreCase("TRUE")) {
            this.silentRollback();
        }
    }

    @Override
    public void silentRollback() {
        try {
            this.conn.rollback();
            this.stmtDmlCounter = 0;
            if (this.statusMessages.size() > 0) {
                this.statusMessages.remove(this.statusMessages.size() - 1);
            }
        }
        catch (SQLException sQLException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getDefaultDBPort() {
        return DEFAULT_DB_PORT;
    }

    @Override
    public String getDefaultDBName() {
        return DEFAULT_DB_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStmtLevelTX() {
        Statement st = null;
        String polar_comp_stmt_level_tx = "off";
        try {
            st = this.conn.createStatement();
            ResultSet rs = st.executeQuery("select setting from pg_settings where name='polar_comp_stmt_level_tx'");
            if (rs.next()) {
                polar_comp_stmt_level_tx = rs.getString(1);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return polar_comp_stmt_level_tx;
    }

    @Override
    public boolean isStandardConformingStrings() throws SQLException {
        String standardConformingStrings = this.readGUC("standard_conforming_strings");
        return standardConformingStrings != null && "on".equalsIgnoreCase(standardConformingStrings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readGUC(String gucName) throws SQLException {
        if (this.commonStmt == null) {
            return null;
        }
        try (ResultSet rs = null;){
            String query = "SHOW " + gucName + ";";
            rs = this.commonStmt.executeQuery(query);
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
            String string = null;
            return string;
        }
    }

    public static Class getStatementClass() throws ClassNotFoundException {
        return PolarDBHandler.findClass("com.aliyun.polardb.jdbc.PgStatement", "com.aliyun.polardb.jdbc2.AbstractJdbc2Statement");
    }

    public static Class findClass(String className1, String className2) throws ClassNotFoundException {
        Class<?> klass;
        try {
            klass = Class.forName(className1, false, PolarDBHandler.class.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            klass = Class.forName(className2, false, PolarDBHandler.class.getClassLoader());
        }
        return klass;
    }

    public void setFetchSize(Settings settings) {
        if (this.commonStmt != null && "OFF".equalsIgnoreCase(settings.autocommit)) {
            try {
                this.commonStmt.setFetchSize(1000);
            }
            catch (SQLException ex) {
                System.out.println("ERROR: Failed to set fetch size. Reason: " + ex.getMessage());
            }
        }
    }
}

