/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;

public class DBUtils {
    public static String[] split(String srcList, char[] separators, char escapeChar, boolean removeEscape) throws IllegalArgumentException {
        for (char sep : separators) {
            if (sep != escapeChar) continue;
            throw new IllegalArgumentException("Character '" + sep + "' and quotes character conflict");
        }
        ArrayList<String> list = new ArrayList<String>();
        char[] chars = srcList.toCharArray();
        boolean inQuotes = false;
        int lastDotIndex = -1;
        String token = "";
        Arrays.sort(separators);
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == escapeChar) {
                inQuotes = !inQuotes;
                continue;
            }
            if (Arrays.binarySearch(separators, chars[i]) < 0 || inQuotes) continue;
            if (removeEscape) {
                list.add(DBUtils.removeEscapeChar(srcList.substring(lastDotIndex + 1, i), escapeChar));
            } else {
                list.add(srcList.substring(lastDotIndex + 1, i));
            }
            lastDotIndex = i;
        }
        if (removeEscape) {
            list.add(DBUtils.removeEscapeChar(srcList.substring(lastDotIndex + 1), escapeChar));
        } else {
            list.add(srcList.substring(lastDotIndex + 1));
        }
        return list.toArray(new String[0]);
    }

    public static String removeEscapeChar(String source, char escapeChar) {
        if (source.startsWith("" + escapeChar) && source.endsWith("" + escapeChar)) {
            source = source.substring(1, source.length() - 1);
            StringBuffer sb = new StringBuffer();
            char[] chars = source.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                sb.append(chars[i]);
                if (i >= chars.length - 1 || chars[i] != escapeChar || chars[i + 1] != escapeChar) continue;
                ++i;
            }
            source = sb.toString();
        }
        return source;
    }

    public static String escapeSingleQuotes(String s) {
        StringBuffer sb = new StringBuffer();
        int length = s.length();
        int prevChar = 32;
        int prevPrevChar = 32;
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            sb.append(c);
            if (c == '\'') {
                sb.append('\'');
            }
            if (c == '\\') {
                sb.append('\\');
            }
            prevPrevChar = prevChar;
            prevChar = c;
        }
        return sb.toString();
    }

    public static boolean isPolarDB84OrGreater(Connection conn) throws SQLException {
        String productName = conn.getMetaData().getDatabaseProductName();
        float version = Float.parseFloat(conn.getMetaData().getDatabaseMajorVersion() + "." + conn.getMetaData().getDatabaseMinorVersion());
        return productName.toLowerCase().contains("polardb") && version >= 8.4f;
    }
}

