/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb;

import com.aliyun.polardb.Column;
import com.aliyun.polardb.Settings;
import com.aliyun.polardb.Util;
import com.aliyun.polardb.exception.InternalException;
import java.util.ArrayList;
import java.util.Vector;

public class PrintUtils {
    public static void printRow(Column[] columns, Settings s, String prefix) throws InternalException {
        PrintUtils.printRow(columns, s, prefix, " ");
    }

    public static int printRow(Column[] columns, Settings s, String prefix, String columnSep) throws InternalException {
        return PrintUtils.printRow(null, columns, s, prefix, columnSep, false, false, 0);
    }

    private static int printRow(Vector<Column> columnHeaders, Column[] columns, Settings s, String prefix, String columnSep, boolean printEmptyRowOnWrap, boolean honorPageSize, int lastRowNumber) throws InternalException {
        boolean hasMore = true;
        int currentRow = 0;
        int rows = 0;
        boolean broken = false;
        while (hasMore) {
            if (honorPageSize && columnHeaders != null && lastRowNumber + rows >= s.pageSize) {
                lastRowNumber = PrintUtils.checkPageSize(columnHeaders, s, lastRowNumber + rows);
                rows = 0;
            }
            ++rows;
            Util.print(prefix, s);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < columns.length; ++i) {
                Column col = columns[i];
                String field = col.getLine(currentRow);
                String trimedField = field.replaceAll("\\s+$", "");
                if (trimedField.length() > 0) {
                    Util.print(sb.toString(), s);
                    Util.print(trimedField, s);
                    sb = new StringBuilder();
                }
                sb.append(Util.padRight("", ' ', col.colSize - trimedField.length()));
                if (i >= columns.length - 1) continue;
                sb.append(columnSep);
            }
            if (!s.trims.equals("ON") || !s.spool.equals("ON")) {
                Util.print(sb.toString(), s);
            } else {
                String padding = sb.toString();
                if ((padding = padding.replaceAll("\\s+$", "")).length() > 0) {
                    Util.print(padding, s);
                }
            }
            if (!(hasMore = PrintUtils.hasMoreRows(columns, ++currentRow))) continue;
            Util.println("", s);
            broken = true;
        }
        if (printEmptyRowOnWrap && broken && rows + lastRowNumber < s.pageSize) {
            Util.println("", s);
            ++rows;
        }
        return rows + lastRowNumber;
    }

    public static int printRow(Column[] columns, Settings s, String prefix, String columnSep, int lineSize, int numRowsBeforeThis) throws InternalException {
        int length = prefix.length();
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                length += columnSep.length();
            }
            length += columns[i].colSize;
        }
        if (lineSize < prefix.length() + 1 || length <= lineSize) {
            return PrintUtils.printRow(PrintUtils.ArrayToVector(columns), columns, s, prefix, columnSep, true, true, numRowsBeforeThis);
        }
        int rowCount = numRowsBeforeThis;
        int lastColumn = -1;
        int columnStart = 0;
        boolean broken = false;
        int[] indexes = PrintUtils.getNextColumnRow(PrintUtils.ArrayToVector(columns), lastColumn, lineSize, columnSep.length(), columnStart);
        while (indexes.length > 0) {
            if (lastColumn != -1) {
                rowCount = PrintUtils.checkPageSize(columns, s, rowCount);
            }
            lastColumn = indexes[indexes.length - 1];
            Column[] cols = new Column[indexes.length];
            length = prefix.length();
            for (int i = 0; i < indexes.length; ++i) {
                cols[i] = columns[indexes[i]];
                if (i > 0) {
                    length += columnSep.length();
                }
                length += cols[i].colSize;
            }
            String nextVal = "";
            if (length > s.lineSize) {
                if (cols[cols.length - 1].wrapper.equals("TRUNCATED")) {
                    cols[cols.length - 1] = cols[cols.length - 1].clone();
                    cols[cols.length - 1].colSize -= length - s.lineSize;
                } else {
                    int truncateIndex;
                    String text = cols[cols.length - 1].text;
                    cols[cols.length - 1] = cols[cols.length - 1].clone();
                    cols[cols.length - 1].colSize -= length - s.lineSize;
                    cols[cols.length - 1].wrapper = "WRAPPED";
                    text = cols[cols.length - 1].colSigned ? Util.padLeft(text, ' ', truncateIndex) : Util.padRight(text, ' ', truncateIndex);
                    nextVal = text.substring(truncateIndex = cols[cols.length - 1].getLine(0).length());
                    if (nextVal.startsWith("\n")) {
                        nextVal = nextVal.substring(1);
                    }
                    cols[cols.length - 1].text = text.substring(0, truncateIndex);
                }
            }
            rowCount = PrintUtils.printRow(PrintUtils.ArrayToVector(columns), cols, s, prefix, columnSep, false, true, rowCount);
            indexes = PrintUtils.getNextColumnRow(PrintUtils.ArrayToVector(columns), lastColumn, lineSize, columnSep.length(), columnStart);
            boolean printedNext = false;
            if (nextVal.length() > 0) {
                Column c = cols[cols.length - 1];
                c.text = nextVal;
                if (c.colSize > s.lineSize) {
                    c.colSize = s.lineSize;
                }
                Util.println("", s);
                if (rowCount >= s.pageSize) {
                    rowCount = PrintUtils.checkPageSize(columns, s, rowCount);
                }
                rowCount = PrintUtils.printRow(new Column[]{c}, s, prefix, columnSep, s.lineSize, rowCount);
                printedNext = true;
                nextVal = "";
            }
            if (printedNext) {
                broken = true;
            }
            if (indexes.length <= 0) continue;
            Util.println("", s);
            broken = true;
        }
        if (broken && rowCount < s.pageSize) {
            Util.println("", s);
            ++rowCount;
        }
        return rowCount;
    }

    public static int getNumerOfRows(Column[] columns) {
        int numRows = 0;
        for (int i = 0; i < columns.length; ++i) {
            while (columns[i].hasLine(numRows)) {
                ++numRows;
            }
        }
        return numRows;
    }

    private static boolean hasMoreRows(Column[] columns, int currentIndex) {
        for (int i = 0; i < columns.length; ++i) {
            Column col = columns[i];
            if (!col.hasLine(currentIndex)) continue;
            return true;
        }
        return false;
    }

    public static int printColumnHeaders(Vector columns, Settings s) throws InternalException {
        return PrintUtils.printColumnHeaders(columns, s, true);
    }

    private static int printColumnHeaders(Vector columns, Settings s, boolean print) throws InternalException {
        int maxHeadRows = 0;
        int localRows = 0;
        String colLabelNext = "";
        int headKount = 0;
        if (s.heading.equals("ON")) {
            int[] indexes = null;
            int lastColumn = -1;
            int rowNum = -1;
            int currentIndex = 0;
            int columnStart = 0;
            do {
                int i;
                ++rowNum;
                indexes = PrintUtils.getNextColumnRow(columns, lastColumn, s.lineSize, s.colSep.length(), columnStart);
                if (indexes.length < 1) break;
                for (int i2 = 0; i2 < indexes.length; ++i2) {
                    Column c = (Column)columns.elementAt(indexes[i2]);
                    localRows = c.headSep.length() == 0 ? 1 : PrintUtils.characterKounter(c.colLabel, c.headSep.charAt(0)) + 1;
                    if (localRows <= maxHeadRows) continue;
                    maxHeadRows = localRows;
                }
                String[] header = new String[maxHeadRows];
                String underline = "";
                columnStart = 0;
                for (i = 0; i < maxHeadRows; ++i) {
                    header[i] = "";
                    for (int j = 0; j < indexes.length; ++j) {
                        int preferredSize;
                        Column c = (Column)columns.elementAt(indexes[j]);
                        currentIndex = header[i].length();
                        if (s.lineSize - currentIndex < (preferredSize = c.colSize)) {
                            if (c.colSigned) {
                                throw new InternalException("Line size is less than size of column (\"" + c.colName + "\").", 1);
                            }
                            preferredSize = s.lineSize - currentIndex;
                            for (columnStart = c.colSize - preferredSize; columnStart >= s.lineSize; columnStart -= s.lineSize) {
                            }
                        }
                        colLabelNext = PrintUtils.getColLabel(c, i + 1, maxHeadRows, preferredSize);
                        int n = i;
                        header[n] = header[n] + colLabelNext;
                        if (j < indexes.length - 1) {
                            int n2 = i;
                            header[n2] = header[n2] + s.colSep;
                        }
                        if (i != 0) continue;
                        underline = underline + Util.padRight("", '-', preferredSize);
                        if (j >= indexes.length - 1) continue;
                        underline = underline + s.colSep;
                    }
                }
                for (i = 0; i < header.length; ++i) {
                    if (header[i].trim().length() <= 0) continue;
                    if (print) {
                        Util.println(header[i], s);
                    }
                    ++headKount;
                }
                if (print) {
                    Util.println(underline, s);
                }
                ++headKount;
                if (indexes.length <= 0) continue;
                lastColumn = indexes[indexes.length - 1];
            } while (indexes != null && indexes.length > 0);
        }
        return headKount;
    }

    private static int[] getNextColumnRow(Vector columns, int lastColumn, int lineSize, int sepLength, int columnStart) {
        boolean done = false;
        ArrayList<Integer> al = new ArrayList<Integer>();
        int currentIndex = columnStart;
        for (int i = lastColumn + 1; i < columns.size() && !done; ++i) {
            Column c = (Column)columns.elementAt(i);
            if (i == lastColumn + 1) {
                al.add(new Integer(i));
                currentIndex = c.colSize + sepLength;
                continue;
            }
            if (c.colSize <= lineSize - currentIndex) {
                al.add(new Integer(i));
                currentIndex += c.colSize + sepLength;
                continue;
            }
            if (c.colSize > lineSize - currentIndex && c.colSize > lineSize && c.colSize <= 2 * lineSize - currentIndex && currentIndex < lineSize) {
                al.add(new Integer(i));
                done = true;
                continue;
            }
            done = true;
        }
        int[] retArr = new int[al.size()];
        for (int i = 0; i < retArr.length; ++i) {
            retArr[i] = (Integer)al.get(i);
        }
        return retArr;
    }

    private static int characterKounter(String inStr, char inChar) {
        StringBuffer sb = new StringBuffer(inStr);
        int kounter = 0;
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (c != inChar) continue;
            ++kounter;
        }
        return kounter;
    }

    private static String getColLabel(Column c, int rowKount, int maxRows, int allowedSize) {
        String returnLabel = "";
        returnLabel = c.headSep.length() == 0 ? (rowKount < maxRows ? Util.padRight("", ' ', allowedSize) : c.colLabel) : PrintUtils.parseLabel(c.colLabel, c.headSep.charAt(0), rowKount);
        if (returnLabel.length() > allowedSize) {
            returnLabel = returnLabel.substring(0, allowedSize);
        }
        returnLabel = c.colSigned ? Util.padLeft(returnLabel, ' ', allowedSize) : Util.padRight(returnLabel, ' ', allowedSize);
        return returnLabel;
    }

    private static String parseLabel(String srcStr, char headsep, int rowIndex) {
        String[] tokens = srcStr.split("[" + headsep + "]");
        if (rowIndex > tokens.length) {
            return "";
        }
        return tokens[rowIndex - 1].trim();
    }

    private static int checkPageSize(Vector columns, Settings s, int currentRow) throws InternalException {
        if (currentRow >= s.pageSize) {
            PrintUtils.printPreHeader(s);
            if (s.pageSize > PrintUtils.countHeaderRows(columns, s) + s.newPage) {
                return PrintUtils.printColumnHeaders(columns, s) + s.newPage;
            }
        }
        return currentRow;
    }

    private static int checkPageSize(Column[] columns, Settings s, int currentRow) throws InternalException {
        if (currentRow < s.pageSize) {
            return currentRow;
        }
        return PrintUtils.checkPageSize(PrintUtils.ArrayToVector(columns), s, currentRow);
    }

    private static Vector ArrayToVector(Object[] array) {
        Vector<Object> v = new Vector<Object>();
        for (int i = 0; i < array.length; ++i) {
            v.addElement(array[i]);
        }
        return v;
    }

    public static int countHeaderRows(Vector<Column> columns, Settings s) throws InternalException {
        if (s.heading.equals("ON")) {
            return PrintUtils.printColumnHeaders(columns, s, false);
        }
        return 0;
    }

    public static void printPreHeader(Settings s) {
        if (s.pause.equals("ON")) {
            s.pauseFunction(s.pauseText);
        }
        if (s.pageSize == 0) {
            return;
        }
        if (s.newPage == 0) {
            Util.print("\f", s);
        } else {
            for (int i = 0; i < s.newPage; ++i) {
                Util.println("", s);
            }
        }
    }
}

