/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb2.replication;

import com.aliyun.polardb2.core.BaseConnection;
import com.aliyun.polardb2.replication.PGReplicationConnection;
import com.aliyun.polardb2.replication.fluent.ChainedCreateReplicationSlotBuilder;
import com.aliyun.polardb2.replication.fluent.ChainedStreamBuilder;
import com.aliyun.polardb2.replication.fluent.ReplicationCreateSlotBuilder;
import com.aliyun.polardb2.replication.fluent.ReplicationStreamBuilder;
import java.sql.SQLException;
import java.sql.Statement;

public class PGReplicationConnectionImpl
implements PGReplicationConnection {
    private BaseConnection connection;

    public PGReplicationConnectionImpl(BaseConnection connection) {
        this.connection = connection;
    }

    @Override
    public ChainedStreamBuilder replicationStream() {
        return new ReplicationStreamBuilder(this.connection);
    }

    @Override
    public ChainedCreateReplicationSlotBuilder createReplicationSlot() {
        return new ReplicationCreateSlotBuilder(this.connection);
    }

    @Override
    public void dropReplicationSlot(String slotName) throws SQLException {
        if (slotName == null || slotName.isEmpty()) {
            throw new IllegalArgumentException("Replication slot name can't be null or empty");
        }
        try (Statement statement = this.connection.createStatement();){
            statement.execute("DROP_REPLICATION_SLOT " + slotName);
        }
    }
}

