/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb.util;

import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Enumeration;

public enum PolarCompMode {
    POLARDB("polardb", "jdbc:polardb:", "POLARDB Database Compatible with Oracle"),
    POLAR_V1("polardb1", "jdbc:polardb1:", "POLARDB Database Compatible with Oracle"),
    ORACLE_THIN("oracle", "jdbc:oracle:thin:", "Oracle"),
    ORACLE("oracle", "jdbc:oracle:", "Oracle");

    private String mode;
    private String prefix;
    private int prefixLen;
    private String productName;

    private PolarCompMode(String mode, String prefix, String productName) {
        this.mode = mode;
        this.prefix = prefix;
        this.prefixLen = prefix.length();
        this.productName = productName;
    }

    private static int compOraclePrefix() {
        String url_allow_oracle_prefix = System.getProperty("POLARDB.JDBC.url_allow_oracle_prefix");
        if (url_allow_oracle_prefix == null) {
            return 1;
        }
        if ((url_allow_oracle_prefix = url_allow_oracle_prefix.toLowerCase()).equals("off") || url_allow_oracle_prefix.equals("0") || url_allow_oracle_prefix.equals("false")) {
            return 0;
        }
        if (url_allow_oracle_prefix.equals("auto")) {
            return 2;
        }
        return 1;
    }

    public static PolarCompMode buildCompMode(String url) {
        PolarCompMode ret = null;
        if (url == null || url.isEmpty()) {
            return null;
        }
        for (PolarCompMode mode : PolarCompMode.values()) {
            if (!url.startsWith(mode.getPrefix())) continue;
            ret = mode;
            break;
        }
        if (ret != ORACLE && ret != ORACLE_THIN) {
            return ret;
        }
        switch (PolarCompMode.compOraclePrefix()) {
            case 0: {
                return null;
            }
            case 1: {
                return ret;
            }
            case 2: {
                Enumeration<Driver> drivers = DriverManager.getDrivers();
                while (drivers.hasMoreElements()) {
                    Driver driver = drivers.nextElement();
                    if (!driver.getClass().getName().toLowerCase().contains("oracle.jdbc")) continue;
                    return null;
                }
                return ret;
            }
        }
        throw new RuntimeException("Unexpected run path for compOraclePrefix");
    }

    public static PolarCompMode forName(String name) {
        for (PolarCompMode mode : PolarCompMode.values()) {
            if (!mode.getMode().equalsIgnoreCase(name)) continue;
            return mode;
        }
        return null;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int getPrefixLen() {
        return this.prefixLen;
    }

    public String getMode() {
        return this.mode;
    }

    public String getProductName() {
        return this.productName;
    }

    public static boolean checkUrlPrefix(String url) {
        if (url == null || url.isEmpty()) {
            return false;
        }
        PolarCompMode compMode = PolarCompMode.buildCompMode(url);
        return compMode != null;
    }
}

