#include <iostream>
#include <vector>
#include <fstream>
#include "mns/mns_client.h"

using namespace std;
using namespace mns::sdk;

void readConfig(string& endpoint, string& accessId, string& accessKey, string& stsToken)
{
    stsToken = "";
    ifstream is_file("aliyun-mns.properties");
    std::string line;
    while( std::getline(is_file, line) )
    {
        std::istringstream is_line(line);
        std::string key;
        if( std::getline(is_line, key, '=') )
        {
            std::string value;
            if( std::getline(is_line, value) )
            {
                if (key == "mns.accountendpoint")
                {
                    endpoint = value;
                }
                else if (key == "mns.accesskeyid")
                {
                    accessId = value;
                }
                else if (key == "mns.accesskeysecret")
                {
                    accessKey = value;
                }
                else if (key == "mns.ststoken")
                {
                    stsToken = value;
                }
            }
        }
    }
}

int main()
{
    string endpoint;
    string accessId;
    string accessKey;
    string stsToken;
    readConfig(endpoint, accessId, accessKey, stsToken);
    MNSClient mnsClient(endpoint, accessId, accessKey, stsToken);

    TopicPtr topicPtr;
    try
    {
        mnsClient.deleteTopic("TestCplusplusTopic");
        topicPtr = mnsClient.createTopic("TestCplusplusTopic");
        cout << "TopicName: " << topicPtr->getTopicName() << endl;
    }
    catch (MNSServerException& me)
    {
        cout << "CreateTopic Failed: " + me.GetErrorCode() << endl;
        // handle exception according to the errorcode
        return -1;
    }
    catch (MNSExceptionBase& mb)
    {
        cout << "CreateTopic Failed: " + mb.ToString() << endl;
        // log it and retry
        return -2;
    }

    try
    {
        mnsClient.createTopic("TestCplusplus1");
        mnsClient.createTopic("TestCplusplus2");
        mnsClient.createTopic("TestCplusplus3");
        mnsClient.createTopic("TestCplusplus4");
        mnsClient.createTopic("TestCplusplus5");
        vector<string> topicNames;
        string nextMarker;
        ListTopicRequest req("TestCplusplus", "", 2);
        mnsClient.listTopic(req, topicNames, nextMarker);
        for (int i = 0; i < topicNames.size(); ++i)
        {
            cout << topicNames[i] << endl;
        }
        cout << nextMarker << endl;
        mnsClient.deleteTopic("TestCplusplus1");
        mnsClient.deleteTopic("TestCplusplus2");
        mnsClient.deleteTopic("TestCplusplus3");
        mnsClient.deleteTopic("TestCplusplus4");
        mnsClient.deleteTopic("TestCplusplus5");

        topicPtr = mnsClient.getTopicRef("TestCplusplusTopic");

        TopicAttributes attributes;
        topicPtr->getAttributes(attributes);
        cout << "MaximumMessageSize: "
             << attributes.getMaximumMessageSize() << endl;

        attributes.setMaximumMessageSize(1024);
        topicPtr->setAttributes(attributes);

        topicPtr->getAttributes(attributes);
        cout << "After set, MaximumMessageSize: "
             << attributes.getMaximumMessageSize() << endl;

        // single message
        PublishMessageResponse pmResp;
        topicPtr->publishMessage("Test<HAHA>\"Messge", pmResp);
        cout << "PublishMessage Succeed!" << endl;

        SubscriptionAttributes sa;
        sa.setContentFormat(SIMPLIFIED);
        topicPtr->subscribe("SubscriptionName1", "http://127.0.0.1:8458", sa);
        cout << "SubscribeSucceed" << endl;

        topicPtr->getSubscriptionAttributes("SubscriptionName1", sa);
        cout << " ContentFormat: "
             << ContentFormatHelper::ContentFormatToString(sa.getContentFormat())
             << " NotifyStrategy: "
             << NotifyStrategyHelper::NotifyStrategyToString(sa.getNotifyStrategy())
             << " TopicName: "
             << sa.getTopicName() << endl;

        SubscriptionAttributes sa2;
        sa2.setNotifyStrategy(EXPONENTIAL_DECAY_RETRY);
        topicPtr->setSubscriptionAttributes("SubscriptionName1", sa2);

        cout << "After Setting the NotifyStrategy: " << endl;
        topicPtr->getSubscriptionAttributes("SubscriptionName1", sa);
        cout << " ContentFormat: "
             << ContentFormatHelper::ContentFormatToString(sa.getContentFormat())
             << " NotifyStrategy: "
             << NotifyStrategyHelper::NotifyStrategyToString(sa.getNotifyStrategy())
             << " TopicName: "
             << sa.getTopicName() << endl;

        topicPtr->publishMessage("Test<HAHA>\"Messge", pmResp);
        usleep(1000000);

        topicPtr->subscribe("SubscriptionName2", "http://127.0.0.1:8458", sa);
        topicPtr->subscribe("SubscriptionName3", "http://127.0.0.1:8458", sa);
        topicPtr->subscribe("SubscriptionName4", "http://127.0.0.1:8458", sa);
        topicPtr->subscribe("SubscriptionName5", "http://127.0.0.1:8458", sa);
        topicPtr->subscribe("SubscriptionName6", "http://127.0.0.1:8458", sa);
        std::vector<std::string> subscriptionNames;
        ListSubscriptionRequest lsReq("", "", 3);
        topicPtr->listSubscription(lsReq, subscriptionNames, nextMarker);
        cout << " Subscriptions: " << endl;
        for (int i = 0; i < subscriptionNames.size(); ++i)
        {
            cout << subscriptionNames[i] << endl;
        }
        cout << nextMarker << endl;
        topicPtr->unsubscribe("SubscriptionName2");
        topicPtr->unsubscribe("SubscriptionName3");
        topicPtr->unsubscribe("SubscriptionName4");
        topicPtr->unsubscribe("SubscriptionName5");

        topicPtr->unsubscribe("SubscriptionName1");

        subscriptionNames.clear();
        topicPtr->listSubscription("", subscriptionNames);
        cout << " After Unsubscribe, Subscriptions: " << endl;
        for (int i = 0; i < subscriptionNames.size(); ++i)
        {
            cout << subscriptionNames[i] << endl;
        }
        topicPtr->unsubscribe("SubscriptionName6");

        mnsClient.deleteTopic("TestCplusplusTopic");
        return 0;
    }
    catch (MNSServerException& me)
    {
        cout << "Request Failed: " + me.GetErrorCode() << endl;
        // handle exception according to the errorcode
        return -1;
    }
    catch (MNSExceptionBase& mb)
    {
        cout << "Request Failed: " + mb.ToString() << endl;
        // log it and retry
        return -2;
    }
}
