#include <iostream>
#include <vector>
#include <fstream>
#include "mns/mns_client.h"

using namespace std;
using namespace mns::sdk;

void readConfig(string& endpoint, string& accessId, string& accessKey)
{
    ifstream is_file("aliyun-mns.properties");
    std::string line;
    while( std::getline(is_file, line) )
    {
        std::istringstream is_line(line);
        std::string key;
        if( std::getline(is_line, key, '=') )
        {
            std::string value;
            if( std::getline(is_line, value) ) 
            {
                if (key == "mns.accountendpoint")
                {
                    endpoint = value;
                }
                else if (key == "mns.accesskeyid")
                {
                    accessId = value;
                }
                else if (key == "mns.accesskeysecret")
                {
                    accessKey = value;
                }
            }
        }
    }
}

int main()
{
    string endpoint;
    string accessId;
    string accessKey;
    readConfig(endpoint, accessId, accessKey);
    MNSClient mnsClient(endpoint, accessId, accessKey);

    QueuePtr queue;
    try
    {
        mnsClient.deleteQueue("TestCplusplusQ");
        queue = mnsClient.createQueue("TestCplusplusQ");
        cout << "QueueName: " << queue->getQueueName() << endl;
    }
    catch (MNSServerException& me)
    {
        cout << "CreateQueue Failed: " + me.GetErrorCode() << endl;
        // handle exception according to the errorcode
        return -1;
    }
    catch (MNSExceptionBase& mb)
    {
        cout << "CreateQueue Failed: " + mb.ToString() << endl;
        // log it and retry
        return -2;
    }

    try
    {
        mnsClient.deleteQueue("TestCplusplusQ");
        queue = mnsClient.createQueue("TestCplusplusQ");

        QueueAttributes attributes;
        queue->getAttributes(attributes);
        cout << "VisibilityTimeout: "
             << attributes.getVisibilityTimeout() << endl;

        attributes.setVisibilityTimeout(20);
        queue->setAttributes(attributes);

        // single message
        SendMessageResponse smResp;
        queue->sendMessage("Test<HAHA>\"Messge", smResp);
        Message message1;
        queue->peekMessage(message1);
        cout << "PeekMessage: " << message1.getMessageBody() << endl;

        Message message2;
        queue->receiveMessage(message2);
        cout << "ReceiveMessage: " << message2.getMessageBody() << endl;

        ChangeMessageVisibilityResponse cmvResp;
        queue->changeMessageVisibility(message2.getReceiptHandle(), 30, cmvResp);
        queue->deleteMessage(cmvResp.getReceiptHandle());
        cout << "Message Deleted!" << endl;

        // now batch
        std::vector<SendMessageItem> sendMessageItems;
        SendMessageItem item("Test<HAHA>\"MessgeBatch");
        sendMessageItems.push_back(item);
        sendMessageItems.push_back(item);

        BatchSendMessageResponse bsmResp;
        queue->batchSendMessage(sendMessageItems, bsmResp);
        const std::vector<SendMessageSucceedItem>& succeedItems =
            bsmResp.getSendMessageSucceedItems();
        for (typeof(succeedItems.begin()) iter = succeedItems.begin();
            iter != succeedItems.end(); ++iter)
        {
            cout << "BatchSendSucceedItem: " << iter->messageId << endl;
        }
        if (!bsmResp.isSuccess())
        {
            const std::vector<SendMessageFailedItem>& failedItems =
                bsmResp.getSendMessageFailedItems();
            for (typeof(failedItems.begin()) iter = failedItems.begin();
                iter != failedItems.end(); ++iter)
            {
                cout << "BatchSendFailedItem: " << iter->errorCode << endl;
            }
        }

        std::vector<Message> messages;
        queue->batchPeekMessage(5, messages);
        cout << "BatchPeeked " << messages.size() << " Messages!" << endl;
        for (typeof(messages.begin()) iter = messages.begin();
            iter != messages.end(); ++iter)
        {
            cout << "PeekdItem (MessageId: " << iter->getMessageId()
                 << "MessageBody: " << iter->getMessageBody() << ")" << endl;
        }

        messages.clear();
        queue->batchReceiveMessage(5, messages);
        cout << "BatchReceived " << messages.size() << " Messages!" << endl;

        std::vector<std::string> receiptHandles;
        for (typeof(messages.begin()) iter = messages.begin();
            iter != messages.end(); ++iter)
        {
            cout << "ReceivedItem (MessageId: " << iter->getMessageId()
                 << "MessageBody: " << iter->getMessageBody() << ")" << endl;
            receiptHandles.push_back(iter->getReceiptHandle());
        }

        BatchDeleteMessageResponse bdmResp;
        queue->batchDeleteMessage(receiptHandles, bdmResp);
        if (!bdmResp.isSuccess())
        {
            const std::vector<DeleteMessageFailedItem>& failedItems =
                bdmResp.getDeleteMessageFailedItem();
            for (typeof(failedItems.begin()) iter = failedItems.begin();
                iter != failedItems.end(); ++iter)
            {
                cout << "BatchDeleteFailedItem: " << iter->errorCode
                     << "  " << iter->receiptHandle << endl;
            }
        }
        cout << "BatchDeleted!" << endl;

        mnsClient.deleteQueue("TestCplusplusQ");
        return 0;
    }
    catch (MNSServerException& me)
    {
        cout << "Request Failed: " + me.GetErrorCode() << endl;
        // handle exception according to the errorcode
        return -1;
    }
    catch (MNSExceptionBase& mb)
    {
        cout << "Request Failed: " + mb.ToString() << endl;
        // log it and retry
        return -2;
    }
}
