import json
from flask import Flask, render_template
from alibabacloud_tea_openapi.models import Config
from alibabacloud_sts20150401.client import Client as Sts20150401Client
from alibabacloud_sts20150401 import models as sts_20150401_models
from alibabacloud_credentials.client import Client as CredentialClient

app = Flask(__name__)

# 将<your_role_arn>替换为拥有上传文件到指定OSS Bucket权限的RAM角色的ARN。
role_arn_for_oss_upload = '<your_role_arn>'
# 将<your_role_arn>设置为STS服务的地域，例如cn-hangzhou。
region_id = '<your_role_arn>'


@app.route("/")
def hello_world():
    return render_template('index.html')


@app.route('/get_sts_token_for_oss_upload', methods=['GET'])
def get_sts_token():
    # 初始化 CredentialClient 时不指定参数，代表使用默认凭据链。
    # 在本地运行程序时，可以通过环境变量 ALIBABA_CLOUD_ACCESS_KEY_ID、ALIBABA_CLOUD_ACCESS_KEY_SECRET 指定 AK；
    # 在 ECS\ECI\容器服务上运行时，可以通过环境变量 ALIBABA_CLOUD_ECS_METADATA 来指定绑定的实例\节点角色，SDK 会自动换取 STS 临时凭证。
    config = Config(region_id=region_id, credential=CredentialClient())
    sts_client = Sts20150401Client(config=config)
    assume_role_request = sts_20150401_models.AssumeRoleRequest(
        role_arn=role_arn_for_oss_upload,
        # 将<your_role_session_name>设置为自定义的会话名称，例如oss-role-session。
        role_session_name='<your_role_session_name>'
    )
    response = sts_client.assume_role(assume_role_request)
    token = json.dumps(response.body.credentials.to_map())
    return token


app.run(host="0.0.0.0", port=8000)