<?php
require_once 'vendor/autoload.php';
use AlibabaCloud\Client\AlibabaCloud;
use AlibabaCloud\Client\Exception\ClientException;
use AlibabaCloud\Client\Exception\ServerException;
use AlibabaCloud\Sts\Sts;
// 初始化Alibaba Cloud客户端。
AlibabaCloud::accessKeyClient(getenv('ALIBABA_CLOUD_ACCESS_KEY_ID'), getenv('ALIBABA_CLOUD_ACCESS_KEY_SECRET'))
    ->regionId('cn-hangzhou')
    ->asDefaultClient();
// 创建STS请求。
$request = Sts::v20150401()->assumeRole();
// 发起STS请求并获取结果。
// 将<your_role_session_name>设置为自定义的会话名称，例如oss-role-session。
// 将<your_role_arn>替换为拥有上传文件到指定OSS Bucket权限的RAM角色的ARN。
$result = $request
    ->withRoleSessionName("<your_role_session_name>")
    ->withDurationSeconds(3600)
    ->withRoleArn("<your_role_arn>")
    ->request();
// 获取STS请求结果中的凭证信息。
$credentials = $result->get('Credentials');
// 构建返回的JSON数据。
$response = [
    'AccessKeyId' => $credentials['AccessKeyId'],
    'AccessKeySecret' => $credentials['AccessKeySecret'],
    'SecurityToken' => $credentials['SecurityToken'],
];
// 设置响应头为application/json。
header('Content-Type: application/json');
// 将结果转换为JSON格式并打印。
echo json_encode(['Credentials' => $response]);
?>
