package com.aliyun.help.demo.uploading_to_oss_directly_sts.config;

import com.aliyun.sts20150401.Client;
import com.aliyun.teaopenapi.models.Config;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * StsClientConfiguration
 *
 * @author yang.liuy
 * @date 2023/10/24
 */
@Configuration
public class StsClientConfiguration {

    @Bean
    public Client stsClient() {
        // 当您在初始化凭据客户端不传入任何参数时，Credentials工具会使用默认凭据链方式初始化客户端。
        // 详情请参考：https://help.aliyun.com/zh/sdk/developer-reference/manage-access-credentials
        Config config = new Config();
        // Endpoint 请参考 https://api.aliyun.com/product/Sts
        config.endpoint = "sts.cn-hangzhou.aliyuncs.com";
        try {
            com.aliyun.credentials.Client credentials = new com.aliyun.credentials.Client();
            config.setCredential(credentials);
            return new Client(config);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}
