package com.aliyun.help.demo.uploading_to_oss_directly_presignedurl.config;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Bean;

import javax.annotation.PreDestroy;

/**
 * OssConfig
 *
 * @author yang.liuy
 * @date 2023/10/26
 */
@Configuration
public class OssConfig {

    /**
     * 将<your-endpoint>替换为OSS Endpoint，例如oss-cn-hangzhou.aliyuncs.com。
     */
    private static final String endpoint = "https://oss-cn-hangzhou.aliyuncs.com";

    /**
     * 通过环境变量 ALIBABA_CLOUD_ACCESS_KEY_ID 设置 accessKeyId
     */
    @Value("${ALIBABA_CLOUD_ACCESS_KEY_ID}")
    private String accessKeyId;

    /**
     * 通过环境变量 ALIBABA_CLOUD_ACCESS_KEY_Secret 设置 accessKeySecret
     */
    @Value("${ALIBABA_CLOUD_ACCESS_KEY_SECRET}")
    private String accessKeySecret;

    private OSS ossClient;


    @Bean
    public OSS getSssClient() {
        ossClient = new OSSClientBuilder().build(endpoint, accessKeyId, accessKeySecret);
        return ossClient;
    }

    @PreDestroy
    public void onDestroy() {
        ossClient.shutdown();
    }
}
