package event;

/**
 * <p>event subscriber</p>
 * <p>根据云监控事件名称分别实现该接口类</p>
 * <p>
 *    subscribedToEventType 返回云监控事件名称，用于区分不同类型的事件。
 *      不同类型事件可以参考：https://help.aliyun.com/document_detail/310993.html
 *      网卡事件定义：https://help.aliyun.com/document_detail/348845.html
 * </p>
 * <p>handleEvent 事件处理方法</p>
 *
 * @param <T>
 */
public interface EventSubscriber<T> {
    /**
     * 返回云监控事件名称，用于区分不同类型的事件。
     * @return
     */
    String subscribedToEventType();

    /**
     * 根据事件内容处理业务逻辑
     * @param event
     * @return
     */
    Boolean handleEvent(T event);
}
