package event;

/**
 * <p>网卡操作完成事件</p>
 * <p>定义了用于网卡操作完成通知的变量、属性、方法等</p>
 */
public class EniOperateCompletedEvent extends BaseEvent {
    private final String ENI_ID = "eniId";
    private final String ENI_STATUS = "eniStatus";
    private final String RESULT = "result";
    private final String OPERATION = "operation";
    private final String REQUEST_ID = "requestId";

    public EniOperateCompletedEvent(BaseEvent baseEvent) {
        super.setId(baseEvent.getId());
        super.setEventTime(baseEvent.getEventTime());
        super.setProduct(baseEvent.getProduct());
        super.setInstanceName(baseEvent.getInstanceName());
        super.setRegionId(baseEvent.getRegionId());
        super.setResourceId(baseEvent.getResourceId());
        super.setRuleName(baseEvent.getRuleName());
        super.setStatus(baseEvent.getStatus());
        super.setVer(baseEvent.getVer());
        super.setContent(baseEvent.getContent());
    }

    public static String getEventName() {
        return "NetworkInterface:NetworkInterfaceOperateCompleted";
    }

    public String getEniId() {
        return getFromContent(ENI_ID);
    }

    public String getEniStatus() {
        return getFromContent(ENI_STATUS);
    }

    public String getResult() {
        return getFromContent(RESULT);
    }

    public String getOperation() {
        return getFromContent(OPERATION);
    }

    public String getRequestId() {
        return getFromContent(REQUEST_ID);
    }

}