import java.util.UUID;

import com.aliyun.ecs20140526.Client;
import com.aliyun.ecs20140526.models.CreateNetworkInterfaceRequest;
import com.aliyun.ecs20140526.models.CreateNetworkInterfaceResponse;
import com.aliyun.tea.TeaException;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.models.RuntimeOptions;

public class CreateNetworkInterfaceExample {

    /**
     * 使用AK&SK初始化账号Client。
     *
     * 本示例通过从环境变量中读取AccessKey，来实现API访问的身份验证。请根据你的生产环境要求适当调整。
     * 避免AK&SK等关键信息在代码中明文存储是云上安全红线！
     *
     * @return Client
     * @throws Exception
     */
    public static Client createClient() throws Exception {
        Config config = new Config()
            .setAccessKeyId(System.getenv("ALIBABA_CLOUD_ACCESS_KEY_ID"))
            .setAccessKeySecret(System.getenv("ALIBABA_CLOUD_ACCESS_KEY_SECRET"));
        config.endpoint = "<yourEcsEndPoint>";
        return new Client(config);
    }

    public static String CreateNetworkInterface(Client client, String regionId, String vSwitchId,
        String securityGroupId, String name, String description) {
        try {
            CreateNetworkInterfaceRequest request = new CreateNetworkInterfaceRequest();
            request.setRegionId(regionId);
            request.setVSwitchId(vSwitchId);
            request.setSecurityGroupId(securityGroupId);
            request.setNetworkInterfaceName(name);
            request.setDescription(description);
            request.setClientToken(UUID.randomUUID().toString());

            //用来设置个性化的策略
            RuntimeOptions runtime = new RuntimeOptions();
            CreateNetworkInterfaceResponse response = client.createNetworkInterfaceWithOptions(request, runtime);

            if ("Available".equals(response.getBody().getStatus())) {
                System.out.println(
                    String.format("Instance.CreateNetworkInterface success, eni id:%s. Request is is %s.%n",
                        response.getBody().getNetworkInterfaceId(), response.getBody().getRequestId()));
                return response.getBody().getNetworkInterfaceId();
            }
        } catch (TeaException te) {
            System.out.println("ErrCode:" + te.getCode());
            System.out.println("ErrMsg:" + te.getMessage());
            System.out.println("RequestId:" + te.getData().get("RequestId"));
        } catch (Exception e) {
            System.out.println("ErrCode:" + e.getMessage());
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        String regionId = "<regionId>";
        String vSwitchId = "<yourVSwitchId>";
        String securityGroupId = "<yourSecurityGroupId>";

        Client client = createClient();
        CreateNetworkInterface(client, regionId, vSwitchId, securityGroupId, "test-eni", "description");
    }
}