import com.aliyun.ecs20140526.Client;
import com.aliyun.ecs20140526.models.AttachNetworkInterfaceRequest;
import com.aliyun.ecs20140526.models.AttachNetworkInterfaceResponse;
import com.aliyun.mns.client.CloudAccount;
import com.aliyun.tea.TeaException;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.models.RuntimeOptions;
import event.BaseEvent;
import event.EniOperateCompletedEvent;
import event.EventSubscriber;
import mns.EventClient;

/**
 * 该示例基于事件驱动方式获取弹性网卡操作结果通知
 */
public class AttachNetworkInterfaceWithEDA implements EventSubscriber<BaseEvent> {

    public static void main(String[] args) throws Exception {
        String queueName = "<yourQueueName>";
        String regionId = "<regionId>";
        String ecsInstanceId = "<yourInstanceId>";
        String eniId = "<yourEniId>";

        /**
         * 本示例通过从环境变量中读取AccessKey，来实现API访问的身份验证。请根据你的生产环境要求适当调整。
         * 避免AK&SK等关键信息在代码中明文存储是云上安全红线！
         */
        CloudAccount account = new CloudAccount(System.getenv("ALIBABA_CLOUD_ACCESS_KEY_ID"),
            System.getenv("ALIBABA_CLOUD_ACCESS_KEY_SECRET"), "<yourMnsEndPoint>");

        AttachNetworkInterfaceWithEDA eniOperateCompleteSubscriber = new AttachNetworkInterfaceWithEDA();
        EventClient
            .instance(account, queueName)
            .register(eniOperateCompleteSubscriber)
            .start();

        Client ecsClient = createClient();
        attachNetworkInterface(ecsClient, regionId, eniId, ecsInstanceId);
    }

    /**
     * 使用AK&SK初始化账号Client。
     *
     * 本示例通过从环境变量中读取AccessKey，来实现API访问的身份验证。请根据你的生产环境要求适当调整。
     * 避免AK&SK等关键信息在代码中明文存储是云上安全红线！
     *
     * @return Client
     * @throws Exception
     */
    public static Client createClient() throws Exception {
        Config config = new Config()
            .setAccessKeyId(System.getenv("ALIBABA_CLOUD_ACCESS_KEY_ID"))
            .setAccessKeySecret(System.getenv("ALIBABA_CLOUD_ACCESS_KEY_SECRET"));
        config.endpoint = "<yourEcsEndPoint>";
        return new Client(config);
    }

    /**
     * attach eni
     *
     * @param regionId
     * @param instanceId
     * @param eniId
     * @return
     */
    public static AttachNetworkInterfaceResponse attachNetworkInterface(Client ecsClient, String regionId, String eniId,
        String instanceId) {
        AttachNetworkInterfaceResponse response = null;
        try {
            AttachNetworkInterfaceRequest request = new AttachNetworkInterfaceRequest();
            request.setRegionId(regionId);
            request.setInstanceId(instanceId);
            request.setNetworkInterfaceId(eniId);
            //用来设置个性化的策略
            RuntimeOptions runtime = new RuntimeOptions();
            response = ecsClient.attachNetworkInterfaceWithOptions(request, runtime);
            System.out.println(String.format(
                "attach network interface %s to ecs instance %s send request success. Request id is %s.%n",
                eniId, instanceId, response.body.getRequestId()));
        } catch (TeaException te) {
            System.out.println("ErrCode:" + te.getCode());
            System.out.println("ErrMsg:" + te.getMessage());
            System.out.println("RequestId:" + te.getData().get("RequestId"));
        } catch (Exception e) {
            System.out.println("ErrCode:" + e.getMessage());
        }
        return response;
    }

    /**
     * This is an example that uses event mechanism to process the result of eni attachment.
     * It is recommended that you strengthen the fault tolerance of application services
     * so that errors or inconsistencies will not occur when processing the same message multiple times
     */
    @Override
    public Boolean handleEvent(BaseEvent event) {
        try {
            EniOperateCompletedEvent eniOperateCompletedEvent = new EniOperateCompletedEvent(event);
            String networkInterfaceOperation = eniOperateCompletedEvent.getOperation();
            switch (networkInterfaceOperation) {
                case "AttachNetworkInterface":
                    if ("success".equals(eniOperateCompletedEvent.getResult()) && "InUse".equals(
                        eniOperateCompletedEvent.getEniStatus())) {
                        System.out.println(String.format(
                            "Async attach network interface %s to ecs instance success. Request id is %s.%n",
                            eniOperateCompletedEvent.getEniId(), eniOperateCompletedEvent.getRequestId()));
                        return true;
                    } else {
                        // attach fail, please try again.
                        System.out.println("attach fail.Please try again.");
                    }
                    break;
                default:
            }
        } catch (Exception e) {
            // need to try again
            System.out.println(String.format("handleEvent Error %s", e.getMessage()));
        }

        return false;
    }

    @Override
    public String subscribedToEventType() {
        return EniOperateCompletedEvent.getEventName();
    }
}