package com.example.demo;

import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ScheduleTask {
    /*
     * 每天早上8点设置定时弹升，应对周期性业务高峰
     * 定时任务配置参考：https://docs.spring.io/spring/docs/current/spring-framework-reference/integration.html#scheduling
     *
     * 设置maxRCU为8，minRCU为4
     * Serverless变更配置参考：https://help.aliyun.com/zh/rds/apsaradb-rds-for-mysql/api-rds-2014-08-15-modifydbinstancespec-mysql?spm=a2c4g.11186623.0.i5
     */
    @Scheduled(cron = "0 0 8 * * ? ")
    public void customScheduleConfig() {
        ModifySpecParams params = new ModifySpecParams();
        params.setRegionId("cn-chengdu");
        params.setDBInstanceId("DB_INSTANCE_ID");
        params.setDirection("Serverless");
        params.setPayType("Serverless");
        params.setAutoPause(false);
        params.setSwitchForce(true);
        params.setMaxCapacity(4);
        params.setMinCapacity(4);
        ModifyDBInstanceSpec.modify(params);
    }
}