package com.example.demo;

import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.http.HttpClientConfig;
import com.aliyuncs.profile.DefaultProfile;
import com.google.gson.Gson;
import java.util.*;
import com.aliyuncs.rds.model.v20140815.*;
/*
pom.xml
<dependency>
  <groupId>com.aliyun</groupId>
  <artifactId>aliyun-java-sdk-core</artifactId>
  <version>4.6.0</version>
</dependency>
*/

public class ModifyDBInstanceSpec {

    public static void modify(ModifySpecParams params) {
        // 高级配置，对当前所有 request 有效
        HttpClientConfig clientConfig = HttpClientConfig.getDefault();

        DefaultProfile profile = DefaultProfile.getProfile(params.getRegionId(),
                System.getenv("ALIBABA_CLOUD_ACCESS_KEY_ID"),
                System.getenv("ALIBABA_CLOUD_ACCESS_KEY_SECRET"));
        profile.setHttpClientConfig(clientConfig);

        IAcsClient client = new DefaultAcsClient(profile);

        ModifyDBInstanceSpecRequest request = new ModifyDBInstanceSpecRequest();
        // 超时设置，仅对当前请求有效。该产品部分接口调用比较慢，请您适当调整超时时间。
        request.setSysReadTimeout(50000);
        request.setSysConnectTimeout(50000);
        request.setDBInstanceId(params.getDBInstanceId());
        request.setDirection(params.getDirection());
        request.setPayType(params.getPayType());
        request.setSysRegionId(params.getRegionId());

        ModifyDBInstanceSpecRequest.ServerlessConfiguration serverlessConfiguration = new ModifyDBInstanceSpecRequest.ServerlessConfiguration();
        serverlessConfiguration.setAutoPause(params.isAutoPause());
        serverlessConfiguration.setMaxCapacity(params.getMaxCapacity());
        serverlessConfiguration.setMinCapacity(params.getMinCapacity());
        serverlessConfiguration.setSwitchForce(params.isSwitchForce());
        request.setServerlessConfiguration(serverlessConfiguration);

        try {
            ModifyDBInstanceSpecResponse response = client.getAcsResponse(request);
            System.out.println(new Gson().toJson(response));
        } catch (ServerException e) {
            e.printStackTrace();
        } catch (ClientException e) {
            System.out.println("ErrCode:" + e.getErrCode());
            System.out.println("ErrMsg:" + e.getErrMsg());
            System.out.println("RequestId:" + e.getRequestId());
        }

    }
}

