/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.tunnel.worker;

import com.alicloud.openservices.tablestore.TunnelClientInterface;
import com.alicloud.openservices.tablestore.model.tunnel.ChannelStatus;
import com.alicloud.openservices.tablestore.model.tunnel.internal.Channel;
import com.alicloud.openservices.tablestore.tunnel.pipeline.ProcessDataPipeline;
import com.alicloud.openservices.tablestore.tunnel.worker.ChannelConnectStatus;
import com.alicloud.openservices.tablestore.tunnel.worker.IChannelConnect;
import com.alicloud.openservices.tablestore.tunnel.worker.IChannelProcessor;
import com.alicloud.openservices.tablestore.tunnel.worker.ICheckpointer;
import com.alicloud.openservices.tablestore.tunnel.worker.TunnelStateMachine;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelConnect
implements IChannelConnect {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelConnect.class);
    private String tunnelId;
    private String clientId;
    private String channelId;
    private String token;
    private TunnelClientInterface client;
    private IChannelProcessor processor;
    private Channel currentChannel;
    private TunnelStateMachine stateMachine;
    private AtomicReference<ChannelConnectStatus> status = new AtomicReference<ChannelConnectStatus>(ChannelConnectStatus.WAIT);
    private AtomicBoolean finished = new AtomicBoolean(false);
    private boolean streamChannel;
    private ICheckpointer checkpointer;
    private ProcessDataPipeline processPipeline;
    private ExecutorService channelExecutorService;
    private ThreadPoolExecutor readRecordsExecutor;
    private ThreadPoolExecutor processRecordsExecutor;

    @Override
    public synchronized void notifyStatus(Channel channel) {
        LOG.debug("Begin notify status, channel: {}", (Object)channel);
        if (this.currentChannel != null && this.currentChannel.getVersion() > channel.getVersion()) {
            return;
        }
        this.currentChannel = new Channel(channel);
        switch (this.currentChannel.getStatus()) {
            case CLOSE: {
                LOG.info("Closed channel status {}", (Object)this);
                this.close(false);
                break;
            }
            case CLOSING: {
                if (this.status.get() == ChannelConnectStatus.WAIT) {
                    this.status.set(ChannelConnectStatus.CLOSED);
                } else {
                    this.status.compareAndSet(ChannelConnectStatus.RUNNING, ChannelConnectStatus.CLOSING);
                }
                this.checkAndUpdateChannelStatus();
                break;
            }
            case OPEN: {
                if (this.status.compareAndSet(ChannelConnectStatus.WAIT, ChannelConnectStatus.RUNNING)) {
                    LOG.info("Submit pipeline task, channel connect :{}", (Object)this);
                    if (this.channelExecutorService == null) break;
                    this.channelExecutorService.submit(this.processPipeline);
                    break;
                }
                this.checkAndUpdateChannelStatus();
                break;
            }
            case TERMINATED: {
                LOG.info("Terminated channel status {}", (Object)this);
                this.close(true);
                break;
            }
            default: {
                LOG.warn("Unexpected channel status {}", (Object)this);
            }
        }
    }

    public void checkAndUpdateChannelStatus() {
        LOG.debug("Check update status, ChannelConnectStatus: {}", (Object)this.status.get().name());
        if (this.status.get() == ChannelConnectStatus.CLOSED) {
            this.currentChannel.setVersion(this.currentChannel.getVersion() + 1L);
            if (this.finished.get()) {
                this.currentChannel.setStatus(ChannelStatus.TERMINATED);
            } else {
                this.currentChannel.setStatus(ChannelStatus.CLOSE);
            }
            LOG.info("Update channel status, current channel: {}", (Object)this.currentChannel);
            this.stateMachine.updateStatus(this.currentChannel);
        }
    }

    @Override
    public boolean closed() {
        return this.status.get() == ChannelConnectStatus.CLOSED;
    }

    @Override
    public void close() {
        this.close(false);
    }

    public void close(boolean finish) {
        if (this.status.get() != ChannelConnectStatus.CLOSED) {
            LOG.info("Begin Shutdown Channel connect {}", (Object)this.channelId);
            if (this.processor != null) {
                this.processor.shutdown();
            }
            if (finish) {
                this.finished.set(true);
            }
            this.status.set(ChannelConnectStatus.CLOSED);
            LOG.info("After close channel {}, ChannelConnectStatus: {}", (Object)this.channelId, (Object)this.status.get());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append("TunnelId: ").append(this.tunnelId).append(", ClientId: ").append(this.clientId).append(", ChannelId: ").append(this.channelId).append(", CurrentChannel: ").append(this.currentChannel).append("]");
        return sb.toString();
    }

    public String getTunnelId() {
        return this.tunnelId;
    }

    public void setTunnelId(String tunnelId) {
        this.tunnelId = tunnelId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public TunnelClientInterface getClient() {
        return this.client;
    }

    public void setClient(TunnelClientInterface client) {
        this.client = client;
    }

    public IChannelProcessor getProcessor() {
        return this.processor;
    }

    public void setProcessor(IChannelProcessor processor) {
        this.processor = processor;
    }

    public Channel getCurrentChannel() {
        return this.currentChannel;
    }

    public void setCurrentChannel(Channel currentChannel) {
        this.currentChannel = currentChannel;
    }

    public TunnelStateMachine getStateMachine() {
        return this.stateMachine;
    }

    public void setStateMachine(TunnelStateMachine stateMachine) {
        this.stateMachine = stateMachine;
    }

    public ChannelConnectStatus getStatus() {
        return this.status.get();
    }

    public void setStatus(ChannelConnectStatus status) {
        this.status.set(status);
    }

    public AtomicBoolean getFinished() {
        return this.finished;
    }

    public void setFinished(AtomicBoolean finished) {
        this.finished = finished;
    }

    public boolean isStreamChannel() {
        return this.streamChannel;
    }

    public void setStreamChannel(boolean streamChannel) {
        this.streamChannel = streamChannel;
    }

    public ICheckpointer getCheckpointer() {
        return this.checkpointer;
    }

    public void setCheckpointer(ICheckpointer checkpointer) {
        this.checkpointer = checkpointer;
    }

    public ProcessDataPipeline getProcessPipeline() {
        return this.processPipeline;
    }

    public void setProcessPipeline(ProcessDataPipeline processPipeline) {
        this.processPipeline = processPipeline;
    }

    public ExecutorService getChannelExecutorService() {
        return this.channelExecutorService;
    }

    public void setChannelExecutorService(ExecutorService channelExecutorService) {
        this.channelExecutorService = channelExecutorService;
    }
}

