/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.search.query;

import com.alicloud.openservices.tablestore.core.protocol.SearchQueryBuilder;
import com.alicloud.openservices.tablestore.model.search.query.Query;
import com.alicloud.openservices.tablestore.model.search.query.QueryBuilder;
import com.alicloud.openservices.tablestore.model.search.query.QueryType;
import com.aliyun.ots.thirdparty.com.google.protobuf.ByteString;

public class KnnVectorQuery
implements Query {
    private final QueryType queryType = QueryType.QueryType_KnnVectorQuery;
    private String fieldName;
    private Integer topK;
    private float[] float32QueryVector;
    private Query filter;
    private Float weight;

    public String getFieldName() {
        return this.fieldName;
    }

    public KnnVectorQuery setFieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public KnnVectorQuery setTopK(Integer topK) {
        this.topK = topK;
        return this;
    }

    public float[] getFloat32QueryVector() {
        return this.float32QueryVector;
    }

    public KnnVectorQuery setFloat32QueryVector(float[] float32QueryVector) {
        this.float32QueryVector = float32QueryVector;
        return this;
    }

    public Query getFilter() {
        return this.filter;
    }

    public KnnVectorQuery setFilter(Query queryFilter) {
        this.filter = queryFilter;
        return this;
    }

    public KnnVectorQuery setFilter(QueryBuilder queryFilter) {
        this.filter = queryFilter.build();
        return this;
    }

    public Float getWeight() {
        return this.weight;
    }

    public KnnVectorQuery setWeight(Float weight) {
        this.weight = weight;
        return this;
    }

    @Override
    public QueryType getQueryType() {
        return this.queryType;
    }

    @Override
    public ByteString serialize() {
        return SearchQueryBuilder.buildKnnVectorQuery(this).toByteString();
    }

    protected static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder
    implements QueryBuilder {
        private final KnnVectorQuery knnVectorQuery = new KnnVectorQuery();

        private Builder() {
        }

        public Builder field(String fieldName) {
            this.knnVectorQuery.setFieldName(fieldName);
            return this;
        }

        public Builder topK(Integer topK) {
            this.knnVectorQuery.setTopK(topK);
            return this;
        }

        public Builder queryVector(float[] float32QueryVector) {
            this.knnVectorQuery.setFloat32QueryVector(float32QueryVector);
            return this;
        }

        public Builder filter(Query filter) {
            this.knnVectorQuery.setFilter(filter);
            return this;
        }

        public Builder weight(Float weight) {
            this.knnVectorQuery.setWeight(weight);
            return this;
        }

        @Override
        public KnnVectorQuery build() {
            return this.knnVectorQuery;
        }
    }
}

