/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.ecosystem;

import com.alicloud.openservices.tablestore.SyncClient;
import com.alicloud.openservices.tablestore.SyncClientInterface;
import com.alicloud.openservices.tablestore.ecosystem.CatalogManager;
import com.alicloud.openservices.tablestore.ecosystem.Filter;
import com.alicloud.openservices.tablestore.ecosystem.FilterPushdownConfig;
import com.alicloud.openservices.tablestore.ecosystem.GeoQueryHelper;
import com.alicloud.openservices.tablestore.ecosystem.ICatalogManager;
import com.alicloud.openservices.tablestore.ecosystem.ITablestoreSplit;
import com.alicloud.openservices.tablestore.ecosystem.SearchInfo;
import com.alicloud.openservices.tablestore.ecosystem.TableCatalog;
import com.alicloud.openservices.tablestore.ecosystem.TablestoreSplitIterator;
import com.alicloud.openservices.tablestore.model.BatchGetRowRequest;
import com.alicloud.openservices.tablestore.model.BatchGetRowResponse;
import com.alicloud.openservices.tablestore.model.ColumnType;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.MultiRowQueryCriteria;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.PrimaryKeyBuilder;
import com.alicloud.openservices.tablestore.model.PrimaryKeyColumn;
import com.alicloud.openservices.tablestore.model.PrimaryKeySchema;
import com.alicloud.openservices.tablestore.model.PrimaryKeyType;
import com.alicloud.openservices.tablestore.model.PrimaryKeyValue;
import com.alicloud.openservices.tablestore.model.RangeIteratorParameter;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.model.Split;
import com.alicloud.openservices.tablestore.model.TableMeta;
import com.alicloud.openservices.tablestore.model.iterator.RowIterator;
import com.alicloud.openservices.tablestore.model.search.DescribeSearchIndexRequest;
import com.alicloud.openservices.tablestore.model.search.DescribeSearchIndexResponse;
import com.alicloud.openservices.tablestore.model.search.FieldSchema;
import com.alicloud.openservices.tablestore.model.search.FieldType;
import com.alicloud.openservices.tablestore.model.search.IndexSchema;
import com.alicloud.openservices.tablestore.model.search.ParallelScanRequest;
import com.alicloud.openservices.tablestore.model.search.ScanQuery;
import com.alicloud.openservices.tablestore.model.search.query.BoolQuery;
import com.alicloud.openservices.tablestore.model.search.query.ExistsQuery;
import com.alicloud.openservices.tablestore.model.search.query.GeoPolygonQuery;
import com.alicloud.openservices.tablestore.model.search.query.MatchAllQuery;
import com.alicloud.openservices.tablestore.model.search.query.Query;
import com.alicloud.openservices.tablestore.model.search.query.QueryBuilders;
import com.alicloud.openservices.tablestore.model.search.query.QueryType;
import com.alicloud.openservices.tablestore.model.search.query.RangeQuery;
import com.alicloud.openservices.tablestore.model.search.query.TermQuery;
import com.alicloud.openservices.tablestore.model.search.query.TermsQuery;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TablestoreSplit
implements ITablestoreSplit {
    private static final Logger LOGGER = LoggerFactory.getLogger(TablestoreSplit.class);
    private int maxFirstColumnRangeSupport = 20;
    private int maxFirstColumnEqualSupport = 10;
    private static ICatalogManager manager;
    private static Gson gson;
    private TableMeta meta;
    private SearchInfo searchInfo;
    private String splitName;
    private String tableName;
    private SplitType type;
    private Split kvSplit;
    private Filter filter;
    private byte[] sessionId;
    private int maxParallel;
    private int splitId;
    public static List<String> geoColumnNames;
    private List<String> requiredColumns;
    public static boolean containGeo;
    public static boolean containOr;
    private static boolean pushAll;
    private static boolean containsRangeLong;
    private static boolean containsRangeString;

    public TablestoreSplit(SplitType type, Filter filter, List<String> requiredColumns) {
        this.type = type;
        this.filter = filter;
        this.requiredColumns = requiredColumns;
    }

    public TablestoreSplit(SplitType type, Filter filter, List<String> requiredColumns, byte[] sessionId, int splitId) {
        this.type = type;
        this.filter = filter;
        this.requiredColumns = requiredColumns;
        this.sessionId = sessionId;
        this.splitId = splitId;
    }

    public TablestoreSplit(SplitType type, Filter filter, List<String> requiredColumns, byte[] sessionId, int splitId, int maxParallel, List<String> geoColumnNames) {
        this.type = type;
        this.filter = filter;
        this.requiredColumns = requiredColumns;
        this.sessionId = sessionId;
        this.splitId = splitId;
        this.maxParallel = maxParallel;
        TablestoreSplit.geoColumnNames = geoColumnNames;
    }

    public void setSplitName(String name) {
        this.splitName = name;
    }

    public List<String> getRequiredColumns() {
        return this.requiredColumns;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setKvSplit(Split split) {
        this.kvSplit = split;
    }

    public void setSearchInfo(SearchInfo info) {
        this.searchInfo = info;
    }

    public void setKvTableMeta(TableMeta meta) {
        this.meta = meta;
    }

    @Override
    public Iterator<Row> getRowIterator(SyncClientInterface client) {
        if (this.type == SplitType.KeyValue) {
            return this.generateTableIterator(client);
        }
        FilterPushdownConfig filterPushdownConfig = new FilterPushdownConfig();
        return this.generateSearchIndexIterator(client, filterPushdownConfig);
    }

    @Override
    public Iterator<Row> getRowIterator(SyncClientInterface client, FilterPushdownConfig filterPushdownConfig) {
        if (this.type == SplitType.KeyValue) {
            return this.generateTableIterator(client);
        }
        return this.generateSearchIndexIterator(client, filterPushdownConfig);
    }

    private Iterator<Row> generateTableIterator(SyncClientInterface client) {
        List<PkRange> pkRanges = this.generatePkRange(this.filter, this.kvSplit.getLowerBound(), this.kvSplit.getUpperBound());
        LOGGER.info("kvSplit lower bound: {}, upper bound: {}, pkRanges: {}", new Object[]{this.kvSplit.getLowerBound(), this.kvSplit.getUpperBound(), gson.toJson(pkRanges)});
        if (this.checkIsBatchRead(pkRanges)) {
            LOGGER.debug("Batch get row");
            BatchGetRowRequest request = this.buildBatchGet(pkRanges);
            BatchGetRowResponse response = client.batchGetRow(request);
            if (response.getFailedRows().isEmpty()) {
                ArrayList<Row> rowCollction = new ArrayList<Row>();
                for (BatchGetRowResponse.RowResult result : response.getSucceedRows()) {
                    if (result.getRow() == null) continue;
                    rowCollction.add(result.getRow());
                }
                return rowCollction.iterator();
            }
        } else {
            if (pkRanges.size() == 1) {
                LOGGER.debug("Generate sub range to scan");
                PkRange range = pkRanges.get(0);
                return this.generateIterator(client, range.begin, range.end);
            }
            if (pkRanges.size() > 1) {
                return new TablestoreSplitIterator(client, pkRanges, this.meta.getTableName(), this.requiredColumns);
            }
        }
        LOGGER.debug("Scan the whole split");
        return this.generateIterator(client, this.kvSplit.getLowerBound(), this.kvSplit.getUpperBound());
    }

    private boolean checkIsBatchRead(List<PkRange> pkRanges) {
        if (pkRanges.size() >= 1 && pkRanges.size() <= 100) {
            for (PkRange range : pkRanges) {
                if (range.equal != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private BatchGetRowRequest buildBatchGet(List<PkRange> pkRanges) {
        BatchGetRowRequest request = new BatchGetRowRequest();
        MultiRowQueryCriteria criteria1 = new MultiRowQueryCriteria(this.tableName);
        criteria1.setMaxVersions(1);
        for (PkRange range : pkRanges) {
            criteria1.addRow(range.equal);
            request.addMultiRowQueryCriteria(criteria1);
        }
        return request;
    }

    private List<String> removePrimaryKey(List<String> columnNames) {
        if (!this.tableName.isEmpty()) {
            this.meta = manager.getTableCatalog(this.tableName).getTableMeta();
            Map<String, PrimaryKeyType> primaryKeyTypeMap = this.meta.getPrimaryKeyMap();
            ArrayList<String> retColumns = new ArrayList<String>();
            for (String columnName : columnNames) {
                if (primaryKeyTypeMap.containsKey(columnName)) continue;
                retColumns.add(columnName);
            }
            return retColumns;
        }
        return columnNames;
    }

    private Iterator<Row> generateSearchIndexIterator(SyncClientInterface client, FilterPushdownConfig filterPushdownConfig) {
        Filter flatFilter = this.buildFlatTreeFilter(this.filter);
        Query query = this.buildMergedSearchQueryFromFilter(flatFilter, filterPushdownConfig);
        ParallelScanRequest parallelScanRequestByBuilder = ParallelScanRequest.newBuilder().tableName(this.tableName).indexName(this.searchInfo.getSearchIndexName()).scanQuery(ScanQuery.newBuilder().query(query).limit(2000).currentParallelId(this.splitId).maxParallel(this.maxParallel).build()).addColumnsToGet(this.removePrimaryKey(this.requiredColumns)).sessionId(this.sessionId).build();
        RowIterator iterator = client.createParallelScanIterator(parallelScanRequestByBuilder);
        return iterator;
    }

    private Iterator<Row> generateIterator(SyncClientInterface client, PrimaryKey begin, PrimaryKey end) {
        RangeIteratorParameter rangeIteratorParameter = new RangeIteratorParameter(this.meta.getTableName());
        rangeIteratorParameter.setInclusiveStartPrimaryKey(begin);
        rangeIteratorParameter.setExclusiveEndPrimaryKey(end);
        rangeIteratorParameter.setMaxVersions(1);
        if (this.requiredColumns != null && !this.requiredColumns.isEmpty()) {
            for (String col : this.requiredColumns) {
                rangeIteratorParameter.addColumnsToGet(col);
            }
        } else {
            String defaultString = begin.getPrimaryKeyColumn(0).getName();
            rangeIteratorParameter.addColumnsToGet(defaultString);
        }
        Iterator<Row> iterator = client.createRangeIterator(rangeIteratorParameter);
        return iterator;
    }

    private List<Range> generateColumnRange(Filter filter, PrimaryKey begin, PrimaryKey end, int starPos) {
        String name = this.meta.getPrimaryKeyList().get(starPos).getName();
        if (filter.isNested()) {
            if (filter.getLogicOperator() == Filter.LogicOperator.AND || filter.getLogicOperator() == Filter.LogicOperator.OR) {
                List<Range> mergedResult = new ArrayList<Range>();
                for (Filter subFilter : filter.getSubFilters()) {
                    List<Range> result = this.generateColumnRange(subFilter, begin, end, starPos);
                    if (mergedResult.isEmpty() && result != null && !result.isEmpty()) {
                        mergedResult = result;
                        continue;
                    }
                    if (filter.getLogicOperator() == Filter.LogicOperator.AND) {
                        if (result != null && !result.isEmpty()) {
                            mergedResult = this.mergeSubRange(mergedResult, result, begin, end);
                        }
                        if (result != null) continue;
                        return new ArrayList<Range>();
                    }
                    if (result == null || result.isEmpty()) continue;
                    mergedResult = this.mergeTotalRange(mergedResult, result, begin, end);
                }
                return mergedResult;
            }
            PrimaryKeyColumn col1 = new PrimaryKeyColumn(name, begin.getPrimaryKeyColumn(starPos).getValue());
            PrimaryKeyColumn col2 = new PrimaryKeyColumn(name, end.getPrimaryKeyColumn(starPos).getValue());
            Range range = new Range(col1, col2);
            return Arrays.asList(range);
        }
        ArrayList<Range> result = new ArrayList<Range>();
        if (filter != null && filter.getColumnName() != null && filter.getColumnName().equals(name)) {
            PrimaryKeyValue pkv = PrimaryKeyValue.fromColumn(filter.getColumnValue());
            if (filter.getCompareOperator() == Filter.CompareOperator.EQUAL) {
                PrimaryKeyColumn pkc = new PrimaryKeyColumn(name, PrimaryKeyValue.fromColumn(filter.getColumnValue()));
                Range range = new Range(pkc);
                result.add(range);
            } else if (filter.getCompareOperator() == Filter.CompareOperator.LESS_THAN || filter.getCompareOperator() == Filter.CompareOperator.LESS_EQUAL) {
                boolean isRightOpen;
                boolean bl = isRightOpen = filter.getCompareOperator() == Filter.CompareOperator.LESS_THAN;
                if (starPos == 0) {
                    if (pkv.compareTo(end.getPrimaryKeyColumn(starPos).getValue()) >= 0) {
                        PrimaryKeyColumn pkc1 = new PrimaryKeyColumn(name, begin.getPrimaryKeyColumn(starPos).getValue());
                        PrimaryKeyColumn pkc2 = new PrimaryKeyColumn(name, end.getPrimaryKeyColumn(starPos).getValue());
                        Range range = new Range(pkc1, pkc2, isRightOpen);
                        result.add(range);
                    } else if (pkv.compareTo(begin.getPrimaryKeyColumn(starPos).getValue()) >= 0) {
                        PrimaryKeyColumn pkc1 = new PrimaryKeyColumn(name, begin.getPrimaryKeyColumn(starPos).getValue());
                        PrimaryKeyColumn pkc2 = new PrimaryKeyColumn(name, pkv);
                        Range range = new Range(pkc1, pkc2, isRightOpen);
                        result.add(range);
                    } else {
                        LOGGER.info("find empty split", (Object)begin.toString(), (Object)end.toString());
                    }
                } else {
                    PrimaryKeyColumn pkc1 = new PrimaryKeyColumn(name, PrimaryKeyValue.INF_MIN);
                    PrimaryKeyColumn pkc2 = new PrimaryKeyColumn(name, pkv);
                    Range range = new Range(pkc1, pkc2, isRightOpen);
                    result.add(range);
                }
            } else if (filter.getCompareOperator() == Filter.CompareOperator.GREATER_EQUAL || filter.getCompareOperator() == Filter.CompareOperator.GREATER_THAN) {
                if (starPos == 0) {
                    if (pkv.compareTo(begin.getPrimaryKeyColumn(starPos).getValue()) < 0) {
                        PrimaryKeyColumn pkc1 = new PrimaryKeyColumn(name, begin.getPrimaryKeyColumn(starPos).getValue());
                        PrimaryKeyColumn pkc2 = new PrimaryKeyColumn(name, end.getPrimaryKeyColumn(starPos).getValue());
                        Range range = new Range(pkc1, pkc2);
                        result.add(range);
                    } else if (pkv.compareTo(end.getPrimaryKeyColumn(starPos).getValue()) <= 0) {
                        PrimaryKeyColumn pkc1 = new PrimaryKeyColumn(name, pkv);
                        PrimaryKeyColumn pkc2 = new PrimaryKeyColumn(name, end.getPrimaryKeyColumn(starPos).getValue());
                        Range range = new Range(pkc1, pkc2);
                        result.add(range);
                    }
                } else {
                    PrimaryKeyColumn pkc1 = new PrimaryKeyColumn(name, pkv);
                    PrimaryKeyColumn pkc2 = new PrimaryKeyColumn(name, PrimaryKeyValue.INF_MAX);
                    Range range = new Range(pkc1, pkc2);
                    result.add(range);
                }
            }
        }
        return result;
    }

    public List<PkRange> generatePkRange(Filter filter, PrimaryKey begin, PrimaryKey end) {
        ArrayList<PkRange> pkList = new ArrayList<PkRange>();
        List<Range> first = this.generateColumnRange(filter, begin, end, 0);
        LOGGER.info("First generate column ranges: {}", (Object)gson.toJson(first));
        boolean isRange = false;
        if (first.size() > this.maxFirstColumnEqualSupport && first.size() <= this.maxFirstColumnRangeSupport) {
            isRange = true;
        } else {
            if (first.size() > this.maxFirstColumnRangeSupport) {
                PkRange pkRange = new PkRange(begin, end);
                pkList.add(pkRange);
                return pkList;
            }
            isRange = this.checkHasRange(first);
        }
        if (isRange) {
            return this.buildPkRangeFromRange(first, begin, end);
        }
        if (this.meta.getPrimaryKeyList().size() == 1) {
            return this.buildPkRangeFromRange(first, begin, end);
        }
        for (int i = 1; i < this.meta.getPrimaryKeyList().size(); ++i) {
            List<Range> subRange = this.generateColumnRange(filter, begin, end, i);
            if (this.checkHasRange(subRange) || i == this.meta.getPrimaryKeyList().size() - 1 || subRange.isEmpty()) {
                first = this.appendRange(first, subRange);
                return this.buildPkRangeFromRange(first, begin, end);
            }
            first = this.appendRange(first, subRange);
        }
        return pkList;
    }

    private List<Range> appendRange(List<Range> rangeList1, List<Range> rangeList2) {
        ArrayList<Range> rangeList = new ArrayList<Range>();
        for (Range front : rangeList1) {
            if (rangeList2.isEmpty()) {
                Range temp = new Range(front);
                rangeList.add(temp);
                continue;
            }
            for (Range back : rangeList2) {
                Range temp;
                Range temp2 = temp = new Range(front);
                while (temp2.next != null) {
                    temp2 = temp2.next;
                }
                temp2.next = back;
                rangeList.add(temp);
            }
        }
        return rangeList;
    }

    private List<PkRange> buildPkRangeFromRange(List<Range> rangeList, PrimaryKey begin, PrimaryKey end) {
        ArrayList<PkRange> pkList = new ArrayList<PkRange>();
        int pkCount = this.meta.getPrimaryKeyList().size();
        for (Range range : rangeList) {
            PkRange pkRange;
            LOGGER.info("build rangeBegin: {}, rangeEnd: {}, rangeEqual: {}, PrimaryKeyEnd:{}", new Object[]{range.begin, range.end, range.equal, end});
            PrimaryKeyBuilder pkb = PrimaryKeyBuilder.createPrimaryKeyBuilder();
            PrimaryKeyBuilder pkb2 = PrimaryKeyBuilder.createPrimaryKeyBuilder();
            PrimaryKey equalPk = null;
            boolean isAllEqual = false;
            boolean isRange = false;
            if (range.equal != null) {
                pkb.addPrimaryKeyColumn(range.equal.getName(), range.equal.getValue());
                if (pkCount > 1) {
                    pkb2.addPrimaryKeyColumn(range.equal.getName(), range.equal.getValue());
                } else {
                    equalPk = pkb.build();
                    isAllEqual = true;
                }
            } else {
                isRange = true;
                pkb.addPrimaryKeyColumn(range.begin.getName(), range.begin.getValue());
                pkb2.addPrimaryKeyColumn(range.end.getName(), range.end.getValue());
                if (pkCount == 1 && !range.isRightOpen()) {
                    equalPk = pkb2.build();
                }
            }
            int index = 0;
            Range currentColumn = range.next;
            int equalCursor = 0;
            for (PrimaryKeySchema pkSchema : this.meta.getPrimaryKeyList()) {
                if (index > 0) {
                    if (isRange || currentColumn == null) {
                        pkb.addPrimaryKeyColumn(pkSchema.getName(), PrimaryKeyValue.INF_MIN);
                        if (range.getEqual() != null && !range.getEqual().getValue().equals(end.getPrimaryKeyColumn(equalCursor).getValue())) {
                            pkb2.addPrimaryKeyColumn(pkSchema.getName(), PrimaryKeyValue.INF_MAX);
                        } else if (range.getEqual() != null && range.getEqual().getValue().equals(end.getPrimaryKeyColumn(equalCursor).getValue())) {
                            pkb2.addPrimaryKeyColumn(pkSchema.getName(), PrimaryKeyValue.INF_MIN);
                        } else if (range.getEnd().getValue().equals(end.getPrimaryKeyColumn(equalCursor).getValue())) {
                            pkb2.addPrimaryKeyColumn(pkSchema.getName(), PrimaryKeyValue.INF_MIN);
                        } else if (range.isRightOpen) {
                            pkb2.addPrimaryKeyColumn(pkSchema.getName(), PrimaryKeyValue.INF_MIN);
                        } else {
                            pkb2.addPrimaryKeyColumn(pkSchema.getName(), PrimaryKeyValue.INF_MAX);
                        }
                        isRange = true;
                    } else {
                        if (currentColumn.equal != null) {
                            pkb.addPrimaryKeyColumn(pkSchema.getName(), currentColumn.equal.getValue());
                            if (index < pkCount - 1) {
                                pkb2.addPrimaryKeyColumn(pkSchema.getName(), currentColumn.equal.getValue());
                            } else {
                                equalPk = pkb.build();
                                isAllEqual = true;
                            }
                        } else {
                            PrimaryKey temp;
                            pkb.addPrimaryKeyColumn(pkSchema.getName(), currentColumn.begin.getValue());
                            pkb2.addPrimaryKeyColumn(pkSchema.getName(), currentColumn.end.getValue());
                            isRange = true;
                            if (index == pkCount - 1 && (temp = pkb2.build()).compareTo(end) < 0 && currentColumn.end.getValue() != PrimaryKeyValue.INF_MAX && currentColumn.end.getValue() != PrimaryKeyValue.INF_MIN && !currentColumn.isRightOpen()) {
                                equalPk = pkb2.build();
                            }
                        }
                        range = currentColumn;
                        currentColumn = currentColumn.next;
                        ++equalCursor;
                    }
                }
                ++index;
            }
            PrimaryKey beginPk = pkb.build();
            if (isRange) {
                PrimaryKey endPk = pkb2.build();
                pkRange = new PkRange(beginPk, endPk);
            } else {
                pkRange = new PkRange(beginPk);
            }
            if (!isAllEqual) {
                pkList.add(pkRange);
            }
            if (equalPk == null) continue;
            PkRange pkRange2 = new PkRange(equalPk);
            pkList.add(pkRange2);
        }
        return this.filterPkRanges(pkList, begin, end);
    }

    public List<PkRange> filterPkRanges(List<PkRange> pkList, PrimaryKey begin, PrimaryKey end) {
        ArrayList<PkRange> retRanges = new ArrayList<PkRange>();
        for (PkRange pkRange : pkList) {
            if (pkRange.isSingleValue()) {
                if (pkRange.getEqual().compareTo(begin) >= 0 && pkRange.getEqual().compareTo(end) < 0) {
                    retRanges.add(pkRange);
                    continue;
                }
                LOGGER.info("Filter invalid pkrange: {}, begin: {}, end: {}", new Object[]{gson.toJson((Object)pkRange), begin.jsonize(), end.jsonize()});
                continue;
            }
            if (pkRange.getBegin().compareTo(pkRange.getEnd()) < 0 && pkRange.getBegin().compareTo(begin) >= 0 && pkRange.getEnd().compareTo(end) <= 0) {
                retRanges.add(pkRange);
                continue;
            }
            LOGGER.info("Filter invalid pkrange: {}, begin: {}, end: {}", new Object[]{gson.toJson((Object)pkRange), begin.jsonize(), end.jsonize()});
        }
        return retRanges;
    }

    private boolean checkHasRange(List<Range> rangeList) {
        for (Range range : rangeList) {
            if (range.isSingleValue()) continue;
            return true;
        }
        return false;
    }

    private List<Range> mergeSubRange(List<Range> range1, List<Range> range2, PrimaryKey begin, PrimaryKey end) {
        for (Range subRange : range2) {
            range1 = this.mergeSubRange(range1, subRange, begin, end);
        }
        return range1;
    }

    private List<Range> mergeSubRange(List<Range> range1, Range subRange, PrimaryKey begin, PrimaryKey end) {
        ArrayList<Range> retRange = new ArrayList<Range>();
        for (Range range : range1) {
            LOGGER.info("rangeBegin: {}, rangeEnd: {}, rangeEqual: {}, subRangeBegin: {}, subRangeEnd: {}, subRangeEqual: {}", new Object[]{range.begin, range.end, range.equal, subRange.begin, subRange.end, subRange.equal});
            if (range.equal != null) {
                return range1;
            }
            if (subRange.equal != null) {
                ArrayList<Range> rangeList = new ArrayList<Range>();
                rangeList.add(subRange);
                return rangeList;
            }
            PrimaryKeyColumn pkcBegin = range.begin;
            PrimaryKeyColumn pkcEnd = range.end;
            if (subRange.begin.getName().equals(pkcBegin.getName())) {
                if (pkcEnd.getValue().compareTo(subRange.begin.getValue()) < 0 || pkcBegin.getValue().compareTo(subRange.end.getValue()) > 0) continue;
                if (pkcBegin.getValue().compareTo(subRange.begin.getValue()) > 0 && pkcBegin.getValue().compareTo(subRange.end.getValue()) < 0 && pkcEnd.getValue().compareTo(subRange.end.getValue()) > 0) {
                    range.setEnd(subRange.end);
                    range.setRightOpen(subRange.isRightOpen);
                } else if (pkcBegin.getValue().compareTo(subRange.begin.getValue()) < 0 && pkcEnd.getValue().compareTo(subRange.begin.getValue()) > 0) {
                    if (pkcEnd.getValue().compareTo(subRange.end.getValue()) > 0) {
                        range.setEnd(subRange.end);
                        range.setRightOpen(subRange.isRightOpen);
                        range.setBegin(subRange.begin);
                    }
                    if (pkcEnd.getValue().compareTo(subRange.end.getValue()) <= 0) {
                        range.setBegin(subRange.begin);
                    }
                }
                retRange.add(range);
                continue;
            }
            return range1;
        }
        return retRange;
    }

    private List<Range> mergeTotalRange(List<Range> range1, List<Range> range2, PrimaryKey begin, PrimaryKey end) {
        range1.addAll(range2);
        return range1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void initial(SyncClient client) {
        TableMeta tempMeta;
        if (manager == null) {
            Class<TablestoreSplit> clazz = TablestoreSplit.class;
            // MONITORENTER : com.alicloud.openservices.tablestore.ecosystem.TablestoreSplit.class
            if (manager == null) {
                manager = new CatalogManager(client);
            }
            // MONITOREXIT : clazz
        }
        TableCatalog catalog = manager.getTableCatalog(this.tableName);
        if (this.type != SplitType.KeyValue) {
            List<IndexSchema> metas = catalog.getSearchSchema();
            this.searchInfo = new SearchInfo(this.splitName, metas.get(0));
            return;
        }
        if (this.tableName.equals(this.splitName)) {
            this.meta = catalog.getTableMeta();
            return;
        }
        List<TableMeta> metas = catalog.getIndexMetaList();
        Iterator<TableMeta> iterator = metas.iterator();
        do {
            if (!iterator.hasNext()) throw new IllegalArgumentException("invalid split name");
        } while (!(tempMeta = iterator.next()).getTableName().equals(this.splitName));
        this.meta = tempMeta;
    }

    public boolean checkIfMatchTheFilter(Filter filter) {
        if (filter.isNested()) {
            if (filter.getLogicOperator() == Filter.LogicOperator.AND) {
                for (Filter subFilter : filter.getSubFilters()) {
                    if (this.checkIfMatchTheFilter(subFilter)) continue;
                    return false;
                }
                return true;
            }
            if (filter.getLogicOperator() == Filter.LogicOperator.OR) {
                for (Filter subFilter : filter.getSubFilters()) {
                    if (!this.checkIfMatchTheFilter(subFilter)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        PrimaryKey pk = this.kvSplit.getLowerBound();
        if (filter.getCompareOperator() == Filter.CompareOperator.NOT_EQUAL) {
            return true;
        }
        if (Filter.CompareOperator.EQUAL == filter.getCompareOperator()) {
            if (!filter.getColumnName().equals(pk.getPrimaryKeyColumn(0).getName())) {
                return true;
            }
            try {
                return !(!this.kvSplit.getLowerBound().getPrimaryKeyColumn(0).getValue().isInfMin() && this.kvSplit.getLowerBound().getPrimaryKeyColumn(0).getValue().toColumnValue().compareTo(filter.getColumnValue()) > 0 || !this.kvSplit.getUpperBound().getPrimaryKeyColumn(0).getValue().isInfMax() && this.kvSplit.getUpperBound().getPrimaryKeyColumn(0).getValue().toColumnValue().compareTo(filter.getColumnValue()) <= 0);
            }
            catch (IOException e) {
                e.printStackTrace();
                return true;
            }
        }
        if (Filter.CompareOperator.EMPTY_FILTER == filter.getCompareOperator()) {
            return true;
        }
        if (filter.getColumnName().equals(pk.getPrimaryKeyColumn(0).getName())) {
            if (filter.getCompareOperator() == Filter.CompareOperator.GREATER_THAN || filter.getCompareOperator() == Filter.CompareOperator.GREATER_EQUAL) {
                try {
                    return this.kvSplit.getUpperBound().getPrimaryKeyColumn(0).getValue().isInfMax() || this.kvSplit.getUpperBound().getPrimaryKeyColumn(0).getValue().toColumnValue().compareTo(filter.getColumnValue()) > 0;
                }
                catch (IOException e) {
                    return true;
                }
            }
            if (filter.getCompareOperator() == Filter.CompareOperator.LESS_THAN || filter.getCompareOperator() == Filter.CompareOperator.LESS_EQUAL) {
                try {
                    if (filter.getCompareOperator() == Filter.CompareOperator.LESS_THAN) {
                        return this.kvSplit.getLowerBound().getPrimaryKeyColumn(0).getValue().isInfMin() || this.kvSplit.getLowerBound().getPrimaryKeyColumn(0).getValue().toColumnValue().compareTo(filter.getColumnValue()) < 0;
                    }
                    return this.kvSplit.getLowerBound().getPrimaryKeyColumn(0).getValue().isInfMin() || this.kvSplit.getLowerBound().getPrimaryKeyColumn(0).getValue().toColumnValue().compareTo(filter.getColumnValue()) <= 0;
                }
                catch (IOException e) {
                    return true;
                }
            }
        }
        return true;
    }

    public SplitType getType() {
        return this.type;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public String getSplitName() {
        return this.splitName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setType(SplitType type) {
        this.type = type;
    }

    public Split getKvSplit() {
        return this.kvSplit;
    }

    public void setFilter(Filter filter) {
    }

    public byte[] getSessionId() {
        return this.sessionId;
    }

    public int getSplitId() {
        return this.splitId;
    }

    public List<String> getGeoColumnNames() {
        return geoColumnNames;
    }

    public int getMaxParallel() {
        return this.maxParallel;
    }

    public String toString() {
        return "Name:" + this.tableName + ", splitname" + this.splitName + ",type:" + (Object)((Object)this.type);
    }

    public Filter buildFlatTreeFilter(Filter filter) {
        if (filter.isNested()) {
            ArrayList<Filter> origFilters = new ArrayList<Filter>();
            for (Filter subFilter : filter.getSubFilters()) {
                origFilters.add(this.buildFlatTreeFilter(subFilter));
            }
            ArrayList<Filter> flatFilters = new ArrayList<Filter>();
            for (Filter subFilter : origFilters) {
                if (subFilter.isNested() && filter.getLogicOperator() != Filter.LogicOperator.NOT && filter.getLogicOperator() == subFilter.getLogicOperator()) {
                    flatFilters.addAll(subFilter.getSubFilters());
                    continue;
                }
                flatFilters.add(subFilter);
            }
            return new Filter(filter.getLogicOperator(), flatFilters);
        }
        return filter;
    }

    public List<Query> mergeQuerys(List<Query> origQuerys) {
        ArrayList<Query> remainQuerys = new ArrayList<Query>();
        HashMap<String, RangeQuery> mergedRangeQuerys = new HashMap<String, RangeQuery>(origQuerys.size());
        for (Query query : origQuerys) {
            if (query.getQueryType() == QueryType.QueryType_RangeQuery) {
                RangeQuery rangeQuery = (RangeQuery)query;
                RangeQuery mergedRangeQuery = (RangeQuery)mergedRangeQuerys.get(rangeQuery.getFieldName());
                if (mergedRangeQuery != null) {
                    if (rangeQuery.getFrom() != null) {
                        if (mergedRangeQuery.getFrom() == null) {
                            mergedRangeQuery.setFrom(rangeQuery.getFrom());
                            mergedRangeQuery.setIncludeLower(rangeQuery.isIncludeLower());
                        } else if (rangeQuery.getFrom().compareTo(mergedRangeQuery.getFrom()) > 0) {
                            mergedRangeQuery.setFrom(rangeQuery.getFrom());
                            mergedRangeQuery.setIncludeLower(rangeQuery.isIncludeLower());
                        } else if (!(rangeQuery.getFrom().compareTo(mergedRangeQuery.getFrom()) != 0 || rangeQuery.isIncludeLower() && mergedRangeQuery.isIncludeLower())) {
                            mergedRangeQuery.setIncludeLower(false);
                        }
                    }
                    if (rangeQuery.getTo() == null) continue;
                    if (mergedRangeQuery.getTo() == null) {
                        mergedRangeQuery.setTo(rangeQuery.getTo());
                        mergedRangeQuery.setIncludeUpper(rangeQuery.isIncludeUpper());
                    } else if (rangeQuery.getTo().compareTo(mergedRangeQuery.getTo()) < 0) {
                        mergedRangeQuery.setTo(rangeQuery.getTo());
                        mergedRangeQuery.setIncludeUpper(rangeQuery.isIncludeUpper());
                    } else if (!(rangeQuery.getTo().compareTo(mergedRangeQuery.getTo()) != 0 || rangeQuery.isIncludeUpper() && mergedRangeQuery.isIncludeUpper())) {
                        mergedRangeQuery.setIncludeUpper(false);
                    }
                    if (mergedRangeQuery.getTo() != null && (mergedRangeQuery.getTo() == null || rangeQuery.getTo().compareTo(mergedRangeQuery.getTo()) > 0)) continue;
                    mergedRangeQuery.setTo(rangeQuery.getTo());
                    continue;
                }
                mergedRangeQuerys.put(rangeQuery.getFieldName(), rangeQuery);
                continue;
            }
            remainQuerys.add(query);
        }
        ArrayList<Query> retQuerys = new ArrayList<Query>();
        retQuerys.addAll(mergedRangeQuerys.values());
        retQuerys.addAll(remainQuerys);
        return retQuerys;
    }

    public static Filter getUnhandledOtsFilter(SyncClient client, Filter filter, String tableName, String indexName) {
        FilterPushdownConfig filterPushdownConfig = new FilterPushdownConfig();
        return TablestoreSplit.getUnhandledOtsFilterCore(client, filter, tableName, indexName, filterPushdownConfig);
    }

    public static Filter getUnhandledOtsFilter(SyncClient client, Filter filter, String tableName, String indexName, FilterPushdownConfig filterPushdownConfig) {
        return TablestoreSplit.getUnhandledOtsFilterCore(client, filter, tableName, indexName, filterPushdownConfig);
    }

    public static Filter getUnhandledOtsFilterCore(SyncClient client, Filter filter, String tableName, String indexName, FilterPushdownConfig filterPushdownConfig) {
        boolean pushRangeLong = filterPushdownConfig.pushRangeLong;
        boolean pushRangeString = filterPushdownConfig.pushRangeString;
        if (geoColumnNames == null) {
            geoColumnNames = TablestoreSplit.generateGeoColumnNames(client, tableName, indexName);
        }
        if (filter.isNested()) {
            List<Filter> subFiltersOld = filter.getFilters();
            ArrayList<Filter> subFilterNewList = new ArrayList<Filter>();
            if (filter.getLogicOperator() == Filter.LogicOperator.OR) {
                containOr = true;
                if (!pushRangeLong && containsRangeLong || !pushRangeString && containsRangeString) {
                    LOGGER.warn("push.down.range.long push.down.range.string will be regarded as true when sql contains OR, so all filters will be pushed down");
                }
            }
            for (Filter subFilter : subFiltersOld) {
                Filter subFilterNew = TablestoreSplit.getUnhandledOtsFilterCore(client, subFilter, tableName, indexName, filterPushdownConfig);
                if (subFilterNew == null) continue;
                subFilterNewList.add(subFilterNew);
            }
            if (subFilterNewList.size() >= 2) {
                filter.setFilters(subFilterNewList);
            } else {
                filter = subFilterNewList.size() == 1 ? (Filter)subFilterNewList.get(0) : null;
            }
            return filter;
        }
        ColumnValue filterColumnValue = filter.getColumnValue();
        if (geoColumnNames.contains(filter.getColumnName())) {
            containGeo = true;
            return null;
        }
        if (filter.getCompareOperator() == Filter.CompareOperator.GREATER_THAN || filter.getCompareOperator() == Filter.CompareOperator.GREATER_EQUAL || filter.getCompareOperator() == Filter.CompareOperator.LESS_THAN || filter.getCompareOperator() == Filter.CompareOperator.LESS_EQUAL) {
            if (filterColumnValue.getType() == ColumnType.INTEGER) {
                containsRangeLong = true;
            }
            if (filterColumnValue.getType() == ColumnType.STRING) {
                containsRangeString = true;
            }
            if (containOr) {
                if (!pushRangeLong && containsRangeLong || !pushRangeString && containsRangeString) {
                    LOGGER.warn("push.down.range.long push.down.range.string will be regarded as true when sql contains OR, so all filters will be pushed down");
                }
                return null;
            }
            if (!pushRangeLong && filterColumnValue.getType() == ColumnType.INTEGER || !pushRangeString && filterColumnValue.getType() == ColumnType.STRING) {
                return filter;
            }
            return null;
        }
        return null;
    }

    private static List<String> generateGeoColumnNames(SyncClient client, String tableName, String indexName) {
        ArrayList<String> geoColumnNames = new ArrayList<String>();
        DescribeSearchIndexRequest request = new DescribeSearchIndexRequest();
        request.setTableName(tableName);
        request.setIndexName(indexName);
        DescribeSearchIndexResponse response = client.describeSearchIndex(request);
        IndexSchema indexSchema = response.getSchema();
        for (FieldSchema fieldSchema : indexSchema.getFieldSchemas()) {
            if (fieldSchema.getFieldType() != FieldType.GEO_POINT) continue;
            geoColumnNames.add(fieldSchema.getFieldName());
        }
        return geoColumnNames;
    }

    public Query buildMergedSearchQueryFromFilter(Filter filter) throws Exception {
        return this.buildMergedSearchQueryFromFilter(filter, new FilterPushdownConfig());
    }

    public Query buildMergedSearchQueryFromFilter(Filter filter, FilterPushdownConfig filterPushdownConfig) {
        boolean pushRangeLong = filterPushdownConfig.pushRangeLong;
        boolean pushRangeString = filterPushdownConfig.pushRangeString;
        if (filter.isNested()) {
            BoolQuery boolQuery = new BoolQuery();
            ArrayList<Query> mustQuerys = new ArrayList<Query>();
            ArrayList<Query> shouldQuerys = new ArrayList<Query>();
            ArrayList<Query> mustNotQuerys = new ArrayList<Query>();
            for (Filter subFilter : filter.getSubFilters()) {
                Query subQuery = this.buildMergedSearchQueryFromFilter(subFilter, filterPushdownConfig);
                if (filter.getLogicOperator() == Filter.LogicOperator.AND) {
                    mustQuerys.add(subQuery);
                    continue;
                }
                if (filter.getLogicOperator() == Filter.LogicOperator.OR) {
                    shouldQuerys.add(subQuery);
                    containOr = true;
                    if ((pushRangeLong || !containsRangeLong) && (pushRangeString || !containsRangeString)) continue;
                    LOGGER.warn("push.down.range.long push.down.range.string will be regarded as true when sql contains OR");
                    continue;
                }
                if (filter.getLogicOperator() != Filter.LogicOperator.NOT) continue;
                mustNotQuerys.add(subQuery);
            }
            List<Query> mergedMustQuerys = this.mergeQuerys(mustQuerys);
            boolQuery.setMustQueries(mergedMustQuerys);
            boolQuery.setShouldQueries(shouldQuerys);
            boolQuery.setMustNotQueries(mustNotQuerys);
            return boolQuery;
        }
        ColumnValue filterColumnValue = filter.getColumnValue();
        if (geoColumnNames != null && geoColumnNames.contains(filter.getColumnName())) {
            Query geoQuery = this.getGeoQuery(filter);
            if (geoQuery != null) {
                return geoQuery;
            }
        } else {
            Query rangeQuery;
            if (filter.getCompareOperator() == Filter.CompareOperator.EQUAL) {
                return QueryBuilders.term(filter.getColumnName(), filterColumnValue.getValue()).build();
            }
            if (filter.getCompareOperator() == Filter.CompareOperator.IN) {
                return this.getInQuery(filter);
            }
            if (filter.getCompareOperator() == Filter.CompareOperator.IS_NULL) {
                return this.getIsNullQuery(filter);
            }
            if (filter.getCompareOperator() == Filter.CompareOperator.NOT_EQUAL) {
                return this.getNotEqualQuery(filter, filterColumnValue);
            }
            if (filter.getCompareOperator() == Filter.CompareOperator.START_WITH) {
                return this.getStartWithQuery(filter, filterColumnValue);
            }
            if ((filter.getCompareOperator() == Filter.CompareOperator.GREATER_THAN || filter.getCompareOperator() == Filter.CompareOperator.GREATER_EQUAL || filter.getCompareOperator() == Filter.CompareOperator.LESS_THAN || filter.getCompareOperator() == Filter.CompareOperator.LESS_EQUAL) && (rangeQuery = this.getRangeQuery(filter, pushRangeLong, pushRangeString, filterColumnValue)) != null) {
                return rangeQuery;
            }
        }
        return new MatchAllQuery();
    }

    private Query getRangeQuery(Filter filter, boolean pushRangeLong, boolean pushRangeString, ColumnValue filterColumnValue) {
        if (filterColumnValue.getType() == ColumnType.INTEGER) {
            containsRangeLong = true;
        }
        if (filterColumnValue.getType() == ColumnType.STRING) {
            containsRangeString = true;
        }
        if (containOr) {
            if (!pushRangeLong && containsRangeLong || !pushRangeString && containsRangeString) {
                LOGGER.warn("push.down.range.long push.down.range.string will be regarded as true when sql contains or");
            }
            RangeQuery.Builder builder = QueryBuilders.range(filter.getColumnName());
            if (filter.getCompareOperator() == Filter.CompareOperator.GREATER_THAN) {
                return builder.greaterThan(filterColumnValue.getValue()).build();
            }
            if (filter.getCompareOperator() == Filter.CompareOperator.GREATER_EQUAL) {
                return builder.greaterThanOrEqual(filterColumnValue.getValue()).build();
            }
            if (filter.getCompareOperator() == Filter.CompareOperator.LESS_THAN) {
                return builder.lessThan(filterColumnValue.getValue()).build();
            }
            if (filter.getCompareOperator() == Filter.CompareOperator.LESS_EQUAL) {
                return builder.lessThanOrEqual(filterColumnValue.getValue()).build();
            }
        } else {
            if (!pushRangeLong && filterColumnValue.getType() == ColumnType.INTEGER) {
                return new MatchAllQuery();
            }
            if (!pushRangeString && filterColumnValue.getType() == ColumnType.STRING) {
                return new MatchAllQuery();
            }
            RangeQuery.Builder builder = QueryBuilders.range(filter.getColumnName());
            if (filter.getCompareOperator() == Filter.CompareOperator.GREATER_THAN) {
                return builder.greaterThan(filterColumnValue.getValue()).build();
            }
            if (filter.getCompareOperator() == Filter.CompareOperator.GREATER_EQUAL) {
                return builder.greaterThanOrEqual(filterColumnValue.getValue()).build();
            }
            if (filter.getCompareOperator() == Filter.CompareOperator.LESS_THAN) {
                return builder.lessThan(filterColumnValue.getValue()).build();
            }
            if (filter.getCompareOperator() == Filter.CompareOperator.LESS_EQUAL) {
                return builder.lessThanOrEqual(filterColumnValue.getValue()).build();
            }
        }
        return null;
    }

    private Query getStartWithQuery(Filter filter, ColumnValue filterColumnValue) {
        return QueryBuilders.prefix(filter.getColumnName(), filterColumnValue.asString()).build();
    }

    private Query getNotEqualQuery(Filter filter, ColumnValue filterColumnValue) {
        BoolQuery.Builder boolBuilder = QueryBuilders.bool();
        TermQuery.Builder termBuilder = QueryBuilders.term(filter.getColumnName(), filterColumnValue.getValue());
        return boolBuilder.mustNot(termBuilder).build();
    }

    private Query getIsNullQuery(Filter filter) {
        BoolQuery.Builder boolBuilder = QueryBuilders.bool();
        ExistsQuery.Builder existsBuilder = QueryBuilders.exists(filter.getColumnName());
        return boolBuilder.mustNot(existsBuilder).build();
    }

    private Query getInQuery(Filter filter) {
        TermsQuery.Builder terms = QueryBuilders.terms(filter.getColumnName()).terms(new Object[0]);
        for (ColumnValue columnValue : filter.getColumnValuesForInOperator()) {
            terms.addTerm(columnValue.getValue());
        }
        return terms.build();
    }

    private Query getGeoQuery(Filter filter) {
        GeoQueryHelper query;
        try {
            query = GeoQueryHelper.buildGeoQueryHelper(filter);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
        switch (query.getGeoType()) {
            case DISTANCE: {
                return QueryBuilders.geoDistance(filter.getColumnName()).centerPoint(query.getCenterPoint()).distanceInMeter(query.getDistanceInMeter()).build();
            }
            case BOUNDING_BOX: {
                return QueryBuilders.geoBoundingBox(filter.getColumnName()).topLeft(query.getTopLeft()).bottomRight(query.getBottomRight()).build();
            }
            case POLYGON: {
                GeoPolygonQuery.Builder builder = QueryBuilders.geoPolygon(filter.getColumnName());
                for (String point : query.getPoints()) {
                    builder.addPoint(point);
                }
                return builder.build();
            }
        }
        return null;
    }

    static {
        gson = new Gson();
        containGeo = false;
        containOr = false;
        pushAll = false;
        containsRangeLong = false;
        containsRangeString = false;
    }

    public static class PkRange {
        private PrimaryKey begin;
        private PrimaryKey end;
        private PrimaryKey equal;

        public PrimaryKey getBegin() {
            return this.begin;
        }

        public PrimaryKey getEnd() {
            return this.end;
        }

        public PrimaryKey getEqual() {
            return this.equal;
        }

        public PkRange(PrimaryKey begin, PrimaryKey end) {
            this.begin = begin;
            this.end = end;
        }

        public PkRange(PrimaryKey equal) {
            this.equal = equal;
        }

        public boolean isSingleValue() {
            return this.equal != null;
        }
    }

    public static class Range {
        boolean isRightOpen = false;
        private PrimaryKeyColumn begin;
        private PrimaryKeyColumn end;
        private PrimaryKeyColumn equal;
        private Range next;

        public void setRightOpen(boolean rightOpen) {
            this.isRightOpen = rightOpen;
        }

        public boolean isRightOpen() {
            return this.isRightOpen;
        }

        public Range(Range range) {
            if (range.equal != null) {
                this.equal = range.equal;
            } else {
                this.begin = range.begin;
                this.end = range.end;
            }
            if (range.next != null) {
                this.next = range.next;
            }
            this.isRightOpen = range.isRightOpen;
        }

        public Range(PrimaryKeyColumn begin, PrimaryKeyColumn end) {
            this.begin = begin;
            this.end = end;
        }

        public Range(PrimaryKeyColumn begin, PrimaryKeyColumn end, boolean isRightOpen) {
            this.begin = begin;
            this.end = end;
            this.isRightOpen = isRightOpen;
        }

        public Range(PrimaryKeyColumn equal) {
            this.equal = equal;
        }

        public PrimaryKeyColumn getBegin() {
            return this.begin;
        }

        public PrimaryKeyColumn getEnd() {
            return this.end;
        }

        public PrimaryKeyColumn getEqual() {
            return this.equal;
        }

        public Range getNext() {
            return this.next;
        }

        public void setBegin(PrimaryKeyColumn begin) {
            this.begin = begin;
        }

        public void setEnd(PrimaryKeyColumn end) {
            this.end = end;
        }

        public void setEqual(PrimaryKeyColumn equal) {
            this.equal = equal;
        }

        public void setNext(Range next) {
            this.next = next;
        }

        public boolean isSingleValue() {
            return this.equal != null;
        }
    }

    public static enum SplitType {
        KeyValue,
        SearchIndex;

    }
}

