/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.timeseries;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.Request;
import com.alicloud.openservices.tablestore.model.timeseries.PutTimeseriesDataResponse;
import com.alicloud.openservices.tablestore.model.timeseries.TimeseriesRow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PutTimeseriesDataRequest
implements Request {
    private final String timeseriesTableName;
    private List<TimeseriesRow> rows = new ArrayList<TimeseriesRow>();
    private MetaUpdateMode metaUpdateMode = MetaUpdateMode.NORMAL;

    public PutTimeseriesDataRequest(String timeseriesTableName) {
        this.timeseriesTableName = timeseriesTableName;
    }

    @Override
    public String getOperationName() {
        return "PutTimeseriesData";
    }

    public String getTimeseriesTableName() {
        return this.timeseriesTableName;
    }

    public List<TimeseriesRow> getRows() {
        return this.rows;
    }

    public void setRows(List<TimeseriesRow> rows) {
        for (TimeseriesRow row : rows) {
            if (row.getTimeInUs() >= 0L) continue;
            throw new ClientException("time not set in timeseriesRow");
        }
        this.rows = rows;
    }

    public void addRows(Collection<TimeseriesRow> rows) {
        this.rows.addAll(rows);
    }

    public void addRow(TimeseriesRow row) {
        this.rows.add(row);
    }

    public MetaUpdateMode getMetaUpdateMode() {
        return this.metaUpdateMode;
    }

    public void setMetaUpdateMode(MetaUpdateMode metaUpdateMode) {
        this.metaUpdateMode = metaUpdateMode;
    }

    public PutTimeseriesDataRequest createRequestForRetry(List<PutTimeseriesDataResponse.FailedRowResult> failedRows) {
        Preconditions.checkArgument(failedRows != null && !failedRows.isEmpty(), "failedRows can't be null or empty.");
        PutTimeseriesDataRequest request = new PutTimeseriesDataRequest(this.timeseriesTableName);
        for (PutTimeseriesDataResponse.FailedRowResult rowResult : failedRows) {
            if (rowResult.getIndex() >= this.rows.size() || this.rows.get(rowResult.getIndex()) == null) {
                throw new IllegalArgumentException("Can not find row with index " + rowResult.getIndex());
            }
            request.addRow(this.rows.get(rowResult.getIndex()));
        }
        request.setMetaUpdateMode(this.getMetaUpdateMode());
        return request;
    }

    public static enum MetaUpdateMode {
        NORMAL,
        IGNORE;

    }
}

