/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.timeseries;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.Request;
import com.alicloud.openservices.tablestore.model.TimeseriesTableMeta;
import com.alicloud.openservices.tablestore.model.timeseries.TimeseriesAnalyticalStore;
import java.util.ArrayList;
import java.util.List;

public class CreateTimeseriesTableRequest
implements Request {
    private TimeseriesTableMeta timeseriesTableMeta;
    private List<TimeseriesAnalyticalStore> analyticalStores = new ArrayList<TimeseriesAnalyticalStore>();
    private boolean enableAnalyticalStore = true;

    public CreateTimeseriesTableRequest(TimeseriesTableMeta timeseriesTableMeta) {
        this.setTimeseriesTableMeta(timeseriesTableMeta);
    }

    @Override
    public String getOperationName() {
        return "CreateTimeseriesTable";
    }

    public TimeseriesTableMeta getTimeseriesTableMeta() {
        return this.timeseriesTableMeta;
    }

    public List<TimeseriesAnalyticalStore> getAnalyticalStores() {
        return this.analyticalStores;
    }

    public boolean isEnableAnalyticalStore() {
        return this.enableAnalyticalStore;
    }

    public void setTimeseriesTableMeta(TimeseriesTableMeta timeseriesTableMeta) {
        Preconditions.checkNotNull(timeseriesTableMeta, "timeseriesTableMeta should not be null.");
        this.timeseriesTableMeta = timeseriesTableMeta;
    }

    public void setAnalyticalStores(List<TimeseriesAnalyticalStore> analyticalStores) {
        this.analyticalStores = analyticalStores;
    }

    public void setEnableAnalyticalStore(boolean enableAnalyticalStore) {
        this.enableAnalyticalStore = enableAnalyticalStore;
    }
}

