/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.Request;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DeleteDefinedColumnRequest
implements Request {
    private String tableName;
    private List<String> definedColumns = new ArrayList<String>();

    public void setTableName(String tableName) {
        Preconditions.checkArgument(tableName != null && !tableName.isEmpty(), "The name of table should not be null or empty.");
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void addDefinedColumn(String name) {
        Preconditions.checkArgument(name != null && !name.isEmpty(), "The name of defined column should not be null or empty.");
        this.definedColumns.add(name);
    }

    public List<String> getDefinedColumn() {
        return Collections.unmodifiableList(this.definedColumns);
    }

    @Override
    public String getOperationName() {
        return "DeleteDefinedColumn";
    }
}

