/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.http;

import com.alicloud.openservices.tablestore.core.utils.HttpUtil;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.aliyun.ots.thirdparty.org.apache.HttpHost;
import com.aliyun.ots.thirdparty.org.apache.client.utils.URIUtils;
import java.net.URI;
import java.net.URISyntaxException;

public class OTSUri {
    private URI uri;
    private HttpHost host;
    private String action;

    public OTSUri(String endpoint, String action) {
        int index;
        this.action = action;
        String delimiter = "/";
        if (!endpoint.endsWith("/")) {
            endpoint = endpoint + "/";
        }
        for (index = endpoint.length() - 1; index > 0 && endpoint.charAt(index - 1) == '/'; --index) {
        }
        endpoint = endpoint.substring(0, index + 1);
        Preconditions.checkArgument(HttpUtil.validateEndpointArgs(endpoint), "The endpoint is invalid: " + endpoint);
        try {
            this.uri = new URI(endpoint + action);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("The endpoint is invalid.", e);
        }
        this.host = URIUtils.extractHost(this.uri);
    }

    public URI getUri() {
        return this.uri;
    }

    public HttpHost getHost() {
        return this.host;
    }

    public String getAction() {
        return this.action;
    }
}

