/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore;

import com.alicloud.openservices.tablestore.ClientConfiguration;
import com.alicloud.openservices.tablestore.TableStoreCallback;
import com.alicloud.openservices.tablestore.core.AbortTransactionLauncher;
import com.alicloud.openservices.tablestore.core.AddDefinedColumnLauncher;
import com.alicloud.openservices.tablestore.core.AsyncBatchGetRowCompletion;
import com.alicloud.openservices.tablestore.core.AsyncCompletion;
import com.alicloud.openservices.tablestore.core.AsyncGetRangeCompletion;
import com.alicloud.openservices.tablestore.core.AsyncGetRowCompletion;
import com.alicloud.openservices.tablestore.core.BatchGetRowLauncher;
import com.alicloud.openservices.tablestore.core.BatchWriteRowLauncher;
import com.alicloud.openservices.tablestore.core.BulkExportLauncher;
import com.alicloud.openservices.tablestore.core.BulkImportLauncher;
import com.alicloud.openservices.tablestore.core.CallbackImpledFuture;
import com.alicloud.openservices.tablestore.core.CheckpointLauncher;
import com.alicloud.openservices.tablestore.core.CommitTransactionLauncher;
import com.alicloud.openservices.tablestore.core.ComputeSplitsBySizeLauncher;
import com.alicloud.openservices.tablestore.core.ComputeSplitsLauncher;
import com.alicloud.openservices.tablestore.core.ConnectTunnelLauncher;
import com.alicloud.openservices.tablestore.core.Constants;
import com.alicloud.openservices.tablestore.core.CreateDeliveryTaskLauncher;
import com.alicloud.openservices.tablestore.core.CreateIndexLauncher;
import com.alicloud.openservices.tablestore.core.CreateSearchIndexLauncher;
import com.alicloud.openservices.tablestore.core.CreateTableExLauncher;
import com.alicloud.openservices.tablestore.core.CreateTableLauncher;
import com.alicloud.openservices.tablestore.core.CreateTimeseriesAnalyticalStoreLauncher;
import com.alicloud.openservices.tablestore.core.CreateTimeseriesTableLauncher;
import com.alicloud.openservices.tablestore.core.CreateTunnelLauncher;
import com.alicloud.openservices.tablestore.core.DeleteDefinedColumnLauncher;
import com.alicloud.openservices.tablestore.core.DeleteDeliveryTaskLauncher;
import com.alicloud.openservices.tablestore.core.DeleteIndexLauncher;
import com.alicloud.openservices.tablestore.core.DeleteRowLauncher;
import com.alicloud.openservices.tablestore.core.DeleteSearchIndexLauncher;
import com.alicloud.openservices.tablestore.core.DeleteTableLauncher;
import com.alicloud.openservices.tablestore.core.DeleteTimeseriesAnalyticalStoreLauncher;
import com.alicloud.openservices.tablestore.core.DeleteTimeseriesMetaLauncher;
import com.alicloud.openservices.tablestore.core.DeleteTimeseriesTableLauncher;
import com.alicloud.openservices.tablestore.core.DeleteTunnelLauncher;
import com.alicloud.openservices.tablestore.core.DescribeDeliveryTaskLauncher;
import com.alicloud.openservices.tablestore.core.DescribeSearchIndexLauncher;
import com.alicloud.openservices.tablestore.core.DescribeStreamLauncher;
import com.alicloud.openservices.tablestore.core.DescribeTableLauncher;
import com.alicloud.openservices.tablestore.core.DescribeTimeseriesAnalyticalStoreLauncher;
import com.alicloud.openservices.tablestore.core.DescribeTimeseriesTableLauncher;
import com.alicloud.openservices.tablestore.core.DescribeTunnelLauncher;
import com.alicloud.openservices.tablestore.core.GetCheckpointLauncher;
import com.alicloud.openservices.tablestore.core.GetRangeLauncher;
import com.alicloud.openservices.tablestore.core.GetRowLauncher;
import com.alicloud.openservices.tablestore.core.GetShardIteratorLauncher;
import com.alicloud.openservices.tablestore.core.GetStreamRecordLauncher;
import com.alicloud.openservices.tablestore.core.GetTimeseriesDataLauncher;
import com.alicloud.openservices.tablestore.core.HeartbeatLauncher;
import com.alicloud.openservices.tablestore.core.LauncherFactory;
import com.alicloud.openservices.tablestore.core.ListDeliveryTaskLauncher;
import com.alicloud.openservices.tablestore.core.ListSearchIndexLauncher;
import com.alicloud.openservices.tablestore.core.ListStreamLauncher;
import com.alicloud.openservices.tablestore.core.ListTableLauncher;
import com.alicloud.openservices.tablestore.core.ListTimeseriesTableLauncher;
import com.alicloud.openservices.tablestore.core.ListTunnelLauncher;
import com.alicloud.openservices.tablestore.core.OperationLauncher;
import com.alicloud.openservices.tablestore.core.ParallelScanLauncher;
import com.alicloud.openservices.tablestore.core.PutRowLauncher;
import com.alicloud.openservices.tablestore.core.PutTimeseriesDataLauncher;
import com.alicloud.openservices.tablestore.core.QueryTimeseriesMetaLauncher;
import com.alicloud.openservices.tablestore.core.ReadRecordsLauncher;
import com.alicloud.openservices.tablestore.core.ResourceManager;
import com.alicloud.openservices.tablestore.core.SQLQueryLauncher;
import com.alicloud.openservices.tablestore.core.ScanTimeseriesDataLauncher;
import com.alicloud.openservices.tablestore.core.SearchLauncher;
import com.alicloud.openservices.tablestore.core.ShutdownTunnelLauncher;
import com.alicloud.openservices.tablestore.core.SplitTimeseriesScanTaskLauncher;
import com.alicloud.openservices.tablestore.core.StartLocalTransactionLauncher;
import com.alicloud.openservices.tablestore.core.TraceLogger;
import com.alicloud.openservices.tablestore.core.UpdateRowLauncher;
import com.alicloud.openservices.tablestore.core.UpdateSearchIndexLauncher;
import com.alicloud.openservices.tablestore.core.UpdateTableLauncher;
import com.alicloud.openservices.tablestore.core.UpdateTimeseriesAnalyticalStoreLauncher;
import com.alicloud.openservices.tablestore.core.UpdateTimeseriesMetaLauncher;
import com.alicloud.openservices.tablestore.core.UpdateTimeseriesTableLauncher;
import com.alicloud.openservices.tablestore.core.auth.CredentialsProvider;
import com.alicloud.openservices.tablestore.core.auth.CredentialsProviderFactory;
import com.alicloud.openservices.tablestore.core.auth.DefaultCredentialProvider;
import com.alicloud.openservices.tablestore.core.auth.ServiceCredentials;
import com.alicloud.openservices.tablestore.core.http.AsyncServiceClient;
import com.alicloud.openservices.tablestore.core.utils.HttpUtil;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.AbortTransactionRequest;
import com.alicloud.openservices.tablestore.model.AbortTransactionResponse;
import com.alicloud.openservices.tablestore.model.AddDefinedColumnRequest;
import com.alicloud.openservices.tablestore.model.AddDefinedColumnResponse;
import com.alicloud.openservices.tablestore.model.BatchGetRowRequest;
import com.alicloud.openservices.tablestore.model.BatchGetRowResponse;
import com.alicloud.openservices.tablestore.model.BatchWriteRowRequest;
import com.alicloud.openservices.tablestore.model.BatchWriteRowResponse;
import com.alicloud.openservices.tablestore.model.BulkExportRequest;
import com.alicloud.openservices.tablestore.model.BulkExportResponse;
import com.alicloud.openservices.tablestore.model.BulkImportRequest;
import com.alicloud.openservices.tablestore.model.BulkImportResponse;
import com.alicloud.openservices.tablestore.model.CommitTransactionRequest;
import com.alicloud.openservices.tablestore.model.CommitTransactionResponse;
import com.alicloud.openservices.tablestore.model.ComputeSplitsBySizeRequest;
import com.alicloud.openservices.tablestore.model.ComputeSplitsBySizeResponse;
import com.alicloud.openservices.tablestore.model.ComputeSplitsRequest;
import com.alicloud.openservices.tablestore.model.ComputeSplitsResponse;
import com.alicloud.openservices.tablestore.model.CreateIndexRequest;
import com.alicloud.openservices.tablestore.model.CreateIndexResponse;
import com.alicloud.openservices.tablestore.model.CreateTableRequest;
import com.alicloud.openservices.tablestore.model.CreateTableRequestEx;
import com.alicloud.openservices.tablestore.model.CreateTableResponse;
import com.alicloud.openservices.tablestore.model.DeleteDefinedColumnRequest;
import com.alicloud.openservices.tablestore.model.DeleteDefinedColumnResponse;
import com.alicloud.openservices.tablestore.model.DeleteIndexRequest;
import com.alicloud.openservices.tablestore.model.DeleteIndexResponse;
import com.alicloud.openservices.tablestore.model.DeleteRowRequest;
import com.alicloud.openservices.tablestore.model.DeleteRowResponse;
import com.alicloud.openservices.tablestore.model.DeleteTableRequest;
import com.alicloud.openservices.tablestore.model.DeleteTableResponse;
import com.alicloud.openservices.tablestore.model.DescribeStreamRequest;
import com.alicloud.openservices.tablestore.model.DescribeStreamResponse;
import com.alicloud.openservices.tablestore.model.DescribeTableRequest;
import com.alicloud.openservices.tablestore.model.DescribeTableResponse;
import com.alicloud.openservices.tablestore.model.GetRangeRequest;
import com.alicloud.openservices.tablestore.model.GetRangeResponse;
import com.alicloud.openservices.tablestore.model.GetRowRequest;
import com.alicloud.openservices.tablestore.model.GetRowResponse;
import com.alicloud.openservices.tablestore.model.GetShardIteratorRequest;
import com.alicloud.openservices.tablestore.model.GetShardIteratorResponse;
import com.alicloud.openservices.tablestore.model.GetStreamRecordRequest;
import com.alicloud.openservices.tablestore.model.GetStreamRecordResponse;
import com.alicloud.openservices.tablestore.model.ListStreamRequest;
import com.alicloud.openservices.tablestore.model.ListStreamResponse;
import com.alicloud.openservices.tablestore.model.ListTableRequest;
import com.alicloud.openservices.tablestore.model.ListTableResponse;
import com.alicloud.openservices.tablestore.model.PutRowRequest;
import com.alicloud.openservices.tablestore.model.PutRowResponse;
import com.alicloud.openservices.tablestore.model.RetryStrategy;
import com.alicloud.openservices.tablestore.model.StartLocalTransactionRequest;
import com.alicloud.openservices.tablestore.model.StartLocalTransactionResponse;
import com.alicloud.openservices.tablestore.model.UpdateRowRequest;
import com.alicloud.openservices.tablestore.model.UpdateRowResponse;
import com.alicloud.openservices.tablestore.model.UpdateTableRequest;
import com.alicloud.openservices.tablestore.model.UpdateTableResponse;
import com.alicloud.openservices.tablestore.model.delivery.CreateDeliveryTaskRequest;
import com.alicloud.openservices.tablestore.model.delivery.CreateDeliveryTaskResponse;
import com.alicloud.openservices.tablestore.model.delivery.DeleteDeliveryTaskRequest;
import com.alicloud.openservices.tablestore.model.delivery.DeleteDeliveryTaskResponse;
import com.alicloud.openservices.tablestore.model.delivery.DescribeDeliveryTaskRequest;
import com.alicloud.openservices.tablestore.model.delivery.DescribeDeliveryTaskResponse;
import com.alicloud.openservices.tablestore.model.delivery.ListDeliveryTaskRequest;
import com.alicloud.openservices.tablestore.model.delivery.ListDeliveryTaskResponse;
import com.alicloud.openservices.tablestore.model.search.CreateSearchIndexRequest;
import com.alicloud.openservices.tablestore.model.search.CreateSearchIndexResponse;
import com.alicloud.openservices.tablestore.model.search.DeleteSearchIndexRequest;
import com.alicloud.openservices.tablestore.model.search.DeleteSearchIndexResponse;
import com.alicloud.openservices.tablestore.model.search.DescribeSearchIndexRequest;
import com.alicloud.openservices.tablestore.model.search.DescribeSearchIndexResponse;
import com.alicloud.openservices.tablestore.model.search.ListSearchIndexRequest;
import com.alicloud.openservices.tablestore.model.search.ListSearchIndexResponse;
import com.alicloud.openservices.tablestore.model.search.ParallelScanRequest;
import com.alicloud.openservices.tablestore.model.search.ParallelScanResponse;
import com.alicloud.openservices.tablestore.model.search.SearchRequest;
import com.alicloud.openservices.tablestore.model.search.SearchResponse;
import com.alicloud.openservices.tablestore.model.search.UpdateSearchIndexRequest;
import com.alicloud.openservices.tablestore.model.search.UpdateSearchIndexResponse;
import com.alicloud.openservices.tablestore.model.sql.SQLQueryRequest;
import com.alicloud.openservices.tablestore.model.sql.SQLQueryResponse;
import com.alicloud.openservices.tablestore.model.timeseries.CreateTimeseriesAnalyticalStoreRequest;
import com.alicloud.openservices.tablestore.model.timeseries.CreateTimeseriesAnalyticalStoreResponse;
import com.alicloud.openservices.tablestore.model.timeseries.CreateTimeseriesTableRequest;
import com.alicloud.openservices.tablestore.model.timeseries.CreateTimeseriesTableResponse;
import com.alicloud.openservices.tablestore.model.timeseries.DeleteTimeseriesAnalyticalStoreRequest;
import com.alicloud.openservices.tablestore.model.timeseries.DeleteTimeseriesAnalyticalStoreResponse;
import com.alicloud.openservices.tablestore.model.timeseries.DeleteTimeseriesMetaRequest;
import com.alicloud.openservices.tablestore.model.timeseries.DeleteTimeseriesMetaResponse;
import com.alicloud.openservices.tablestore.model.timeseries.DeleteTimeseriesTableRequest;
import com.alicloud.openservices.tablestore.model.timeseries.DeleteTimeseriesTableResponse;
import com.alicloud.openservices.tablestore.model.timeseries.DescribeTimeseriesAnalyticalStoreRequest;
import com.alicloud.openservices.tablestore.model.timeseries.DescribeTimeseriesAnalyticalStoreResponse;
import com.alicloud.openservices.tablestore.model.timeseries.DescribeTimeseriesTableRequest;
import com.alicloud.openservices.tablestore.model.timeseries.DescribeTimeseriesTableResponse;
import com.alicloud.openservices.tablestore.model.timeseries.GetTimeseriesDataRequest;
import com.alicloud.openservices.tablestore.model.timeseries.GetTimeseriesDataResponse;
import com.alicloud.openservices.tablestore.model.timeseries.ListTimeseriesTableRequest;
import com.alicloud.openservices.tablestore.model.timeseries.ListTimeseriesTableResponse;
import com.alicloud.openservices.tablestore.model.timeseries.PutTimeseriesDataRequest;
import com.alicloud.openservices.tablestore.model.timeseries.PutTimeseriesDataResponse;
import com.alicloud.openservices.tablestore.model.timeseries.QueryTimeseriesMetaRequest;
import com.alicloud.openservices.tablestore.model.timeseries.QueryTimeseriesMetaResponse;
import com.alicloud.openservices.tablestore.model.timeseries.ScanTimeseriesDataRequest;
import com.alicloud.openservices.tablestore.model.timeseries.ScanTimeseriesDataResponse;
import com.alicloud.openservices.tablestore.model.timeseries.SplitTimeseriesScanTaskRequest;
import com.alicloud.openservices.tablestore.model.timeseries.SplitTimeseriesScanTaskResponse;
import com.alicloud.openservices.tablestore.model.timeseries.UpdateTimeseriesAnalyticalStoreRequest;
import com.alicloud.openservices.tablestore.model.timeseries.UpdateTimeseriesAnalyticalStoreResponse;
import com.alicloud.openservices.tablestore.model.timeseries.UpdateTimeseriesMetaRequest;
import com.alicloud.openservices.tablestore.model.timeseries.UpdateTimeseriesMetaResponse;
import com.alicloud.openservices.tablestore.model.timeseries.UpdateTimeseriesTableRequest;
import com.alicloud.openservices.tablestore.model.timeseries.UpdateTimeseriesTableResponse;
import com.alicloud.openservices.tablestore.model.tunnel.CreateTunnelRequest;
import com.alicloud.openservices.tablestore.model.tunnel.CreateTunnelResponse;
import com.alicloud.openservices.tablestore.model.tunnel.DeleteTunnelRequest;
import com.alicloud.openservices.tablestore.model.tunnel.DeleteTunnelResponse;
import com.alicloud.openservices.tablestore.model.tunnel.DescribeTunnelRequest;
import com.alicloud.openservices.tablestore.model.tunnel.DescribeTunnelResponse;
import com.alicloud.openservices.tablestore.model.tunnel.ListTunnelRequest;
import com.alicloud.openservices.tablestore.model.tunnel.ListTunnelResponse;
import com.alicloud.openservices.tablestore.model.tunnel.internal.CheckpointRequest;
import com.alicloud.openservices.tablestore.model.tunnel.internal.CheckpointResponse;
import com.alicloud.openservices.tablestore.model.tunnel.internal.ConnectTunnelRequest;
import com.alicloud.openservices.tablestore.model.tunnel.internal.ConnectTunnelResponse;
import com.alicloud.openservices.tablestore.model.tunnel.internal.GetCheckpointRequest;
import com.alicloud.openservices.tablestore.model.tunnel.internal.GetCheckpointResponse;
import com.alicloud.openservices.tablestore.model.tunnel.internal.HeartbeatRequest;
import com.alicloud.openservices.tablestore.model.tunnel.internal.HeartbeatResponse;
import com.alicloud.openservices.tablestore.model.tunnel.internal.ReadRecordsRequest;
import com.alicloud.openservices.tablestore.model.tunnel.internal.ReadRecordsResponse;
import com.alicloud.openservices.tablestore.model.tunnel.internal.ShutdownTunnelRequest;
import com.alicloud.openservices.tablestore.model.tunnel.internal.ShutdownTunnelResponse;
import com.aliyun.ots.thirdparty.org.apache.concurrent.FutureCallback;
import com.google.common.cache.Cache;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;

public class InternalClient {
    private static int AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();
    private String endpoint;
    private String instanceName;
    private CredentialsProvider crdsProvider;
    private ResourceManager resourceManager;
    private AsyncServiceClient httpClient;
    private ScheduledExecutorService retryExecutor;
    private ExecutorService callbackExecutor;
    private ClientConfiguration clientConfig;
    private RetryStrategy retryStrategy;
    private LauncherFactory launcherFactory;
    private Random random = new Random();
    private Cache<String, Long> timeseriesMetaCache;

    public InternalClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName) {
        this(endpoint, accessKeyId, accessKeySecret, instanceName, null);
    }

    public InternalClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, ClientConfiguration config) {
        this(endpoint, accessKeyId, accessKeySecret, instanceName, config, null);
    }

    public InternalClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, ClientConfiguration config, ExecutorService callbackExecutor) {
        this(endpoint, accessKeyId, accessKeySecret, instanceName, config, callbackExecutor, null);
    }

    public InternalClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, ClientConfiguration config, ExecutorService callbackExecutor, String stsToken) {
        this(endpoint, CredentialsProviderFactory.newDefaultCredentialProvider(accessKeyId, accessKeySecret, stsToken), instanceName, config, new ResourceManager(config, callbackExecutor));
    }

    public InternalClient(String endpoint, CredentialsProvider credsProvider, String instanceName, ClientConfiguration config, ResourceManager resourceManager) {
        Preconditions.checkArgument(endpoint != null && !endpoint.isEmpty(), "The end point should not be null or empty.");
        Preconditions.checkArgument(instanceName != null && !instanceName.isEmpty(), "The name of instance should not be null or empty.");
        Preconditions.checkArgument(instanceName.length() == instanceName.getBytes(Constants.UTF8_CHARSET).length, "InstanceName should not have multibyte character.");
        Preconditions.checkArgument(HttpUtil.checkSSRF(instanceName), "The instance name is invalid: " + instanceName);
        if (!endpoint.startsWith("http://") && !endpoint.startsWith("https://")) {
            throw new IllegalArgumentException("the endpoint must start with \"http://\" or \"https://\".");
        }
        this.endpoint = endpoint;
        this.crdsProvider = credsProvider;
        if (config == null) {
            config = new ClientConfiguration();
        }
        this.clientConfig = config;
        this.retryStrategy = config.getRetryStrategy();
        this.instanceName = instanceName;
        this.resourceManager = resourceManager != null ? resourceManager : new ResourceManager(this.clientConfig);
        this.httpClient = this.resourceManager.getResources().getHttpClient();
        this.retryExecutor = this.resourceManager.getResources().getRetryExecutor();
        this.callbackExecutor = this.resourceManager.getResources().getCallbackExecutor();
        this.launcherFactory = new LauncherFactory(endpoint, instanceName, this.httpClient, this.crdsProvider, config);
    }

    public void setExtraHeaders(Map<String, String> extraHeaders) {
        this.httpClient.setExtraHeaders(extraHeaders);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public ClientConfiguration getClientConfig() {
        return this.clientConfig;
    }

    protected void setTimeseriesMetaCache(Cache<String, Long> cache) {
        this.timeseriesMetaCache = cache;
    }

    protected Cache<String, Long> getTimeseriesMetaCache() {
        return this.timeseriesMetaCache;
    }

    private TraceLogger getTraceLogger() {
        String traceId = new UUID(this.random.nextLong(), new Random().nextLong()).toString();
        return new TraceLogger(traceId, this.clientConfig.getTimeThresholdOfTraceLogger());
    }

    public Future<ListTableResponse> listTable(TableStoreCallback<ListTableRequest, ListTableResponse> callback) {
        ListTableRequest request = new ListTableRequest();
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        ListTableLauncher launcher = this.launcherFactory.listTable(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<ListTableResponse>)completion);
        return f;
    }

    public Future<CreateTableResponse> createTable(CreateTableRequest request, TableStoreCallback<CreateTableRequest, CreateTableResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        CreateTableLauncher launcher = this.launcherFactory.createTable(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<CreateTableResponse>)completion);
        return f;
    }

    public Future<CreateTableResponse> createTableEx(CreateTableRequestEx request, TableStoreCallback<CreateTableRequestEx, CreateTableResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        CreateTableExLauncher launcher = this.launcherFactory.createTableEx(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<CreateTableResponse>)completion);
        return f;
    }

    public Future<DescribeTableResponse> describeTable(DescribeTableRequest request, TableStoreCallback<DescribeTableRequest, DescribeTableResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        DescribeTableLauncher launcher = this.launcherFactory.describeTable(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<DescribeTableResponse>)completion);
        return f;
    }

    public Future<DeleteTableResponse> deleteTable(DeleteTableRequest request, TableStoreCallback<DeleteTableRequest, DeleteTableResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        DeleteTableLauncher launcher = this.launcherFactory.deleteTable(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<DeleteTableResponse>)completion);
        return f;
    }

    public Future<UpdateTableResponse> updateTable(UpdateTableRequest request, TableStoreCallback<UpdateTableRequest, UpdateTableResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        UpdateTableLauncher launcher = this.launcherFactory.updateTable(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<UpdateTableResponse>)completion);
        return f;
    }

    public Future<CreateIndexResponse> createIndex(CreateIndexRequest request, TableStoreCallback<CreateIndexRequest, CreateIndexResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        CreateIndexLauncher launcher = this.launcherFactory.createIndex(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<CreateIndexResponse>)completion);
        return f;
    }

    public Future<DeleteIndexResponse> deleteIndex(DeleteIndexRequest request, TableStoreCallback<DeleteIndexRequest, DeleteIndexResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        DeleteIndexLauncher launcher = this.launcherFactory.deleteIndex(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<DeleteIndexResponse>)completion);
        return f;
    }

    public Future<AddDefinedColumnResponse> addDefinedColumn(AddDefinedColumnRequest request, TableStoreCallback<AddDefinedColumnRequest, AddDefinedColumnResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        AddDefinedColumnLauncher launcher = this.launcherFactory.addDefinedColumn(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<AddDefinedColumnResponse>)completion);
        return f;
    }

    public Future<DeleteDefinedColumnResponse> deleteDefinedColumn(DeleteDefinedColumnRequest request, TableStoreCallback<DeleteDefinedColumnRequest, DeleteDefinedColumnResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        DeleteDefinedColumnLauncher launcher = this.launcherFactory.deleteDefinedColumn(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<DeleteDefinedColumnResponse>)completion);
        return f;
    }

    public Future<GetRowResponse> getRowInternal(GetRowRequest request, TableStoreCallback<GetRowRequest, GetRowResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        GetRowLauncher launcher = this.launcherFactory.getRow(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<GetRowResponse>)completion);
        return f;
    }

    public Future<GetRowResponse> getRow(GetRowRequest request, TableStoreCallback<GetRowRequest, GetRowResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        GetRowLauncher launcher = this.launcherFactory.getRow(tracer, retry, request);
        AsyncGetRowCompletion completion = new AsyncGetRowCompletion((OperationLauncher<GetRowRequest, GetRowResponse>)launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<GetRowResponse>)completion);
        return f;
    }

    public Future<PutRowResponse> putRow(PutRowRequest request, TableStoreCallback<PutRowRequest, PutRowResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        PutRowLauncher launcher = this.launcherFactory.putRow(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<PutRowResponse>)completion);
        return f;
    }

    public Future<UpdateRowResponse> updateRow(UpdateRowRequest request, TableStoreCallback<UpdateRowRequest, UpdateRowResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        UpdateRowLauncher launcher = this.launcherFactory.updateRow(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<UpdateRowResponse>)completion);
        return f;
    }

    public Future<DeleteRowResponse> deleteRow(DeleteRowRequest request, TableStoreCallback<DeleteRowRequest, DeleteRowResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        DeleteRowLauncher launcher = this.launcherFactory.deleteRow(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<DeleteRowResponse>)completion);
        return f;
    }

    public Future<BatchGetRowResponse> batchGetRowInternal(BatchGetRowRequest request, TableStoreCallback<BatchGetRowRequest, BatchGetRowResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        BatchGetRowLauncher launcher = this.launcherFactory.batchGetRow(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<BatchGetRowResponse>)completion);
        return f;
    }

    public Future<BatchGetRowResponse> batchGetRow(BatchGetRowRequest request, TableStoreCallback<BatchGetRowRequest, BatchGetRowResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        BatchGetRowLauncher launcher = this.launcherFactory.batchGetRow(tracer, retry, request);
        AsyncBatchGetRowCompletion completion = new AsyncBatchGetRowCompletion((OperationLauncher)launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<BatchGetRowResponse>)completion);
        return f;
    }

    public Future<BatchWriteRowResponse> batchWriteRow(BatchWriteRowRequest request, TableStoreCallback<BatchWriteRowRequest, BatchWriteRowResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        BatchWriteRowLauncher launcher = this.launcherFactory.batchWriteRow(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<BatchWriteRowResponse>)completion);
        return f;
    }

    public Future<BulkImportResponse> bulkImport(BulkImportRequest request, TableStoreCallback<BulkImportRequest, BulkImportResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        BulkImportLauncher launcher = this.launcherFactory.bulkImport(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<BulkImportResponse>)completion);
        return f;
    }

    public Future<GetRangeResponse> getRangeInternal(GetRangeRequest request, TableStoreCallback<GetRangeRequest, GetRangeResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        GetRangeLauncher launcher = this.launcherFactory.getRange(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<GetRangeResponse>)completion);
        return f;
    }

    public Future<BulkExportResponse> bulkExportInternal(BulkExportRequest request, TableStoreCallback<BulkExportRequest, BulkExportResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        BulkExportLauncher launcher = this.launcherFactory.bulkExport(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<BulkExportResponse>)completion);
        return f;
    }

    public Future<GetRangeResponse> getRange(GetRangeRequest request, TableStoreCallback<GetRangeRequest, GetRangeResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        GetRangeLauncher launcher = this.launcherFactory.getRange(tracer, retry, request);
        AsyncGetRangeCompletion completion = new AsyncGetRangeCompletion((OperationLauncher<GetRangeRequest, GetRangeResponse>)launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<GetRangeResponse>)completion);
        return f;
    }

    public Future<BulkExportResponse> bulkExport(BulkExportRequest request, TableStoreCallback<BulkExportRequest, BulkExportResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        BulkExportLauncher launcher = this.launcherFactory.bulkExport(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<BulkExportResponse>)completion);
        return f;
    }

    public Future<ComputeSplitsBySizeResponse> computeSplitsBySize(ComputeSplitsBySizeRequest request, TableStoreCallback<ComputeSplitsBySizeRequest, ComputeSplitsBySizeResponse> callback) {
        Preconditions.checkNotNull(request);
        Preconditions.checkStringNotNullAndEmpty(request.getTableName(), "The table name for ComputeSplitsBySize should not be null or empty.");
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        ComputeSplitsBySizeLauncher launcher = this.launcherFactory.computeSplitsBySize(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<ComputeSplitsBySizeResponse>)completion);
        return f;
    }

    public void shutdown() {
        this.resourceManager.shutdown();
        if (this.timeseriesMetaCache != null) {
            this.timeseriesMetaCache.invalidateAll();
        }
    }

    public Future<ListStreamResponse> listStream(ListStreamRequest request, TableStoreCallback<ListStreamRequest, ListStreamResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        ListStreamLauncher launcher = this.launcherFactory.listStream(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<ListStreamResponse>)completion);
        return f;
    }

    public Future<DescribeStreamResponse> describeStream(DescribeStreamRequest request, TableStoreCallback<DescribeStreamRequest, DescribeStreamResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        DescribeStreamLauncher launcher = this.launcherFactory.describeStream(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<DescribeStreamResponse>)completion);
        return f;
    }

    public Future<GetShardIteratorResponse> getShardIterator(GetShardIteratorRequest request, TableStoreCallback<GetShardIteratorRequest, GetShardIteratorResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        GetShardIteratorLauncher launcher = this.launcherFactory.getShardIterator(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<GetShardIteratorResponse>)completion);
        return f;
    }

    public Future<GetStreamRecordResponse> getStreamRecord(GetStreamRecordRequest request, TableStoreCallback<GetStreamRecordRequest, GetStreamRecordResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        GetStreamRecordLauncher launcher = this.launcherFactory.getStreamRecord(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<GetStreamRecordResponse>)completion);
        return f;
    }

    public Future<StartLocalTransactionResponse> startLocalTransaction(StartLocalTransactionRequest request, TableStoreCallback<StartLocalTransactionRequest, StartLocalTransactionResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        StartLocalTransactionLauncher launcher = this.launcherFactory.startLocalTransaction(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<StartLocalTransactionResponse>)completion);
        return f;
    }

    public Future<CommitTransactionResponse> commitTransaction(CommitTransactionRequest request, TableStoreCallback<CommitTransactionRequest, CommitTransactionResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        CommitTransactionLauncher launcher = this.launcherFactory.commitTransaction(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<CommitTransactionResponse>)completion);
        return f;
    }

    public Future<AbortTransactionResponse> abortTransaction(AbortTransactionRequest request, TableStoreCallback<AbortTransactionRequest, AbortTransactionResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        AbortTransactionLauncher launcher = this.launcherFactory.abortTransaction(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<AbortTransactionResponse>)completion);
        return f;
    }

    public Future<CreateSearchIndexResponse> createSearchIndex(CreateSearchIndexRequest request, TableStoreCallback<CreateSearchIndexRequest, CreateSearchIndexResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        CreateSearchIndexLauncher launcher = this.launcherFactory.createSearchIndex(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<CreateSearchIndexResponse>)completion);
        return f;
    }

    public Future<UpdateSearchIndexResponse> updateSearchIndex(UpdateSearchIndexRequest request, TableStoreCallback<UpdateSearchIndexRequest, UpdateSearchIndexResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        UpdateSearchIndexLauncher launcher = this.launcherFactory.updateSearchIndex(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<UpdateSearchIndexResponse>)completion);
        return f;
    }

    public Future<ListSearchIndexResponse> listSearchIndex(ListSearchIndexRequest request, TableStoreCallback<ListSearchIndexRequest, ListSearchIndexResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        ListSearchIndexLauncher launcher = this.launcherFactory.listSearchIndex(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<ListSearchIndexResponse>)completion);
        return f;
    }

    public Future<DeleteSearchIndexResponse> deleteSearchIndex(DeleteSearchIndexRequest request, TableStoreCallback<DeleteSearchIndexRequest, DeleteSearchIndexResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        DeleteSearchIndexLauncher launcher = this.launcherFactory.deleteSearchIndex(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<DeleteSearchIndexResponse>)completion);
        return f;
    }

    public Future<DescribeSearchIndexResponse> describeSearchIndex(DescribeSearchIndexRequest request, TableStoreCallback<DescribeSearchIndexRequest, DescribeSearchIndexResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        DescribeSearchIndexLauncher launcher = this.launcherFactory.describeSearchIndex(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<DescribeSearchIndexResponse>)completion);
        return f;
    }

    public Future<ComputeSplitsResponse> computeSplits(ComputeSplitsRequest request, TableStoreCallback<ComputeSplitsRequest, ComputeSplitsResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        ComputeSplitsLauncher launcher = this.launcherFactory.computeSplits(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<ComputeSplitsResponse>)completion);
        return f;
    }

    public Future<ParallelScanResponse> parallelScan(ParallelScanRequest request, TableStoreCallback<ParallelScanRequest, ParallelScanResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        ParallelScanLauncher launcher = this.launcherFactory.parallelScan(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<ParallelScanResponse>)completion);
        return f;
    }

    public Future<SearchResponse> search(SearchRequest request, TableStoreCallback<SearchRequest, SearchResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        SearchLauncher launcher = this.launcherFactory.search(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<SearchResponse>)completion);
        return f;
    }

    public Future<CreateTunnelResponse> createTunnel(CreateTunnelRequest request, TableStoreCallback<CreateTunnelRequest, CreateTunnelResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        CreateTunnelLauncher launcher = this.launcherFactory.createTunnel(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<CreateTunnelResponse>)completion);
        return f;
    }

    public Future<ListTunnelResponse> listTunnel(ListTunnelRequest request, TableStoreCallback<ListTunnelRequest, ListTunnelResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        ListTunnelLauncher launcher = this.launcherFactory.listTunnel(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<ListTunnelResponse>)completion);
        return f;
    }

    public Future<DescribeTunnelResponse> describeTunnel(DescribeTunnelRequest request, TableStoreCallback<DescribeTunnelRequest, DescribeTunnelResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        DescribeTunnelLauncher launcher = this.launcherFactory.describeTunnel(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<DescribeTunnelResponse>)completion);
        return f;
    }

    public Future<DeleteTunnelResponse> deleteTunnel(DeleteTunnelRequest request, TableStoreCallback<DeleteTunnelRequest, DeleteTunnelResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        DeleteTunnelLauncher launcher = this.launcherFactory.deleteTunnel(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<DeleteTunnelResponse>)completion);
        return f;
    }

    public Future<ConnectTunnelResponse> connectTunnel(ConnectTunnelRequest request, TableStoreCallback<ConnectTunnelRequest, ConnectTunnelResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        ConnectTunnelLauncher launcher = this.launcherFactory.connectTunnel(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<ConnectTunnelResponse>)completion);
        return f;
    }

    public Future<HeartbeatResponse> heartbeat(HeartbeatRequest request, TableStoreCallback<HeartbeatRequest, HeartbeatResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        HeartbeatLauncher launcher = this.launcherFactory.heartbeat(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<HeartbeatResponse>)completion);
        return f;
    }

    public Future<ShutdownTunnelResponse> shutdownTunnel(ShutdownTunnelRequest request, TableStoreCallback<ShutdownTunnelRequest, ShutdownTunnelResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        ShutdownTunnelLauncher launcher = this.launcherFactory.shutdownTunnel(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<ShutdownTunnelResponse>)completion);
        return f;
    }

    public Future<GetCheckpointResponse> getCheckpoint(GetCheckpointRequest request, TableStoreCallback<GetCheckpointRequest, GetCheckpointResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        GetCheckpointLauncher launcher = this.launcherFactory.getCheckpoint(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<GetCheckpointResponse>)completion);
        return f;
    }

    public Future<ReadRecordsResponse> readRecords(ReadRecordsRequest request, TableStoreCallback<ReadRecordsRequest, ReadRecordsResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        ReadRecordsLauncher launcher = this.launcherFactory.readRecords(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<ReadRecordsResponse>)completion);
        return f;
    }

    public Future<CheckpointResponse> checkpoint(CheckpointRequest request, TableStoreCallback<CheckpointRequest, CheckpointResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        CheckpointLauncher launcher = this.launcherFactory.checkpoint(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<CheckpointResponse>)completion);
        return f;
    }

    public Future<CreateDeliveryTaskResponse> createDeliveryTask(CreateDeliveryTaskRequest request, TableStoreCallback<CreateDeliveryTaskRequest, CreateDeliveryTaskResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        CreateDeliveryTaskLauncher launcher = this.launcherFactory.createDeliveryTask(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<CreateDeliveryTaskResponse>)completion);
        return f;
    }

    public Future<DeleteDeliveryTaskResponse> deleteDeliveryTask(DeleteDeliveryTaskRequest request, TableStoreCallback<DeleteDeliveryTaskRequest, DeleteDeliveryTaskResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        DeleteDeliveryTaskLauncher launcher = this.launcherFactory.deleteDeliveryTask(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<DeleteDeliveryTaskResponse>)completion);
        return f;
    }

    public Future<DescribeDeliveryTaskResponse> describeDeliveryTask(DescribeDeliveryTaskRequest request, TableStoreCallback<DescribeDeliveryTaskRequest, DescribeDeliveryTaskResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        DescribeDeliveryTaskLauncher launcher = this.launcherFactory.describeDeliveryTask(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<DescribeDeliveryTaskResponse>)completion);
        return f;
    }

    public Future<ListDeliveryTaskResponse> listDeliveryTask(ListDeliveryTaskRequest request, TableStoreCallback<ListDeliveryTaskRequest, ListDeliveryTaskResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        ListDeliveryTaskLauncher launcher = this.launcherFactory.listDeliveryTask(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<ListDeliveryTaskResponse>)completion);
        return f;
    }

    public Future<CreateTimeseriesTableResponse> createTimeseriesTable(CreateTimeseriesTableRequest request, TableStoreCallback<CreateTimeseriesTableRequest, CreateTimeseriesTableResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        CreateTimeseriesTableLauncher launcher = this.launcherFactory.createTimeseriesTable(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<CreateTimeseriesTableResponse>)completion);
        return f;
    }

    public Future<DeleteTimeseriesTableResponse> deleteTimeseriesTable(DeleteTimeseriesTableRequest request, TableStoreCallback<DeleteTimeseriesTableRequest, DeleteTimeseriesTableResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        DeleteTimeseriesTableLauncher launcher = this.launcherFactory.deleteTimeseriesTable(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<DeleteTimeseriesTableResponse>)completion);
        return f;
    }

    public Future<DescribeTimeseriesTableResponse> describeTimeseriesTable(DescribeTimeseriesTableRequest request, TableStoreCallback<DescribeTimeseriesTableRequest, DescribeTimeseriesTableResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        DescribeTimeseriesTableLauncher launcher = this.launcherFactory.describeTimeseriesTable(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<DescribeTimeseriesTableResponse>)completion);
        return f;
    }

    public Future<UpdateTimeseriesTableResponse> updateTimeseriesTable(UpdateTimeseriesTableRequest request, TableStoreCallback<UpdateTimeseriesTableRequest, UpdateTimeseriesTableResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        UpdateTimeseriesTableLauncher launcher = this.launcherFactory.updateTimeseriesTable(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<UpdateTimeseriesTableResponse>)completion);
        return f;
    }

    public Future<PutTimeseriesDataResponse> putTimeseriesData(PutTimeseriesDataRequest request, TableStoreCallback<PutTimeseriesDataRequest, PutTimeseriesDataResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        PutTimeseriesDataLauncher launcher = this.launcherFactory.putTimeseriesData(tracer, retry, request, this.timeseriesMetaCache);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<PutTimeseriesDataResponse>)completion);
        return f;
    }

    public Future<GetTimeseriesDataResponse> getTimeseriesData(GetTimeseriesDataRequest request, TableStoreCallback<GetTimeseriesDataRequest, GetTimeseriesDataResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        GetTimeseriesDataLauncher launcher = this.launcherFactory.getTimeseriesData(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<GetTimeseriesDataResponse>)completion);
        return f;
    }

    public Future<ListTimeseriesTableResponse> listTimeseriesTable(TableStoreCallback<ListTimeseriesTableRequest, ListTimeseriesTableResponse> callback) {
        ListTimeseriesTableRequest request = new ListTimeseriesTableRequest();
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        ListTimeseriesTableLauncher launcher = this.launcherFactory.listTimeseriesTable(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<ListTimeseriesTableResponse>)completion);
        return f;
    }

    public Future<QueryTimeseriesMetaResponse> queryTimeseriesMeta(QueryTimeseriesMetaRequest request, TableStoreCallback<QueryTimeseriesMetaRequest, QueryTimeseriesMetaResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        QueryTimeseriesMetaLauncher launcher = this.launcherFactory.queryTimeseriesMeta(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<QueryTimeseriesMetaResponse>)completion);
        return f;
    }

    public Future<UpdateTimeseriesMetaResponse> updateTimeseriesMeta(UpdateTimeseriesMetaRequest request, TableStoreCallback<UpdateTimeseriesMetaRequest, UpdateTimeseriesMetaResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        UpdateTimeseriesMetaLauncher launcher = this.launcherFactory.updateTimeseriesMeta(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<UpdateTimeseriesMetaResponse>)completion);
        return f;
    }

    public Future<DeleteTimeseriesMetaResponse> deleteTimeseriesMeta(DeleteTimeseriesMetaRequest request, TableStoreCallback<DeleteTimeseriesMetaRequest, DeleteTimeseriesMetaResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        DeleteTimeseriesMetaLauncher launcher = this.launcherFactory.deleteTimeseriesMeta(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<DeleteTimeseriesMetaResponse>)completion);
        return f;
    }

    public Future<SplitTimeseriesScanTaskResponse> splitTimeseriesScanTask(SplitTimeseriesScanTaskRequest request, TableStoreCallback<SplitTimeseriesScanTaskRequest, SplitTimeseriesScanTaskResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        SplitTimeseriesScanTaskLauncher launcher = this.launcherFactory.splitTimeseriesScanTask(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<SplitTimeseriesScanTaskResponse>)completion);
        return f;
    }

    public Future<ScanTimeseriesDataResponse> scanTimeseriesData(ScanTimeseriesDataRequest request, TableStoreCallback<ScanTimeseriesDataRequest, ScanTimeseriesDataResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        ScanTimeseriesDataLauncher launcher = this.launcherFactory.scanTimeseriesData(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<ScanTimeseriesDataResponse>)completion);
        return f;
    }

    public Future<CreateTimeseriesAnalyticalStoreResponse> createTimeseriesAnalyticalStore(CreateTimeseriesAnalyticalStoreRequest request, TableStoreCallback<CreateTimeseriesAnalyticalStoreRequest, CreateTimeseriesAnalyticalStoreResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        CreateTimeseriesAnalyticalStoreLauncher launcher = this.launcherFactory.createTimeseriesAnalyticalStore(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<CreateTimeseriesAnalyticalStoreResponse>)completion);
        return f;
    }

    public Future<DeleteTimeseriesAnalyticalStoreResponse> deleteTimeseriesAnalyticalStore(DeleteTimeseriesAnalyticalStoreRequest request, TableStoreCallback<DeleteTimeseriesAnalyticalStoreRequest, DeleteTimeseriesAnalyticalStoreResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        DeleteTimeseriesAnalyticalStoreLauncher launcher = this.launcherFactory.deleteTimeseriesAnalyticalStore(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<DeleteTimeseriesAnalyticalStoreResponse>)completion);
        return f;
    }

    public Future<DescribeTimeseriesAnalyticalStoreResponse> describeTimeseriesAnalyticalStore(DescribeTimeseriesAnalyticalStoreRequest request, TableStoreCallback<DescribeTimeseriesAnalyticalStoreRequest, DescribeTimeseriesAnalyticalStoreResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        DescribeTimeseriesAnalyticalStoreLauncher launcher = this.launcherFactory.describeTimeseriesAnalyticalStore(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<DescribeTimeseriesAnalyticalStoreResponse>)completion);
        return f;
    }

    public Future<UpdateTimeseriesAnalyticalStoreResponse> updateTimeseriesAnalyticalStore(UpdateTimeseriesAnalyticalStoreRequest request, TableStoreCallback<UpdateTimeseriesAnalyticalStoreRequest, UpdateTimeseriesAnalyticalStoreResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        UpdateTimeseriesAnalyticalStoreLauncher launcher = this.launcherFactory.updateTimeseriesAnalyticalStore(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<UpdateTimeseriesAnalyticalStoreResponse>)completion);
        return f;
    }

    public void setCredentials(ServiceCredentials credentials) {
        DefaultCredentialProvider newCrdsProvider = CredentialsProviderFactory.newDefaultCredentialProvider(credentials.getAccessKeyId(), credentials.getAccessKeySecret(), credentials.getSecurityToken());
        this.switchCredentialsProvider(newCrdsProvider);
    }

    public void switchCredentialsProvider(CredentialsProvider newCrdsProvider) {
        this.crdsProvider = newCrdsProvider;
        this.launcherFactory.setCredentialsProvider(newCrdsProvider);
    }

    public Future<SQLQueryResponse> sqlQuery(SQLQueryRequest request, TableStoreCallback<SQLQueryRequest, SQLQueryResponse> callback) {
        Preconditions.checkNotNull(request);
        TraceLogger tracer = this.getTraceLogger();
        RetryStrategy retry = this.retryStrategy.clone();
        SQLQueryLauncher launcher = this.launcherFactory.sqlQuery(tracer, retry, request);
        AsyncCompletion completion = new AsyncCompletion(launcher, request, tracer, this.callbackExecutor, retry, this.retryExecutor);
        CallbackImpledFuture f = new CallbackImpledFuture();
        completion.watchBy((TableStoreCallback)f);
        if (callback != null) {
            f.watchBy((TableStoreCallback)callback);
        }
        launcher.fire(request, (FutureCallback<SQLQueryResponse>)completion);
        return f;
    }
}

