/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore;

import com.alicloud.openservices.tablestore.AsyncClient;
import com.alicloud.openservices.tablestore.AsyncClientInterface;
import com.alicloud.openservices.tablestore.ClientConfiguration;
import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.TableStoreCallback;
import com.alicloud.openservices.tablestore.TableStoreWriter;
import com.alicloud.openservices.tablestore.core.ResourceManager;
import com.alicloud.openservices.tablestore.core.auth.DefaultCredentialProvider;
import com.alicloud.openservices.tablestore.core.auth.ServiceCredentials;
import com.alicloud.openservices.tablestore.core.utils.ParamChecker;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.ConsumedCapacity;
import com.alicloud.openservices.tablestore.model.DescribeTableRequest;
import com.alicloud.openservices.tablestore.model.DescribeTableResponse;
import com.alicloud.openservices.tablestore.model.RowChange;
import com.alicloud.openservices.tablestore.model.TableMeta;
import com.alicloud.openservices.tablestore.writer.Bucket;
import com.alicloud.openservices.tablestore.writer.Group;
import com.alicloud.openservices.tablestore.writer.RowWriteResult;
import com.alicloud.openservices.tablestore.writer.WriterConfig;
import com.alicloud.openservices.tablestore.writer.WriterResult;
import com.alicloud.openservices.tablestore.writer.WriterStatistics;
import com.alicloud.openservices.tablestore.writer.config.BucketConfig;
import com.alicloud.openservices.tablestore.writer.dispatch.BaseDispatcher;
import com.alicloud.openservices.tablestore.writer.dispatch.HashPartitionKeyDispatcher;
import com.alicloud.openservices.tablestore.writer.dispatch.HashPrimaryKeyDispatcher;
import com.alicloud.openservices.tablestore.writer.dispatch.RoundRobinDispatcher;
import com.alicloud.openservices.tablestore.writer.handle.WriterHandleStatistics;
import com.alicloud.openservices.tablestore.writer.retry.CertainCodeNotRetryStrategy;
import com.alicloud.openservices.tablestore.writer.retry.CertainCodeRetryStrategy;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTableStoreWriter
implements TableStoreWriter {
    private Logger logger = LoggerFactory.getLogger(TableStoreWriter.class);
    private static final int SCHEDULED_CORE_POOL_SIZE = 2;
    private final AsyncClientInterface ots;
    private final Executor executor;
    private final WriterConfig writerConfig;
    private TableStoreCallback<RowChange, ConsumedCapacity> callback;
    private TableStoreCallback<RowChange, RowWriteResult> resultCallback;
    private final String tableName;
    private TableMeta tableMeta;
    private Bucket[] buckets;
    private final WriterHandleStatistics writerStatistics;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private BaseDispatcher dispatcher;
    private final Semaphore semaphore;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(2, new ThreadFactory(){
        private final AtomicInteger counter = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "writer-scheduled-pool-%d" + this.counter.getAndIncrement());
        }
    });
    private final boolean isInnerConstruct;
    private boolean allowDuplicatePkInBatchRequest = true;

    public DefaultTableStoreWriter(AsyncClientInterface ots, String tableName, WriterConfig config, TableStoreCallback<RowChange, ConsumedCapacity> callback, Executor executor) {
        Preconditions.checkNotNull(ots, "The ots client can not be null.");
        Preconditions.checkArgument(tableName != null && !tableName.isEmpty(), "The table name can not be null or empty.");
        Preconditions.checkNotNull(executor, "The executor service can not be null.");
        this.writerStatistics = new WriterHandleStatistics();
        this.ots = ots;
        this.tableName = tableName;
        this.writerConfig = config;
        this.callback = callback;
        this.resultCallback = this.createResultCallback(callback);
        this.executor = executor;
        this.allowDuplicatePkInBatchRequest = this.writerConfig.isAllowDuplicatedRowInBatchRequest();
        this.semaphore = new Semaphore(this.writerConfig.getConcurrency());
        this.isInnerConstruct = false;
        this.initialize();
        this.closed.set(false);
    }

    public DefaultTableStoreWriter(String endpoint, ServiceCredentials credentials, String instanceName, String tableName, WriterConfig config, TableStoreCallback<RowChange, RowWriteResult> resultCallback) {
        Preconditions.checkArgument(tableName != null && !tableName.isEmpty(), "The table name can not be null or empty.");
        this.writerStatistics = new WriterHandleStatistics();
        ClientConfiguration cc = new ClientConfiguration();
        cc.setMaxConnections(config.getClientMaxConnections());
        switch (config.getWriterRetryStrategy()) {
            case CERTAIN_ERROR_CODE_NOT_RETRY: {
                cc.setRetryStrategy(new CertainCodeNotRetryStrategy());
                break;
            }
            default: {
                cc.setRetryStrategy(new CertainCodeRetryStrategy());
            }
        }
        this.ots = new AsyncClient(endpoint, new DefaultCredentialProvider(credentials), instanceName, cc, new ResourceManager(cc, null));
        this.tableName = tableName;
        this.writerConfig = config;
        this.callback = null;
        this.resultCallback = resultCallback;
        this.executor = this.createThreadPool(config);
        this.allowDuplicatePkInBatchRequest = this.writerConfig.isAllowDuplicatedRowInBatchRequest();
        this.semaphore = new Semaphore(this.writerConfig.getConcurrency());
        this.isInnerConstruct = true;
        this.initialize();
        this.closed.set(false);
    }

    public DefaultTableStoreWriter(String endpoint, ServiceCredentials credentials, String instanceName, String tableName, WriterConfig config, ClientConfiguration cc, TableStoreCallback<RowChange, RowWriteResult> resultCallback) {
        Preconditions.checkArgument(tableName != null && !tableName.isEmpty(), "The table name can not be null or empty.");
        this.writerStatistics = new WriterHandleStatistics();
        this.ots = new AsyncClient(endpoint, new DefaultCredentialProvider(credentials), instanceName, cc, new ResourceManager(cc, null));
        this.tableName = tableName;
        this.writerConfig = config;
        this.callback = null;
        this.resultCallback = resultCallback;
        this.executor = this.createThreadPool(config);
        this.allowDuplicatePkInBatchRequest = this.writerConfig.isAllowDuplicatedRowInBatchRequest();
        this.semaphore = new Semaphore(this.writerConfig.getConcurrency());
        this.isInnerConstruct = true;
        this.initialize();
        this.closed.set(false);
    }

    private void initialize() {
        this.logger.info("Start initialize ots writer, table name: {}.", (Object)this.tableName);
        DescribeTableRequest request = new DescribeTableRequest();
        request.setTableName(this.tableName);
        Future<DescribeTableResponse> result = this.ots.describeTable(request, null);
        DescribeTableResponse res = null;
        try {
            res = result.get();
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
        if (res.getIndexMeta() != null && res.getIndexMeta().size() > 0) {
            this.allowDuplicatePkInBatchRequest = false;
            this.logger.info("Table [{}] has globalIndex, allowDuplicatePkInBatchRequest will be overwrite by [false]", (Object)this.tableName);
        }
        this.tableMeta = res.getTableMeta();
        this.logger.info("End initialize with table meta: {}.", (Object)this.tableMeta);
        this.buckets = new Bucket[this.writerConfig.getBucketCount()];
        for (int i = 0; i < this.writerConfig.getBucketCount(); ++i) {
            BucketConfig bucketConfig = new BucketConfig(i, this.tableMeta.getTableName(), this.writerConfig.getWriteMode(), this.allowDuplicatePkInBatchRequest);
            this.buckets[i] = new Bucket(bucketConfig, this.ots, this.writerConfig, this.resultCallback, this.executor, this.writerStatistics, this.semaphore);
        }
        switch (this.writerConfig.getDispatchMode()) {
            case HASH_PARTITION_KEY: {
                this.dispatcher = new HashPartitionKeyDispatcher(this.writerConfig.getBucketCount());
                break;
            }
            case ROUND_ROBIN: {
                this.dispatcher = new RoundRobinDispatcher(this.writerConfig.getBucketCount());
                break;
            }
            case HASH_PRIMARY_KEY: {
                this.dispatcher = new HashPrimaryKeyDispatcher(this.writerConfig.getBucketCount());
                break;
            }
            default: {
                throw new ClientException(String.format("The dispatch mode [%s] not supported", new Object[]{this.writerConfig.getDispatchMode()}));
            }
        }
        this.startFlushTimer(this.writerConfig.getFlushInterval());
        this.startLogTimer(this.writerConfig.getLogInterval());
    }

    private ExecutorService createThreadPool(WriterConfig config) {
        int coreThreadCount;
        int maxThreadCount = coreThreadCount = config.getCallbackThreadCount();
        int queueSize = config.getCallbackThreadPoolQueueSize();
        ThreadFactory threadFactory = new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "writer-callback-" + this.counter.getAndIncrement());
            }
        };
        return new ThreadPoolExecutor(coreThreadCount, maxThreadCount, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueSize), threadFactory, new ThreadPoolExecutor.CallerRunsPolicy());
    }

    private TableStoreCallback<RowChange, RowWriteResult> createResultCallback(final TableStoreCallback<RowChange, ConsumedCapacity> callback) {
        if (callback != null) {
            return new TableStoreCallback<RowChange, RowWriteResult>(){

                @Override
                public void onCompleted(RowChange req, RowWriteResult res) {
                    callback.onCompleted(req, res.getConsumedCapacity());
                }

                @Override
                public void onFailed(RowChange req, Exception ex) {
                    callback.onFailed(req, ex);
                }
            };
        }
        return null;
    }

    @Override
    public void addRowChange(RowChange rowChange) {
        if (this.writerConfig.isEnableSchemaCheck()) {
            ParamChecker.checkRowChange(this.tableMeta, rowChange, this.writerConfig);
        }
        Group group = new Group(1);
        while (!this.addRowChangeInternal(rowChange, group)) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public Future<WriterResult> addRowChangeWithFuture(RowChange rowChange) {
        if (this.writerConfig.isEnableSchemaCheck()) {
            ParamChecker.checkRowChange(this.tableMeta, rowChange, this.writerConfig);
        }
        Group group = new Group(1);
        while (!this.addRowChangeInternal(rowChange, group)) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return group.getFuture();
    }

    @Override
    public boolean tryAddRowChange(RowChange rowChange) {
        if (this.writerConfig.isEnableSchemaCheck()) {
            ParamChecker.checkRowChange(this.tableMeta, rowChange, this.writerConfig);
        }
        Group group = new Group(1);
        return this.addRowChangeInternal(rowChange, group);
    }

    private boolean addRowChangeInternal(RowChange rowChange, Group group) {
        if (this.closed.get()) {
            throw new ClientException("The writer has been closed.");
        }
        int targetBucketIndex = this.dispatcher.getDispatchIndex(rowChange);
        return this.buckets[targetBucketIndex].addRowChange(rowChange, group);
    }

    public void startFlushTimer(int flushInterval) {
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                DefaultTableStoreWriter.this.triggerFlush();
            }
        }, 0L, flushInterval, TimeUnit.MILLISECONDS);
    }

    private void startLogTimer(int interval) {
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                StringBuilder ringBufferRemain = new StringBuilder("RingBuffer Remain: ");
                for (Bucket bucket : DefaultTableStoreWriter.this.buckets) {
                    ringBufferRemain.append(bucket.getRingBuffer().remainingCapacity());
                    ringBufferRemain.append(", ");
                }
                DefaultTableStoreWriter.this.logger.debug(ringBufferRemain.toString());
                StringBuilder dispatcherCount = new StringBuilder("Dispatcher Count: ");
                for (AtomicLong count : DefaultTableStoreWriter.this.dispatcher.getBucketDispatchRowCount()) {
                    dispatcherCount.append(count.get());
                    dispatcherCount.append(", ");
                }
                DefaultTableStoreWriter.this.logger.debug(dispatcherCount.toString());
            }
        }, 0L, interval, TimeUnit.MILLISECONDS);
    }

    @Override
    public void addRowChange(List<RowChange> rowChanges, List<RowChange> dirtyRows) throws ClientException {
        dirtyRows.clear();
        for (RowChange rowChange : rowChanges) {
            try {
                this.addRowChange(rowChange);
            }
            catch (ClientException e) {
                dirtyRows.add(rowChange);
            }
        }
        if (!dirtyRows.isEmpty()) {
            throw new ClientException("There is dirty rows.");
        }
    }

    @Override
    public Future<WriterResult> addRowChangeWithFuture(List<RowChange> rowChanges) throws ClientException {
        Group group = new Group(rowChanges.size());
        for (RowChange rowChange : rowChanges) {
            if (this.writerConfig.isEnableSchemaCheck()) {
                ParamChecker.checkRowChange(this.tableMeta, rowChange, this.writerConfig);
            }
            try {
                while (!this.addRowChangeInternal(rowChange, group)) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (ClientException e) {
                group.failedOneRow(rowChange, e);
            }
        }
        return group.getFuture();
    }

    @Override
    public void setCallback(TableStoreCallback<RowChange, ConsumedCapacity> callback) {
        this.callback = callback;
        this.resultCallback = this.createResultCallback(callback);
        for (Bucket bucket : this.buckets) {
            bucket.setResultCallback(this.resultCallback);
        }
    }

    @Override
    public void setResultCallback(TableStoreCallback<RowChange, RowWriteResult> resultCallback) {
        this.callback = null;
        this.resultCallback = resultCallback;
        for (Bucket bucket : this.buckets) {
            bucket.setResultCallback(resultCallback);
        }
    }

    @Override
    public TableStoreCallback<RowChange, ConsumedCapacity> getCallback() {
        return this.callback;
    }

    @Override
    public TableStoreCallback<RowChange, RowWriteResult> getResultCallback() {
        return this.resultCallback;
    }

    @Override
    public WriterConfig getWriterConfig() {
        return this.writerConfig;
    }

    @Override
    public WriterStatistics getWriterStatistics() {
        return this.writerStatistics;
    }

    private CountDownLatch triggerFlush() {
        CountDownLatch latch = new CountDownLatch(this.writerConfig.getBucketCount());
        for (Bucket bucket : this.buckets) {
            bucket.addSignal(latch);
        }
        this.logger.info("WriterStatistics: " + this.writerStatistics);
        return latch;
    }

    @Override
    public synchronized void flush() throws ClientException {
        this.logger.debug("trigger flush and waiting.");
        if (this.closed.get()) {
            throw new ClientException("The writer has been closed.");
        }
        CountDownLatch latch = this.triggerFlush();
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new ClientException(e);
        }
        this.logger.debug("user trigger flush finished.");
    }

    @Override
    public synchronized void close() {
        if (this.closed.get()) {
            throw new ClientException("The writer has already been closed.");
        }
        this.flush();
        this.scheduledExecutorService.shutdown();
        for (Bucket bucket : this.buckets) {
            bucket.close();
            this.logger.debug(String.format("bucket [%d] is closed.", bucket.getId()));
        }
        if (this.isInnerConstruct) {
            this.ots.shutdown();
            ((ExecutorService)this.executor).shutdown();
        }
        this.closed.set(true);
    }
}

