/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore;

import com.alicloud.openservices.tablestore.AsyncClient;
import com.alicloud.openservices.tablestore.AsyncTimeseriesClientInterface;
import com.alicloud.openservices.tablestore.ClientConfiguration;
import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.InternalClient;
import com.alicloud.openservices.tablestore.SyncClient;
import com.alicloud.openservices.tablestore.TableStoreCallback;
import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.TimeseriesClient;
import com.alicloud.openservices.tablestore.TimeseriesClientInterface;
import com.alicloud.openservices.tablestore.TimeseriesConfiguration;
import com.alicloud.openservices.tablestore.core.ResourceManager;
import com.alicloud.openservices.tablestore.core.auth.CredentialsProvider;
import com.alicloud.openservices.tablestore.core.auth.DefaultCredentialProvider;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.timeseries.CreateTimeseriesAnalyticalStoreRequest;
import com.alicloud.openservices.tablestore.model.timeseries.CreateTimeseriesAnalyticalStoreResponse;
import com.alicloud.openservices.tablestore.model.timeseries.CreateTimeseriesTableRequest;
import com.alicloud.openservices.tablestore.model.timeseries.CreateTimeseriesTableResponse;
import com.alicloud.openservices.tablestore.model.timeseries.DeleteTimeseriesAnalyticalStoreRequest;
import com.alicloud.openservices.tablestore.model.timeseries.DeleteTimeseriesAnalyticalStoreResponse;
import com.alicloud.openservices.tablestore.model.timeseries.DeleteTimeseriesMetaRequest;
import com.alicloud.openservices.tablestore.model.timeseries.DeleteTimeseriesMetaResponse;
import com.alicloud.openservices.tablestore.model.timeseries.DeleteTimeseriesTableRequest;
import com.alicloud.openservices.tablestore.model.timeseries.DeleteTimeseriesTableResponse;
import com.alicloud.openservices.tablestore.model.timeseries.DescribeTimeseriesAnalyticalStoreRequest;
import com.alicloud.openservices.tablestore.model.timeseries.DescribeTimeseriesAnalyticalStoreResponse;
import com.alicloud.openservices.tablestore.model.timeseries.DescribeTimeseriesTableRequest;
import com.alicloud.openservices.tablestore.model.timeseries.DescribeTimeseriesTableResponse;
import com.alicloud.openservices.tablestore.model.timeseries.GetTimeseriesDataRequest;
import com.alicloud.openservices.tablestore.model.timeseries.GetTimeseriesDataResponse;
import com.alicloud.openservices.tablestore.model.timeseries.ListTimeseriesTableRequest;
import com.alicloud.openservices.tablestore.model.timeseries.ListTimeseriesTableResponse;
import com.alicloud.openservices.tablestore.model.timeseries.PutTimeseriesDataRequest;
import com.alicloud.openservices.tablestore.model.timeseries.PutTimeseriesDataResponse;
import com.alicloud.openservices.tablestore.model.timeseries.QueryTimeseriesMetaRequest;
import com.alicloud.openservices.tablestore.model.timeseries.QueryTimeseriesMetaResponse;
import com.alicloud.openservices.tablestore.model.timeseries.ScanTimeseriesDataRequest;
import com.alicloud.openservices.tablestore.model.timeseries.ScanTimeseriesDataResponse;
import com.alicloud.openservices.tablestore.model.timeseries.SplitTimeseriesScanTaskRequest;
import com.alicloud.openservices.tablestore.model.timeseries.SplitTimeseriesScanTaskResponse;
import com.alicloud.openservices.tablestore.model.timeseries.UpdateTimeseriesAnalyticalStoreRequest;
import com.alicloud.openservices.tablestore.model.timeseries.UpdateTimeseriesAnalyticalStoreResponse;
import com.alicloud.openservices.tablestore.model.timeseries.UpdateTimeseriesMetaRequest;
import com.alicloud.openservices.tablestore.model.timeseries.UpdateTimeseriesMetaResponse;
import com.alicloud.openservices.tablestore.model.timeseries.UpdateTimeseriesTableRequest;
import com.alicloud.openservices.tablestore.model.timeseries.UpdateTimeseriesTableResponse;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.Weigher;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class AsyncTimeseriesClient
implements AsyncTimeseriesClientInterface {
    private InternalClient internalClient;
    private Cache<String, Long> timeseriesMetaCache;

    public AsyncTimeseriesClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName) {
        this(endpoint, accessKeyId, accessKeySecret, instanceName, new ClientConfiguration());
    }

    public AsyncTimeseriesClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, ClientConfiguration conf) {
        this(endpoint, accessKeyId, accessKeySecret, instanceName, conf, null);
    }

    public AsyncTimeseriesClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, String stsToken) {
        this(endpoint, accessKeyId, accessKeySecret, instanceName, new ClientConfiguration(), stsToken);
    }

    public AsyncTimeseriesClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, ClientConfiguration config, String stsToken) {
        this(endpoint, accessKeyId, accessKeySecret, instanceName, config, stsToken, null);
    }

    public AsyncTimeseriesClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, ClientConfiguration config, String stsToken, ExecutorService callbackExecutor) {
        this(endpoint, new DefaultCredentialProvider(accessKeyId, accessKeySecret, stsToken), instanceName, config, new ResourceManager(config, callbackExecutor));
    }

    public AsyncTimeseriesClient(String endpoint, CredentialsProvider credsProvider, String instanceName, ClientConfiguration config, ResourceManager resourceManager) {
        this(new InternalClient(endpoint, credsProvider, instanceName, config, resourceManager));
    }

    AsyncTimeseriesClient(InternalClient internalClient) {
        Preconditions.checkNotNull(internalClient);
        this.internalClient = internalClient;
        if (this.internalClient.getTimeseriesMetaCache() != null) {
            this.timeseriesMetaCache = this.internalClient.getTimeseriesMetaCache();
            return;
        }
        ClientConfiguration config = this.internalClient.getClientConfig();
        if (config.getTimeseriesConfiguration() == null) {
            config.setTimeseriesConfiguration(new TimeseriesConfiguration());
        }
        this.timeseriesMetaCache = CacheBuilder.newBuilder().maximumWeight(config.getTimeseriesConfiguration().getMetaCacheMaxDataSize()).expireAfterAccess((long)config.getTimeseriesConfiguration().getMetaCacheExpireTimeAfterAccessInSec(), TimeUnit.SECONDS).weigher((Weigher)new Weigher<String, Long>(){

            public int weigh(String key, Long value) {
                return key.length() + 48 + 16;
            }
        }).build();
        this.internalClient.setTimeseriesMetaCache(this.timeseriesMetaCache);
    }

    public void setExtraHeaders(Map<String, String> extraHeaders) {
        this.internalClient.setExtraHeaders(extraHeaders);
    }

    @Override
    public Future<CreateTimeseriesTableResponse> createTimeseriesTable(CreateTimeseriesTableRequest request, TableStoreCallback<CreateTimeseriesTableRequest, CreateTimeseriesTableResponse> callback) {
        return this.internalClient.createTimeseriesTable(request, callback);
    }

    @Override
    public Future<ListTimeseriesTableResponse> listTimeseriesTable(TableStoreCallback<ListTimeseriesTableRequest, ListTimeseriesTableResponse> callback) {
        return this.internalClient.listTimeseriesTable(callback);
    }

    @Override
    public Future<DeleteTimeseriesTableResponse> deleteTimeseriesTable(DeleteTimeseriesTableRequest request, TableStoreCallback<DeleteTimeseriesTableRequest, DeleteTimeseriesTableResponse> callback) {
        return this.internalClient.deleteTimeseriesTable(request, callback);
    }

    @Override
    public Future<DescribeTimeseriesTableResponse> describeTimeseriesTable(DescribeTimeseriesTableRequest request, TableStoreCallback<DescribeTimeseriesTableRequest, DescribeTimeseriesTableResponse> callback) {
        return this.internalClient.describeTimeseriesTable(request, callback);
    }

    @Override
    public Future<UpdateTimeseriesTableResponse> updateTimeseriesTable(UpdateTimeseriesTableRequest request, TableStoreCallback<UpdateTimeseriesTableRequest, UpdateTimeseriesTableResponse> callback) {
        return this.internalClient.updateTimeseriesTable(request, callback);
    }

    @Override
    public Future<PutTimeseriesDataResponse> putTimeseriesData(PutTimeseriesDataRequest request, TableStoreCallback<PutTimeseriesDataRequest, PutTimeseriesDataResponse> callback) throws TableStoreException, ClientException {
        return this.internalClient.putTimeseriesData(request, callback);
    }

    @Override
    public Future<GetTimeseriesDataResponse> getTimeseriesData(GetTimeseriesDataRequest request, TableStoreCallback<GetTimeseriesDataRequest, GetTimeseriesDataResponse> callback) throws TableStoreException, ClientException {
        return this.internalClient.getTimeseriesData(request, callback);
    }

    @Override
    public Future<QueryTimeseriesMetaResponse> queryTimeseriesMeta(QueryTimeseriesMetaRequest request, TableStoreCallback<QueryTimeseriesMetaRequest, QueryTimeseriesMetaResponse> callback) throws TableStoreException, ClientException {
        return this.internalClient.queryTimeseriesMeta(request, callback);
    }

    @Override
    public Future<UpdateTimeseriesMetaResponse> updateTimeseriesMeta(UpdateTimeseriesMetaRequest request, TableStoreCallback<UpdateTimeseriesMetaRequest, UpdateTimeseriesMetaResponse> callback) throws TableStoreException, ClientException {
        return this.internalClient.updateTimeseriesMeta(request, callback);
    }

    @Override
    public Future<DeleteTimeseriesMetaResponse> deleteTimeseriesMeta(DeleteTimeseriesMetaRequest request, TableStoreCallback<DeleteTimeseriesMetaRequest, DeleteTimeseriesMetaResponse> callback) throws TableStoreException, ClientException {
        return this.internalClient.deleteTimeseriesMeta(request, callback);
    }

    @Override
    public Future<SplitTimeseriesScanTaskResponse> splitTimeseriesScanTask(SplitTimeseriesScanTaskRequest request, TableStoreCallback<SplitTimeseriesScanTaskRequest, SplitTimeseriesScanTaskResponse> callback) throws TableStoreException, ClientException {
        return this.internalClient.splitTimeseriesScanTask(request, callback);
    }

    @Override
    public Future<ScanTimeseriesDataResponse> scanTimeseriesData(ScanTimeseriesDataRequest request, TableStoreCallback<ScanTimeseriesDataRequest, ScanTimeseriesDataResponse> callback) throws TableStoreException, ClientException {
        return this.internalClient.scanTimeseriesData(request, callback);
    }

    @Override
    public Future<CreateTimeseriesAnalyticalStoreResponse> createTimeseriesAnalyticalStore(CreateTimeseriesAnalyticalStoreRequest request, TableStoreCallback<CreateTimeseriesAnalyticalStoreRequest, CreateTimeseriesAnalyticalStoreResponse> callback) throws TableStoreException, ClientException {
        return this.internalClient.createTimeseriesAnalyticalStore(request, callback);
    }

    @Override
    public Future<DeleteTimeseriesAnalyticalStoreResponse> deleteTimeseriesAnalyticalStore(DeleteTimeseriesAnalyticalStoreRequest request, TableStoreCallback<DeleteTimeseriesAnalyticalStoreRequest, DeleteTimeseriesAnalyticalStoreResponse> callback) throws TableStoreException, ClientException {
        return this.internalClient.deleteTimeseriesAnalyticalStore(request, callback);
    }

    @Override
    public Future<DescribeTimeseriesAnalyticalStoreResponse> describeTimeseriesAnalyticalStore(DescribeTimeseriesAnalyticalStoreRequest request, TableStoreCallback<DescribeTimeseriesAnalyticalStoreRequest, DescribeTimeseriesAnalyticalStoreResponse> callback) throws TableStoreException, ClientException {
        return this.internalClient.describeTimeseriesAnalyticalStore(request, callback);
    }

    @Override
    public Future<UpdateTimeseriesAnalyticalStoreResponse> updateTimeseriesAnalyticalStore(UpdateTimeseriesAnalyticalStoreRequest request, TableStoreCallback<UpdateTimeseriesAnalyticalStoreRequest, UpdateTimeseriesAnalyticalStoreResponse> callback) throws TableStoreException, ClientException {
        return this.internalClient.updateTimeseriesAnalyticalStore(request, callback);
    }

    @Override
    public void shutdown() {
        this.internalClient.shutdown();
    }

    @Override
    public TimeseriesClientInterface asTimeseriesClientInterface() {
        return new TimeseriesClient(this.internalClient);
    }

    public SyncClient asSyncClient() {
        return new SyncClient(this.internalClient);
    }

    public AsyncClient asAsyncClient() {
        return new AsyncClient(this.internalClient);
    }

    public TimeseriesClient asTimeseriesClient() {
        return new TimeseriesClient(this.internalClient);
    }
}

