/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tablestore.util;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.tablestore.TablestoreErrorCode;
import com.facebook.presto.tablestore.model.TablestoreColumn;
import com.facebook.presto.tablestore.model.TablestoreTable;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;

public class TablestoreTableSerde {
    private TablestoreTableSerde() {
    }

    public static final class Deserializer
    extends JsonDeserializer<TablestoreTable> {
        private final TypeManager typeManager;

        @Inject
        public Deserializer(TypeManager typeManager) {
            this.typeManager = typeManager;
        }

        public TablestoreTable deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            ObjectNode o = (ObjectNode)jsonParser.readValueAsTree();
            String schemaName = o.get("schema").textValue();
            String tableName = o.get("table").textValue();
            String originName = o.get("origin_name").textValue();
            ArrayList<TablestoreColumn> columns = new ArrayList<TablestoreColumn>();
            ArrayNode columnsNode = (ArrayNode)o.get("columns");
            for (int i = 0; i < columnsNode.size(); ++i) {
                JsonNode cn = columnsNode.get(i);
                String columnName = cn.get("name").textValue();
                String originColumnName = cn.get("origin_name").textValue();
                Type type = this.typeManager.getType(TypeSignature.parseTypeSignature((String)cn.get("type").textValue()));
                boolean nullable = cn.get("nullable").booleanValue();
                String comment = cn.get("comment").textValue();
                String extraInfo = cn.get("extraInfo").textValue();
                boolean hidden = cn.get("hidden").booleanValue();
                HashMap properties = new HashMap();
                JsonNode pNode = cn.get("properties");
                Iterator iter = pNode.fields();
                while (iter.hasNext()) {
                    Map.Entry pn = (Map.Entry)iter.next();
                    properties.put(pn.getKey(), this.getValue((JsonNode)pn.getValue()));
                }
                ColumnMetadata metadata = new ColumnMetadata(columnName, type, nullable, comment, extraInfo, hidden, properties);
                TablestoreColumn column = new TablestoreColumn(columnName, originColumnName, metadata);
                columns.add(column);
            }
            HashMap<String, Object> properties = new HashMap<String, Object>();
            ObjectNode propertiesNode = (ObjectNode)o.get("properties");
            Iterator iter = propertiesNode.fields();
            while (iter.hasNext()) {
                Map.Entry pn = (Map.Entry)iter.next();
                properties.put((String)pn.getKey(), this.getValue((JsonNode)pn.getValue()));
            }
            Optional<String> comment = Optional.empty();
            if (o.has("comment")) {
                comment = Optional.of(o.get("comment").textValue());
            }
            return new TablestoreTable(new SchemaTableName(schemaName, tableName), originName, columns, comment, properties);
        }

        private Object getValue(JsonNode value) {
            if (!value.isValueNode()) {
                throw new PrestoException((ErrorCodeSupplier)TablestoreErrorCode.INVALID_STATE, "The property node is not a value node.");
            }
            if (value.isInt()) {
                return value.intValue();
            }
            if (value.isTextual()) {
                return value.textValue();
            }
            if (value.isNull()) {
                return null;
            }
            if (value.isDouble()) {
                return value.doubleValue();
            }
            if (value.isShort()) {
                return value.shortValue();
            }
            if (value.isLong()) {
                return value.longValue();
            }
            throw new PrestoException((ErrorCodeSupplier)TablestoreErrorCode.INVALID_STATE, "Unrecognized property type: " + value.getNodeType());
        }
    }

    public static final class Serializer
    extends JsonSerializer<TablestoreTable> {
        public void serialize(TablestoreTable table, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("schema", table.getTableName().getSchemaName());
            jsonGenerator.writeStringField("table", table.getTableName().getTableName());
            jsonGenerator.writeStringField("origin_name", table.getOriginName());
            if (table.getComment().isPresent()) {
                jsonGenerator.writeStringField("comment", table.getComment().get());
            }
            jsonGenerator.writeArrayFieldStart("columns");
            for (TablestoreColumn tablestoreColumn : table.getColumns()) {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeStringField("name", tablestoreColumn.getName());
                jsonGenerator.writeStringField("origin_name", tablestoreColumn.getOriginName());
                jsonGenerator.writeObjectField("type", (Object)tablestoreColumn.getMetadata().getType());
                jsonGenerator.writeBooleanField("nullable", tablestoreColumn.getMetadata().isNullable());
                jsonGenerator.writeStringField("comment", tablestoreColumn.getMetadata().getComment());
                jsonGenerator.writeStringField("extraInfo", tablestoreColumn.getMetadata().getExtraInfo());
                jsonGenerator.writeBooleanField("hidden", tablestoreColumn.getMetadata().isHidden());
                jsonGenerator.writeObjectFieldStart("properties");
                for (Map.Entry entry : tablestoreColumn.getMetadata().getProperties().entrySet()) {
                    jsonGenerator.writeObjectField((String)entry.getKey(), entry.getValue());
                }
                jsonGenerator.writeEndObject();
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndArray();
            jsonGenerator.writeObjectFieldStart("properties");
            for (Map.Entry entry : table.getProperties().entrySet()) {
                jsonGenerator.writeObjectField((String)entry.getKey(), entry.getValue());
            }
            jsonGenerator.writeEndObject();
            jsonGenerator.writeEndObject();
        }
    }
}

