/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tablestore.util;

import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.PrimaryKeyBuilder;
import com.alicloud.openservices.tablestore.model.PrimaryKeyColumn;
import com.alicloud.openservices.tablestore.model.PrimaryKeyType;
import com.alicloud.openservices.tablestore.model.PrimaryKeyValue;
import com.facebook.presto.tablestore.util.Base64;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;

public class PrimaryKeyJsonSerde {
    private PrimaryKeyJsonSerde() {
    }

    public static final class Deserializer
    extends JsonDeserializer<PrimaryKey> {
        public PrimaryKey deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            ArrayNode s = (ArrayNode)jsonParser.readValueAsTree();
            PrimaryKeyBuilder builder = PrimaryKeyBuilder.createPrimaryKeyBuilder();
            block5: for (int i = 0; i < s.size(); ++i) {
                JsonNode node = s.get(i);
                String name = node.get("name").asText();
                String type = node.get("type").asText();
                if (type.equalsIgnoreCase("INF_MIN")) {
                    builder.addPrimaryKeyColumn(name, PrimaryKeyValue.INF_MIN);
                    continue;
                }
                if (type.equalsIgnoreCase("INF_MAX")) {
                    builder.addPrimaryKeyColumn(name, PrimaryKeyValue.INF_MAX);
                    continue;
                }
                PrimaryKeyType t = PrimaryKeyType.valueOf((String)type);
                switch (t) {
                    case STRING: {
                        builder.addPrimaryKeyColumn(name, PrimaryKeyValue.fromString((String)node.get("value").asText()));
                        continue block5;
                    }
                    case INTEGER: {
                        builder.addPrimaryKeyColumn(name, PrimaryKeyValue.fromLong((long)node.get("value").asLong()));
                        continue block5;
                    }
                    case BINARY: {
                        builder.addPrimaryKeyColumn(name, PrimaryKeyValue.fromBinary((byte[])Base64.fromBase64String(node.get("value").asText())));
                    }
                }
            }
            return builder.build();
        }
    }

    public static final class Serializer
    extends JsonSerializer<PrimaryKey> {
        public void serialize(PrimaryKey primaryKey, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            PrimaryKeyColumn[] pkColumns = primaryKey.getPrimaryKeyColumns();
            jsonGenerator.writeStartArray(pkColumns.length);
            for (PrimaryKeyColumn c : pkColumns) {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeStringField("name", c.getName());
                if (c.getValue().isInfMin() || c.getValue().isInfMax()) {
                    jsonGenerator.writeStringField("type", c.getValue().isInfMin() ? "INF_MIN" : "INF_MAX");
                } else {
                    jsonGenerator.writeStringField("type", c.getValue().getType().name());
                    this.writeValue(jsonGenerator, c.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndArray();
        }

        private void writeValue(JsonGenerator jsonGenerator, PrimaryKeyValue value) throws IOException {
            switch (value.getType()) {
                case STRING: {
                    jsonGenerator.writeStringField("value", value.asString());
                    break;
                }
                case INTEGER: {
                    jsonGenerator.writeNumberField("value", value.asLong());
                    break;
                }
                case BINARY: {
                    jsonGenerator.writeStringField("value", Base64.toBase64String(value.asBinary()));
                }
            }
        }
    }
}

