/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tablestore.schema.localstore;

import com.facebook.presto.tablestore.schema.localstore.TablestoreTableJsonConf;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import java.util.AbstractMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class TablestoreInstanceJsonConf {
    private final String instanceName;
    private final String endpoint;
    private final Map<String, TablestoreTableJsonConf> tables;

    @JsonCreator
    public TablestoreInstanceJsonConf(@JsonProperty(value="instanceName") String instanceName, @JsonProperty(value="endpoint") String endpoint, @JsonProperty(value="tables") Map<String, TablestoreTableJsonConf> tables) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceName) ? 1 : 0) != 0, (Object)"instanceName is null or is empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)endpoint) ? 1 : 0) != 0, (Object)"endpoint is null or is empty");
        Preconditions.checkArgument((!Objects.isNull(tables) ? 1 : 0) != 0, (Object)"table is null");
        this.instanceName = Objects.requireNonNull(instanceName, "instance name is null");
        this.endpoint = Objects.requireNonNull(endpoint, "endpoint is null");
        this.tables = ImmutableMap.copyOf((Iterable)Collections2.transform(tables.entrySet(), entry -> new AbstractMap.SimpleEntry(((String)entry.getKey()).toLowerCase(Locale.ENGLISH), entry.getValue())));
    }

    @JsonProperty
    public String getInstanceName() {
        return this.instanceName;
    }

    @JsonProperty
    public String getEndpoint() {
        return this.endpoint;
    }

    @JsonProperty
    public Map<String, TablestoreTableJsonConf> getTables() {
        return this.tables;
    }
}

