/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tablestore.schema.localstore;

import com.alicloud.openservices.tablestore.SyncClient;
import com.alicloud.openservices.tablestore.model.ComputeSplitsBySizeRequest;
import com.alicloud.openservices.tablestore.model.ComputeSplitsBySizeResponse;
import com.alicloud.openservices.tablestore.model.DescribeTableRequest;
import com.alicloud.openservices.tablestore.model.DescribeTableResponse;
import com.alicloud.openservices.tablestore.model.Split;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.tablestore.TablestoreConfig;
import com.facebook.presto.tablestore.TablestoreErrorCode;
import com.facebook.presto.tablestore.model.TablestoreAccount;
import com.facebook.presto.tablestore.model.TablestoreColumn;
import com.facebook.presto.tablestore.model.TablestoreSchema;
import com.facebook.presto.tablestore.model.TablestoreTable;
import com.facebook.presto.tablestore.model.TablestoreTableMeta;
import com.facebook.presto.tablestore.model.TablestoreTableState;
import com.facebook.presto.tablestore.schema.IMetaStore;
import com.facebook.presto.tablestore.schema.localstore.TablestoreColumnJsonConf;
import com.facebook.presto.tablestore.schema.localstore.TablestoreInstanceJsonConf;
import com.facebook.presto.tablestore.schema.localstore.TablestoreSchemaJsonConf;
import com.facebook.presto.tablestore.schema.localstore.TablestoreTableJsonConf;
import com.facebook.presto.tablestore.util.MetaUtil;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.io.CharSource;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class LocalMetaStore
implements IMetaStore {
    public static final Logger log = Logger.get(LocalMetaStore.class);
    private final TablestoreConfig config;
    private final TablestoreAccount account;
    private final Map<String, TablestoreSchema> schemas;
    private final Map<SchemaTableName, TablestoreTable> tables;
    private final Map<SchemaTableName, TablestoreTableState> tableStates;
    private final Map<String, SyncClient> clients;

    public LocalMetaStore(TablestoreConfig config, JsonCodec<TablestoreSchemaJsonConf> schemaJsonCodec) {
        this.config = config;
        this.schemas = new HashMap<String, TablestoreSchema>();
        this.tables = new HashMap<SchemaTableName, TablestoreTable>();
        this.tableStates = new ConcurrentHashMap<SchemaTableName, TablestoreTableState>();
        this.clients = new ConcurrentHashMap<String, SyncClient>();
        TablestoreSchemaJsonConf conf = this.readJsonConf(config.getSchema(), schemaJsonCodec);
        this.account = conf.getAccount();
        this.initFromConf(conf);
    }

    private void initFromConf(TablestoreSchemaJsonConf conf) {
        for (Map.Entry<String, TablestoreInstanceJsonConf> entry : conf.getInstances().entrySet()) {
            String schemaName = entry.getKey();
            TablestoreInstanceJsonConf instance = entry.getValue();
            TablestoreSchema schema = new TablestoreSchema(schemaName, instance.getInstanceName(), instance.getEndpoint(), this.account);
            this.schemas.put(schemaName, schema);
            for (Map.Entry<String, TablestoreTableJsonConf> te : instance.getTables().entrySet()) {
                String tableName = te.getKey();
                TablestoreTableJsonConf table = te.getValue();
                SchemaTableName schemaTableName = new SchemaTableName(schemaName, tableName);
                this.tables.put(schemaTableName, this.toTable(schemaTableName, table));
            }
        }
    }

    private TablestoreTable toTable(SchemaTableName schemaTableName, TablestoreTableJsonConf tableConf) {
        String originTableName = tableConf.getOriginName() == null ? schemaTableName.getTableName() : tableConf.getOriginName();
        ArrayList<TablestoreColumn> columns = new ArrayList<TablestoreColumn>();
        for (TablestoreColumnJsonConf columnConf : tableConf.getColumns()) {
            TablestoreColumn column = this.toColumn(columnConf);
            columns.add(column);
        }
        TablestoreTable table = new TablestoreTable(schemaTableName, originTableName, columns, null, null);
        return table;
    }

    private TablestoreColumn toColumn(TablestoreColumnJsonConf columnConf) {
        String originName = columnConf.getOriginName() == null ? columnConf.getName() : columnConf.getOriginName();
        ColumnMetadata metadata = new ColumnMetadata(columnConf.getName(), columnConf.getType());
        TablestoreColumn column = new TablestoreColumn(columnConf.getName(), originName, metadata);
        return column;
    }

    private TablestoreSchemaJsonConf readJsonConf(String schema, JsonCodec<TablestoreSchemaJsonConf> schemaJsonCodec) {
        try {
            TablestoreSchemaJsonConf ts = LocalMetaStore.readSchema(schema, schemaJsonCodec);
            return ts;
        }
        catch (IOException e) {
            log.error((Throwable)e, "read schema failed.");
            throw new UncheckedIOException(e);
        }
        catch (Exception e) {
            log.error((Throwable)e, "read schema failed.");
            throw e;
        }
    }

    private static TablestoreSchemaJsonConf readSchema(String schemaFile, JsonCodec<TablestoreSchemaJsonConf> schemaCodec) throws IOException {
        log.info("start read schema.");
        CharSource cs = Files.asCharSource((File)new File(schemaFile), (Charset)StandardCharsets.UTF_8);
        return (TablestoreSchemaJsonConf)schemaCodec.fromJson(cs.read());
    }

    public TablestoreSchema getSchema(String schemaName) {
        TablestoreSchema schema = this.schemas.get(schemaName);
        if (schema == null) {
            log.warn("Schema [%s] is not exist.", new Object[]{schemaName});
            throw new IllegalStateException("This schema is not exist.");
        }
        return schema;
    }

    @Override
    public List<String> listSchema() {
        return ImmutableList.copyOf(this.schemas.keySet());
    }

    @Override
    public TablestoreTable getTable(String schemaName, String tableName) {
        TablestoreSchema schema = this.getSchema(schemaName);
        TablestoreTable table = this.tables.get(new SchemaTableName(schemaName, tableName));
        if (table == null) {
            log.warn("Table [%s.%s] is not exist.", new Object[]{schemaName, tableName});
            return null;
        }
        this.checkTableMeta(schema, table);
        return table;
    }

    @Override
    public TablestoreTableMeta describeTable(String schema, String tableName) {
        TablestoreTable table = this.getTable(schema, tableName);
        TablestoreTableState tableState = this.tableStates.get(table.getTableName());
        if (tableState == null) {
            throw new PrestoException((ErrorCodeSupplier)TablestoreErrorCode.INVALID_STATE, "Table is not exist.");
        }
        return tableState.getTableMeta();
    }

    private void checkTableMeta(TablestoreSchema schema, TablestoreTable table) {
        TablestoreTableState tableState = this.tableStates.get(table.getTableName());
        if (tableState == null) {
            DescribeTableResponse tableMeta = this.refreshTableMeta(schema, table);
            try {
                MetaUtil.checkMeta(table, tableMeta.getTableMeta());
                tableState = TablestoreTableState.checkPassed(table, new TablestoreTableMeta(tableMeta.getTableMeta(), tableMeta.getIndexMeta()));
            }
            catch (PrestoException e) {
                tableState = TablestoreTableState.metaCheckFailed(table, e.getMessage());
            }
            this.tableStates.put(table.getTableName(), tableState);
        }
        if (tableState.isStateInvalid()) {
            throw new IllegalStateException(tableState.getInvalidReason());
        }
    }

    private DescribeTableResponse refreshTableMeta(TablestoreSchema schema, TablestoreTable table) {
        log.info("refresh table meta: %s", new Object[]{table.getOriginName()});
        DescribeTableRequest request = new DescribeTableRequest();
        request.setTableName(table.getOriginName());
        SyncClient c = this.getClientInternal(schema);
        DescribeTableResponse response = c.describeTable(request);
        return response;
    }

    @Override
    public List<String> listTable(String schema) {
        return ImmutableList.copyOf((Collection)Collections2.transform((Collection)this.tables.entrySet().stream().filter(entry -> ((SchemaTableName)entry.getKey()).getSchemaName().equalsIgnoreCase(schema)).collect(Collectors.toList()), entry -> ((SchemaTableName)entry.getKey()).getTableName()));
    }

    @Override
    public List<Split> getTableSplits(String schema, String tableName) {
        TablestoreTable table = this.getTable(schema, tableName);
        SyncClient c = this.getClientInternal(this.getSchema(schema));
        ComputeSplitsBySizeRequest request = new ComputeSplitsBySizeRequest();
        request.setTableName(table.getOriginName());
        request.setSplitPointLimit(this.config.getMaxSplits());
        request.setSplitSizeInByte((long)this.config.getSplitSizeInMB(), 0x100000L);
        ComputeSplitsBySizeResponse response = c.computeSplitsBySize(request);
        return response.getSplits();
    }

    @Override
    public SyncClient getClient(String schema) {
        return this.getClientInternal(this.getSchema(schema));
    }

    @Override
    public void createSchema(TablestoreSchema schema) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support creating schemas");
    }

    @Override
    public void dropSchema(String schemaName) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support dropping schemas.");
    }

    @Override
    public void createTable(ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support creating tables");
    }

    @Override
    public void dropTable(String schemaName, String tableName) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support dropping tables.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SyncClient getClientInternal(TablestoreSchema schema) {
        SyncClient client = this.clients.get(schema.getSchemaName());
        if (client != null) {
            return client;
        }
        Map<String, SyncClient> map = this.clients;
        synchronized (map) {
            client = this.clients.get(schema.getSchemaName());
            if (client != null) {
                return client;
            }
            TablestoreAccount account = schema.getAccount();
            client = Strings.isNullOrEmpty((String)account.getToken()) ? new SyncClient(schema.getEndpoint(), account.getAccessId(), account.getAccessKey(), schema.getInstanceName(), this.config.getClientConfig()) : new SyncClient(schema.getEndpoint(), account.getAccessId(), account.getAccessKey(), schema.getInstanceName(), this.config.getClientConfig(), account.getToken());
            this.clients.put(schema.getSchemaName(), client);
            return client;
        }
    }
}

