/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tablestore.model;

import com.facebook.presto.tablestore.model.TablestoreTable;
import com.facebook.presto.tablestore.model.TablestoreTableMeta;

public class TablestoreTableState {
    private TablestoreTable table;
    private boolean isExist;
    private boolean metaChecked;
    private TablestoreTableMeta tableMeta;
    private boolean stateInvalid;
    private String invalidReason;

    private TablestoreTableState() {
    }

    public static TablestoreTableState tableNotExist(TablestoreTable table, String reason) {
        TablestoreTableState tableState = new TablestoreTableState();
        tableState.table = table;
        tableState.isExist = false;
        tableState.stateInvalid = true;
        tableState.invalidReason = reason;
        return tableState;
    }

    public static TablestoreTableState metaCheckFailed(TablestoreTable table, String invalidReason) {
        TablestoreTableState tableState = new TablestoreTableState();
        tableState.table = table;
        tableState.isExist = true;
        tableState.stateInvalid = true;
        tableState.invalidReason = invalidReason;
        return tableState;
    }

    public static TablestoreTableState checkPassed(TablestoreTable table, TablestoreTableMeta tableMeta) {
        TablestoreTableState tableState = new TablestoreTableState();
        tableState.table = table;
        tableState.tableMeta = tableMeta;
        tableState.isExist = true;
        tableState.stateInvalid = false;
        return tableState;
    }

    public static TablestoreTableState authFailed(TablestoreTable table, String reason) {
        TablestoreTableState tableState = new TablestoreTableState();
        tableState.table = table;
        tableState.isExist = true;
        tableState.stateInvalid = true;
        tableState.invalidReason = reason;
        return tableState;
    }

    public TablestoreTable getTable() {
        return this.table;
    }

    public boolean isExist() {
        return this.isExist;
    }

    public void setExist(boolean exist) {
        this.isExist = exist;
    }

    public boolean isMetaChecked() {
        return this.metaChecked;
    }

    public void setMetaChecked(boolean metaChecked) {
        this.metaChecked = metaChecked;
    }

    public boolean isStateInvalid() {
        return this.stateInvalid;
    }

    public void stateInvalid(String reason) {
        this.stateInvalid = true;
        this.invalidReason = reason;
    }

    public String getInvalidReason() {
        return this.invalidReason;
    }

    public TablestoreTableMeta getTableMeta() {
        return this.tableMeta;
    }
}

