/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tablestore;

import com.alicloud.openservices.tablestore.model.IndexMeta;
import com.alicloud.openservices.tablestore.model.PrimaryKeyBuilder;
import com.alicloud.openservices.tablestore.model.PrimaryKeySchema;
import com.alicloud.openservices.tablestore.model.PrimaryKeyValue;
import com.alicloud.openservices.tablestore.model.Split;
import com.alicloud.openservices.tablestore.model.filter.SingleColumnValueFilter;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.Marker;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.predicate.Ranges;
import com.facebook.presto.common.predicate.ValueSet;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.tablestore.TablestoreClient;
import com.facebook.presto.tablestore.TablestoreColumnHandle;
import com.facebook.presto.tablestore.TablestoreConfig;
import com.facebook.presto.tablestore.TablestoreConnectorId;
import com.facebook.presto.tablestore.TablestoreSplit;
import com.facebook.presto.tablestore.TablestoreTableHandle;
import com.facebook.presto.tablestore.TablestoreTableLayoutHandle;
import com.facebook.presto.tablestore.model.PrunnedTable;
import com.facebook.presto.tablestore.model.TablestoreTable;
import com.facebook.presto.tablestore.model.TablestoreTableMeta;
import com.facebook.presto.tablestore.model.WrappedPrimaryKey;
import com.facebook.presto.tablestore.util.MetaUtil;
import com.facebook.presto.tablestore.util.TypeUtil;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class TablestoreSplitManager
implements ConnectorSplitManager {
    private static final Logger log = Logger.get(TablestoreSplitManager.class);
    private final String connectorId;
    private final TablestoreConfig config;
    private final TablestoreClient tablestoreClient;

    @Inject
    public TablestoreSplitManager(TablestoreConnectorId connectorId, TablestoreConfig config, TablestoreClient tablestoreClient) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.config = Objects.requireNonNull(config, "config is null");
        this.tablestoreClient = Objects.requireNonNull(tablestoreClient, "client is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle handle, ConnectorSession session, ConnectorTableLayoutHandle layout, ConnectorSplitManager.SplitSchedulingContext splitSchedulingContext) {
        TablestoreTableLayoutHandle layoutHandle = (TablestoreTableLayoutHandle)layout;
        TablestoreTableHandle tableHandle = layoutHandle.getTable();
        TablestoreTable table = this.tablestoreClient.getTable(tableHandle.getSchemaName(), tableHandle.getTableName());
        Optional domains = ((TablestoreTableLayoutHandle)layout).getTupleDomain().getDomains();
        Optional<Set<ColumnHandle>> desiredColumns = ((TablestoreTableLayoutHandle)layout).getDesiredColumns();
        Optional<TablestoreColumnHandle> onlyNullPk = ((Map)domains.get()).entrySet().stream().filter(entry -> ((TablestoreColumnHandle)entry.getKey()).isPrimaryKey() && ((Domain)entry.getValue()).isOnlyNull()).findFirst().map(entry -> (TablestoreColumnHandle)entry.getKey());
        if (onlyNullPk.isPresent()) {
            log.warn("Primary key column [%s] can't be only null.", new Object[]{onlyNullPk.get().getColumnName()});
            return new FixedSplitSource(Collections.emptyList());
        }
        ArrayList<PrunnedTable> prunnedTables = new ArrayList<PrunnedTable>();
        if (domains.isPresent() && this.config.isEnablePartitionPruning()) {
            log.info("Partition pruning enabled with domain [%s].", new Object[]{((Map)domains.get()).toString()});
            TablestoreTableMeta tableMeta = this.tablestoreClient.describeTable(tableHandle.getSchemaName(), tableHandle.getTableName());
            List<Range[]> pkRanges = this.toPrimaryKeyRangesByPredicate(session, tableMeta.getTableMeta().getPrimaryKeyList(), (Map)domains.get());
            prunnedTables.add(new PrunnedTable(tableHandle.getSchemaName(), tableHandle.getTableName(), tableMeta.getTableMeta().getPrimaryKeyList(), pkRanges));
            if (this.config.isEnableOptimizeBySecondaryIndex()) {
                for (IndexMeta indexMeta : tableMeta.getSecondaryIndexes()) {
                    if (desiredColumns.isPresent() && MetaUtil.suitableForIndex(desiredColumns.get(), tableMeta.getTableMeta(), indexMeta)) {
                        List<PrimaryKeySchema> indexPks = MetaUtil.getIndexTableSchema(tableMeta.getTableMeta(), indexMeta);
                        log.info("Optimize ranges by predicate, primary key schema is [%s], index table is [%s].", new Object[]{indexPks, indexMeta.getIndexName()});
                        List<Range[]> indexRanges = this.toPrimaryKeyRangesByPredicate(session, indexPks, (Map)domains.get());
                        prunnedTables.add(new PrunnedTable(tableHandle.getSchemaName(), indexMeta.getIndexName(), indexPks, indexRanges));
                        continue;
                    }
                    log.info("Index [%s] is not suitable for this query.", new Object[]{indexMeta.getIndexName()});
                }
            }
        } else {
            prunnedTables.add(new PrunnedTable(tableHandle.getSchemaName(), tableHandle.getTableName(), null, null));
        }
        PrunnedTable prunnedTable = this.chooseBestTable(prunnedTables);
        HashMap<String, Domain> filtersPushDown = new HashMap<String, Domain>();
        if (this.config.isEnableScanWithFilter() && domains.isPresent()) {
            int keyCount = this.prunedKeyCount(prunnedTable.getPkRanges());
            HashSet prunnedKeys = new HashSet(prunnedTable.getIndexPks().subList(0, keyCount).stream().map(k -> k.getName()).collect(Collectors.toList()));
            log.info("Prunned Keys: %s", new Object[]{prunnedKeys});
            ((Map)domains.get()).entrySet().stream().filter(s -> !prunnedKeys.contains(((TablestoreColumnHandle)s.getKey()).getOriginColumnName())).forEach(entry -> {
                Domain cfr_ignored_0 = (Domain)filtersPushDown.put(((TablestoreColumnHandle)entry.getKey()).getOriginColumnName(), (Domain)entry.getValue());
            });
            log.info("Scan with filter and got %d domains on keys [%s].", new Object[]{filtersPushDown.size(), filtersPushDown.keySet()});
        }
        List<Split> splits = this.tablestoreClient.getTableSplits(prunnedTable.getSchemaName(), prunnedTable.getTableName());
        log.info("Split to %d splits of table [%s] by size.", new Object[]{splits.size(), prunnedTable.getTableName()});
        if (splits.isEmpty()) {
            throw new IllegalStateException(String.format("Can not get table [%s]'s splits.", table.getOriginName()));
        }
        if (prunnedTable.getPkRanges() != null) {
            List<Split> splitsAfterPruning = this.toTablestoreSplit(session, prunnedTable.getIndexPks(), prunnedTable.getPkRanges());
            splits = this.intersectSplits(splits, splitsAfterPruning);
        }
        for (int i = 0; i < splits.size(); ++i) {
            Split split = splits.get(i);
            log.info("Final splits[%d]: [(%s), (%s))", new Object[]{i, split.getLowerBound(), split.getUpperBound()});
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Split split : splits) {
            TablestoreSplit ts = new TablestoreSplit(this.connectorId, prunnedTable.getSchemaName(), prunnedTable.getTableName(), new WrappedPrimaryKey(split.getLowerBound()), new WrappedPrimaryKey(split.getUpperBound()), filtersPushDown);
            builder.add((Object)ts);
        }
        return new FixedSplitSource((Iterable)builder.build());
    }

    private PrunnedTable chooseBestTable(List<PrunnedTable> prunnedTables) {
        PrunnedTable prunnedTable = null;
        int score = 0;
        for (PrunnedTable table : prunnedTables) {
            int s = this.prunedKeyCount(table.getPkRanges());
            log.info("Pruned key count of table [%s] is %d.", new Object[]{table.getTableName(), s});
            if (prunnedTable == null) {
                prunnedTable = table;
                score = s;
                continue;
            }
            if (score >= s) continue;
            prunnedTable = table;
            score = s;
        }
        log.info("Choose best table '[%s]' with score [%d].", new Object[]{prunnedTable.getTableName(), score});
        return prunnedTable;
    }

    private int prunedKeyCount(List<Range[]> ranges) {
        if (ranges == null) {
            return 0;
        }
        int maxMatchCount = 0;
        for (Range[] range : ranges) {
            int matchCount = 0;
            for (Range r : range) {
                if (r.isAll()) break;
                ++matchCount;
            }
            maxMatchCount = Math.max(maxMatchCount, matchCount);
        }
        return maxMatchCount;
    }

    private List<Split> intersectSplits(List<Split> tableSplits, List<Split> splitsAfterPruning) {
        if (tableSplits.isEmpty() || splitsAfterPruning.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Split> finalSplits = new ArrayList<Split>();
        Iterator<Split> tableSplitsIter = tableSplits.iterator();
        Split tableSplit = tableSplitsIter.next();
        Iterator<Split> sapIter = splitsAfterPruning.iterator();
        Split prunedSplit = sapIter.next();
        while (true) {
            boolean takeNextTableSplit;
            if (tableSplit.getLowerBound().compareTo(prunedSplit.getUpperBound()) >= 0) {
                takeNextTableSplit = false;
            } else if (tableSplit.getUpperBound().compareTo(prunedSplit.getLowerBound()) <= 0) {
                takeNextTableSplit = true;
            } else {
                boolean prunedSplitLowerBoundLarger = prunedSplit.getLowerBound().compareTo(tableSplit.getLowerBound()) > 0;
                boolean prunedSplitUpperBoundLarger = prunedSplit.getUpperBound().compareTo(tableSplit.getUpperBound()) > 0;
                Split intersectSplit = new Split("", prunedSplitLowerBoundLarger ? prunedSplit.getLowerBound() : tableSplit.getLowerBound(), prunedSplitUpperBoundLarger ? tableSplit.getUpperBound() : prunedSplit.getUpperBound());
                finalSplits.add(intersectSplit);
                takeNextTableSplit = prunedSplitUpperBoundLarger;
            }
            if (takeNextTableSplit) {
                if (!tableSplitsIter.hasNext()) break;
                tableSplit = tableSplitsIter.next();
                continue;
            }
            if (!sapIter.hasNext()) break;
            prunedSplit = sapIter.next();
        }
        return finalSplits;
    }

    private boolean rangePruned(Domain domain) {
        return !domain.isAll();
    }

    private List<Range[]> toPrimaryKeyRangesByPredicate(ConnectorSession session, List<PrimaryKeySchema> primaryKey, Map<ColumnHandle, Domain> columnDomains) {
        ImmutableMap columnToDomain = ImmutableMap.copyOf((Iterable)Collections2.transform(columnDomains.entrySet(), entry -> new AbstractMap.SimpleEntry(((TablestoreColumnHandle)entry.getKey()).getOriginColumnName(), entry.getValue())));
        Pair[] pkDomain = primaryKey.stream().map(pk -> new MutablePair(pk, columnToDomain.containsKey((Object)pk.getName()) ? columnToDomain.get((Object)pk.getName()) : Domain.all((Type)TypeUtil.toPrestoType(pk.getType())))).collect(Collectors.toList()).toArray(new Pair[0]);
        ArrayList<Range[]> pkRanges = new ArrayList<Range[]>();
        int pkDomainPosition = 0;
        for (Pair pk2 : pkDomain) {
            if (pkDomainPosition == 0) {
                Ranges ranges = ((Domain)pk2.getRight()).getValues().getRanges();
                for (Range range : ranges.getOrderedRanges()) {
                    Range[] pkRange = new Range[pkDomain.length];
                    pkRange[0] = range;
                    pkRanges.add(pkRange);
                }
            } else {
                ArrayList newRanges = new ArrayList();
                for (Range[] pkRange : pkRanges) {
                    if (pkRange[pkDomainPosition - 1].isSingleValue() && !((Domain)pk2.getRight()).isOnlyNull()) {
                        Range[][] derivedRanges;
                        Ranges ranges = ((Domain)pk2.getRight()).getValues().getRanges();
                        if (ranges.getOrderedRanges().size() == 1) {
                            pkRange[pkDomainPosition] = (Range)ranges.getOrderedRanges().get(0);
                            continue;
                        }
                        for (Range[] r : derivedRanges = new Range[ranges.getOrderedRanges().size() - 1][pkRange.length]) {
                            System.arraycopy(pkRange, 0, r, 0, r.length);
                        }
                        pkRange[pkDomainPosition] = (Range)ranges.getOrderedRanges().get(0);
                        for (int j = 1; j < ranges.getOrderedRanges().size(); ++j) {
                            derivedRanges[j - 1][pkDomainPosition] = (Range)ranges.getOrderedRanges().get(j);
                        }
                        newRanges.addAll(Arrays.asList(derivedRanges));
                        continue;
                    }
                    pkRange[pkDomainPosition] = Range.all((Type)TypeUtil.toPrestoType(((PrimaryKeySchema)pk2.getLeft()).getType()));
                }
                if (!newRanges.isEmpty()) {
                    pkRanges.addAll(newRanges);
                }
            }
            ++pkDomainPosition;
        }
        return pkRanges;
    }

    public List<Split> toTablestoreSplit(ConnectorSession session, List<PrimaryKeySchema> primaryKey, List<Range[]> pkRanges) {
        ArrayList<Split> tablestoreSplits = new ArrayList<Split>();
        for (Range[] ranges : pkRanges) {
            String ps = Arrays.asList(ranges).stream().map(r -> r.toString(session.getSqlFunctionProperties())).collect(Collectors.joining(","));
            log.info("PK Range after all: %s", new Object[]{ps});
            PrimaryKeyBuilder startKey = PrimaryKeyBuilder.createPrimaryKeyBuilder();
            PrimaryKeyBuilder endKey = PrimaryKeyBuilder.createPrimaryKeyBuilder();
            boolean hasIncludeUpperBound = false;
            PrimaryKeyValue[] includeUpperBound = new PrimaryKeyValue[primaryKey.size()];
            int i = 0;
            boolean lastKeyValueIncluded = true;
            for (Range range : ranges) {
                PrimaryKeyValue value;
                String primaryKeyName = primaryKey.get(i).getName();
                if (range.isAll()) {
                    startKey.addPrimaryKeyColumn(primaryKeyName, PrimaryKeyValue.INF_MIN);
                    endKey.addPrimaryKeyColumn(primaryKeyName, lastKeyValueIncluded ? PrimaryKeyValue.INF_MAX : PrimaryKeyValue.INF_MIN);
                } else if (range.isSingleValue()) {
                    lastKeyValueIncluded = true;
                    value = TypeUtil.toPrimaryKeyValue(range.getType(), range.getSingleValue());
                    startKey.addPrimaryKeyColumn(primaryKeyName, value);
                    endKey.addPrimaryKeyColumn(primaryKeyName, value);
                    includeUpperBound[i] = value;
                } else {
                    lastKeyValueIncluded = false;
                    if (range.getLow().isLowerUnbounded()) {
                        startKey.addPrimaryKeyColumn(primaryKeyName, PrimaryKeyValue.INF_MIN);
                    } else {
                        startKey.addPrimaryKeyColumn(primaryKeyName, TypeUtil.toPrimaryKeyValue(range.getType(), range.getLow().getValue()));
                    }
                    if (range.getHigh().isUpperUnbounded()) {
                        endKey.addPrimaryKeyColumn(primaryKeyName, PrimaryKeyValue.INF_MAX);
                    } else {
                        value = TypeUtil.toPrimaryKeyValue(range.getType(), range.getHigh().getValue());
                        if (range.getHigh().getBound() == Marker.Bound.EXACTLY) {
                            hasIncludeUpperBound = true;
                            includeUpperBound[i] = value;
                        }
                        endKey.addPrimaryKeyColumn(primaryKeyName, value);
                    }
                }
                ++i;
            }
            tablestoreSplits.add(new Split("", startKey.build(), endKey.build()));
            if (!hasIncludeUpperBound) continue;
            PrimaryKeyBuilder sk = PrimaryKeyBuilder.createPrimaryKeyBuilder();
            PrimaryKeyBuilder ek = PrimaryKeyBuilder.createPrimaryKeyBuilder();
            int j = 0;
            for (PrimaryKeyValue value : includeUpperBound) {
                String name = primaryKey.get(j).getName();
                if (value != null) {
                    sk.addPrimaryKeyColumn(name, value);
                    ek.addPrimaryKeyColumn(name, value);
                } else {
                    sk.addPrimaryKeyColumn(name, PrimaryKeyValue.INF_MIN);
                    ek.addPrimaryKeyColumn(name, PrimaryKeyValue.INF_MAX);
                }
                ++j;
            }
            tablestoreSplits.add(new Split("", sk.build(), ek.build()));
        }
        tablestoreSplits.sort(new Comparator<Split>(){

            @Override
            public int compare(Split o1, Split o2) {
                return o1.getLowerBound().compareTo(o2.getLowerBound());
            }
        });
        log.info("Merge into %d splits.", new Object[]{tablestoreSplits.size()});
        for (int i = 0; i < tablestoreSplits.size(); ++i) {
            Split split = (Split)tablestoreSplits.get(i);
            log.info("Splits[%s]: lower_bound[%s], upper_bound[%s].", new Object[]{i, split.getLowerBound(), split.getUpperBound()});
        }
        return tablestoreSplits;
    }

    private SingleColumnValueFilter toColumnFilter(String name, Type type, Domain domain) {
        ValueSet value = domain.getValues();
        if (domain.isOnlyNull()) {
            return null;
        }
        if (value.isSingleValue()) {
            return new SingleColumnValueFilter(name, SingleColumnValueFilter.CompareOperator.EQUAL, TypeUtil.toColumnValue(type, value.getSingleValue()));
        }
        if (!(value.isNone() || value.isAll() || value.isSingleValue())) {
            List ranges = value.getRanges().getOrderedRanges();
            for (Range range : ranges) {
                if (!range.getLow().isLowerUnbounded()) {
                    SingleColumnValueFilter.CompareOperator ct = range.getLow().getBound() == Marker.Bound.EXACTLY ? SingleColumnValueFilter.CompareOperator.GREATER_EQUAL : SingleColumnValueFilter.CompareOperator.GREATER_THAN;
                    return new SingleColumnValueFilter(name, ct, TypeUtil.toColumnValue(type, range.getLow().getValue()));
                }
                if (range.getHigh().isUpperUnbounded()) continue;
                SingleColumnValueFilter.CompareOperator ct = range.getHigh().getBound() == Marker.Bound.EXACTLY ? SingleColumnValueFilter.CompareOperator.LESS_EQUAL : SingleColumnValueFilter.CompareOperator.LESS_THAN;
                return new SingleColumnValueFilter(name, ct, TypeUtil.toColumnValue(type, range.getHigh().getValue()));
            }
        }
        return null;
    }
}

