/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tablestore;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.NodeProvider;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.facebook.presto.tablestore.model.WrappedPrimaryKey;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TablestoreSplit
implements ConnectorSplit {
    private final String connectorId;
    private final String schemaName;
    private final String tableName;
    private final WrappedPrimaryKey startKey;
    private final WrappedPrimaryKey endKey;
    private final Map<String, Domain> filters;

    @JsonCreator
    public TablestoreSplit(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="startKey") WrappedPrimaryKey startKey, @JsonProperty(value="endKey") WrappedPrimaryKey endKey, @JsonProperty(value="filters") Map<String, Domain> filters) {
        this.schemaName = Objects.requireNonNull(schemaName, "schema name is null");
        this.connectorId = Objects.requireNonNull(connectorId, "connector id is null");
        this.tableName = Objects.requireNonNull(tableName, "table name is null");
        this.startKey = Objects.requireNonNull(startKey, "start key is null");
        this.endKey = Objects.requireNonNull(endKey, "end key is null");
        this.filters = Objects.requireNonNull(filters, "filters is null");
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public WrappedPrimaryKey getStartKey() {
        return this.startKey;
    }

    @JsonProperty
    public WrappedPrimaryKey getEndKey() {
        return this.endKey;
    }

    @JsonProperty
    public Map<String, Domain> getFilters() {
        return this.filters;
    }

    public NodeSelectionStrategy getNodeSelectionStrategy() {
        return NodeSelectionStrategy.NO_PREFERENCE;
    }

    public List<HostAddress> getPreferredNodes(NodeProvider nodeProvider) {
        return ImmutableList.of();
    }

    public Object getInfo() {
        return this;
    }
}

