/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tablestore;

import com.alicloud.openservices.tablestore.SyncClient;
import com.alicloud.openservices.tablestore.model.GetRowRequest;
import com.alicloud.openservices.tablestore.model.GetRowResponse;
import com.alicloud.openservices.tablestore.model.SingleRowQueryCriteria;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.tablestore.TablestoreClient;
import com.facebook.presto.tablestore.TablestoreColumnHandle;
import com.facebook.presto.tablestore.TablestoreRecordCursor;
import com.facebook.presto.tablestore.TablestoreSplit;
import java.util.List;

public class TablestoreSingleGetRecordCursor
extends TablestoreRecordCursor {
    private static final Logger log = Logger.get(TablestoreSingleGetRecordCursor.class);
    private boolean gotRow;

    public TablestoreSingleGetRecordCursor(TablestoreClient client, TablestoreSplit split, List<TablestoreColumnHandle> columnHandles) {
        super(client, split, columnHandles);
        log.info("Start single row record cursor.");
        this.gotRow = false;
    }

    public boolean advanceNextPosition() {
        if (!this.gotRow) {
            SyncClient sc = this.client.getClient(this.split.getSchemaName());
            SingleRowQueryCriteria criteria = new SingleRowQueryCriteria(this.split.getTableName());
            criteria.setPrimaryKey(this.split.getStartKey().getPrimaryKey());
            criteria.setMaxVersions(1);
            for (TablestoreColumnHandle column : this.columnHandles) {
                criteria.addColumnsToGet(column.getOriginColumnName());
            }
            GetRowRequest request = new GetRowRequest();
            request.setRowQueryCriteria(criteria);
            GetRowResponse response = sc.getRow(request);
            this.currentRow = response.getRow();
            this.gotRow = true;
            return true;
        }
        return false;
    }
}

