/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tablestore;

import com.alicloud.openservices.tablestore.model.Column;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.PrimaryKeyColumn;
import com.alicloud.openservices.tablestore.model.Row;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.tablestore.TablestoreClient;
import com.facebook.presto.tablestore.TablestoreColumnHandle;
import com.facebook.presto.tablestore.TablestoreSplit;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;

public abstract class TablestoreRecordCursor
implements RecordCursor {
    private static final Logger log = Logger.get(TablestoreRecordCursor.class);
    protected final TablestoreColumnHandle[] columnHandles;
    protected final TablestoreClient client;
    protected final TablestoreSplit split;
    protected Row currentRow;
    protected long count;

    public TablestoreRecordCursor(TablestoreClient client, TablestoreSplit split, List<TablestoreColumnHandle> columnHandles) {
        log.info("Start range scan record cursor.");
        this.columnHandles = columnHandles.toArray(new TablestoreColumnHandle[0]);
        this.client = client;
        this.split = split;
        this.count = 0L;
    }

    public long getCompletedBytes() {
        return this.count;
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public Type getType(int field) {
        Preconditions.checkArgument((field < this.columnHandles.length ? 1 : 0) != 0, (Object)"Invalid field index");
        return this.columnHandles[field].getColumnType();
    }

    private ColumnValue getFieldValue(int field) {
        TablestoreColumnHandle column = this.columnHandles[field];
        if (column.isPrimaryKey()) {
            PrimaryKeyColumn c = this.currentRow.getPrimaryKey().getPrimaryKeyColumn(column.getOriginColumnName());
            try {
                return c.getValue().toColumnValue();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        Column c = this.currentRow.getLatestColumn(column.getOriginColumnName());
        if (c == null) {
            return null;
        }
        return c.getValue();
    }

    public boolean getBoolean(int field) {
        this.checkFieldType(field, (Type)BooleanType.BOOLEAN);
        return this.getFieldValue(field).asBoolean();
    }

    public long getLong(int field) {
        this.checkFieldType(field, (Type)BigintType.BIGINT);
        return this.getFieldValue(field).asLong();
    }

    public double getDouble(int field) {
        this.checkFieldType(field, (Type)DoubleType.DOUBLE);
        return this.getFieldValue(field).asDouble();
    }

    public Slice getSlice(int field) {
        this.checkFieldType(field, (Type)VarcharType.createUnboundedVarcharType());
        return Slices.utf8Slice((String)this.getFieldValue(field).asString());
    }

    public Object getObject(int field) {
        throw new UnsupportedOperationException();
    }

    public boolean isNull(int field) {
        Preconditions.checkArgument((field < this.columnHandles.length ? 1 : 0) != 0, (Object)"Invalid field index");
        return this.currentRow == null || this.getFieldValue(field) == null;
    }

    private void checkFieldType(int field, Type expected) {
        Type actual = this.getType(field);
        Preconditions.checkArgument((boolean)actual.equals(expected), (String)"Expected field %s to be type %s but is %s", (Object)field, (Object)expected, (Object)actual);
    }

    public void close() {
    }
}

