/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tablestore;

import com.alicloud.openservices.tablestore.SyncClient;
import com.alicloud.openservices.tablestore.model.RangeIteratorParameter;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.model.filter.Filter;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.tablestore.TablestoreClient;
import com.facebook.presto.tablestore.TablestoreColumnHandle;
import com.facebook.presto.tablestore.TablestoreRecordCursor;
import com.facebook.presto.tablestore.TablestoreSplit;
import java.util.Iterator;
import java.util.List;

public class TablestoreRangeScanRecordCursor
extends TablestoreRecordCursor {
    private static final Logger log = Logger.get(TablestoreRangeScanRecordCursor.class);
    private Iterator<Row> rowIter;
    private Filter filter;

    public TablestoreRangeScanRecordCursor(TablestoreClient client, TablestoreSplit split, List<TablestoreColumnHandle> columnHandles, Filter filter) {
        super(client, split, columnHandles);
        this.filter = filter;
        log.info("Start range scan record cursor.");
    }

    public boolean advanceNextPosition() {
        if (this.rowIter == null) {
            SyncClient sc = this.client.getClient(this.split.getSchemaName());
            RangeIteratorParameter param = new RangeIteratorParameter(this.split.getTableName());
            param.setInclusiveStartPrimaryKey(this.split.getStartKey().getPrimaryKey());
            param.setExclusiveEndPrimaryKey(this.split.getEndKey().getPrimaryKey());
            if (this.filter != null) {
                param.setFilter(this.filter);
            }
            for (TablestoreColumnHandle column : this.columnHandles) {
                param.addColumnsToGet(column.getOriginColumnName());
            }
            param.setMaxVersions(1);
            this.rowIter = sc.createRangeIterator(param);
        }
        if (this.rowIter.hasNext()) {
            this.currentRow = this.rowIter.next();
            return true;
        }
        return false;
    }
}

