/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tablestore;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.PageSinkContext;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.tablestore.TablestoreAsyncPageSink;
import com.facebook.presto.tablestore.TablestoreClient;
import com.facebook.presto.tablestore.TablestoreConnectorId;
import com.facebook.presto.tablestore.TablestoreInsertTableHandle;
import com.facebook.presto.tablestore.TablestorePageSink;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.inject.Inject;

public class TablestorePageSinkProvider
implements ConnectorPageSinkProvider {
    private static final Logger log = Logger.get(TablestorePageSinkProvider.class);
    private final String connectorId;
    private final TablestoreClient client;

    @Inject
    public TablestorePageSinkProvider(TablestoreConnectorId connectorId, TablestoreClient client) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.client = Objects.requireNonNull(client, "client is null");
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle outputTableHandle, PageSinkContext pageSinkContext) {
        Preconditions.checkArgument((!pageSinkContext.isCommitRequired() ? 1 : 0) != 0, (Object)"Tablestore connector does not support partition commit");
        return null;
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle insertTableHandle, PageSinkContext pageSinkContext) {
        Preconditions.checkArgument((!pageSinkContext.isCommitRequired() ? 1 : 0) != 0, (Object)"Tablestore connector does not support partition commit");
        TablestoreInsertTableHandle tableHandle = (TablestoreInsertTableHandle)insertTableHandle;
        log.info("create page sink for table [%s.%s].", new Object[]{tableHandle.getSchemaName(), tableHandle.getTableName()});
        TablestoreAsyncPageSink asyncSink = this.client.getAsyncPageSink(tableHandle.getSchemaName(), tableHandle.getTableName());
        return new TablestorePageSink(tableHandle, asyncSink);
    }
}

